/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.common.datetime.conversion;

import com.jxdinfo.hussar.integration.support.common.datetime.DateTimeHelper;
import com.jxdinfo.hussar.integration.support.common.datetime.conversion.AbstractTemporalConversionRule;
import com.jxdinfo.hussar.integration.support.common.datetime.helper.LegacyJavaDateHelper;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Date;

public final class LocalDateTemporalConversionRule
extends AbstractTemporalConversionRule<LocalDate> {
    @Override
    public Class<LocalDate> getType() {
        return LocalDate.class;
    }

    @Override
    public LocalDateTime toLocalDateTime(DateTimeHelper context, LocalDate temporal) {
        return temporal.atStartOfDay();
    }

    @Override
    public ZonedDateTime toZonedDateTime(DateTimeHelper context, LocalDate temporal) {
        return temporal.atStartOfDay(context.getZone());
    }

    @Override
    public LocalDate toLocalDate(DateTimeHelper context, LocalDate temporal) {
        return temporal;
    }

    @Override
    public Date toDate(DateTimeHelper context, LocalDate temporal) {
        LocalDateTime datetime = temporal.atStartOfDay();
        return LegacyJavaDateHelper.toDate(datetime, context.getZone(), null);
    }
}

