/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.common.datetime.conversion;

import com.jxdinfo.hussar.integration.support.common.datetime.DateTimeHelper;
import com.jxdinfo.hussar.integration.support.common.datetime.conversion.TemporalConversionRule;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.TemporalAccessor;
import java.util.Date;

public abstract class AbstractTemporalConversionRule<T extends TemporalAccessor>
implements TemporalConversionRule<T> {
    @Override
    public Instant toInstant(DateTimeHelper context, T temporal) {
        return this.toZonedDateTime(context, temporal).toInstant();
    }

    @Override
    public LocalDateTime toLocalDateTime(DateTimeHelper context, T temporal) {
        return this.toOffsetDateTime(context, temporal).toLocalDateTime();
    }

    @Override
    public OffsetDateTime toOffsetDateTime(DateTimeHelper context, T temporal) {
        return this.toZonedDateTime(context, temporal).toOffsetDateTime();
    }

    @Override
    public LocalDate toLocalDate(DateTimeHelper context, T temporal) {
        return this.toLocalDateTime(context, temporal).toLocalDate();
    }

    @Override
    public LocalTime toLocalTime(DateTimeHelper context, T temporal) {
        return this.toLocalDateTime(context, temporal).toLocalTime();
    }

    @Override
    public OffsetTime toOffsetTime(DateTimeHelper context, T temporal) {
        return this.toOffsetDateTime(context, temporal).toOffsetTime();
    }

    @Override
    public Date toDate(DateTimeHelper context, T temporal) {
        return Date.from(this.toInstant(context, temporal));
    }
}

