/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.common.datetime;

import com.google.common.collect.Lists;
import com.jxdinfo.hussar.integration.support.common.constants.DateTimeConstants;
import com.jxdinfo.hussar.integration.support.common.datetime.conversion.InstantTemporalConversionRule;
import com.jxdinfo.hussar.integration.support.common.datetime.conversion.LocalDateTemporalConversionRule;
import com.jxdinfo.hussar.integration.support.common.datetime.conversion.LocalDateTimeTemporalConversionRule;
import com.jxdinfo.hussar.integration.support.common.datetime.conversion.LocalTimeTemporalConversionRule;
import com.jxdinfo.hussar.integration.support.common.datetime.conversion.OffsetDateTimeTemporalConversionRule;
import com.jxdinfo.hussar.integration.support.common.datetime.conversion.OffsetTimeTemporalConversionRule;
import com.jxdinfo.hussar.integration.support.common.datetime.conversion.TemporalConversionRule;
import com.jxdinfo.hussar.integration.support.common.datetime.conversion.UnknownTemporalConversionRule;
import com.jxdinfo.hussar.integration.support.common.datetime.conversion.ZonedDateTimeTemporalConversionRule;
import com.jxdinfo.hussar.integration.support.common.datetime.formating.TemporalFormatingRule;
import com.jxdinfo.hussar.integration.support.common.datetime.recognize.TemporalRecognitionRule;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeHelper {
    private static final Logger logger = LoggerFactory.getLogger(DateTimeHelper.class);
    public static final DateTimeHelper DEFAULT = Builder.createDefault().build();
    private final List<TemporalRecognitionRule<? extends TemporalAccessor>> temporalRecognitionRules;
    private final Map<Class<? extends TemporalAccessor>, TemporalFormatingRule> temporalFormatingRules;
    private final Map<Class<? extends TemporalAccessor>, TemporalConversionRule<? extends TemporalAccessor>> temporalConversionRules;
    private final Locale locale;
    private final ZoneId zone;
    private final LocalDate fallbackDate;

    private DateTimeHelper(List<TemporalRecognitionRule<? extends TemporalAccessor>> temporalRecognitionRules, Map<Class<? extends TemporalAccessor>, TemporalFormatingRule> temporalFormatingRules, Map<Class<? extends TemporalAccessor>, TemporalConversionRule<? extends TemporalAccessor>> temporalConversionRules, Locale locale, ZoneId zone, LocalDate fallbackDate) {
        this.temporalRecognitionRules = temporalRecognitionRules;
        this.temporalFormatingRules = temporalFormatingRules;
        this.temporalConversionRules = temporalConversionRules;
        this.locale = locale;
        this.zone = zone;
        this.fallbackDate = fallbackDate;
    }

    public <T extends TemporalAccessor> T convert(TemporalAccessor temporal, Class<T> clazz) {
        if (temporal == null) {
            return null;
        }
        if (clazz == Instant.class) {
            return (T)this.toInstant(temporal);
        }
        if (clazz == LocalDateTime.class) {
            return (T)this.toLocalDateTime(temporal);
        }
        if (clazz == OffsetDateTime.class) {
            return (T)this.toOffsetDateTime(temporal);
        }
        if (clazz == ZonedDateTime.class) {
            return (T)this.toZonedDateTime(temporal);
        }
        if (clazz == LocalDate.class) {
            return (T)this.toLocalDate(temporal);
        }
        if (clazz == LocalTime.class) {
            return (T)this.toLocalTime(temporal);
        }
        if (clazz == OffsetTime.class) {
            return (T)this.toOffsetTime(temporal);
        }
        return null;
    }

    public String toString(TemporalAccessor temporal) {
        if (temporal == null) {
            return null;
        }
        TemporalFormatingRule rule = this.temporalFormatingRules.get(temporal.getClass());
        if (rule != null) {
            return rule.format(this, temporal);
        }
        return null;
    }

    public TemporalAccessor toTemporalAccessor(String string) {
        if (string == null) {
            return null;
        }
        String text = StringUtils.trim((String)string);
        for (TemporalRecognitionRule<? extends TemporalAccessor> rule : this.temporalRecognitionRules) {
            TemporalAccessor parsed = rule.recognize(this, text);
            if (parsed == null) continue;
            return parsed;
        }
        return null;
    }

    public Instant toInstant(TemporalAccessor temporal) {
        if (temporal == null) {
            return null;
        }
        TemporalConversionRule<TemporalAccessor> rule = this.getTemporalConversionRule(temporal.getClass());
        if (rule == null) {
            return null;
        }
        return rule.toInstant(this, temporal);
    }

    public Instant toInstant(String string) {
        return this.toInstant(this.toTemporalAccessor(string));
    }

    public Instant toInstant(Date date) {
        return date.toInstant();
    }

    public Instant toInstant(Long timestamp) {
        if (timestamp == null) {
            return null;
        }
        try {
            return Instant.ofEpochMilli(timestamp);
        }
        catch (DateTimeException ex) {
            logger.debug("failed to convert timestamp '{}' to instant", (Object)timestamp, (Object)ex);
            return null;
        }
    }

    public LocalDateTime toLocalDateTime(TemporalAccessor temporal) {
        if (temporal == null) {
            return null;
        }
        TemporalConversionRule<TemporalAccessor> rule = this.getTemporalConversionRule(temporal.getClass());
        if (rule == null) {
            return null;
        }
        return rule.toLocalDateTime(this, temporal);
    }

    public LocalDateTime toLocalDateTime(String string) {
        return this.toLocalDateTime(this.toTemporalAccessor(string));
    }

    public LocalDateTime toLocalDateTime(Date date) {
        return this.toLocalDateTime(date.toInstant());
    }

    public LocalDateTime toLocalDateTime(Long timestamp) {
        return this.toLocalDateTime(this.toInstant(timestamp));
    }

    public OffsetDateTime toOffsetDateTime(TemporalAccessor temporal) {
        if (temporal == null) {
            return null;
        }
        TemporalConversionRule<TemporalAccessor> rule = this.getTemporalConversionRule(temporal.getClass());
        if (rule == null) {
            return null;
        }
        return rule.toOffsetDateTime(this, temporal);
    }

    public OffsetDateTime toOffsetDateTime(String string) {
        return this.toOffsetDateTime(this.toTemporalAccessor(string));
    }

    public OffsetDateTime toOffsetDateTime(Date date) {
        return this.toOffsetDateTime(date.toInstant());
    }

    public OffsetDateTime toOffsetDateTime(Long timestamp) {
        return this.toOffsetDateTime(this.toInstant(timestamp));
    }

    public ZonedDateTime toZonedDateTime(TemporalAccessor temporal) {
        if (temporal == null) {
            return null;
        }
        TemporalConversionRule<TemporalAccessor> rule = this.getTemporalConversionRule(temporal.getClass());
        if (rule == null) {
            return null;
        }
        return rule.toZonedDateTime(this, temporal);
    }

    public ZonedDateTime toZonedDateTime(String string) {
        return this.toZonedDateTime(this.toTemporalAccessor(string));
    }

    public ZonedDateTime toZonedDateTime(Date date) {
        return this.toZonedDateTime(date.toInstant());
    }

    public ZonedDateTime toZonedDateTime(Long timestamp) {
        return this.toZonedDateTime(this.toInstant(timestamp));
    }

    public LocalDate toLocalDate(TemporalAccessor temporal) {
        if (temporal == null) {
            return null;
        }
        TemporalConversionRule<TemporalAccessor> rule = this.getTemporalConversionRule(temporal.getClass());
        if (rule == null) {
            return null;
        }
        return rule.toLocalDate(this, temporal);
    }

    public LocalDate toLocalDate(String string) {
        return this.toLocalDate(this.toTemporalAccessor(string));
    }

    public LocalDate toLocalDate(Date date) {
        return this.toLocalDate(date.toInstant());
    }

    public LocalDate toLocalDate(Long timestamp) {
        return this.toLocalDate(this.toInstant(timestamp));
    }

    public LocalTime toLocalTime(TemporalAccessor temporal) {
        if (temporal == null) {
            return null;
        }
        TemporalConversionRule<TemporalAccessor> rule = this.getTemporalConversionRule(temporal.getClass());
        if (rule == null) {
            return null;
        }
        return rule.toLocalTime(this, temporal);
    }

    public LocalTime toLocalTime(String string) {
        return this.toLocalTime(this.toTemporalAccessor(string));
    }

    public LocalTime toLocalTime(Date date) {
        return this.toLocalTime(date.toInstant());
    }

    public LocalTime toLocalTime(Long timestamp) {
        return this.toLocalTime(this.toInstant(timestamp));
    }

    public OffsetTime toOffsetTime(TemporalAccessor temporal) {
        if (temporal == null) {
            return null;
        }
        TemporalConversionRule<TemporalAccessor> rule = this.getTemporalConversionRule(temporal.getClass());
        if (rule == null) {
            return null;
        }
        return rule.toOffsetTime(this, temporal);
    }

    public OffsetTime toOffsetTime(String string) {
        return this.toOffsetTime(this.toTemporalAccessor(string));
    }

    public OffsetTime toOffsetTime(Date date) {
        return this.toOffsetTime(date.toInstant());
    }

    public OffsetTime toOffsetTime(Long timestamp) {
        return this.toOffsetTime(this.toInstant(timestamp));
    }

    public Date toDate(TemporalAccessor temporal) {
        if (temporal == null) {
            return null;
        }
        TemporalConversionRule<TemporalAccessor> rule = this.getTemporalConversionRule(temporal.getClass());
        if (rule == null) {
            return null;
        }
        return rule.toDate(this, temporal);
    }

    public Date toDate(String string) {
        TemporalAccessor temporal = this.toTemporalAccessor(string);
        return this.toDate(temporal);
    }

    public Date toDate(Long timestamp) {
        Instant instant = this.toInstant(timestamp);
        if (instant == null) {
            return null;
        }
        return Date.from(instant);
    }

    public Long toTimestamp(String string) {
        Instant instant = this.toInstant(string);
        if (instant == null) {
            return null;
        }
        return instant.toEpochMilli();
    }

    public Long toTimestamp(Date date) {
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    public Long toTimestamp(TemporalAccessor temporal) {
        Instant instant = this.toInstant(temporal);
        if (instant == null) {
            return null;
        }
        return instant.toEpochMilli();
    }

    private TemporalConversionRule<TemporalAccessor> getTemporalConversionRule(Class<? extends TemporalAccessor> clazz) {
        TemporalConversionRule<TemporalAccessor> rule = this.temporalConversionRules.get(clazz);
        if (rule != null) {
            return rule;
        }
        return this.temporalConversionRules.get(DateTimeConstants.UNKNOWN_TEMPORAL_ACCESSOR_PLACEHOLDER);
    }

    public Builder toBuilder() {
        return Builder.createEmpty().withTemporalRecognitionRules(this.temporalRecognitionRules).withTemporalFormatingRules(this.temporalFormatingRules).withTemporalConversionRules(this.temporalConversionRules).locale(this.locale).zone(this.zone).fallbackDate(this.fallbackDate);
    }

    public List<TemporalRecognitionRule<? extends TemporalAccessor>> getTemporalRecognitionRules() {
        return this.temporalRecognitionRules;
    }

    public Map<Class<? extends TemporalAccessor>, TemporalFormatingRule> getTemporalFormatingRules() {
        return this.temporalFormatingRules;
    }

    public Map<Class<? extends TemporalAccessor>, TemporalConversionRule<? extends TemporalAccessor>> getTemporalConversionRules() {
        return this.temporalConversionRules;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ZoneId getZone() {
        return this.zone;
    }

    public LocalDate getFallbackDate() {
        return this.fallbackDate;
    }

    public static final class Builder {
        public static final List<TemporalRecognitionRule<? extends TemporalAccessor>> DEFAULT_TEMPORAL_RECOGNITION_RULES;
        public static final Map<Class<? extends TemporalAccessor>, TemporalFormatingRule> DEFAULT_TEMPORAL_FORMATING_RULES;
        public static final Map<Class<? extends TemporalAccessor>, TemporalConversionRule<? extends TemporalAccessor>> DEFAULT_TEMPORAL_CONVERSION_RULES;
        public static final Locale DEFAULT_LOCALE;
        public static final ZoneId DEFAULT_ZONE;
        public static final LocalDate DEFAULT_FALLBACK_DATE;
        private List<TemporalRecognitionRule<? extends TemporalAccessor>> temporalRecognitionRules;
        private Map<Class<? extends TemporalAccessor>, TemporalFormatingRule> temporalFormatingRules;
        private Map<Class<? extends TemporalAccessor>, TemporalConversionRule<? extends TemporalAccessor>> temporalConversionRules;
        private Locale locale;
        private ZoneId zone;
        private LocalDate fallbackDate;

        private Builder() {
        }

        public static Builder createEmpty() {
            return new Builder();
        }

        public static Builder createDefault() {
            return new Builder().withTemporalRecognitionRules(DEFAULT_TEMPORAL_RECOGNITION_RULES).withTemporalFormatingRules(DEFAULT_TEMPORAL_FORMATING_RULES).withTemporalConversionRules(DEFAULT_TEMPORAL_CONVERSION_RULES).locale(DEFAULT_LOCALE).zone(DEFAULT_ZONE).fallbackDate(DEFAULT_FALLBACK_DATE);
        }

        public Builder withTemporalRecognitionRules(List<TemporalRecognitionRule<? extends TemporalAccessor>> rules) {
            this.temporalRecognitionRules = rules != null ? new ArrayList<TemporalRecognitionRule<? extends TemporalAccessor>>(rules) : null;
            return this;
        }

        public Builder addTemporalRecognitionRule(TemporalRecognitionRule<? extends TemporalAccessor> rule) {
            return this.addTemporalRecognitionRule(rule, true);
        }

        public Builder addTemporalRecognitionRule(TemporalRecognitionRule<? extends TemporalAccessor> rule, boolean prior) {
            return this.addTemporalRecognitionRules(Collections.singletonList(rule), prior);
        }

        public Builder addTemporalRecognitionRules(List<TemporalRecognitionRule<? extends TemporalAccessor>> rules) {
            return this.addTemporalRecognitionRules(rules, true);
        }

        public Builder addTemporalRecognitionRules(List<TemporalRecognitionRule<? extends TemporalAccessor>> rules, boolean prior) {
            if (rules == null || rules.stream().anyMatch(Objects::isNull)) {
                throw new NullPointerException();
            }
            if (this.temporalRecognitionRules == null) {
                this.temporalRecognitionRules = new ArrayList<TemporalRecognitionRule<? extends TemporalAccessor>>();
            }
            if (prior) {
                this.temporalRecognitionRules.addAll(0, rules);
            } else {
                this.temporalRecognitionRules.addAll(rules);
            }
            return this;
        }

        public Builder withTemporalFormatingRules(Map<Class<? extends TemporalAccessor>, TemporalFormatingRule> rules) {
            this.temporalFormatingRules = rules != null ? new LinkedHashMap<Class<? extends TemporalAccessor>, TemporalFormatingRule>(rules) : null;
            return this;
        }

        public Builder addTemporalFormatingRule(TemporalFormatingRule rule) {
            return this.addTemporalFormatingRule(rule, true);
        }

        public Builder addTemporalFormatingRule(TemporalFormatingRule rule, boolean prior) {
            return this.addTemporalFormatingRules(Collections.singletonList(rule), prior);
        }

        public Builder addTemporalFormatingRules(List<TemporalFormatingRule> rules) {
            return this.addTemporalFormatingRules(rules, true);
        }

        public Builder addTemporalFormatingRules(List<TemporalFormatingRule> rules, boolean prior) {
            if (rules == null || rules.stream().anyMatch(Objects::isNull)) {
                throw new NullPointerException();
            }
            if (this.temporalFormatingRules == null) {
                this.temporalFormatingRules = new LinkedHashMap<Class<? extends TemporalAccessor>, TemporalFormatingRule>();
            }
            if (prior) {
                for (TemporalFormatingRule rule : rules) {
                    this.temporalFormatingRules.put(rule.getType(), rule);
                }
            } else {
                for (TemporalFormatingRule rule : Lists.reverse(rules)) {
                    this.temporalFormatingRules.putIfAbsent(rule.getType(), rule);
                }
            }
            return this;
        }

        public Builder withTemporalConversionRules(Map<Class<? extends TemporalAccessor>, TemporalConversionRule<? extends TemporalAccessor>> rules) {
            this.temporalConversionRules = rules != null ? new LinkedHashMap<Class<? extends TemporalAccessor>, TemporalConversionRule<? extends TemporalAccessor>>(rules) : null;
            return this;
        }

        public Builder addTemporalConversionRule(TemporalConversionRule<? extends TemporalAccessor> rule) {
            return this.addTemporalConversionRule(rule, true);
        }

        public Builder addTemporalConversionRule(TemporalConversionRule<? extends TemporalAccessor> rule, boolean prior) {
            return this.addTemporalConversionRules(Collections.singletonList(rule), prior);
        }

        public Builder addTemporalConversionRules(List<TemporalConversionRule<? extends TemporalAccessor>> rules) {
            return this.addTemporalConversionRules(rules, true);
        }

        public Builder addTemporalConversionRules(List<TemporalConversionRule<? extends TemporalAccessor>> rules, boolean prior) {
            if (rules == null || rules.stream().anyMatch(Objects::isNull)) {
                throw new NullPointerException();
            }
            if (this.temporalConversionRules == null) {
                this.temporalConversionRules = new LinkedHashMap<Class<? extends TemporalAccessor>, TemporalConversionRule<? extends TemporalAccessor>>();
            }
            if (prior) {
                for (TemporalConversionRule<? extends TemporalAccessor> rule : rules) {
                    this.temporalConversionRules.put(rule.getType(), rule);
                }
            } else {
                for (TemporalConversionRule rule : Lists.reverse(rules)) {
                    this.temporalConversionRules.putIfAbsent(rule.getType(), rule);
                }
            }
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder zone(ZoneId zone) {
            this.zone = zone;
            return this;
        }

        public Builder fallbackDate(LocalDate fallbackDate) {
            this.fallbackDate = fallbackDate;
            return this;
        }

        public DateTimeHelper build() {
            List temporalRecognitionRules = this.temporalRecognitionRules != null ? Collections.unmodifiableList(new ArrayList<TemporalRecognitionRule<? extends TemporalAccessor>>(this.temporalRecognitionRules)) : Collections.emptyList();
            Map temporalFormatingRules = this.temporalFormatingRules != null ? Collections.unmodifiableMap(new LinkedHashMap<Class<? extends TemporalAccessor>, TemporalFormatingRule>(this.temporalFormatingRules)) : Collections.emptyMap();
            Map temporalConversionRules = this.temporalConversionRules != null ? Collections.unmodifiableMap(new LinkedHashMap<Class<? extends TemporalAccessor>, TemporalConversionRule<? extends TemporalAccessor>>(this.temporalConversionRules)) : Collections.emptyMap();
            Locale locale = this.locale != null ? this.locale : DEFAULT_LOCALE;
            ZoneId zone = this.zone != null ? this.zone : DEFAULT_ZONE;
            LocalDate fallbackDate = this.fallbackDate != null ? this.fallbackDate : DEFAULT_FALLBACK_DATE;
            return new DateTimeHelper(temporalRecognitionRules, temporalFormatingRules, temporalConversionRules, locale, zone, fallbackDate);
        }

        static {
            Cloneable rules = new ArrayList<TemporalRecognitionRule<Comparable<ChronoLocalDateTime<Object>>>>();
            rules.add(TemporalRecognitionRule.of(LocalDateTime.class, DateTimeConstants.LEGACY_LOCAL_DATE_TIME, LocalDateTime::parse));
            rules.add(TemporalRecognitionRule.of(LocalDateTime.class, DateTimeFormatter.ISO_LOCAL_DATE_TIME, LocalDateTime::parse));
            rules.add(TemporalRecognitionRule.of(OffsetDateTime.class, DateTimeFormatter.RFC_1123_DATE_TIME, OffsetDateTime::parse));
            rules.add(TemporalRecognitionRule.of(Instant.class, DateTimeFormatter.ISO_INSTANT, (text, formatter) -> Instant.parse(text)));
            rules.add(TemporalRecognitionRule.of(OffsetDateTime.class, DateTimeFormatter.ISO_OFFSET_DATE_TIME, OffsetDateTime::parse));
            rules.add(TemporalRecognitionRule.of(LocalDate.class, DateTimeFormatter.ISO_LOCAL_DATE, LocalDate::parse));
            rules.add(TemporalRecognitionRule.of(LocalDateTime.class, DateTimeConstants.NUMERICAL_LOCAL_DATE_TIME, LocalDateTime::parse, (formatter, string) -> string.length() >= 12 && StringUtils.isNumeric((CharSequence)string)));
            rules.add(TemporalRecognitionRule.of(ZonedDateTime.class, DateTimeFormatter.ISO_ZONED_DATE_TIME, ZonedDateTime::parse));
            rules.add(TemporalRecognitionRule.of(LocalDate.class, DateTimeConstants.NUMERICAL_LOCAL_DATE, LocalDate::parse, (formatter, string) -> string.length() == 8 && StringUtils.isNumeric((CharSequence)string)));
            rules.add(TemporalRecognitionRule.of(LocalTime.class, DateTimeFormatter.ISO_LOCAL_TIME, LocalTime::parse));
            rules.add(TemporalRecognitionRule.of(OffsetTime.class, DateTimeFormatter.ISO_OFFSET_TIME, OffsetTime::parse));
            DEFAULT_TEMPORAL_RECOGNITION_RULES = Collections.unmodifiableList(rules);
            rules = new LinkedHashMap<Class<? extends TemporalAccessor>, TemporalFormatingRule>(){
                {
                    this.add(Instant.class, DateTimeFormatter.ISO_INSTANT);
                    this.add(LocalDateTime.class, DateTimeConstants.LEGACY_LOCAL_DATE_TIME_WITHOUT_NANOS);
                    this.add(OffsetDateTime.class, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                    this.add(ZonedDateTime.class, DateTimeFormatter.ISO_ZONED_DATE_TIME);
                    this.add(LocalDate.class, DateTimeFormatter.ISO_LOCAL_DATE);
                    this.add(LocalTime.class, DateTimeConstants.LEGACY_LOCAL_TIME_WITHOUT_NANOS);
                    this.add(OffsetTime.class, DateTimeFormatter.ISO_OFFSET_TIME);
                }

                private void add(Class<? extends TemporalAccessor> clazz, DateTimeFormatter formatter) {
                    this.put(clazz, TemporalFormatingRule.of(clazz, formatter));
                }
            };
            DEFAULT_TEMPORAL_FORMATING_RULES = Collections.unmodifiableMap(rules);
            rules = new LinkedHashMap<Class<? extends TemporalAccessor>, TemporalConversionRule<? extends TemporalAccessor>>(){
                {
                    this.add(new InstantTemporalConversionRule());
                    this.add(new LocalDateTimeTemporalConversionRule());
                    this.add(new OffsetDateTimeTemporalConversionRule());
                    this.add(new ZonedDateTimeTemporalConversionRule());
                    this.add(new LocalDateTemporalConversionRule());
                    this.add(new LocalTimeTemporalConversionRule());
                    this.add(new OffsetTimeTemporalConversionRule());
                    this.add(new UnknownTemporalConversionRule());
                }

                private void add(TemporalConversionRule<? extends TemporalAccessor> rule) {
                    this.put(rule.getType(), rule);
                }
            };
            DEFAULT_TEMPORAL_CONVERSION_RULES = Collections.unmodifiableMap(rules);
            DEFAULT_LOCALE = DateTimeConstants.DEFAULT_LOCALE;
            DEFAULT_ZONE = DateTimeConstants.DEFAULT_ZONE_ID;
            DEFAULT_FALLBACK_DATE = LocalDate.of(1970, 1, 1);
        }
    }
}

