/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.expression.engine;

import com.jxdinfo.hussar.integration.support.expression.builder.HussarExpressionEngineBuilder;
import com.jxdinfo.hussar.integration.support.expression.engine.HussarExpressionEngineFactory;
import com.jxdinfo.hussar.integration.support.expression.exception.HussarExpressionCreationException;
import com.jxdinfo.hussar.integration.support.expression.spi.HussarExpressionEngineSpi;
import java.security.AccessController;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.integration.support.expression.engine.hussarExpressionEngineFactoryImpl")
public class HussarExpressionEngineFactoryImpl
implements HussarExpressionEngineFactory {
    private static final Logger logger = LoggerFactory.getLogger(HussarExpressionEngineFactoryImpl.class);
    private volatile Map<String, HussarExpressionEngineSpi> providers = null;

    public HussarExpressionEngineBuilder configuring(String name) {
        return Optional.ofNullable(this.getProviders().get(name)).map(HussarExpressionEngineSpi::getEngineBuilder).orElseThrow(() -> new HussarExpressionCreationException("no such expression engine: " + name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, HussarExpressionEngineSpi> getProviders() {
        if (this.providers == null) {
            HussarExpressionEngineFactoryImpl hussarExpressionEngineFactoryImpl = this;
            synchronized (hussarExpressionEngineFactoryImpl) {
                if (this.providers == null) {
                    this.providers = this.doLoadEngineSpi();
                }
            }
        }
        return this.providers;
    }

    private Map<String, HussarExpressionEngineSpi> doLoadEngineSpi() {
        LinkedHashMap<String, HussarExpressionEngineSpi> providers = new LinkedHashMap<String, HussarExpressionEngineSpi>();
        ServiceLoader<HussarExpressionEngineSpi> serviceLoader = this.getEngineSpiServiceLoader(this.getClass().getClassLoader());
        for (HussarExpressionEngineSpi engineSpi : serviceLoader) {
            String name = engineSpi.getEngineName();
            HussarExpressionEngineSpi previous = providers.put(name, engineSpi);
            if (previous == null || previous == engineSpi) continue;
            logger.warn("duplicated expression engine provider name {}: override {} => {}", new Object[]{name, previous.getClass(), engineSpi.getClass()});
        }
        return Collections.unmodifiableMap(providers);
    }

    private ServiceLoader<HussarExpressionEngineSpi> getEngineSpiServiceLoader(ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            return classLoader == null ? ServiceLoader.load(HussarExpressionEngineSpi.class) : ServiceLoader.load(HussarExpressionEngineSpi.class, classLoader);
        }
        return AccessController.doPrivileged(() -> classLoader == null ? ServiceLoader.load(HussarExpressionEngineSpi.class) : ServiceLoader.load(HussarExpressionEngineSpi.class, classLoader));
    }
}

