(function (self, $Intrinsics$) {
    function toBytes(value, preferUtf8) {
        if (typeof value === 'string') {
            return preferUtf8 ? $Intrinsics$.toUtf8(value) : $Intrinsics$.toLatin1(value);
        } else {
            return preferUtf8 ? $Intrinsics$.toUtf8(String(value)) : $Intrinsics$.toLatin1(String(value));
        }
    }

    function fromBytes(value, preferUtf8) {
        return preferUtf8 ? $Intrinsics$.fromUtf8(value) : $Intrinsics$.fromLatin1(value);
    }

    self.btoa = function btoa(value) {
        var bytes = toBytes(value, false);
        return $Intrinsics$.base64Encode(bytes);
    }

    self.base64Encode = function base64Encode(value) {
        var bytes = toBytes(value, true);
        return $Intrinsics$.base64Encode(bytes);
    }

    self.base64UrlSafeEncode = function base64UrlSafeEncode(value) {
        var bytes = toBytes(value, true);
        return $Intrinsics$.base64Encode(bytes, true);
    }

    self.atob = function atob(value) {
        var bytes = $Intrinsics$.base64Decode(String(value));
        return fromBytes(bytes, false);
    }

    self.base64Decode = function base64Decode(value) {
        var bytes = $Intrinsics$.base64Decode(String(value));
        return fromBytes(bytes, true);
    }

    self.base64UrlSafeDecode = function base64Decode(value) {
        var bytes = $Intrinsics$.base64Decode(String(value), true);
        return fromBytes(bytes, true);
    }

    self.md5 = function md5(value) {
        return $Intrinsics$.md5(toBytes(value, true));
    }

    self.sha1 = function sha1(value) {
        return $Intrinsics$.sha1(toBytes(value, true));
    }

    self.sha256 = function sha256(value) {
        return $Intrinsics$.sha256(toBytes(value, true));
    }

    self.sha512 = function sha512(value) {
        return $Intrinsics$.sha512(toBytes(value, true));
    }
})(global, global.$Intrinsics$);
