(function (self, $Intrinsics$) {
    var JSDate = self.Date;

    function toLocalDateTime(value) {
        if (value == null) {
            return null;
        } else if (value instanceof JSDate) {
            return $Intrinsics$.toLocalDateTime($Intrinsics$.toLong(Number(value)));
        } else if (value instanceof $Intrinsics$.LocalDateTime) {
            return value;
        } else if (value instanceof $Intrinsics$.Date) {
            return $Intrinsics$.toLocalDateTime(value);
        } else if ($Intrinsics$.isNumeric(value)) {
            return $Intrinsics$.toLocalDateTime($Intrinsics$.toLong(value));
        } else {
            return $Intrinsics$.toLocalDateTime(String(value));
        }
    }
    self.toLocalDateTime = toLocalDateTime;

    self.now = function now() {
        return $Intrinsics$.now();
    }

    self.parseDate = function parseDate(value) {
        if (arguments.length === 0) {
            return null;
        } else if (arguments.length === 1) {
            return $Intrinsics$.parseDate(String(value));
        } else {
            var format = String(arguments[1]);
            return $Intrinsics$.parseDate(String(value), format);
        }
    }

    self.parseISODate = function parseISODate(value) {
        if (arguments.length === 0) {
            return null;
        } else {
            return $Intrinsics$.parseISODate(String(value));
        }
    }

    self.parseGMTDate = function parseGMTDate(value) {
        if (arguments.length === 0) {
            return null;
        } else {
            return $Intrinsics$.parseGMTDate(String(value));
        }
    }

    self.formatDate = function formatDate(value) {
        if (arguments.length === 0) {
            return null;
        } else if (arguments.length === 1) {
            return $Intrinsics$.formatDate(toLocalDateTime(value));
        } else {
            var format = String(arguments[1]);
            return $Intrinsics$.formatDate(toLocalDateTime(value), format);
        }
    }

    self.formatISODate = function formatISODate(value) {
        if (arguments.length === 0) {
            return null;
        } else {
            return $Intrinsics$.formatISODate(toLocalDateTime(value));
        }
    }

    self.formatGMTDate = function formatGMTDate(value) {
        if (arguments.length === 0) {
            return null;
        } else {
            return $Intrinsics$.formatGMTDate(toLocalDateTime(value));
        }
    }
})(global, global.$Intrinsics$);
