(function (self, $Intrinsics$) {
    function toString(value) {
        if (arguments.length >= 2) {
            var number = Number(value);
            var radix = Number(arguments[1]);
            if (($Intrinsics$.isIntegral(number) || (isFinite(number) && Math.floor(number) === number)) && isFinite(radix)) {
                if (radix < 2 || radix > 36) {
                    throw new RangeError('toString() radix argument must be between 2 and 36');
                }
                return $Intrinsics$.integralToString(number, radix | 0);
            }
        }
        return String(value);
    }
    self.toString = toString;

    function getPadding(content, maxLength, fillString) {
        content = String(content);
        maxLength = maxLength | 0;
        fillString = fillString === undefined ? ' ' : String(fillString);

        var contentLength, fillLength, padding;
        contentLength = content.length;
        if (maxLength <= contentLength || fillString === '') return null;
        fillLength = maxLength - contentLength;

        padding = '';
        var i, n;
        n = Math.floor(fillLength / fillString.length);
        for (i = 0; i < n; i++) padding += fillString;
        if (padding.length < fillLength) padding += fillString.slice(0, fillLength - padding.length);
        return padding;
    }

    String.prototype.padStart = function padStart(maxLength, fillString) {
        var content = String(this);
        var padding = getPadding(content, maxLength, fillString);
        return padding != null ? padding + content : content;
    };

    String.prototype.padEnd = function padEnd(maxLength, fillString) {
        var content = String(this);
        var padding = getPadding(content, maxLength, fillString);
        return padding != null ? content + padding : content;
    };

    String.prototype.includes = function includes(searchString, position){
        return String(this).indexOf(searchString, position) >= 0;
    }

    String.prototype.trimStart = function trimStart(){
        return String(this).trimLeft();
    }

    String.prototype.trimEnd = function trimEnd(){
        return String(this).trimRight();
    }
})(global, global.$Intrinsics$);
