var Long = (function ($Intrinsics$) {
    var Long = Object.create(null);

    Long.ZERO = $Intrinsics$.toLong(0);
    Long.ONE = $Intrinsics$.toLong(1);
    Long.MIN_VALUE = $Intrinsics$.Long.MIN_VALUE;
    Long.MAX_VALUE = $Intrinsics$.Long.MAX_VALUE;

    Long.valueOf = function (value) {
        return $Intrinsics$.toLong(value);
    }

    Long.equals = function equals(x, y) {
        if (!$Intrinsics$.isNumeric(x) || !$Intrinsics$.isNumeric(y)) {
            return false;
        }
        return $Intrinsics$.longEquals($Intrinsics$.toLong(x), $Intrinsics$.toLong(y));
    }

    Long.compare = function compare(x, y) {
        return $Intrinsics$.longCompare($Intrinsics$.toLong(x), $Intrinsics$.toLong(y));
    }

    Long.add = function add(x, y) {
        if (arguments.length === 0) {
            return Long.ZERO;
        } else if (arguments.length === 1) {
            return $Intrinsics$.toLong(x);
        } else if (arguments.length === 2) {
            return $Intrinsics$.longAdd($Intrinsics$.toLong(x), $Intrinsics$.toLong(y));
        } else {
            var acc = $Intrinsics$.toLong(x);
            for (var i = 1; i < arguments.length; i++) {
                acc = $Intrinsics$.longAdd(acc, $Intrinsics$.toLong(arguments[i]));
            }
            return acc;
        }
    }

    Long.sub = function sub(x, y) {
        if (arguments.length === 0) {
            return Long.ZERO;
        } else if (arguments.length === 1) {
            return $Intrinsics$.toLong(x);
        } else if (arguments.length === 2) {
            return $Intrinsics$.longSub($Intrinsics$.toLong(x), $Intrinsics$.toLong(y));
        } else {
            var acc = $Intrinsics$.toLong(x);
            for (var i = 1; i < arguments.length; i++) {
                acc = $Intrinsics$.longSub(acc, $Intrinsics$.toLong(arguments[i]));
            }
            return acc;
        }
    }

    Long.mul = function sub(x, y) {
        if (arguments.length === 0) {
            return Long.ONE;
        } else if (arguments.length === 1) {
            return $Intrinsics$.toLong(x);
        } else if (arguments.length === 2) {
            return $Intrinsics$.longMul($Intrinsics$.toLong(x), $Intrinsics$.toLong(y));
        } else {
            var acc = $Intrinsics$.toLong(x);
            for (var i = 1; i < arguments.length; i++) {
                acc = $Intrinsics$.longMul(acc, $Intrinsics$.toLong(arguments[i]))
            }
            return acc;
        }
    }

    Long.div = function div(x, y) {
        var divider;
        if (arguments.length === 0) {
            return Long.ONE;
        } else if (arguments.length === 1) {
            return $Intrinsics$.toLong(x);
        } else if (arguments.length === 2) {
            divider = $Intrinsics$.toLong(y);
            if ($Intrinsics$.longEquals(divider, Long.ZERO)) throw new RangeError('divide by zero');
            return $Intrinsics$.longDiv($Intrinsics$.toLong(x), divider);
        } else {
            var acc = $Intrinsics$.toLong(x);
            for (var i = 1; i < arguments.length; i++) {
                divider = $Intrinsics$.toLong(arguments[i]);
                if ($Intrinsics$.longEquals(divider, Long.ZERO)) throw new RangeError('divide by zero');
                acc = $Intrinsics$.longDiv(acc, divider);
            }
            return acc;
        }
    }

    Long.mod = function mod(x, y) {
        var divider;
        if (arguments.length === 0) {
            return Long.ONE;
        } else if (arguments.length === 1) {
            return $Intrinsics$.toLong(x);
        } else if (arguments.length === 2) {
            divider = $Intrinsics$.toLong(y);
            if ($Intrinsics$.longEquals(divider, Long.ZERO)) throw new RangeError('divide by zero');
            return $Intrinsics$.longMod($Intrinsics$.toLong(x), divider);
        } else {
            var acc = $Intrinsics$.toLong(x);
            for (var i = 1; i < arguments.length; i++) {
                divider = $Intrinsics$.toLong(arguments[i]);
                if ($Intrinsics$.longEquals(divider, Long.ZERO)) throw new RangeError('divide by zero');
                acc = $Intrinsics$.longMod(acc, divider);
            }
            return acc;
        }
    }

    Long.abs = function abs(x) {
         return $Intrinsics$.longAbs($Intrinsics$.toLong(x))
    }

    Long.sign = function sign(x) {
        return $Intrinsics$.longSign($Intrinsics$.toLong(x))
    }

    Long.max = function max(x, y) {
         if (arguments.length === 0) {
               return Long.MIN_VALUE;
         } else if (arguments.length === 1) {
               return $Intrinsics$.toLong(x);
         } else {
             var max = $Intrinsics$.toLong(x);
             for (var i = 1; i < arguments.length; i++) {
                 max = $Intrinsics$.longMax(max, $Intrinsics$.toLong(arguments[i]));
             }
             return max;
         }
    }

    Long.min = function min(x, y) {
         if (arguments.length === 0) {
               return Long.MAX_VALUE;
         } else if (arguments.length === 1) {
               return $Intrinsics$.toLong(x);
         } else {
             var min = $Intrinsics$.toLong(x);
             for (var i = 1; i < arguments.length; i++) {
                 min = $Intrinsics$.longMin(min, $Intrinsics$.toLong(arguments[i]));
             }
             return min;
         }
    }

    Long.parse = function parseLong(string, radix) {
        if (arguments.length === 0){
            return Long.ZERO;
        } else if (arguments.length === 1){
            return $Intrinsics$.parseLong(String(string));
        } else {
            var r = $Intrinsics$.toInt(radix);
            if (r < 2 || r > 36) throw new RangeError('Long.parse() radix argument must be between 2 and 36');
            return $Intrinsics$.parseLong(String(string), r);
        }
    }

    Long.toString = function toString(number, radix) {
        if(arguments.length === 1){
            return $Intrinsics$.longToString($Intrinsics$.toLong(number));
        } else {
            var r = $Intrinsics$.toInt(radix);
            if (r < 2 || r > 36) return '';
            return $Intrinsics$.longToString($Intrinsics$.toLong(number), r);
        }
    }

    return Long;
})(global.$Intrinsics$);

var Integer = (function ($Intrinsics$) {
    var Integer = Object.create(null);

    Integer.ZERO = $Intrinsics$.toInt(0);
    Integer.ONE = $Intrinsics$.toInt(1);
    Integer.MIN_VALUE = $Intrinsics$.Integer.MIN_VALUE;
    Integer.MAX_VALUE = $Intrinsics$.Integer.MAX_VALUE;

    Integer.valueOf = function (value) {
        return $Intrinsics$.toInt(value);
    }

    Integer.equals = function equals(x, y) {
        if (!$Intrinsics$.isNumeric(x) || !$Intrinsics$.isNumeric(y)) {
            return false;
        }
        return $Intrinsics$.intEquals($Intrinsics$.toInt(x), $Intrinsics$.toInt(y));
    }

    Integer.compare = function compare(x, y) {
        return $Intrinsics$.intCompare($Intrinsics$.toInt(x), $Intrinsics$.toInt(y));
    }

    Integer.add = function add(x, y) {
        if (arguments.length === 0) {
            return Integer.ZERO;
        } else if (arguments.length === 1) {
            return $Intrinsics$.toInt(x);
        } else if (arguments.length === 2) {
            return $Intrinsics$.intAdd($Intrinsics$.toInt(x), $Intrinsics$.toInt(y));
        } else {
            var acc = $Intrinsics$.toInt(x);
            for (var i = 1; i < arguments.length; i++) {
                acc = $Intrinsics$.intAdd(acc, $Intrinsics$.toInt(arguments[i]));
            }
            return acc;
        }
    }

    Integer.sub = function sub(x, y) {
        if (arguments.length === 0) {
            return Integer.ZERO;
        } else if (arguments.length === 1) {
            return $Intrinsics$.toInt(x);
        } else if (arguments.length === 2) {
            return $Intrinsics$.intSub($Intrinsics$.toInt(x), $Intrinsics$.toInt(y));
        } else {
            var acc = $Intrinsics$.toInt(x);
            for (var i = 1; i < arguments.length; i++) {
                acc = $Intrinsics$.intSub(acc, $Intrinsics$.toInt(arguments[i]));
            }
            return acc;
        }
    }

    Integer.mul = function mul(x, y) {
        if (arguments.length === 0) {
            return Integer.ONE;
        } else if (arguments.length === 1) {
            return $Intrinsics$.toInt(x);
        } else if (arguments.length === 2) {
            return $Intrinsics$.intMul($Intrinsics$.toInt(x), $Intrinsics$.toInt(y));
        } else {
            var acc = $Intrinsics$.toInt(x);
            for (var i = 1; i < arguments.length; i++) {
                acc = $Intrinsics$.intMul(acc, $Intrinsics$.toInt(arguments[i]))
            }
            return acc;
        }
    }

    Integer.div = function div(x, y) {
        var divider;
        if (arguments.length === 0) {
            return Integer.ONE;
        } else if (arguments.length === 1) {
            return $Intrinsics$.toInt(x);
        } else if (arguments.length === 2) {
            divider = $Intrinsics$.toInt(y);
            if ($Intrinsics$.intEquals(divider, Integer.ZERO)) throw new RangeError('divide by zero');
            return $Intrinsics$.intDiv($Intrinsics$.toInt(x), divider);
        } else {
            var acc = $Intrinsics$.toInt(x);
            for (var i = 1; i < arguments.length; i++) {
                divider = $Intrinsics$.toInt(arguments[i]);
                if ($Intrinsics$.intEquals(divider, Integer.ZERO)) throw new RangeError('divide by zero');
                acc = $Intrinsics$.intDiv(acc, divider);
            }
            return acc;
        }
    }

    Integer.mod = function mod(x, y) {
        var divider;
        if (arguments.length === 0) {
            return Integer.ONE;
        } else if (arguments.length === 1) {
            return $Intrinsics$.toInt(x);
        } else if (arguments.length === 2) {
            divider = $Intrinsics$.toInt(y);
            if ($Intrinsics$.intEquals(divider, Integer.ZERO)) throw new RangeError('divide by zero');
            return $Intrinsics$.intMod($Intrinsics$.toInt(x), divider);
        } else {
            var acc = $Intrinsics$.toInt(x);
            for (var i = 1; i < arguments.length; i++) {
                divider = $Intrinsics$.toInt(arguments[i]);
                if ($Intrinsics$.intEquals(divider, Integer.ZERO)) throw new RangeError('divide by zero');
                acc = $Intrinsics$.intMod(acc, divider);
            }
            return acc;
        }
    }

    Integer.abs = function abs(x) {
         return $Intrinsics$.intAbs($Intrinsics$.toInt(x))
    }

    Integer.sign = function sign(x) {
        return $Intrinsics$.intSign($Intrinsics$.toInt(x))
    }

    Integer.max = function max(x, y) {
         if (arguments.length === 0) {
               return Integer.MIN_VALUE;
         } else if (arguments.length === 1) {
               return $Intrinsics$.toInt(x);
         } else {
             var max = $Intrinsics$.toInt(x);
             for (var i = 1; i < arguments.length; i++) {
                 max = $Intrinsics$.intMax(max, $Intrinsics$.toInt(arguments[i]));
             }
             return max;
         }
    }

    Integer.min = function min(x, y) {
         if (arguments.length === 0) {
               return Integer.MAX_VALUE;
         } else if (arguments.length === 1) {
               return $Intrinsics$.toInt(x);
         } else {
             var min = $Intrinsics$.toInt(x);
             for (var i = 1; i < arguments.length; i++) {
                 min = $Intrinsics$.intMin(min, $Intrinsics$.toInt(arguments[i]))
             }
             return min;
         }
    }

    Integer.parse = function parseInt(string, radix) {
         if (arguments.length === 0){
             return Integer.ZERO;
         } else if (arguments.length === 1){
             return $Intrinsics$.parseInt(String(string));
         } else {
             var r = $Intrinsics$.toInt(radix);
             if (r < 2 || r > 36) throw new RangeError('Integer.parse() radix argument must be between 2 and 36');
             return $Intrinsics$.parseInt(String(string), r);
         }
    }

    Integer.toString = function toString(number, radix) {
        if (arguments.length === 1){
            return $Intrinsics$.intToString($Intrinsics$.toInt(number));
        } else {
            var r = $Intrinsics$.toInt(radix);
            if (r < 2 || r > 36) return '';
            return $Intrinsics$.intToString($Intrinsics$.toInt(number), r);
        }
    }

    return Integer;
})(global.$Intrinsics$);

Number.MAX_SAFE_INTEGER = 9007199254740991;
Number.MIN_SAFE_INTEGER = -9007199254740991;

Number.isNaN = isNaN;
Number.isFinite = isFinite;
Number.parseInt = parseInt;
Number.parseFloat = parseFloat;

Number.isInteger = function isInteger(number) {
    return isFinite(number) && Math.floor(number) === number;
}

Number.isSafeInteger = function isSafeInteger(number) {
    return isFinite(number) && Math.floor(number) === number &&
        number <= Number.MAX_SAFE_INTEGER && number >= Number.MIN_SAFE_INTEGER;
}

function parseDouble() {
    return parseFloat.apply(this, arguments);
}
