/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.expression.runtime.es5;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public final class ES5Intrinsics {
    private static final List<DateTimeFormatter> LEGACY_DATE_TIME_FORMATTERS = new ArrayList<DateTimeFormatter>();
    private static final DateTimeFormatter DEFAULT_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    private ES5Intrinsics() {
    }

    public static String getClassName(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass().getName();
    }

    public static boolean isNullity(Object value) {
        return value == null || ScriptObjectMirror.isUndefined((Object)value);
    }

    public static boolean isNumeric(Object object) {
        return object instanceof Number;
    }

    public static boolean isIntegral(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz == null) {
            return false;
        }
        return clazz == Integer.class || clazz == Long.class || clazz == BigInteger.class || clazz == Short.class || clazz == Byte.class;
    }

    public static String integralToString(Number number, int radix) {
        Class<?> clazz = number.getClass();
        if (clazz == null) {
            return null;
        }
        if (clazz == Integer.class) {
            return Integer.toString((Integer)number, radix);
        }
        if (clazz == Long.class) {
            return Long.toString((Long)number, radix);
        }
        if (clazz == BigInteger.class) {
            return ((BigInteger)number).toString(radix);
        }
        if (clazz == Short.class) {
            return Integer.toString(((Short)number).shortValue(), radix);
        }
        if (clazz == Byte.class) {
            return Integer.toString(((Byte)number).byteValue(), radix);
        }
        return Long.toString(number.longValue(), radix);
    }

    public static long toLong(Object object) {
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        return 0L;
    }

    public static int longCompare(long x, long y) {
        return Long.compare(x, y);
    }

    public static boolean longEquals(long x, long y) {
        return x == y;
    }

    public static long longAdd(long x, long y) {
        return x + y;
    }

    public static long longSub(long x, long y) {
        return x - y;
    }

    public static long longMul(long x, long y) {
        return x * y;
    }

    public static Long longDiv(long x, long y) {
        return x / y;
    }

    public static Long longMod(long x, long y) {
        return x % y;
    }

    public static int longSign(long x) {
        return Long.signum(x);
    }

    public static long longAbs(long x) {
        return Math.abs(x);
    }

    public static long longMax(long x, long y) {
        return Long.max(x, y);
    }

    public static long longMin(long x, long y) {
        return Long.min(x, y);
    }

    public static long parseLong(String string) {
        return Long.parseLong(string);
    }

    public static long parseLong(String string, int radix) {
        return Long.parseLong(string, radix);
    }

    public static String longToString(long x) {
        return Long.toString(x);
    }

    public static String longToString(long x, int radix) {
        return Long.toString(x, radix);
    }

    public static int toInt(Object object) {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return 0;
    }

    public static int intCompare(int x, int y) {
        return Integer.compare(x, y);
    }

    public static boolean intEquals(long x, long y) {
        return x == y;
    }

    public static long intAdd(long x, long y) {
        return x + y;
    }

    public static long intSub(long x, long y) {
        return x - y;
    }

    public static long intMul(long x, long y) {
        return x * y;
    }

    public static Long intDiv(long x, long y) {
        return x / y;
    }

    public static Long intMod(long x, long y) {
        return x % y;
    }

    public static int intSign(int x) {
        return Integer.signum(x);
    }

    public static long intAbs(int x) {
        return Math.abs(x);
    }

    public static int intMax(int x, int y) {
        return Integer.max(x, y);
    }

    public static int intMin(int x, int y) {
        return Integer.min(x, y);
    }

    public static int parseInt(String string) {
        return Integer.parseInt(string);
    }

    public static int parseInt(String string, int radix) {
        return Integer.parseInt(string, radix);
    }

    public static String intToString(int x) {
        return Integer.toString(x);
    }

    public static String intToString(int x, int radix) {
        return Integer.toString(x, radix);
    }

    public static LocalDateTime toLocalDateTime(String stringDate) {
        if (ES5Intrinsics.isNullity(stringDate)) {
            return null;
        }
        return ES5Intrinsics.parseDate(stringDate);
    }

    public static LocalDateTime toLocalDateTime(Long timestamp) {
        if (ES5Intrinsics.isNullity(timestamp)) {
            return null;
        }
        try {
            return Instant.ofEpochMilli(timestamp).atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        catch (RuntimeException ignored) {
            return null;
        }
    }

    public static LocalDateTime toLocalDateTime(Date javaDate) {
        if (ES5Intrinsics.isNullity(javaDate)) {
            return null;
        }
        try {
            Instant instant = javaDate.toInstant();
            return instant.atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        catch (RuntimeException ignored) {
            return null;
        }
    }

    public static LocalDateTime now() {
        return LocalDateTime.now();
    }

    public static LocalDateTime parseDate(String stringDate, String format) {
        if (ES5Intrinsics.isNullity(stringDate)) {
            return null;
        }
        if (ES5Intrinsics.isNullity(format)) {
            try {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
                return LocalDateTime.parse(stringDate, formatter);
            }
            catch (RuntimeException ignored) {
                return null;
            }
        }
        return null;
    }

    public static LocalDateTime parseDate(String stringDate) {
        if (ES5Intrinsics.isNullity(stringDate)) {
            return null;
        }
        LocalDateTime date = null;
        for (DateTimeFormatter legacyFormat : LEGACY_DATE_TIME_FORMATTERS) {
            try {
                date = LocalDateTime.parse(stringDate, legacyFormat);
            }
            catch (RuntimeException runtimeException) {}
        }
        if (date == null) {
            date = ES5Intrinsics.parseISODate(stringDate);
        }
        if (date == null) {
            date = ES5Intrinsics.parseGMTDate(stringDate);
        }
        return date;
    }

    public static LocalDateTime parseISODate(String stringDate) {
        if (ES5Intrinsics.isNullity(stringDate)) {
            return null;
        }
        try {
            return LocalDateTime.parse(stringDate, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        catch (RuntimeException runtimeException) {
            try {
                return Instant.parse(stringDate).atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
            catch (RuntimeException runtimeException2) {
                try {
                    return OffsetDateTime.parse(stringDate, DateTimeFormatter.ISO_OFFSET_DATE_TIME).atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
                }
                catch (RuntimeException runtimeException3) {
                    try {
                        return ZonedDateTime.parse(stringDate, DateTimeFormatter.ISO_ZONED_DATE_TIME).toOffsetDateTime().atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
                    }
                    catch (RuntimeException runtimeException4) {
                        return null;
                    }
                }
            }
        }
    }

    public static LocalDateTime parseGMTDate(String stringDate) {
        if (ES5Intrinsics.isNullity(stringDate)) {
            return null;
        }
        try {
            return OffsetDateTime.parse(stringDate, DateTimeFormatter.RFC_1123_DATE_TIME).atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
        }
        catch (RuntimeException ignored) {
            return null;
        }
    }

    public static String formatDate(LocalDateTime date, String format) {
        if (ES5Intrinsics.isNullity(date)) {
            return null;
        }
        try {
            return date.format(DateTimeFormatter.ofPattern(format));
        }
        catch (RuntimeException ignored) {
            return null;
        }
    }

    public static String formatDate(LocalDateTime date) {
        if (ES5Intrinsics.isNullity(date)) {
            return null;
        }
        return DEFAULT_DATE_FORMATTER.format(date);
    }

    public static String formatISODate(LocalDateTime date) {
        if (ES5Intrinsics.isNullity(date)) {
            return null;
        }
        return date.atZone(ZoneId.systemDefault()).toOffsetDateTime().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public static String formatGMTDate(LocalDateTime date) {
        if (ES5Intrinsics.isNullity(date)) {
            return null;
        }
        return date.atZone(ZoneId.systemDefault()).toOffsetDateTime().atZoneSameInstant(ZoneId.of("GMT")).format(DateTimeFormatter.RFC_1123_DATE_TIME);
    }

    public static byte[] toLatin1(CharSequence data) {
        return data.toString().getBytes(StandardCharsets.ISO_8859_1);
    }

    public static String fromLatin1(byte[] bytes) {
        return new String(bytes, StandardCharsets.ISO_8859_1);
    }

    public static byte[] toUtf8(CharSequence data) {
        return data.toString().getBytes(StandardCharsets.UTF_8);
    }

    public static String fromUtf8(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String base64Encode(byte[] data) {
        return ES5Intrinsics.base64Encode(data, false);
    }

    public static String base64Encode(byte[] data, boolean urlSafe) {
        Base64.Encoder encoder = urlSafe ? Base64.getUrlEncoder() : Base64.getEncoder();
        return encoder.encodeToString(data);
    }

    public static byte[] base64Decode(String base64) {
        boolean urlSafe = StringUtils.containsAny((CharSequence)base64, (char[])new char[]{'-', '_'});
        return ES5Intrinsics.base64Decode(base64, urlSafe);
    }

    public static byte[] base64Decode(String base64, boolean urlSafe) {
        Base64.Decoder decoder;
        Base64.Decoder decoder2 = decoder = urlSafe ? Base64.getUrlDecoder() : Base64.getDecoder();
        if (base64.length() % 4 != 0 && !base64.endsWith("=")) {
            int padding = 4 - base64.length() % 4;
            StringBuilder builder = new StringBuilder(base64.length() + padding);
            builder.append(base64);
            for (int i = 0; i < padding; ++i) {
                builder.append('=');
            }
            base64 = builder.toString();
        }
        return decoder.decode(base64);
    }

    public static String md5(byte[] data) {
        return DigestUtils.md5Hex((byte[])data);
    }

    public static String sha1(byte[] data) {
        return DigestUtils.sha1Hex((byte[])data);
    }

    public static String sha256(byte[] data) {
        return DigestUtils.sha256Hex((byte[])data);
    }

    public static String sha512(byte[] data) {
        return DigestUtils.sha512Hex((byte[])data);
    }

    static {
        LEGACY_DATE_TIME_FORMATTERS.add(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LEGACY_DATE_TIME_FORMATTERS.add(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LEGACY_DATE_TIME_FORMATTERS.add(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
    }
}

