/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.expression.runtime.es5;

import com.jxdinfo.hussar.integration.support.expression.runtime.es5.ES5Intrinsics;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class ES5BuiltinFunctions {
    private ES5BuiltinFunctions() {
    }

    public static Integer parseInteger(String string) {
        return ES5BuiltinFunctions.parseInteger(string, 10);
    }

    public static Integer parseInteger(String string, int radix) {
        if (ES5Intrinsics.isNullity(string) || radix < 2 || radix > 36) {
            return null;
        }
        char DECIMAL_DIGIT_BOUND = (char)(48 + Integer.min(10, radix));
        char UPPER_LETTER_DIGIT_BOUND = (char)(65 + Integer.max(0, radix - 10));
        char LOWER_LETTER_DIGIT_BOUND = (char)(97 + Integer.max(0, radix - 10));
        boolean STATE_INIT = false;
        boolean STATE_SIGN = true;
        int STATE_DIGITS = 2;
        int value = 0;
        boolean negative = false;
        int state = 0;
        for (int i = 0; i < string.length(); ++i) {
            int digit;
            char ch = string.charAt(i);
            if (Character.isSpaceChar(ch) && state == 0) continue;
            if ((ch == '-' || ch == '+') && state == 0) {
                negative = ch == '-';
                state = 1;
                continue;
            }
            if (ch >= '0' && ch < DECIMAL_DIGIT_BOUND) {
                digit = ch - 48;
            } else if (ch >= 'A' && ch < UPPER_LETTER_DIGIT_BOUND) {
                digit = ch - 65 + 10;
            } else if (ch >= 'a' && ch < LOWER_LETTER_DIGIT_BOUND) {
                digit = ch - 97 + 10;
            } else {
                if (state == 2) break;
                return null;
            }
            state = 2;
            try {
                value = Math.multiplyExact(value, radix);
                value = negative ? Math.subtractExact(value, digit) : Math.addExact(value, digit);
                continue;
            }
            catch (ArithmeticException ignore) {
                return negative ? Integer.MIN_VALUE : Integer.MAX_VALUE;
            }
        }
        if (state == 2) {
            return value;
        }
        return null;
    }

    public static Long parseLong(String string) {
        return ES5BuiltinFunctions.parseLong(string, 10);
    }

    public static Long parseLong(String string, int radix) {
        if (ES5Intrinsics.isNullity(string) || radix < 2 || radix > 36) {
            return null;
        }
        char DECIMAL_DIGIT_BOUND = (char)(48 + Integer.min(10, radix));
        char UPPER_LETTER_DIGIT_BOUND = (char)(65 + Integer.max(0, radix - 10));
        char LOWER_LETTER_DIGIT_BOUND = (char)(97 + Integer.max(0, radix - 10));
        boolean STATE_INIT = false;
        boolean STATE_SIGN = true;
        int STATE_DIGITS = 2;
        long value = 0L;
        boolean negative = false;
        int state = 0;
        for (int i = 0; i < string.length(); ++i) {
            int digit;
            char ch = string.charAt(i);
            if (Character.isSpaceChar(ch) && state == 0) continue;
            if ((ch == '-' || ch == '+') && state == 0) {
                negative = ch == '-';
                state = 1;
                continue;
            }
            if (ch >= '0' && ch < DECIMAL_DIGIT_BOUND) {
                digit = ch - 48;
            } else if (ch >= 'A' && ch < UPPER_LETTER_DIGIT_BOUND) {
                digit = ch - 65 + 10;
            } else if (ch >= 'a' && ch < LOWER_LETTER_DIGIT_BOUND) {
                digit = ch - 97 + 10;
            } else {
                if (state == 2) break;
                return null;
            }
            state = 2;
            try {
                value = Math.multiplyExact(value, (long)radix);
                value = negative ? Math.subtractExact(value, (long)digit) : Math.addExact(value, (long)digit);
                continue;
            }
            catch (ArithmeticException ignore) {
                return negative ? Long.MIN_VALUE : Long.MAX_VALUE;
            }
        }
        if (state == 2) {
            return value;
        }
        return null;
    }

    public static String formatNumber(Number number) {
        return ES5BuiltinFunctions.formatNumber(number, 10);
    }

    public static String formatNumber(Number number, int radix) {
        if (ES5Intrinsics.isNullity(number) || radix < 2 || radix > 36) {
            return null;
        }
        if (number instanceof Double || number instanceof Float || number instanceof BigDecimal) {
            return number.toString();
        }
        if (number instanceof BigInteger) {
            return ((BigInteger)number).toString(radix);
        }
        return Long.toString(number.longValue(), radix);
    }
}

