/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.expression.engine.es5.utils;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class ES5TypeUtils {
    private static final Map<Class<?>, Class<?>> WRAPPER_TYPES = ES5TypeUtils.createWrapperTypes();
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TYPES = ES5TypeUtils.invertMap(WRAPPER_TYPES);
    private static final Map<String, Class<?>> PRIMITIVE_TYPES_BY_NAME = ES5TypeUtils.createClassNameMapping(WRAPPER_TYPES.keySet());

    private ES5TypeUtils() {
    }

    private static Map<Class<?>, Class<?>> createWrapperTypes() {
        IdentityHashMap<Class<Object>, Class<Double>> wrapperTypes = new IdentityHashMap<Class<Object>, Class<Double>>(8);
        wrapperTypes.put(Void.TYPE, Void.class);
        wrapperTypes.put(Boolean.TYPE, Boolean.class);
        wrapperTypes.put(Byte.TYPE, Byte.class);
        wrapperTypes.put(Character.TYPE, Character.class);
        wrapperTypes.put(Short.TYPE, Short.class);
        wrapperTypes.put(Integer.TYPE, Integer.class);
        wrapperTypes.put(Long.TYPE, Long.class);
        wrapperTypes.put(Float.TYPE, Float.class);
        wrapperTypes.put(Double.TYPE, Double.class);
        return Collections.unmodifiableMap(wrapperTypes);
    }

    private static Map<String, Class<?>> createClassNameMapping(Collection<Class<?>> classes) {
        HashMap map = new HashMap();
        for (Class<?> clazz : classes) {
            map.put(clazz.getName(), clazz);
        }
        return map;
    }

    private static <K, V> Map<V, K> invertMap(Map<K, V> map) {
        IdentityHashMap<V, K> inverted = new IdentityHashMap<V, K>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            inverted.put(entry.getValue(), entry.getKey());
        }
        return Collections.unmodifiableMap(inverted);
    }

    public static boolean isMethodInvocationConvertible(Class<?> sourceType, Class<?> targetType) {
        if (targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        if (sourceType.isPrimitive()) {
            if (targetType.isPrimitive()) {
                return ES5TypeUtils.isProperPrimitiveSubtype(sourceType, targetType);
            }
            return ES5TypeUtils.isBoxingAndWideningReferenceConversion(sourceType, targetType);
        }
        if (targetType.isPrimitive()) {
            Class<?> unboxedCallSiteType = ES5TypeUtils.getPrimitiveType(sourceType);
            return unboxedCallSiteType != null && (unboxedCallSiteType == targetType || ES5TypeUtils.isProperPrimitiveSubtype(unboxedCallSiteType, targetType));
        }
        return false;
    }

    private static boolean isBoxingAndWideningReferenceConversion(Class<?> sourceType, Class<?> targetType) {
        Class<?> wrapperType = ES5TypeUtils.getWrapperType(sourceType);
        assert (wrapperType != null) : sourceType.getName();
        return targetType.isAssignableFrom(wrapperType);
    }

    public static boolean isConvertibleWithoutLoss(Class<?> sourceType, Class<?> targetType) {
        if (targetType.isAssignableFrom(sourceType) || targetType == Void.TYPE) {
            return true;
        }
        if (sourceType.isPrimitive()) {
            if (sourceType == Void.TYPE) {
                return targetType == Object.class;
            }
            if (targetType.isPrimitive()) {
                return ES5TypeUtils.isProperPrimitiveLosslessSubtype(sourceType, targetType);
            }
            return ES5TypeUtils.isBoxingAndWideningReferenceConversion(sourceType, targetType);
        }
        return false;
    }

    public static boolean isSubtype(Class<?> subType, Class<?> superType) {
        if (superType.isAssignableFrom(subType)) {
            return true;
        }
        if (superType.isPrimitive() && subType.isPrimitive()) {
            return ES5TypeUtils.isProperPrimitiveSubtype(subType, superType);
        }
        return false;
    }

    private static boolean isProperPrimitiveSubtype(Class<?> subType, Class<?> superType) {
        if (superType == Boolean.TYPE || subType == Boolean.TYPE) {
            return false;
        }
        if (subType == Byte.TYPE) {
            return superType != Character.TYPE;
        }
        if (subType == Character.TYPE) {
            return superType != Short.TYPE && superType != Byte.TYPE;
        }
        if (subType == Short.TYPE) {
            return superType != Character.TYPE && superType != Byte.TYPE;
        }
        if (subType == Integer.TYPE) {
            return superType == Long.TYPE || superType == Float.TYPE || superType == Double.TYPE;
        }
        if (subType == Long.TYPE) {
            return superType == Float.TYPE || superType == Double.TYPE;
        }
        if (subType == Float.TYPE) {
            return superType == Double.TYPE;
        }
        return false;
    }

    private static boolean isProperPrimitiveLosslessSubtype(Class<?> subType, Class<?> superType) {
        if (superType == Boolean.TYPE || subType == Boolean.TYPE) {
            return false;
        }
        if (superType == Character.TYPE || subType == Character.TYPE) {
            return false;
        }
        if (subType == Byte.TYPE) {
            return true;
        }
        if (subType == Short.TYPE) {
            return superType != Byte.TYPE;
        }
        if (subType == Integer.TYPE) {
            return superType == Long.TYPE || superType == Double.TYPE;
        }
        if (subType == Float.TYPE) {
            return superType == Double.TYPE;
        }
        return false;
    }

    public static Class<?> getPrimitiveTypeByName(String name) {
        return PRIMITIVE_TYPES_BY_NAME.get(name);
    }

    public static Class<?> getPrimitiveType(Class<?> wrapperType) {
        return PRIMITIVE_TYPES.get(wrapperType);
    }

    public static Class<?> getWrapperType(Class<?> primitiveType) {
        return WRAPPER_TYPES.get(primitiveType);
    }

    public static boolean isWrapperType(Class<?> type) {
        return PRIMITIVE_TYPES.containsKey(type);
    }

    public static List<MethodHandle> getMaximallySpecificMethods(List<MethodHandle> methods, boolean varArgs) {
        return ES5TypeUtils.getMaximallySpecificMethods(methods, varArgs, MethodHandle::type);
    }

    private static <T> List<T> getMaximallySpecificMethods(List<T> methods, boolean varArgs, Function<T, MethodType> methodTypeGetter) {
        if (methods.size() < 2) {
            return methods;
        }
        LinkedList<T> maximals = new LinkedList<T>();
        for (T m : methods) {
            MethodType methodType = methodTypeGetter.apply(m);
            boolean lessSpecific = false;
            Iterator maximal = maximals.iterator();
            block6: while (maximal.hasNext()) {
                Object max = maximal.next();
                switch (ES5TypeUtils.isMoreSpecific(methodType, methodTypeGetter.apply(max), varArgs)) {
                    case TYPE_1_BETTER: {
                        maximal.remove();
                        continue block6;
                    }
                    case TYPE_2_BETTER: {
                        lessSpecific = true;
                        continue block6;
                    }
                    case INDETERMINATE: {
                        continue block6;
                    }
                }
                throw new AssertionError();
            }
            if (lessSpecific) continue;
            maximals.addLast(m);
        }
        return maximals;
    }

    private static Comparison isMoreSpecific(MethodType t1, MethodType t2, boolean varArgs) {
        int pc1 = t1.parameterCount();
        int pc2 = t2.parameterCount();
        assert (varArgs || pc1 == pc2);
        int maxPc = Math.max(pc1, pc2);
        boolean t1MoreSpecific = false;
        boolean t2MoreSpecific = false;
        for (int i = 1; i < maxPc; ++i) {
            Class<?> c2;
            Class<?> c1 = ES5TypeUtils.getParameterClass(t1, pc1, i, varArgs);
            if (c1 == (c2 = ES5TypeUtils.getParameterClass(t2, pc2, i, varArgs))) continue;
            Comparison cmp = ES5TypeUtils.compare(c1, c2, i);
            if (cmp == Comparison.TYPE_1_BETTER && !t1MoreSpecific) {
                t1MoreSpecific = true;
                if (t2MoreSpecific) {
                    return Comparison.INDETERMINATE;
                }
            }
            if (cmp != Comparison.TYPE_2_BETTER || t2MoreSpecific) continue;
            t2MoreSpecific = true;
            if (!t1MoreSpecific) continue;
            return Comparison.INDETERMINATE;
        }
        if (t1MoreSpecific) {
            return Comparison.TYPE_1_BETTER;
        }
        if (t2MoreSpecific) {
            return Comparison.TYPE_2_BETTER;
        }
        return Comparison.INDETERMINATE;
    }

    private static Comparison compare(Class<?> c1, Class<?> c2, int i) {
        if (ES5TypeUtils.isSubtype(c1, c2)) {
            return Comparison.TYPE_1_BETTER;
        }
        if (ES5TypeUtils.isSubtype(c2, c1)) {
            return Comparison.TYPE_2_BETTER;
        }
        return Comparison.INDETERMINATE;
    }

    private static Class<?> getParameterClass(MethodType t, int l, int i, boolean varArgs) {
        return varArgs && i >= l - 1 ? ((Class)t.parameterType(l - 1)).getComponentType() : t.parameterType(i);
    }

    private static enum Comparison {
        INDETERMINATE,
        TYPE_1_BETTER,
        TYPE_2_BETTER;

    }
}

