/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.expression.engine.es5.utils;

import com.jxdinfo.hussar.integration.support.expression.engine.es5.objects.ES5Function;
import com.jxdinfo.hussar.integration.support.expression.engine.es5.utils.ES5TypeUtils;
import com.jxdinfo.hussar.integration.support.expression.exception.HussarExpressionCreationException;
import com.jxdinfo.hussar.integration.support.expression.exception.es5.HussarExpressionES5NativeCallException;
import com.jxdinfo.hussar.integration.support.expression.properties.HussarExpressionProperties;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;

public final class ES5DynamicBindingUtils {
    private static final String INACCESSIBLE_EXCEPTION_CLASS = "java.lang.reflect.InaccessibleObjectException";
    private static final List<String> STATIC_CLASS_CLASS = Arrays.asList("jdk.internal.dynalink.beans.StaticClass", "jdk.dynalink.beans.StaticClass");
    private static final List<String> SINGLE_DYNAMIC_METHOD_CLASS = Arrays.asList("jdk.internal.dynalink.beans.SingleDynamicMethod", "jdk.dynalink.beans.SingleDynamicMethod");
    private static final List<String> SIMPLE_DYNAMIC_METHOD_CLASS = Arrays.asList("jdk.internal.dynalink.beans.SimpleDynamicMethod", "jdk.dynalink.beans.SimpleDynamicMethod");
    private static final List<String> OVERLOADED_DYNAMIC_METHOD_CLASS = Arrays.asList("jdk.internal.dynalink.beans.OverloadedDynamicMethod", "jdk.dynalink.beans.OverloadedDynamicMethod");
    private static volatile HussarExpressionProperties properties = null;

    private ES5DynamicBindingUtils() {
    }

    public static Object getJavaClass(Class<?> clazz) {
        Method staticClassForClassMethod;
        Class<?> staticClassClass = ES5DynamicBindingUtils.loadDynalinkClass(STATIC_CLASS_CLASS);
        try {
            staticClassForClassMethod = staticClassClass.getMethod("forClass", Class.class);
            staticClassForClassMethod.setAccessible(true);
        }
        catch (NoSuchMethodException ex) {
            throw new HussarExpressionCreationException((Throwable)ex);
        }
        try {
            return staticClassForClassMethod.invoke(null, clazz);
        }
        catch (InvocationTargetException ex) {
            throw new HussarExpressionCreationException(ex.getTargetException());
        }
        catch (IllegalAccessException ex) {
            throw new HussarExpressionCreationException((Throwable)ex);
        }
    }

    public static Map<String, Object> getDynamicStaticMethods(Class<?> utility, String ... includes) {
        Map<String, List<MethodHandle>> groupedMethods;
        block3: {
            groupedMethods = ES5DynamicBindingUtils.getGroupedMethods(utility, includes);
            if (ES5DynamicBindingUtils.isEnableJdkDynalink()) {
                try {
                    return ES5DynamicBindingUtils.createDynamicMethodsByDynalink(utility, groupedMethods);
                }
                catch (RuntimeException ex) {
                    if (INACCESSIBLE_EXCEPTION_CLASS.equals(ex.getClass().getName())) break block3;
                    throw ex;
                }
            }
        }
        return ES5DynamicBindingUtils.createDynamicMethodsByWrappingES5Function(utility, groupedMethods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isEnableJdkDynalink() {
        try {
            if (properties != null) return Optional.ofNullable(properties).map(HussarExpressionProperties::getEnableJdkDynalink).orElse(false);
            Class<ES5DynamicBindingUtils> clazz = ES5DynamicBindingUtils.class;
            synchronized (ES5DynamicBindingUtils.class) {
                if (properties != null) return Optional.ofNullable(properties).map(HussarExpressionProperties::getEnableJdkDynalink).orElse(false);
                properties = (HussarExpressionProperties)SpringContextUtil.getBean(HussarExpressionProperties.class);
                // ** MonitorExit[var0] (shouldn't be in output)
                return Optional.ofNullable(properties).map(HussarExpressionProperties::getEnableJdkDynalink).orElse(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.ofNullable(properties).map(HussarExpressionProperties::getEnableJdkDynalink).orElse(false);
    }

    private static Map<String, List<MethodHandle>> getGroupedMethods(Class<?> utility, String ... includes) {
        LinkedHashMap<String, List<MethodHandle>> groupedMethods = new LinkedHashMap<String, List<MethodHandle>>();
        HashSet<String> whitelist = ArrayUtils.isNotEmpty((Object[])includes) ? new HashSet<String>(Arrays.asList(includes)) : Collections.emptySet();
        for (Method method : utility.getMethods()) {
            method.setAccessible(true);
            if (!Modifier.isStatic(method.getModifiers())) continue;
            String name = method.getName();
            if (whitelist.size() > 0 && !whitelist.contains(name)) continue;
            ArrayList<MethodHandle> list = (ArrayList<MethodHandle>)groupedMethods.get(name);
            if (list == null) {
                list = new ArrayList<MethodHandle>();
            }
            try {
                MethodHandle handle = MethodHandles.lookup().unreflect(method);
                handle = MethodHandles.dropArguments(handle, 0, new Class[]{Object.class});
                list.add(handle);
            }
            catch (IllegalAccessException ex) {
                throw new HussarExpressionCreationException((Throwable)ex);
            }
            groupedMethods.put(name, list);
        }
        return groupedMethods;
    }

    private static Map<String, Object> createDynamicMethodsByDynalink(Class<?> utility, Map<String, List<MethodHandle>> groupedMethods) {
        Method overloadedDynamicMethodAddMethod;
        Constructor<?> overloadedDynamicMethodConstructor;
        Constructor<?> simpleDynamicMethodConstructor;
        Class<?> singleDynamicMethodClass = ES5DynamicBindingUtils.loadDynalinkClass(SINGLE_DYNAMIC_METHOD_CLASS);
        Class<?> simpleDynamicMethodClass = ES5DynamicBindingUtils.loadDynalinkClass(SIMPLE_DYNAMIC_METHOD_CLASS);
        Class<?> overloadedDynamicMethodClass = ES5DynamicBindingUtils.loadDynalinkClass(OVERLOADED_DYNAMIC_METHOD_CLASS);
        try {
            simpleDynamicMethodConstructor = simpleDynamicMethodClass.getDeclaredConstructor(MethodHandle.class, Class.class, String.class);
            overloadedDynamicMethodConstructor = overloadedDynamicMethodClass.getDeclaredConstructor(Class.class, String.class);
            overloadedDynamicMethodAddMethod = overloadedDynamicMethodClass.getMethod("addMethod", singleDynamicMethodClass);
            simpleDynamicMethodConstructor.setAccessible(true);
            overloadedDynamicMethodConstructor.setAccessible(true);
            overloadedDynamicMethodAddMethod.setAccessible(true);
        }
        catch (NoSuchMethodException ex) {
            throw new HussarExpressionCreationException((Throwable)ex);
        }
        LinkedHashMap<String, Object> dynamicMethods = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, List<MethodHandle>> handleEntry : groupedMethods.entrySet()) {
            Object dynamicMethod;
            String methodName = handleEntry.getKey();
            List<MethodHandle> overloadMethods = handleEntry.getValue();
            try {
                if (overloadMethods.size() == 1) {
                    dynamicMethod = simpleDynamicMethodConstructor.newInstance(overloadMethods.get(0), utility, methodName);
                } else if (overloadMethods.size() > 1) {
                    dynamicMethod = overloadedDynamicMethodConstructor.newInstance(utility, methodName);
                    for (MethodHandle overload : overloadMethods) {
                        Object simpleDynamicMethod = simpleDynamicMethodConstructor.newInstance(overload, utility, methodName);
                        overloadedDynamicMethodAddMethod.invoke(dynamicMethod, simpleDynamicMethod);
                    }
                } else {
                    dynamicMethod = null;
                }
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw new HussarExpressionCreationException((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                throw new HussarExpressionCreationException(ex.getTargetException());
            }
            if (dynamicMethod == null) continue;
            dynamicMethods.put(methodName, dynamicMethod);
        }
        return dynamicMethods;
    }

    private static Class<?> loadDynalinkClass(List<String> alternativeClassNames) {
        for (String alternative : alternativeClassNames) {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass(alternative);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new HussarExpressionCreationException((Throwable)new ClassNotFoundException("all the alternative classes not found: " + alternativeClassNames));
    }

    private static Map<String, Object> createDynamicMethodsByWrappingES5Function(Class<?> utility, Map<String, List<MethodHandle>> groupedMethods) {
        LinkedHashMap<String, Object> jsFunctions = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, List<MethodHandle>> groupedMethodEntry : groupedMethods.entrySet()) {
            ES5Function jsFunction = new ES5Function(groupedMethodEntry.getKey(), groupedMethodEntry.getValue());
            jsFunctions.put(groupedMethodEntry.getKey(), (Object)jsFunction);
        }
        return jsFunctions;
    }

    public static MethodHandle resolveMethodOverload(String name, List<MethodHandle> overloadMethods, Class<?>[] argumentTypes) {
        List<MethodHandle> maximallySpecificMethods = ES5TypeUtils.getMaximallySpecificMethods(ES5DynamicBindingUtils.getMethodCandidates(OverloadResolutionStrategy.SUBTYPING, overloadMethods, argumentTypes), false);
        if (maximallySpecificMethods.isEmpty() && (maximallySpecificMethods = ES5TypeUtils.getMaximallySpecificMethods(ES5DynamicBindingUtils.getMethodCandidates(OverloadResolutionStrategy.CONVERTIBLE, overloadMethods, argumentTypes), false)).isEmpty()) {
            maximallySpecificMethods = ES5TypeUtils.getMaximallySpecificMethods(ES5DynamicBindingUtils.getMethodCandidates(OverloadResolutionStrategy.VARIABLE_ARGUMENTS, overloadMethods, argumentTypes), true);
        }
        switch (maximallySpecificMethods.size()) {
            case 0: {
                if (overloadMethods.size() > 0) {
                    throw new HussarExpressionES5NativeCallException(ES5DynamicBindingUtils.getResolutionExceptionMessage(ResolutionExceptionMessageKind.NO_MATCHED, name, overloadMethods, argumentTypes));
                }
                throw new HussarExpressionES5NativeCallException(ES5DynamicBindingUtils.getResolutionExceptionMessage(ResolutionExceptionMessageKind.MISMATCHED, name, overloadMethods, argumentTypes));
            }
            case 1: {
                return maximallySpecificMethods.get(0);
            }
        }
        throw new HussarExpressionES5NativeCallException(ES5DynamicBindingUtils.getResolutionExceptionMessage(ResolutionExceptionMessageKind.MULTIPLE_MATCHED, name, overloadMethods, argumentTypes));
    }

    private static String getResolutionExceptionMessage(ResolutionExceptionMessageKind kind, String name, List<MethodHandle> methodHandles, Class<?>[] argumentTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append("function");
        if (name != null) {
            builder.append(' ').append(name);
        }
        builder.append("(this: ");
        boolean firstArgument = true;
        for (Class<?> argumentType : argumentTypes) {
            if (!firstArgument) {
                builder.append(", ");
            }
            if (argumentType == null) {
                builder.append("<null>");
            } else {
                builder.append(argumentType.getSimpleName());
            }
            firstArgument = false;
        }
        builder.append(')');
        switch (kind) {
            case NO_MATCHED: {
                builder.append(": no matched method signature in");
                break;
            }
            case MISMATCHED: {
                builder.append(": method signature mismatched");
                break;
            }
            case MULTIPLE_MATCHED: {
                builder.append(": multiple method signatures matched among");
            }
        }
        builder.append(" [");
        boolean firstMethod = true;
        for (MethodHandle methodHandle : methodHandles) {
            if (!firstMethod) {
                builder.append(", ");
            }
            builder.append(methodHandle.type());
            firstMethod = false;
        }
        builder.append(']');
        return builder.toString();
    }

    private static List<MethodHandle> getMethodCandidates(OverloadResolutionStrategy strategy, List<MethodHandle> overloadMethods, Class<?>[] argumentTypes) {
        ArrayList<MethodHandle> methodCandidates = new ArrayList<MethodHandle>();
        block5: for (MethodHandle overloadMethod : overloadMethods) {
            MethodType methodType = overloadMethod.type();
            int methodArity = methodType.parameterCount();
            switch (strategy) {
                case SUBTYPING: {
                    int i;
                    if (argumentTypes.length != methodArity) continue block5;
                    for (i = 1; i < argumentTypes.length; ++i) {
                        if (ES5DynamicBindingUtils.isSubtypeMismatched(argumentTypes[i], methodType.parameterType(i))) continue block5;
                    }
                }
                case CONVERTIBLE: {
                    int i;
                    if (argumentTypes.length != methodArity) continue block5;
                    for (i = 1; i < argumentTypes.length; ++i) {
                        if (ES5DynamicBindingUtils.isConvertibleMismatched(argumentTypes[i], methodType.parameterType(i))) continue block5;
                    }
                }
                case VARIABLE_ARGUMENTS: {
                    int i;
                    if (overloadMethod.isVarargsCollector()) {
                        TypeDescriptor.OfField restParameterType = methodType.parameterType(methodArity - 1);
                        if (argumentTypes.length < methodArity - 1) continue block5;
                        for (int i2 = 1; i2 < argumentTypes.length; ++i2) {
                            if (ES5DynamicBindingUtils.isConvertibleMismatched(argumentTypes[i2], i2 < methodArity - 1 ? methodType.parameterType(i2) : ((Class)restParameterType).getComponentType())) continue block5;
                        }
                    } else {
                        if (argumentTypes.length != methodArity) continue block5;
                        for (i = 1; i < argumentTypes.length; ++i) {
                            if (ES5DynamicBindingUtils.isConvertibleMismatched(argumentTypes[i], methodType.parameterType(i))) continue block5;
                        }
                    }
                    break;
                }
            }
            methodCandidates.add(overloadMethod);
        }
        return methodCandidates;
    }

    private static boolean isSubtypeMismatched(Class<?> argumentType, Class<?> parameterType) {
        if (argumentType == null) {
            return parameterType.isPrimitive();
        }
        return !ES5TypeUtils.isSubtype(argumentType, parameterType);
    }

    private static boolean isConvertibleMismatched(Class<?> argumentType, Class<?> parameterType) {
        if (argumentType == null) {
            return parameterType.isPrimitive();
        }
        return !ES5TypeUtils.isMethodInvocationConvertible(argumentType, parameterType);
    }

    public static Object[] getApplicableArguments(MethodHandle method, Object[] arguments) {
        return arguments;
    }

    private static enum OverloadResolutionStrategy {
        SUBTYPING,
        CONVERTIBLE,
        VARIABLE_ARGUMENTS;

    }

    private static enum ResolutionExceptionMessageKind {
        NO_MATCHED,
        MISMATCHED,
        MULTIPLE_MATCHED;

    }
}

