/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.expression.engine.es5.objects;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jdk.nashorn.api.scripting.AbstractJSObject;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

public final class ES5Namespace
extends AbstractJSObject {
    private static final int MAX_TO_STRING_MEMBER_COUNT = 10;
    private final String name;
    private final Map<String, Object> members;

    public ES5Namespace(Map<String, Object> members) {
        this(null, members);
    }

    public ES5Namespace(String name, Map<String, Object> members) {
        this.name = name;
        this.members = new LinkedHashMap<String, Object>();
        this.members.putAll(members);
    }

    public boolean hasMember(String name) {
        return this.members.containsKey(name);
    }

    public Object getMember(String name) {
        return this.members.get(name);
    }

    public void setMember(String name, Object value) {
        if (ScriptObjectMirror.isUndefined((Object)value)) {
            this.members.remove(name);
        }
        this.members.put(name, value);
    }

    public void removeMember(String name) {
        this.members.remove(name);
    }

    public Set<String> keySet() {
        return this.members.keySet();
    }

    public Collection<Object> values() {
        return this.members.values();
    }

    public Object getDefaultValue(Class<?> hint) {
        if (hint == Number.class) {
            return Double.NaN;
        }
        return this.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("namespace ");
        if (this.name != null) {
            builder.append(this.name).append(' ');
        }
        builder.append('{');
        int count = 0;
        for (String key : this.members.keySet()) {
            if (count > 0) {
                builder.append(", ");
            }
            if (count > 10) {
                builder.append("...").append(this.members.size() - 10).append(" more");
            } else {
                builder.append(key);
            }
            ++count;
        }
        builder.append('}');
        return builder.toString();
    }
}

