/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.expression.engine.es5.objects;

import com.jxdinfo.hussar.integration.support.expression.engine.es5.utils.ES5DynamicBindingUtils;
import com.jxdinfo.hussar.integration.support.expression.exception.es5.HussarExpressionES5NativeCallException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.WrongMethodTypeException;
import java.util.List;
import java.util.Map;
import jdk.nashorn.api.scripting.AbstractJSObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.util.ConcurrentReferenceHashMap;

public final class ES5Function
extends AbstractJSObject {
    private final String name;
    private final List<MethodHandle> overloads;
    private final Map<Class<?>[], Pair<MethodHandle, String>> linkages = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.WEAK);

    public ES5Function(List<MethodHandle> overloads) {
        this(null, overloads);
    }

    public ES5Function(String name, List<MethodHandle> overloads) {
        if (CollectionUtils.isEmpty(overloads)) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.overloads = overloads;
    }

    public boolean isFunction() {
        return true;
    }

    public boolean isStrictFunction() {
        return false;
    }

    public Object call(Object self, Object ... arguments) {
        MethodHandle methodHandle = this.getMostSpecificOverloadMethod(self, arguments);
        Object[] applicableArguments = ES5Function.getApplicableArguments(methodHandle, self, arguments);
        try {
            return methodHandle.invokeWithArguments(applicableArguments);
        }
        catch (ClassCastException | WrongMethodTypeException ex) {
            throw new HussarExpressionES5NativeCallException(ex);
        }
        catch (Throwable throwable) {
            throw ES5Function.sneakyThrow(throwable);
        }
    }

    private MethodHandle getMostSpecificOverloadMethod(Object self, Object ... arguments) {
        Class<?>[] argumentTypes = ES5Function.getArgumentTypes(self, arguments);
        Pair result = this.linkages.computeIfAbsent(argumentTypes, this::doGetMostSpecificOverloadMethod);
        if (result.getLeft() != null) {
            return (MethodHandle)result.getLeft();
        }
        if (result.getRight() != null) {
            throw new HussarExpressionES5NativeCallException((String)result.getRight());
        }
        throw new HussarExpressionES5NativeCallException("failed to resolve method overloads");
    }

    private Pair<MethodHandle, String> doGetMostSpecificOverloadMethod(Class<?> ... argumentTypes) {
        try {
            MethodHandle methodHandle = ES5DynamicBindingUtils.resolveMethodOverload(this.name, this.overloads, argumentTypes);
            return Pair.of((Object)methodHandle, null);
        }
        catch (HussarExpressionES5NativeCallException ex) {
            return Pair.of(null, (Object)ex.getMessage());
        }
    }

    private static Object[] getApplicableArguments(MethodHandle method, Object self, Object ... arguments) {
        Object[] assembledArguments = new Object[arguments != null ? arguments.length + 1 : 1];
        assembledArguments[0] = self;
        if (arguments != null) {
            System.arraycopy(arguments, 0, assembledArguments, 1, arguments.length);
        }
        return ES5DynamicBindingUtils.getApplicableArguments(method, assembledArguments);
    }

    private static Class<?>[] getArgumentTypes(Object self, Object ... arguments) {
        Class[] argumentTypes = new Class[arguments != null ? arguments.length + 1 : 1];
        Class<?> clazz = argumentTypes[0] = self != null ? self.getClass() : null;
        if (arguments != null) {
            for (int i = 0; i < arguments.length; ++i) {
                Object argument = arguments[i];
                argumentTypes[i + 1] = argument != null ? argument.getClass() : null;
            }
        }
        return argumentTypes;
    }

    private static RuntimeException sneakyThrow(Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException();
        }
        ES5Function.sneakyThrow0(throwable);
        throw new RuntimeException("unreachable");
    }

    private static <T extends Throwable> void sneakyThrow0(Throwable throwable) throws T {
        throw throwable;
    }

    public Object getDefaultValue(Class<?> hint) {
        if (hint == Number.class) {
            return Double.NaN;
        }
        return this.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("function");
        if (this.name != null) {
            builder.append(' ').append(this.name);
        }
        builder.append("() { [native code] }");
        return builder.toString();
    }
}

