/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.expression.engine.es5;

import com.jxdinfo.hussar.integration.support.expression.builder.HussarExpressionNamespaceBuilder;
import com.jxdinfo.hussar.integration.support.expression.engine.es5.objects.ES5DynamicNamespace;
import com.jxdinfo.hussar.integration.support.expression.engine.es5.objects.ES5Namespace;
import com.jxdinfo.hussar.integration.support.expression.engine.es5.utils.ES5DynamicBindingUtils;
import com.jxdinfo.hussar.integration.support.expression.namespace.HussarExpressionDynamicNamespace;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ES5NamespaceBuilder<T>
implements HussarExpressionNamespaceBuilder<T> {
    private final String name;
    private final Function<Object, T> injector;
    private final Map<String, Object> members = new LinkedHashMap<String, Object>();

    public ES5NamespaceBuilder(String name, Function<Object, T> injector) {
        this.name = name;
        this.injector = injector;
    }

    public HussarExpressionNamespaceBuilder<T> variable(String name, Object value) {
        this.members.put(name, value);
        return this;
    }

    public HussarExpressionNamespaceBuilder<T> variables(Map<String, Object> variables) {
        if (variables != null) {
            this.members.putAll(variables);
        }
        return this;
    }

    public HussarExpressionNamespaceBuilder<T> function(String name, Runnable function) {
        this.members.put(name, function);
        return this;
    }

    public HussarExpressionNamespaceBuilder<T> function(String name, Function<?, ?> function) {
        this.members.put(name, function);
        return this;
    }

    public HussarExpressionNamespaceBuilder<T> function(String name, BiFunction<?, ?, ?> function) {
        this.members.put(name, function);
        return this;
    }

    public HussarExpressionNamespaceBuilder<T> function(String name, Consumer<?> function) {
        this.members.put(name, function);
        return this;
    }

    public HussarExpressionNamespaceBuilder<T> function(String name, BiConsumer<?, ?> function) {
        this.members.put(name, function);
        return this;
    }

    public HussarExpressionNamespaceBuilder<T> function(String name, Supplier<?> function) {
        this.members.put(name, function);
        return this;
    }

    public HussarExpressionNamespaceBuilder<T> functions(Class<?> utility, String ... includes) {
        Map<String, Object> staticMethods = ES5DynamicBindingUtils.getDynamicStaticMethods(utility, includes);
        this.members.putAll(staticMethods);
        return this;
    }

    public HussarExpressionNamespaceBuilder<HussarExpressionNamespaceBuilder<T>> namespace(String namespace) {
        return new ES5NamespaceBuilder<HussarExpressionNamespaceBuilder<T>>(namespace, ns -> {
            this.members.put(namespace, ns);
            return this;
        });
    }

    public HussarExpressionNamespaceBuilder<T> namespace(String namespaceName, HussarExpressionDynamicNamespace namespaceAccessor) {
        this.members.put(namespaceName, (Object)new ES5DynamicNamespace(namespaceName, namespaceAccessor));
        return this;
    }

    public T end() {
        ES5Namespace namespace = new ES5Namespace(this.name, this.members);
        return this.injector.apply((Object)namespace);
    }
}

