/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.expression.engine.es5;

import com.jxdinfo.hussar.integration.support.expression.builder.HussarExpressionEngineBuilder;
import com.jxdinfo.hussar.integration.support.expression.builder.HussarExpressionNamespaceBuilder;
import com.jxdinfo.hussar.integration.support.expression.engine.es5.AbstractES5ExpressionEngineBuilder;
import com.jxdinfo.hussar.integration.support.expression.engine.es5.utils.ES5DynamicBindingUtils;
import com.jxdinfo.hussar.integration.support.expression.runtime.es5.ES5BuiltinFunctions;
import com.jxdinfo.hussar.integration.support.expression.runtime.es5.ES5Intrinsics;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ES5ExpressionEngineBuilder
extends AbstractES5ExpressionEngineBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ES5ExpressionEngineBuilder.class);
    private static final Map<String, Object> DEFAULT_OPTIONS;
    private static final Map<String, Object> DEFAULT_BUILTINS;
    private static final List<String> DEFAULT_BOOTSTRAP_SCRIPTS;
    private static final List<Function<String, String>> DEFAULT_EXPRESSION_PREPROCESSORS;
    private static final List<String> DEFAULT_BOOTSTRAP_SCRIPT_PATHS;

    @Override
    protected Map<String, Object> getDefaultOptions() {
        return DEFAULT_OPTIONS;
    }

    @Override
    protected Map<String, Object> getDefaultBuiltins() {
        return DEFAULT_BUILTINS;
    }

    @Override
    protected List<String> getDefaultBootstrapScripts() {
        return DEFAULT_BOOTSTRAP_SCRIPTS;
    }

    @Override
    protected List<Function<String, String>> getDefaultExpressionPreprocessors() {
        return DEFAULT_EXPRESSION_PREPROCESSORS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadBootstrapScript(String path) {
        try (InputStream stream = ES5ExpressionEngineBuilder.class.getClassLoader().getResourceAsStream(path);){
            if (stream != null) {
                String string2 = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                return string2;
            }
            logger.warn("bootstrap script not found: {}", (Object)path);
            String string = "";
            return string;
        }
        catch (IOException ignore) {
            logger.warn("failed to load bootstrap script: {}", (Object)path);
            return "";
        }
    }

    static {
        DEFAULT_BOOTSTRAP_SCRIPT_PATHS = Arrays.asList("hussar-expression/es5/bootstrap/00-bootstrap.js", "hussar-expression/es5/bootstrap/10-number.js", "hussar-expression/es5/bootstrap/20-string.js", "hussar-expression/es5/bootstrap/30-date.js", "hussar-expression/es5/bootstrap/40-crypto.js", "hussar-expression/es5/bootstrap/99-finalize.js");
        EarlyEngineBuilder earlyBuilder = new EarlyEngineBuilder();
        HussarExpressionEngineBuilder builder = earlyBuilder.option("common.locale", "zh-CN").option("common.timezone", (Object)"Asia/Shanghai").option("es5.strict", (Object)false).option("es5.java", (Object)true).option("es5.typed.arrays", (Object)false).option("es5.syntax.extensions", (Object)true).option("es5.scripting", (Object)false).option("es5.lazy.compilation", (Object)false).option("es5.language", (Object)"es6");
        builder = (HussarExpressionEngineBuilder)builder.functions(ES5BuiltinFunctions.class, new String[0]);
        builder = (HussarExpressionEngineBuilder)((HussarExpressionNamespaceBuilder)((HussarExpressionNamespaceBuilder)((HussarExpressionNamespaceBuilder)((HussarExpressionNamespaceBuilder)((HussarExpressionNamespaceBuilder)((HussarExpressionNamespaceBuilder)((HussarExpressionNamespaceBuilder)((HussarExpressionNamespaceBuilder)builder.namespace("$Intrinsics$").functions(ES5Intrinsics.class, new String[0])).variable("Boolean", ES5DynamicBindingUtils.getJavaClass(Boolean.class))).variable("Integer", ES5DynamicBindingUtils.getJavaClass(Integer.class))).variable("Long", ES5DynamicBindingUtils.getJavaClass(Long.class))).variable("Double", ES5DynamicBindingUtils.getJavaClass(Double.class))).variable("String", ES5DynamicBindingUtils.getJavaClass(String.class))).variable("Date", ES5DynamicBindingUtils.getJavaClass(Date.class))).variable("LocalDateTime", ES5DynamicBindingUtils.getJavaClass(LocalDateTime.class))).end();
        for (String bootstrapScriptPath : DEFAULT_BOOTSTRAP_SCRIPT_PATHS) {
            String bootstrapScript = ES5ExpressionEngineBuilder.loadBootstrapScript(bootstrapScriptPath);
            builder = builder.bootstrap(bootstrapScript);
        }
        DEFAULT_OPTIONS = Collections.unmodifiableMap(earlyBuilder.takeEarlyOptions());
        DEFAULT_BUILTINS = Collections.unmodifiableMap(earlyBuilder.takeEarlyBuiltins());
        DEFAULT_BOOTSTRAP_SCRIPTS = Collections.unmodifiableList(earlyBuilder.takeEarlyBootstrapScripts());
        DEFAULT_EXPRESSION_PREPROCESSORS = Collections.unmodifiableList(earlyBuilder.takeEarlyExpressionPreprocessors());
    }

    private static final class EarlyEngineBuilder
    extends AbstractES5ExpressionEngineBuilder {
        private EarlyEngineBuilder() {
        }

        public Map<String, Object> takeEarlyOptions() {
            return this.options;
        }

        public Map<String, Object> takeEarlyBuiltins() {
            return this.builtins;
        }

        public List<String> takeEarlyBootstrapScripts() {
            return this.bootstrapScripts;
        }

        public List<Function<String, String>> takeEarlyExpressionPreprocessors() {
            return this.expressionPreprocessors;
        }
    }
}

