/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.expression.engine.es5;

import com.jxdinfo.hussar.integration.support.expression.builder.HussarExpressionEvaluator;
import com.jxdinfo.hussar.integration.support.expression.builder.HussarExpressionNamespaceBuilder;
import com.jxdinfo.hussar.integration.support.expression.engine.HussarExpressionEngine;
import com.jxdinfo.hussar.integration.support.expression.engine.es5.ES5NamespaceBuilder;
import com.jxdinfo.hussar.integration.support.expression.engine.es5.objects.ES5DynamicNamespace;
import com.jxdinfo.hussar.integration.support.expression.engine.es5.utils.ES5DynamicBindingUtils;
import com.jxdinfo.hussar.integration.support.expression.exception.HussarExpressionEvaluationException;
import com.jxdinfo.hussar.integration.support.expression.namespace.HussarExpressionDynamicNamespace;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ES5ExpressionEngine
implements HussarExpressionEngine {
    private final ScriptEngine nashorn;
    private final Map<String, Object> builtins;
    private final List<CompiledScript> bootstraps;
    private final List<Function<String, String>> expressionPreprocessors;

    public ES5ExpressionEngine(ScriptEngine nashorn, Map<String, Object> builtins, List<CompiledScript> bootstraps, List<Function<String, String>> expressionPreprocessors) {
        this.nashorn = nashorn;
        this.builtins = builtins;
        this.bootstraps = bootstraps;
        this.expressionPreprocessors = expressionPreprocessors;
    }

    public HussarExpressionEvaluator preparing() {
        return new ES5ExpressionEvaluator(this);
    }

    public static class ES5ExpressionEvaluator
    implements HussarExpressionEvaluator {
        private final ES5ExpressionEngine engine;
        private final Map<String, Object> globals = new LinkedHashMap<String, Object>();

        public ES5ExpressionEvaluator(ES5ExpressionEngine engine) {
            this.engine = engine;
        }

        public HussarExpressionEvaluator variable(String name, Object value) {
            this.globals.put(name, value);
            return this;
        }

        public HussarExpressionEvaluator variables(Map<String, Object> variables) {
            if (variables != null) {
                this.globals.putAll(variables);
            }
            return this;
        }

        public HussarExpressionEvaluator function(String name, Runnable function) {
            this.globals.put(name, function);
            return this;
        }

        public HussarExpressionEvaluator function(String name, Function<?, ?> function) {
            this.globals.put(name, function);
            return this;
        }

        public HussarExpressionEvaluator function(String name, BiFunction<?, ?, ?> function) {
            this.globals.put(name, function);
            return this;
        }

        public HussarExpressionEvaluator function(String name, Consumer<?> function) {
            this.globals.put(name, function);
            return this;
        }

        public HussarExpressionEvaluator function(String name, BiConsumer<?, ?> function) {
            this.globals.put(name, function);
            return this;
        }

        public HussarExpressionEvaluator function(String name, Supplier<?> function) {
            this.globals.put(name, function);
            return this;
        }

        public HussarExpressionEvaluator functions(Class<?> utility, String ... includes) {
            Map<String, Object> staticMethods = ES5DynamicBindingUtils.getDynamicStaticMethods(utility, includes);
            this.globals.putAll(staticMethods);
            return this;
        }

        public HussarExpressionNamespaceBuilder<HussarExpressionEvaluator> namespace(String namespace) {
            return new ES5NamespaceBuilder<HussarExpressionEvaluator>(namespace, ns -> {
                this.globals.put(namespace, ns);
                return this;
            });
        }

        public HussarExpressionEvaluator namespace(String namespaceName, HussarExpressionDynamicNamespace namespaceAccessor) {
            this.globals.put(namespaceName, (Object)new ES5DynamicNamespace(namespaceName, namespaceAccessor));
            return this;
        }

        public Object evaluate(String expression) {
            String processedExpression = this.getProcessedExpression(expression);
            ScriptContext context = this.createContext();
            Bindings bindings = context.getBindings(100);
            bindings.putAll(this.engine.builtins);
            try {
                for (CompiledScript bootstrap : this.engine.bootstraps) {
                    bootstrap.eval(context);
                }
            }
            catch (ScriptException ex) {
                String message = "expression bootstrap scripts failed";
                if (StringUtils.isNotEmpty((CharSequence)ex.getMessage())) {
                    message = message + ": " + ex.getMessage();
                }
                throw new HussarExpressionEvaluationException(message, (Throwable)ex);
            }
            bindings.putAll((Map<? extends String, ? extends Object>)this.globals);
            try {
                return this.engine.nashorn.eval(processedExpression, context);
            }
            catch (ScriptException ex) {
                throw new HussarExpressionEvaluationException((Throwable)ex);
            }
        }

        private String getProcessedExpression(String expression) {
            String processedExpression = expression;
            try {
                if (CollectionUtils.isNotEmpty((Collection)this.engine.expressionPreprocessors)) {
                    for (Function expressionPreprocessor : this.engine.expressionPreprocessors) {
                        processedExpression = (String)expressionPreprocessor.apply(processedExpression);
                    }
                }
            }
            catch (Exception ex) {
                throw new HussarExpressionEvaluationException((Throwable)ex);
            }
            return processedExpression;
        }

        private ScriptContext createContext() {
            SimpleScriptContext context = new SimpleScriptContext();
            context.setReader(null);
            context.setWriter(null);
            context.setErrorWriter(null);
            return context;
        }
    }
}

