/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.expression.engine.es5;

import com.jxdinfo.hussar.integration.support.expression.builder.HussarExpressionEngineBuilder;
import com.jxdinfo.hussar.integration.support.expression.builder.HussarExpressionNamespaceBuilder;
import com.jxdinfo.hussar.integration.support.expression.engine.HussarExpressionEngine;
import com.jxdinfo.hussar.integration.support.expression.engine.es5.ES5ExpressionEngine;
import com.jxdinfo.hussar.integration.support.expression.engine.es5.ES5NamespaceBuilder;
import com.jxdinfo.hussar.integration.support.expression.engine.es5.objects.ES5DynamicNamespace;
import com.jxdinfo.hussar.integration.support.expression.engine.es5.utils.ES5DynamicBindingUtils;
import com.jxdinfo.hussar.integration.support.expression.exception.HussarExpressionCreationException;
import com.jxdinfo.hussar.integration.support.expression.namespace.HussarExpressionDynamicNamespace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractES5ExpressionEngineBuilder
implements HussarExpressionEngineBuilder {
    protected static final NashornOptionMapper NASHORN_OPTIONS = new NashornOptionMapper();
    protected boolean useDefaultOptions = true;
    protected boolean useDefaultBindings = true;
    protected boolean useDefaultBootstrapScripts = true;
    protected boolean useDefaultPreprocessors = true;
    protected final Map<String, Object> options = new LinkedHashMap<String, Object>();
    protected final Map<String, Object> builtins = new LinkedHashMap<String, Object>();
    protected final List<String> bootstrapScripts = new ArrayList<String>();
    protected final List<Function<String, String>> expressionPreprocessors = new ArrayList<Function<String, String>>();

    public HussarExpressionEngineBuilder useDefaultPreset(boolean useDefault) {
        this.useDefaultOptions = useDefault;
        this.useDefaultBindings = useDefault;
        this.useDefaultBootstrapScripts = useDefault;
        this.useDefaultPreprocessors = useDefault;
        return this;
    }

    public HussarExpressionEngineBuilder useDefaultOptions(boolean useDefaultOptions) {
        this.useDefaultOptions = useDefaultOptions;
        return this;
    }

    public HussarExpressionEngineBuilder useDefaultBindings(boolean useDefaultBindings) {
        this.useDefaultBindings = useDefaultBindings;
        return this;
    }

    public HussarExpressionEngineBuilder useDefaultBootstrapScripts(boolean useDefaultBootstrapScripts) {
        this.useDefaultBootstrapScripts = useDefaultBootstrapScripts;
        return this;
    }

    public HussarExpressionEngineBuilder useDefaultPreprocessors(boolean useDefaultPreprocessors) {
        this.useDefaultPreprocessors = useDefaultPreprocessors;
        return this;
    }

    public HussarExpressionEngineBuilder option(String option, Object value) {
        this.options.put(option, value);
        return this;
    }

    public HussarExpressionEngineBuilder options(Map<String, Object> options) {
        if (options != null) {
            this.options.putAll(options);
        }
        return this;
    }

    public HussarExpressionEngineBuilder variable(String name, Object value) {
        this.builtins.put(name, value);
        return this;
    }

    public HussarExpressionEngineBuilder variables(Map<String, Object> variables) {
        if (variables != null) {
            this.builtins.putAll(variables);
        }
        return this;
    }

    public HussarExpressionEngineBuilder function(String name, Runnable function) {
        this.builtins.put(name, function);
        return this;
    }

    public HussarExpressionEngineBuilder function(String name, Function<?, ?> function) {
        this.builtins.put(name, function);
        return this;
    }

    public HussarExpressionEngineBuilder function(String name, BiFunction<?, ?, ?> function) {
        this.builtins.put(name, function);
        return this;
    }

    public HussarExpressionEngineBuilder function(String name, Consumer<?> function) {
        this.builtins.put(name, function);
        return this;
    }

    public HussarExpressionEngineBuilder function(String name, BiConsumer<?, ?> function) {
        this.builtins.put(name, function);
        return this;
    }

    public HussarExpressionEngineBuilder function(String name, Supplier<?> function) {
        this.builtins.put(name, function);
        return this;
    }

    public HussarExpressionEngineBuilder functions(Class<?> utility, String ... includes) {
        Map<String, Object> staticMethods = ES5DynamicBindingUtils.getDynamicStaticMethods(utility, includes);
        this.builtins.putAll(staticMethods);
        return this;
    }

    public HussarExpressionNamespaceBuilder<HussarExpressionEngineBuilder> namespace(String namespace) {
        return new ES5NamespaceBuilder<HussarExpressionEngineBuilder>(namespace, ns -> {
            this.builtins.put(namespace, ns);
            return this;
        });
    }

    public HussarExpressionEngineBuilder namespace(String namespaceName, HussarExpressionDynamicNamespace namespaceAccessor) {
        this.builtins.put(namespaceName, (Object)new ES5DynamicNamespace(namespaceName, namespaceAccessor));
        return this;
    }

    public HussarExpressionEngineBuilder bootstrap(String bootstrapScript) {
        if (StringUtils.isNotBlank((CharSequence)bootstrapScript)) {
            this.bootstrapScripts.add(bootstrapScript);
        }
        return this;
    }

    public HussarExpressionEngineBuilder preprocessor(Function<String, String> expressionPreprocessor) {
        if (expressionPreprocessor != null) {
            this.expressionPreprocessors.add(expressionPreprocessor);
        }
        return this;
    }

    public HussarExpressionEngine create() {
        Map<String, Object> options = this.getOptions();
        Map<String, Object> builtins = this.getBuiltins();
        List<String> bootstrapScripts = this.getBootstrapScripts();
        List<Function<String, String>> expressionPreprocessors = this.getExpressionPreprocessors();
        ScriptEngine engine = this.createNashornEngine(options);
        List<CompiledScript> compiledScripts = this.compileBootstrapScripts(engine, bootstrapScripts);
        return new ES5ExpressionEngine(engine, builtins, compiledScripts, expressionPreprocessors);
    }

    protected ScriptEngine createNashornEngine(Map<String, Object> options) {
        try {
            NashornScriptEngineFactory factory = new NashornScriptEngineFactory();
            List<String> nashornOptions = this.toNashornOptions(options);
            return factory.getScriptEngine(nashornOptions.toArray(new String[0]));
        }
        catch (Exception ex) {
            throw new HussarExpressionCreationException("cannot create nashorn engine", (Throwable)ex);
        }
    }

    protected List<String> toNashornOptions(Map<String, Object> options) {
        return NASHORN_OPTIONS.parse(options);
    }

    protected List<CompiledScript> compileBootstrapScripts(ScriptEngine engine, List<String> bootstrapScripts) {
        try {
            Compilable compilable = (Compilable)((Object)engine);
            ArrayList<CompiledScript> compiledScripts = new ArrayList<CompiledScript>();
            for (String bootstrapScript : bootstrapScripts) {
                compiledScripts.add(compilable.compile(bootstrapScript));
            }
            return compiledScripts;
        }
        catch (ScriptException ex) {
            throw new HussarExpressionCreationException("failed to execute bootstrap scripts", (Throwable)ex);
        }
    }

    private Map<String, Object> getOptions() {
        Map<String, Object> defaultOptions;
        LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
        Map<String, Object> map = defaultOptions = this.useDefaultOptions ? this.getDefaultOptions() : null;
        if (defaultOptions != null) {
            options.putAll(defaultOptions);
        }
        options.putAll(this.options);
        return options;
    }

    protected Map<String, Object> getDefaultOptions() {
        return Collections.emptyMap();
    }

    private Map<String, Object> getBuiltins() {
        Map<String, Object> defaultBuiltins;
        LinkedHashMap<String, Object> builtins = new LinkedHashMap<String, Object>();
        Map<String, Object> map = defaultBuiltins = this.useDefaultBindings ? this.getDefaultBuiltins() : null;
        if (defaultBuiltins != null) {
            builtins.putAll(defaultBuiltins);
        }
        builtins.putAll(this.builtins);
        return builtins;
    }

    protected Map<String, Object> getDefaultBuiltins() {
        return Collections.emptyMap();
    }

    private List<String> getBootstrapScripts() {
        List<String> defaultBootstrapScripts;
        ArrayList<String> bootstrapScripts = new ArrayList<String>();
        List<String> list = defaultBootstrapScripts = this.useDefaultBootstrapScripts ? this.getDefaultBootstrapScripts() : null;
        if (defaultBootstrapScripts != null) {
            bootstrapScripts.addAll(defaultBootstrapScripts);
        }
        bootstrapScripts.addAll(this.bootstrapScripts);
        return bootstrapScripts;
    }

    protected List<String> getDefaultBootstrapScripts() {
        return Collections.emptyList();
    }

    private List<Function<String, String>> getExpressionPreprocessors() {
        List<Function<String, String>> defaultExpressionPreprocessors;
        ArrayList<Function<String, String>> expressionPreprocessors = new ArrayList<Function<String, String>>();
        List<Function<String, String>> list = defaultExpressionPreprocessors = this.useDefaultPreprocessors ? this.getDefaultExpressionPreprocessors() : null;
        if (defaultExpressionPreprocessors != null) {
            expressionPreprocessors.addAll(defaultExpressionPreprocessors);
        }
        expressionPreprocessors.addAll(this.expressionPreprocessors);
        return expressionPreprocessors;
    }

    protected List<Function<String, String>> getDefaultExpressionPreprocessors() {
        return Collections.emptyList();
    }

    protected static class NashornOption {
        private final String name;
        private final String option;
        private final Class<?> type;
        private final Object defaults;

        protected NashornOption(String name, String option, Class<?> type, Object defaults) {
            this.name = name;
            this.option = option;
            this.type = type;
            this.defaults = defaults;
        }

        public static NashornOption flag(String name, String option, boolean defaults) {
            if (name == null || option == null) {
                throw new NullPointerException();
            }
            return new NashornOption(name, option, Boolean.class, defaults);
        }

        public static NashornOption string(String name, String option, String defaults) {
            if (name == null || option == null || defaults == null) {
                throw new NullPointerException();
            }
            return new NashornOption(name, option, String.class, defaults);
        }

        public static NashornOption integer(String name, String option, int defaults) {
            if (name == null || option == null) {
                throw new NullPointerException();
            }
            return new NashornOption(name, option, Integer.class, defaults);
        }

        public void parse(Object value, List<String> arguments) {
            if (value == null) {
                return;
            }
            if (this.type == Boolean.class) {
                double num;
                Boolean flag = value instanceof Boolean ? (Boolean)value : (value instanceof String ? (Objects.equals(value, "true") ? Boolean.valueOf(true) : (Objects.equals(value, "false") ? Boolean.valueOf(false) : null)) : (value instanceof Number ? Boolean.valueOf((num = ((Number)value).doubleValue()) != 0.0 && !Double.isNaN(num)) : null));
                if (flag != null && !Objects.equals(flag, this.defaults)) {
                    arguments.add(flag != false ? this.option : this.option + "=false");
                }
            } else if (this.type == String.class) {
                String string = String.valueOf(value);
                if (!Objects.equals(string, this.defaults)) {
                    arguments.add(this.option + "=" + string);
                }
            } else if (this.type == Integer.class) {
                Integer integer;
                if (value instanceof Boolean) {
                    integer = (Boolean)value != false ? 1 : 0;
                } else if (value instanceof String) {
                    try {
                        integer = Integer.parseInt((String)value);
                    }
                    catch (NumberFormatException ignore) {
                        integer = null;
                    }
                } else {
                    integer = value instanceof Number ? Integer.valueOf(((Number)value).intValue()) : null;
                }
                if (integer != null && !Objects.equals(integer, this.defaults)) {
                    arguments.add(this.option + "=" + integer);
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public String getOption() {
            return this.option;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Object getDefaults() {
            return this.defaults;
        }
    }

    protected static class NashornOptionMapper
    extends LinkedHashMap<String, NashornOption> {
        protected NashornOptionMapper() {
            this.add(NashornOption.string("common.locale", "--locale", "en-US"));
            this.add(NashornOption.string("common.timezone", "-timezone", "Europe/Stockholm"));
            this.add(NashornOption.flag("es5.strict", "-strict", false));
            this.add(NashornOption.flag("es5.java", "--no-java", false));
            this.add(NashornOption.flag("es5.typed.arrays", "--no-typed-arrays", false));
            this.add(NashornOption.flag("es5.syntax.extensions", "--no-syntax-extensions", false));
            this.add(NashornOption.flag("es5.scripting", "-scripting", false));
            this.add(NashornOption.flag("es5.lazy.compilation", "--lazy-compilation", false));
            this.add(NashornOption.string("es5.language", "--language", "es5"));
        }

        private void add(NashornOption option) {
            this.put(option.getName(), option);
        }

        public List<String> parse(Map<String, Object> options) {
            ArrayList<String> arguments = new ArrayList<String>();
            for (Map.Entry<String, Object> option : options.entrySet()) {
                NashornOption nashornOption = (NashornOption)this.get(option.getKey());
                if (nashornOption == null) continue;
                nashornOption.parse(option.getValue(), arguments);
            }
            return arguments;
        }
    }
}

