/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.identity.user.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.identity.audit.model.SysUserIpAudit;
import com.jxdinfo.hussar.identity.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.identity.audit.service.ISysUserIpAuditService;
import com.jxdinfo.hussar.identity.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.identity.enums.UserStatus;
import com.jxdinfo.hussar.identity.organ.vo.OrganizationUserVo;
import com.jxdinfo.hussar.identity.sysuserip.model.SysUserIp;
import com.jxdinfo.hussar.identity.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.identity.user.bo.ChooseRoleStruBo;
import com.jxdinfo.hussar.identity.user.dao.ChooseRoleStruMapper;
import com.jxdinfo.hussar.identity.user.dao.SysUsersMapper;
import com.jxdinfo.hussar.identity.user.dto.AddUserDto;
import com.jxdinfo.hussar.identity.user.dto.EditUserDto;
import com.jxdinfo.hussar.identity.user.dto.UserInfolVo;
import com.jxdinfo.hussar.identity.user.dto.UserPartialVo;
import com.jxdinfo.hussar.identity.user.manager.AddUserManager;
import com.jxdinfo.hussar.identity.user.manager.EditUserManager;
import com.jxdinfo.hussar.identity.user.model.SysGetBackPassword;
import com.jxdinfo.hussar.identity.user.model.SysUsers;
import com.jxdinfo.hussar.identity.user.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.identity.user.service.IHussarBaseUserService;
import com.jxdinfo.hussar.identity.user.service.ISysGetBackPasswordService;
import com.jxdinfo.hussar.identity.user.service.ISysUsersService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;

@Master
@Service(value="com.jxdinfo.hussar.identity.user.service.impl.HussarBaseUserBoServiceImpl")
public class HussarBaseUserBoServiceImpl
implements IHussarBaseUserBoService {
    @Autowired
    private ISysUsersService sysUsersService;
    @Autowired
    private IHussarBaseUserService hussarBaseUserService;
    @Autowired
    private SysUsersMapper sysUsersMapper;
    @Autowired
    private EditUserManager editUserManager;
    @Autowired
    private AddUserManager addUserManager;
    @Autowired
    private ISysUserIpAuditService sysUserIpAuditService;
    @Autowired
    private ISysUsersAuditService sysUsersAuditService;
    @Autowired
    private ISysUserIpService sysUserIpService;
    @Autowired
    private ISysGetBackPasswordService sysGetBackPasswordService;
    @Resource
    JdbcTemplate jdbcTemplate;
    @Resource
    private ChooseRoleStruMapper chooseRoleStruMapper;

    @HussarDs(value="master")
    public SysUsers getUserById(Long userId) {
        return (SysUsers)this.sysUsersService.getById((Serializable)userId);
    }

    public Boolean updateUser(SysUsers sysUsers) {
        return this.sysUsersService.updateById((Object)sysUsers);
    }

    public List<JSTreeModel> getUserByRole(Long roleId) {
        return this.sysUsersService.getUserByRole(roleId);
    }

    public SysUsers selectById(Long userId) {
        return (SysUsers)this.sysUsersService.getById((Serializable)userId);
    }

    public List<JSTreeModel> getLazyUserByRole(Long roleId, Long nodeId) {
        return this.sysUsersService.getLazyUserByRole(roleId, nodeId);
    }

    public List<SysUsers> getUsersByIds(List<Long> userIdList) {
        if (ToolUtil.isNotEmpty(userIdList)) {
            return this.sysUsersService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysUsers::getId, userIdList));
        }
        return new ArrayList<SysUsers>();
    }

    public List<OrganizationUserVo> getOrganizationUserInfo(String userName, String userAccount) {
        return this.sysUsersMapper.getOrganizationUserInfo(userName, userAccount);
    }

    public List<SysUsers> getNoDeleteUsersById(List<Long> userIds) {
        if (ToolUtil.isNotEmpty(userIds)) {
            LambdaQueryWrapper queryWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysUsers::getId, userIds);
            queryWrapper.eq(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode());
            return this.sysUsersService.list((Wrapper)queryWrapper);
        }
        return new ArrayList<SysUsers>();
    }

    public String editUserWithoutRole(EditUserDto editUserDto) {
        return this.editUserManager.editUserWithoutRole(editUserDto);
    }

    public void removeUserIpAuditAll() {
        LambdaQueryWrapper wrapper7 = new LambdaQueryWrapper();
        this.sysUserIpAuditService.remove((Wrapper)wrapper7);
    }

    public void updateUserIpByUserAudit(SysUsersAudit sysUsersAudit) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"USER_ID", (Object)sysUsersAudit.getUserId())).eq((Object)"IS_AUDIT", (Object)"0");
        SysUserIpAudit sysUserIpAudit = new SysUserIpAudit();
        sysUserIpAudit.setIsAudit("1");
        this.sysUserIpAuditService.update((Object)sysUserIpAudit, (Wrapper)wrapper);
    }

    public void saveUserAudit(SysUsersAudit sysUsersAudit) {
        this.sysUsersAuditService.save((Object)sysUsersAudit);
    }

    public List<String> selectUserIp(Long userId, String status) {
        return this.sysUserIpAuditService.selectUserIp(userId, status);
    }

    public void removeUserNotAudit() {
        LambdaQueryWrapper wrapper9 = new LambdaQueryWrapper();
        wrapper9.eq(SysUsersAudit::getIsAudit, (Object)"0");
        this.sysUsersAuditService.remove((Wrapper)wrapper9);
    }

    public boolean adjustEdit(Long userId) {
        return this.sysUsersAuditService.adjustEdit(userId);
    }

    public List<String> selectUserIpByUserId(Long id) {
        return this.sysUserIpService.selectUserIp(id);
    }

    public void removeUserIpByUserId(Long userId) {
        this.sysUserIpService.remove((Wrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)userId));
    }

    public void saveUserIpBatch(List<SysUserIp> userIpList) {
        this.sysUserIpService.saveBatch(userIpList);
    }

    public void saveOrUpdateGetBackPassword(SysGetBackPassword sysGetBackPassword) {
        this.sysGetBackPasswordService.saveOrUpdate((Object)sysGetBackPassword);
    }

    public List<SysUsers> getAllUsers() {
        return this.sysUsersService.list((Wrapper)new LambdaQueryWrapper());
    }

    public List<SysUsers> getUsersByStruIds(List<Long> struIdList) {
        return this.sysUsersService.list((Wrapper)new LambdaQueryWrapper().in(SysUsers::getDepartmentId, struIdList));
    }

    public List<SysUsers> queryChooseUsers(String struId) {
        return this.sysUsersService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().ne(SysUsers::getIsSys, (Object)"1")).eq(SysUsers::getDepartmentId, (Object)struId)).lt(SysUsers::getAccountStatus, (Object)"2"));
    }

    public UserInfolVo loadUser(Long id) {
        return (UserInfolVo)this.hussarBaseUserService.loadUser(id).getData();
    }

    @DS(value="master")
    public Map<Long, Long> getUserIdsByStruId(List<Long> struIds) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        paramMap.put("ids", this.removeDuplicate(struIds));
        NamedParameterJdbcTemplate jdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)this.jdbcTemplate);
        List result = jdbcTemplate.query("select EMPLOYEE_ID, USER_ID AS id from sys_users where EMPLOYEE_ID in(:ids) and ACCOUNT_STATUS != '2'", paramMap, (RowMapper)new BeanPropertyRowMapper(SysUsers.class));
        return result.stream().collect(Collectors.toMap(SysUsers::getEmployeeId, SysUsers::getId));
    }

    private List<Long> removeDuplicate(List<Long> list) {
        if (!(list instanceof ArrayList)) {
            return new ArrayList<Long>();
        }
        HashSet<Long> h = new HashSet<Long>(list);
        list.clear();
        list.addAll(h);
        return list;
    }

    public Long addUserAndUserRole(AddUserDto addUserDto) {
        return (Long)this.addUserManager.addUser(addUserDto).getData();
    }

    public SysUsers getNotDeleteUserByAccount(String account) {
        return (SysUsers)this.sysUsersService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)account)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode()), false);
    }

    public List<JSTreeModel> getUserTreeStruByRole(Long roleId) {
        return this.sysUsersMapper.getUserTreeStruByRole(roleId);
    }

    public List<JSTreeModel> getUserTreeByRole() {
        return this.sysUsersMapper.getUserTreeByRole();
    }

    public UserPartialVo viewUser(Long id) {
        return this.sysUsersService.viewUser(id);
    }

    public List<SysUsers> getUsersByStaffId(List<Long> staffIds) {
        if (ToolUtil.isNotEmpty(staffIds)) {
            return this.sysUsersService.list((Wrapper)new LambdaQueryWrapper().in(SysUsers::getEmployeeId, staffIds));
        }
        return new ArrayList<SysUsers>();
    }

    public List<ChooseRoleStruBo> chooseRoleSelectStruList(Long groupId, List<Long> sysIdsList) {
        return this.chooseRoleStruMapper.selectStruList(groupId, sysIdsList);
    }

    public List<ChooseRoleStruBo> selectRoleList(Long groupId, List<Long> roleIdsList) {
        return this.chooseRoleStruMapper.selectRoleList(groupId, roleIdsList);
    }
}

