/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.identity.user.manager.impl;

import com.jxdinfo.hussar.authorization.permit.dto.DelUserRoleDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleData;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseRoleBoService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserRoleBoService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.identity.user.manager.OperateUserRoleManage;
import com.jxdinfo.hussar.identity.user.model.SysUsers;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="com.jxdinfo.hussar.identity.user.manager.impl.operateUserRoleImpl")
public class OperateUserRoleImpl
implements OperateUserRoleManage {
    @Autowired
    protected ISysAuditConfigService sysAuditConfig;
    @Resource
    protected IHussarBaseUserRoleBoService hussarBaseUserRoleBoService;
    @Resource
    protected IHussarBaseRoleBoService hussarBaseRoleBoService;

    @Override
    @HussarDs(value="#connName")
    public void processRoleAuditIfNecessary(SysUsers user, Long[] roleIds, String connName) {
        Long userId = user.getId();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isRoleAudit()) {
            List auditList = this.hussarBaseUserRoleBoService.listAuditByUserId(userId);
            List connList = this.hussarBaseUserRoleBoService.listByUserId(userId);
            ArrayList<Long> adds = new ArrayList<Long>();
            ArrayList<Long> dels = new ArrayList<Long>();
            if (HussarUtils.isNotEmpty((Object)connList)) {
                for (SysUserRole sysUserRole : connList) {
                    int isSame = 0;
                    if (HussarUtils.isNotEmpty((Object[])roleIds)) {
                        for (Long roleId : roleIds) {
                            if (ToolUtil.isEmpty((Object)roleId) || !roleId.equals(sysUserRole.getGrantedRole())) continue;
                            isSame = 1;
                            break;
                        }
                    }
                    if (isSame != 0) continue;
                    dels.add(sysUserRole.getGrantedRole());
                }
            }
            if (HussarUtils.isNotEmpty((Object[])roleIds)) {
                for (Long roleId : roleIds) {
                    boolean isSame = false;
                    for (SysUserRole sysUserRole : connList) {
                        if (!roleId.equals(sysUserRole.getGrantedRole())) continue;
                        isSame = true;
                        break;
                    }
                    if (isSame || SysUserAndRole.PUBLIC_ROLE.getValue().equals(roleId)) continue;
                    adds.add(roleId);
                }
            }
        } else {
            List roleList;
            this.hussarBaseRoleBoService.delAuthCacheInfo(userId);
            if (BaseSecurityUtil.getUser().isGradeadmin()) {
                roleList = this.hussarBaseUserRoleBoService.delOrganRoleIdByUserId(userId);
                if (roleList.size() > 0) {
                    List cdidList = LambdaQueryUtil.getSplitList((List)roleList);
                    DelUserRoleDto delUserRoleDto = new DelUserRoleDto();
                    delUserRoleDto.setUserId(userId);
                    delUserRoleDto.setRoleIds(cdidList);
                    this.hussarBaseUserRoleBoService.delUserRoleByRoleId(delUserRoleDto);
                }
            } else {
                roleList = this.hussarBaseUserRoleBoService.getSysRolesByUserId(userId);
                if (CollectionUtils.isNotEmpty((Collection)roleList)) {
                    List cdids = roleList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                    List cdidList = LambdaQueryUtil.getSplitList(cdids);
                    DelUserRoleDto delUserRoleDto = new DelUserRoleDto();
                    delUserRoleDto.setUserId(userId);
                    delUserRoleDto.setRoleIds(cdidList);
                    this.hussarBaseUserRoleBoService.delSysRolesByUserId(delUserRoleDto);
                }
            }
            ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
            if (HussarUtils.isNotEmpty((Object[])roleIds)) {
                SecurityUser securityUser = BaseSecurityUtil.getUser();
                LocalDateTime now = LocalDateTime.now();
                for (Long roleId : roleIds) {
                    if (SysUserAndRole.PUBLIC_ROLE.getValue().equals(roleId) && BaseSecurityUtil.getUser().isGradeadmin()) continue;
                    SysUserRole sysUserRole = new SysUserRole();
                    sysUserRole.setUserId(userId);
                    sysUserRole.setGrantedRole(roleId);
                    sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                    sysUserRole.setCreator(securityUser.getId());
                    sysUserRole.setLastEditor(securityUser.getId());
                    sysUserRole.setLastTime(now);
                    sysUserRole.setCreateTime(now);
                    userRoleList.add(sysUserRole);
                }
            }
            this.hussarBaseUserRoleBoService.delete(userId);
            if (HussarUtils.isNotEmpty(userRoleList)) {
                this.hussarBaseUserRoleBoService.saveBatchSize(userRoleList);
            }
        }
    }

    @Override
    @HussarDs(value="#connName")
    public List<RoleData> getCommonUserRoleData(Long id, boolean gradeAdmin, String connName) {
        return this.hussarBaseUserRoleBoService.getCommonUserRoleData(id, gradeAdmin);
    }
}

