/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.identity.user.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eryuanregister.model.SysServerStru;
import com.jxdinfo.hussar.eryuanregister.service.ISysServerStruService;
import com.jxdinfo.hussar.identity.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.identity.organ.model.SysStru;
import com.jxdinfo.hussar.identity.organ.service.IHussarBaseStruBoService;
import com.jxdinfo.hussar.identity.user.dao.SysUsersMapper;
import com.jxdinfo.hussar.identity.user.service.IHussarBaseTeamService;
import com.jxdinfo.hussar.identity.user.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.identity.user.manager.impl.hussarBaseTeamServiceImpl")
public class HussarBaseTeamServiceImpl
implements IHussarBaseTeamService {
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Autowired
    private SysStruMapper sysStruMapper;
    @Resource
    private ISysServerStruService iSysServerStruService;
    @Resource
    private IHussarBaseStruBoService hussarBaseStruBoService;
    @Resource
    private SysUsersMapper oldUsersMapper;
    @Autowired
    private ISysServerStruService sysServerStruService;

    @HussarDs(value="master")
    public List<JSTreeModel> getTeamUserTree(Long parentId) {
        List struIdList;
        List userList;
        Object permissionStruId = null;
        List<Object> list = new ArrayList();
        if (ToolUtil.equals((Object)Constants.ROOT_NODE_ID, (Object)parentId)) {
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysServerStru::getServerId, securityUser.getExtendUserMap("serverId"));
            List sysServerInfoList = this.sysServerStruService.list((Wrapper)queryWrapper);
            List<Long> orgList = sysServerInfoList.stream().map(SysServerStru::getStruId).collect(Collectors.toList());
            if (ToolUtil.isNotEmpty(orgList)) {
                list = this.sysStruMapper.getTeamUserTree(parentId, orgList);
            }
        } else {
            list = this.sysStruMapper.getTeamUserTree(parentId, null);
        }
        List leafModel = list.stream().filter(item -> "Y".equals(item.getIsLeaf())).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(leafModel) && HussarUtils.isNotEmpty((Object)(userList = this.hussarBaseUserBoService.getUsersByStruIds(struIdList = leafModel.stream().map(JSTreeModel::getId).collect(Collectors.toList()))))) {
            HashMap<Long, JSTreeModel> map = new HashMap<Long, JSTreeModel>();
            for (JSTreeModel item2 : leafModel) {
                map.put(item2.getId(), item2);
            }
            for (JSTreeModel item2 : userList) {
                JSTreeModel jsTreeModel = (JSTreeModel)map.get(item2.getDepartmentId());
                jsTreeModel.setIsLeaf("N");
            }
        }
        return list;
    }

    public Map<Long, Long> getUserIdsByStruId(Map<String, List<Long>> map) {
        return this.hussarBaseUserBoService.getUserIdsByStruId(map.get("ids"));
    }

    public List<JSTreeModel> getSpecialUserTree(String userName, String sysType, String isSecurity) {
        SecurityUser user = BaseSecurityUtil.getUser();
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        Object permissionStruId = null;
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId(Long.valueOf(11L));
        root.setCode("organ");
        root.setText("\u7ec4\u7ec7\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setStruLevel("0");
        root.setType("isRoot");
        root.setState(false, false, true);
        result.add(root);
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysServerStru::getServerId, securityUser.getExtendUserMap("serverId"));
        List sysServerInfoList = this.iSysServerStruService.list((Wrapper)queryWrapper);
        List orgList = sysServerInfoList.stream().map(SysServerStru::getStruId).collect(Collectors.toList());
        List list = this.hussarBaseStruBoService.selectList(orgList);
        List struFidList = list.stream().map(SysStru::getStruFid).collect(Collectors.toList());
        ArrayList<String> stringList = new ArrayList<String>();
        for (String s : struFidList) {
            stringList.add(s + "%");
        }
        if (!sysType.equals("1") && !sysType.equals("0")) {
            Integer securityLevel = null;
            if (isSecurity.equals("1")) {
                securityLevel = user.getSecurityLevel();
            }
            queryParams.put("securityLevel", securityLevel);
        }
        queryParams.put("orgList", stringList);
        queryParams.put("userName", userName);
        List<JSTreeModel> userList = this.oldUsersMapper.searchUsers(queryParams);
        if (userList.size() > 0) {
            userList.forEach(org -> {
                String[] name = org.getPath().split("/");
                StringBuilder parentAllName = new StringBuilder();
                for (int i = name.length - 1; i > 0; --i) {
                    parentAllName.append("/").append(name[i]);
                }
                org.setText(org.getText() + "(" + parentAllName + ")");
                org.setParent(Long.valueOf(11L));
                if (sysType.equals("0") && "1".equals(org.getIsSys())) {
                    org.setState(false, false, true);
                }
            });
        }
        result.addAll(userList);
        return result;
    }
}

