/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.identity.user.manager.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.authentication.lock.LoginLock;
import com.jxdinfo.hussar.authorization.permit.dto.CopyUserRoleDto;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.identity.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.identity.organ.model.SysStru;
import com.jxdinfo.hussar.identity.sysuserip.model.SysUserIp;
import com.jxdinfo.hussar.identity.user.dao.SysUsersMapper;
import com.jxdinfo.hussar.identity.user.dto.EditUserDto;
import com.jxdinfo.hussar.identity.user.manager.EditUserManager;
import com.jxdinfo.hussar.identity.user.manager.OperateUserRoleManage;
import com.jxdinfo.hussar.identity.user.manager.impl.CommonUserManager;
import com.jxdinfo.hussar.identity.user.model.SysUsers;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Master
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.editUserManagerImpl")
public class EditUserManagerImpl
extends CommonUserManager
implements EditUserManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditUserManagerImpl.class);
    @Autowired
    private IHussarValidateService validateService;
    @Autowired
    private IHussarLoginConfigService hussarLoginConfigService;
    @Autowired
    private OperateUserRoleManage operateUserRoleManage;
    @Resource
    private SysUsersMapper sysUsersMapper;

    @Override
    public String editUser(EditUserDto editUserDto) {
        String validateMsg = this.validateService.validate((Object)editUserDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String allowedIps = StringUtils.trimToEmpty((String)editUserDto.getAllowedIps());
        String roleIds = StringUtils.trimToEmpty((String)editUserDto.getRoleIds());
        Long[] roleIdsArr = null;
        if (HussarUtils.isNotBlank((CharSequence)roleIds)) {
            roleIdsArr = (Long[])ConvertUtils.convert((String[])roleIds.split(","), Long.class);
        }
        SysUsers user = this.initialization(editUserDto);
        this.checkIncludeConfRole(roleIdsArr);
        this.userAuditDataExists(user.getId());
        String result = this.processAuditIfNecessary(user, allowedIps, roleIdsArr);
        return result;
    }

    @Override
    public String editUserWithoutRole(EditUserDto editUserDto) {
        String validateMsg = this.validateService.validate((Object)editUserDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String allowedIps = StringUtils.trimToEmpty((String)editUserDto.getAllowedIps());
        SysUsers user = this.initialization(editUserDto);
        this.userAuditDataExists(user.getId());
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            return this.doProcessUserAudit(user, allowedIps, new Long[0]);
        }
        return this.doProcessUser(user, allowedIps, new Long[0]);
    }

    @Override
    public String copyUserRole(CopyUserRoleDto copyRoleDto) {
        String validateMsg = this.validateService.validate((Object)copyRoleDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        boolean result = this.copyRole(copyRoleDto.getSource(), copyRoleDto.getTarget());
        if (!result) {
            throw new BaseException("\u89d2\u8272\u590d\u5236\u5931\u8d25\uff01\uff08\u590d\u5236\u7684\u89d2\u8272\u4e0e\u539f\u89d2\u8272\u4e2d\u6709\u4e0d\u76f8\u5bb9\u89d2\u8272\uff01\uff09");
        }
        return "\u89d2\u8272\u590d\u5236\u6210\u529f\uff01";
    }

    @Override
    public String dormancyUser(Long id) {
        LOGGER.info("\u4f11\u7720\u7528\u6237\uff1a{}", (Object)id);
        SysUsers sysUsers = (SysUsers)this.sysUsersMapper.selectById(id);
        AssertUtil.isNotNull((Object)sysUsers, (String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        sysUsers.setAccountStatus(UserStatus.DORMANCY.getCode());
        sysUsers.setLockTime(Java8DateUtils.currentLocalDateTime());
        this.sysUsersMapper.updateById(sysUsers);
        return "\u4f11\u7720\u7528\u6237\u6210\u529f\uff01";
    }

    @Override
    public String cancelUser(Long id) {
        LOGGER.info("\u6ce8\u9500\u7528\u6237\uff1a{}", (Object)id);
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        SysUsers sysUser = (SysUsers)this.sysUsersMapper.selectById(id);
        AssertUtil.isNotNull((Object)sysUser, (String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        if (Whether.YES.getValue().equals(sysUser.getIsSys())) {
            throw new BaseException("\u6ce8\u9500\u5931\u8d25\uff01\uff08\u4e0d\u80fd\u6ce8\u9500\u7ba1\u7406\u5458\u7528\u6237\uff01\uff09");
        }
        if (shiroUser.getId().equals(id)) {
            throw new BaseException("\u6ce8\u9500\u5931\u8d25\uff01\uff08\u4e0d\u80fd\u6ce8\u9500\u5f53\u524d\u7528\u6237\uff01\uff09");
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit() && this.sysUsersAuditService.adjustEdit(id)) {
            throw new BaseException("\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u6ce8\u9500\uff01");
        }
        SysUsersAudit sysUsersAudit = new SysUsersAudit();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            CopyPropertieUtils.copyProperties((Object)sysUsersAudit, (Object)sysUser);
            sysUsersAudit.setId(null);
            sysUsersAudit.setUserId(sysUser.getId());
            sysUsersAudit.setIsAudit("0");
            sysUsersAudit.setCurrentStatus("4");
            this.sysUsersAuditService.save((Object)sysUsersAudit);
            return "\u6ce8\u9500\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01";
        }
        Long employeeId = sysUser.getEmployeeId();
        HussarCacheUtil.evictKeysLike((String)"Login_Lock", (String)String.valueOf(sysUser.getId()));
        sysUser.setAccountStatus(UserStatus.CANCEL.getCode());
        this.hussarBaseUserRoleBoService.removeAuditByUserId(sysUser.getId());
        this.sysUsersMapper.updateById(sysUser);
        return "\u6ce8\u9500\u6210\u529f\uff01";
    }

    @Override
    public String activateUser(Long id) {
        LOGGER.info("\u6fc0\u6d3b\u7528\u6237\uff1a{}", (Object)id);
        SysUsers sysUsers = (SysUsers)this.sysUsersMapper.selectById(id);
        AssertUtil.isNotNull((Object)sysUsers, (String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        this.dealLock(sysUsers);
        boolean flag = true;
        if ("0".equals(sysUsers.getTypeProperty())) {
            LocalDateTime nowDay = LocalDateTime.now();
            LocalDateTime expiredDay = sysUsers.getExpiredTime();
            LocalDateTime startDay = sysUsers.getStartTime();
            flag = nowDay.isAfter(startDay);
            if (flag) {
                flag = expiredDay.isAfter(nowDay);
            }
        }
        if (!flag) {
            throw new BaseException("\u4e0d\u80fd\u6fc0\u6d3b\u6709\u6548\u671f\u5916\u7684\u4e34\u65f6\u8d26\u53f7");
        }
        this.sysUsersMapper.update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysUsers::getAccountStatus, (Object)UserStatus.OK.getCode())).set(SysUsers::getLastLoginTime, (Object)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()))).eq(SysUsers::getId, (Object)id));
        return "\u4fee\u6539\u6210\u529f\uff01";
    }

    private void dealLock(SysUsers sysUsers) {
        if (sysUsers != null) {
            HussarCacheUtil.evictKeysLike((String)"Login_Lock", (String)String.valueOf(sysUsers.getId()));
        }
    }

    public boolean copyRole(Long copyFrom, Long copyTo) {
        if (HussarUtils.isEmpty((Object)copyTo)) {
            return true;
        }
        List rolesFrom = this.hussarBaseUserRoleBoService.listByUserId(copyFrom);
        List rolesTo = this.hussarBaseUserRoleBoService.listByUserId(copyTo);
        ArrayList<Long> adds = new ArrayList<Long>();
        for (SysUserRole from : rolesFrom) {
            if (ToolUtil.isEmpty((Object)from.getGrantedRole())) continue;
            boolean isSame = false;
            for (SysUserRole to : rolesTo) {
                if (!from.getGrantedRole().equals(to.getGrantedRole())) continue;
                isSame = true;
                break;
            }
            if (isSame) continue;
            adds.add(from.getGrantedRole());
        }
        int size = adds.size();
        Long[] toRolesArray = new Long[rolesTo.size()];
        Long[] addArray = adds.toArray(new Long[size]);
        for (int i = 0; i < rolesTo.size(); ++i) {
            toRolesArray[i] = ((SysUserRole)rolesTo.get(i)).getGrantedRole();
        }
        int arryLen1 = addArray.length;
        int arryLen2 = toRolesArray.length;
        if ((addArray = Arrays.copyOf(addArray, arryLen1 + arryLen2)).length == 0) {
            return true;
        }
        System.arraycopy(toRolesArray, 0, addArray, arryLen1, arryLen2);
        if (this.hussarBaseConfRolesBoService.isIncludeConfRole(addArray)) {
            return false;
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isRoleAudit()) {
            List auditList = this.hussarBaseUserRoleBoService.listAuditByUserId(copyTo);
            if (ToolUtil.isNotEmpty(adds)) {
                this.insertAndUpdateUserRoleAudit(adds, auditList, copyTo, "1");
            }
        } else {
            ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
            for (Long roleId : adds) {
                if (ToolUtil.isEmpty((Object)roleId)) continue;
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(copyTo);
                sysUserRole.setGrantedRole(roleId);
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                userRoleList.add(sysUserRole);
            }
            if (ToolUtil.isNotEmpty(userRoleList)) {
                this.hussarBaseUserRoleBoService.saveBatch(userRoleList);
            }
        }
        return true;
    }

    private String processAuditIfNecessary(SysUsers user, String allowedIps, Long[] roleIds) {
        String dbName = "master";
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        if (HussarUtils.isNotEmpty((Object)securityUser.getExtendUserMap("dbName"))) {
            dbName = (String)securityUser.getExtendUserMap("dbName");
        }
        this.operateUserRoleManage.processRoleAuditIfNecessary(user, roleIds, dbName);
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            return this.doProcessUserAudit(user, allowedIps, roleIds);
        }
        return this.doProcessUser(user, allowedIps, roleIds);
    }

    private String doProcessUser(SysUsers user, String allowedIps, Long[] roleIds) {
        Long userId = user.getId();
        SysUsers old = (SysUsers)this.sysUsersMapper.selectById(userId);
        if (!"1".equals(old.getAccountStatus()) && "1".equals(user.getAccountStatus())) {
            user.setLastLoginTime(LocalDateTime.now());
            LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
            loginLock.removeUserCache(String.valueOf(userId));
        }
        this.sysUsersMapper.updateById(user);
        this.sysUserIpService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)userId));
        this.saveUserIP(userId, allowedIps);
        return "\u4fee\u6539\u6210\u529f\uff01";
    }

    private String doProcessUserAudit(SysUsers user, String allowedIps, Long[] roleIds) {
        SysUsersAudit sysUsersAudit = new SysUsersAudit();
        SysUsers oldUser = (SysUsers)this.sysUsersMapper.selectById(user.getId());
        Long oldEmployeeId = oldUser.getEmployeeId();
        Long newEmployeeId = user.getEmployeeId();
        AssertUtil.isTrue((boolean)this.sysStruAuditService.checkCanOperate(oldEmployeeId), (String)"\u7528\u6237\u5173\u8054\u7684\u4eba\u5458\u5b58\u5728\u672a\u5ba1\u6838\u6570\u636e\uff0c\u7981\u6b62\u4fee\u6539!");
        if (!oldEmployeeId.equals(newEmployeeId)) {
            AssertUtil.isTrue((boolean)this.sysStruAuditService.checkCanOperate(newEmployeeId), (String)"\u7528\u6237\u65b0\u5173\u8054\u7684\u4eba\u5458\u5b58\u5728\u672a\u5ba1\u6838\u6570\u636e\uff0c\u7981\u6b62\u4fee\u6539\uff01");
        }
        BeanUtils.copyProperties((Object)user, (Object)sysUsersAudit, (String[])new String[]{"id"});
        sysUsersAudit.setUserId(user.getId());
        sysUsersAudit.setCurrentStatus("1");
        sysUsersAudit.setIsAudit("0");
        this.sysUsersAuditService.save((Object)sysUsersAudit);
        this.saveUserAuditIP(user.getId(), allowedIps, "1");
        return "\u4fee\u6539\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01";
    }

    private void insertAndUpdateUserRoleAudit(List<Long> roleIds, List<SysUserroleAudit> auditList, Long userId, String operationType) {
        Long account;
        ArrayList<SysUserroleAudit> updateAuditList = new ArrayList<SysUserroleAudit>();
        HashMap<String, Object> updateMap = new HashMap<String, Object>();
        ArrayList<SysUserroleAudit> addAuditList = new ArrayList<SysUserroleAudit>();
        Date currentDate = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        Long l = account = ToolUtil.isNotEmpty((Object)BaseSecurityUtil.getUser()) ? BaseSecurityUtil.getUser().getId() : null;
        if (HussarUtils.isNotEmpty(roleIds)) {
            for (Long roleId : roleIds) {
                if (ToolUtil.isEmpty((Object)roleId) || Objects.equals(roleId, SysUserAndRole.PUBLIC_ROLE.getValue())) continue;
                boolean isExist = false;
                for (SysUserroleAudit sysUserroleAudit : auditList) {
                    if (!roleId.equals(sysUserroleAudit.getRoleId())) continue;
                    isExist = true;
                    updateAuditList.add(sysUserroleAudit);
                    break;
                }
                if (isExist) continue;
                SysUserroleAudit sysUserroleAudit = new SysUserroleAudit();
                sysUserroleAudit.setUserId(userId);
                sysUserroleAudit.setRoleId(roleId);
                sysUserroleAudit.setStatus(UserRoleStatus.LOCKED.getCode());
                sysUserroleAudit.setOperationType(operationType);
                addAuditList.add(sysUserroleAudit);
            }
        }
        if (updateAuditList.size() > 0) {
            updateMap.put("userId", userId);
            updateMap.put("operationType", operationType);
            updateMap.put("status", UserRoleStatus.LOCKED.getCode());
            updateMap.put("lastTime", currentDate);
            updateMap.put("lastEditor", account);
            updateMap.put("updateAuditList", updateAuditList);
            this.hussarBaseUserRoleAuditBoService.updateAuditBatch(updateMap);
        }
        if (addAuditList.size() > 0) {
            this.hussarBaseUserRoleAuditBoService.saveBatch(addAuditList);
        }
    }

    private void userAuditDataExists(Long userId) {
        LOGGER.debug("\u5224\u65ad\u662f\u5426\u5df2\u6709\u5728\u4fee\u6539\u5ba1\u6838\u7684\u7528\u6237");
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit() && this.sysUsersAuditService.adjustEdit(userId)) {
            throw new BaseException("\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u4fee\u6539\uff01");
        }
    }

    private SysUsers initialization(EditUserDto editUserDto) {
        LOGGER.info("\u6839\u636eEditUserDto\u521d\u59cb\u5316SysUsers,\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)editUserDto));
        long id = editUserDto.getId();
        SysUsers user = (SysUsers)this.sysUsersMapper.selectById(Long.valueOf(id));
        AssertUtil.isNotNull((Object)user, (String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        Long staffId = editUserDto.getStaffId();
        String mail = StringUtils.trimToEmpty((String)editUserDto.getMail());
        Integer maxSessions = editUserDto.getMaxSessions();
        String weChat = StringUtils.trimToEmpty((String)editUserDto.getWeChat());
        String mobile = StringUtils.trimToEmpty((String)editUserDto.getMobile());
        String telephone = StringUtils.trimToEmpty((String)editUserDto.getTelephone());
        String accountProperty = StringUtils.trimToEmpty((String)editUserDto.getAccountProperty());
        String accountStatus = StringUtils.trimToEmpty((String)editUserDto.getAccountStatus());
        boolean isLoginTimeLimit = editUserDto.getLoginTimeLimit();
        String accessLoginStartTime = StringUtils.trimToEmpty((String)editUserDto.getAccessLoginStartTime());
        String accessLoginEndTime = StringUtils.trimToEmpty((String)editUserDto.getAccessLoginEndTime());
        String userOrderStr = StringUtils.trimToEmpty((String)(editUserDto.getUserOrder() == null ? "" : editUserDto.getUserOrder().toString()));
        String startTime = StringUtils.trimToEmpty((String)editUserDto.getStartTime());
        String endTime = StringUtils.trimToEmpty((String)editUserDto.getEndTime());
        Integer securityLevel = editUserDto.getSecurityLevel();
        boolean isLoginIpLimit = editUserDto.getLoginIpLimit();
        SysStru sysStru = (SysStru)this.sysStruMapper.selectById(staffId);
        AssertUtil.isNotNull((Object)sysStru, (String)"\u672a\u67e5\u8be2\u5230\u4eba\u5458\u4fe1\u606f");
        user.setUserName(sysStru.getOrganAlias());
        user.setStartTime(Java8DateUtils.convertStringToLocalDateTime((String)startTime));
        user.setExpiredTime(Java8DateUtils.convertStringToLocalDateTime((String)endTime));
        user.seteMail(mail);
        user.setEmployeeId(staffId);
        user.setTypeProperty(accountProperty);
        user.setTelephone(telephone);
        user.setMobile(mobile);
        user.setWeChat(weChat);
        user.setMaxSessions(maxSessions);
        user.setAccountStatus(accountStatus);
        user.setLoginTimeLimit(isLoginTimeLimit ? "1" : "0");
        user.setLoginIpLimit(isLoginIpLimit ? "1" : "0");
        user.setSecurityLevel(securityLevel);
        if (isLoginTimeLimit) {
            user.setAccessLoginStartTime(Java8DateUtils.convertStringToLocalTime((String)accessLoginStartTime));
            user.setAccessLoginEndTime(Java8DateUtils.convertStringToLocalTime((String)accessLoginEndTime));
        }
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue()) {
            user.setUserAccount(user.getUserAccount().toUpperCase());
        }
        if (UserStatus.TEMPORARY.getCode().equals(user.getTypeProperty())) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date begin = sdf.parse(startTime);
                Date end = sdf.parse(endTime);
                Date now = sdf.parse(sdf.format(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant())));
                if (begin.getTime() > now.getTime() || end.getTime() < now.getTime()) {
                    user.setAccountStatus(UserStatus.DORMANCY.getCode());
                    user.setLockTime(Java8DateUtils.currentLocalDateTime());
                }
            }
            catch (ParseException e) {
                throw new BaseException("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
            }
        }
        if (HussarUtils.isNotEmpty((Object)userOrderStr)) {
            user.setUserOrder(Integer.valueOf(Integer.parseInt(userOrderStr)));
        }
        return user;
    }
}

