/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.identity.user.manager.impl;

import com.baomidou.dynamic.datasource.annotation.Master;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.identity.audit.dao.SysUsersAuditMapper;
import com.jxdinfo.hussar.identity.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.identity.audit.service.ISysUserIpAuditService;
import com.jxdinfo.hussar.identity.sysuserip.model.SysUserIp;
import com.jxdinfo.hussar.identity.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.identity.user.service.ISysUsersService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Master
public class CommonUserAuditManager {
    @Resource
    protected SysUsersAuditMapper sysUsersAuditMapper;
    @Autowired
    protected ISysUserIpAuditService sysUserIpAuditService;
    @Autowired
    protected ISysUserIpService sysUserIpService;
    @Autowired
    protected ISysUsersService sysUsersService;
    @Autowired
    protected ISysDicRefService dicRefService;

    protected SysUsersAudit getSysUsersAudit(Long id) {
        AssertUtil.isNotNull((Object)id, (String)"\u672a\u4f20\u9012\u53c2\u6570");
        SysUsersAudit usersAudit = (SysUsersAudit)this.sysUsersAuditMapper.selectById(id);
        AssertUtil.isNotNull((Object)usersAudit, (String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u5ba1\u6838\u4fe1\u606f");
        return usersAudit;
    }

    protected String queryIp(Long userId) {
        List userIps = this.sysUserIpService.selectUserIp(userId);
        if (HussarUtils.isNotEmpty((Object)userIps)) {
            return String.join((CharSequence)",", userIps);
        }
        return null;
    }

    protected String queryAuditIp(Long userId, String inuse) {
        List userIps = this.sysUserIpAuditService.selectUserIp(userId, inuse);
        if (HussarUtils.isNotEmpty((Object)userIps)) {
            return String.join((CharSequence)",", userIps);
        }
        return null;
    }

    protected boolean saveUserIP(Long userId, String accessLoginIp) {
        boolean flag = false;
        ArrayList<SysUserIp> sysUserIps = new ArrayList<SysUserIp>();
        if (StringUtils.isNotEmpty((CharSequence)accessLoginIp)) {
            List<String> list = Arrays.asList(accessLoginIp.split(","));
            for (String ip : list) {
                SysUserIp sysUserIp = new SysUserIp();
                sysUserIp.setUserId(userId);
                sysUserIp.setUserIp(ip);
                sysUserIps.add(sysUserIp);
            }
        }
        if (ToolUtil.isNotEmpty(sysUserIps)) {
            flag = this.sysUserIpService.saveBatch(sysUserIps);
        }
        return flag;
    }
}

