/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.identity.user.manager.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.GeneratePassword;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.identity.audit.model.SysStruAudit;
import com.jxdinfo.hussar.identity.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.identity.organ.model.SysStru;
import com.jxdinfo.hussar.identity.user.dto.AddUserDto;
import com.jxdinfo.hussar.identity.user.manager.AddUserManager;
import com.jxdinfo.hussar.identity.user.manager.impl.CommonUserManager;
import com.jxdinfo.hussar.identity.user.model.SysUsers;
import com.jxdinfo.hussar.identity.user.util.CreateUserSendMailUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

@Master
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.addUserManagerImpl")
public class AddUserManagerImpl
extends CommonUserManager
implements AddUserManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddUserManagerImpl.class);

    @Override
    public ApiResponse<Long> addUser(AddUserDto addUserDto) {
        String validateMsg = this.validateService.validate((Object)addUserDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String allowedIps = StringUtils.trimToEmpty((String)addUserDto.getAllowedIps());
        String roleIds = StringUtils.trimToEmpty((String)addUserDto.getRoleIds());
        Long[] roleIdsArr = null;
        ArrayList<Object> listRoles = new ArrayList<Object>();
        if (HussarUtils.isNotBlank((CharSequence)roleIds)) {
            String[] arr = roleIds.split(",");
            Object[] temp = (Long[])ConvertUtils.convert((String[])roleIds.split(","), Long.class);
            if (!ArrayUtils.contains((Object[])temp, (Object)SysUserAndRole.PUBLIC_ROLE.getValue())) {
                listRoles.add(SysUserAndRole.PUBLIC_ROLE.getValue());
            }
            for (Object role : temp) {
                listRoles.add(role);
            }
        } else {
            listRoles.add(SysUserAndRole.PUBLIC_ROLE.getValue());
        }
        roleIdsArr = listRoles.toArray(new Long[listRoles.size()]);
        SysUsers user = this.initialization(addUserDto);
        boolean tenantFlag = this.isCanAdd(user);
        this.checkIncludeConfRole(roleIdsArr);
        this.userAuditDataExists(user.getUserAccount());
        String secure = this.wrapUser(user);
        String result = this.processAuditIfNecessary(tenantFlag, user, allowedIps, roleIdsArr, secure);
        return ApiResponse.success((Object)user.getId(), (String)result);
    }

    private String processAuditIfNecessary(boolean tenantFlag, SysUsers sysUsers, String allowedIps, Long[] roleIds, String secure) {
        LOGGER.debug("\u5224\u65ad\u9700\u4e0d\u9700\u8981\u5ba1\u6838,\u5982\u679c\u9700\u8981\u5ba1\u6838\uff0c\u5219\u5148\u52a0\u5165\u5ba1\u6838\u8868");
        StringBuilder stringBuilder = new StringBuilder("");
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            stringBuilder.append(this.doProcessUserAudit(sysUsers, allowedIps, roleIds));
        } else {
            stringBuilder.append(this.doProcessUser(tenantFlag, sysUsers, allowedIps, roleIds, secure));
        }
        Long sysUsersId = sysUsers.getId();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isRoleAudit()) {
            SysUserRole sysUserRole = new SysUserRole();
            sysUserRole.setUserId(sysUsersId);
            sysUserRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
            sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
            this.hussarBaseUserRoleBoService.save(sysUserRole);
            ArrayList<SysUserroleAudit> sysUserroleAuditList = new ArrayList<SysUserroleAudit>();
            if (HussarUtils.isNotEmpty((Object[])roleIds)) {
                for (Long roleId : roleIds) {
                    if (SysUserAndRole.PUBLIC_ROLE.getValue().equals((long)roleId)) continue;
                    if (SysUserAndRole.GRADEADMIN_ROLE.getValue().equals((long)roleId)) {
                        SysUserRole sysUserGradeRole = new SysUserRole();
                        sysUserGradeRole.setUserId(sysUsersId);
                        sysUserGradeRole.setGrantedRole(SysUserAndRole.GRADEADMIN_ROLE.getValue());
                        sysUserGradeRole.setAdminOption(UserRoleStatus.OK.getCode());
                        this.hussarBaseUserRoleBoService.save(sysUserGradeRole);
                        continue;
                    }
                    SysUserroleAudit sysUserroleAudit = new SysUserroleAudit();
                    sysUserroleAudit.setUserId(sysUsersId);
                    sysUserroleAudit.setRoleId(Long.valueOf(roleId));
                    sysUserroleAudit.setStatus(UserStatus.LOCKED.getCode());
                    sysUserroleAudit.setOperationType("1");
                    sysUserroleAuditList.add(sysUserroleAudit);
                }
            }
            if (HussarUtils.isNotEmpty(sysUserroleAuditList)) {
                this.hussarBaseUserRoleBoService.saveBatchAudit(sysUserroleAuditList);
                stringBuilder.append("\u65b0\u589e\u7528\u6237\u89d2\u8272\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            }
        }
        return stringBuilder.toString();
    }

    private String doProcessUser(boolean tenantFlag, SysUsers sysUsers, String allowedIps, Long[] roleIds, String secure) {
        StringBuilder stringBuilder = new StringBuilder("");
        this.sysUsersMapper.insert(sysUsers);
        this.saveUserIP(sysUsers.getId(), allowedIps);
        if (tenantFlag) {
            this.sysLoginUserService.syncAddUser(sysUsers);
        }
        stringBuilder.append("\u65b0\u589e\u7528\u6237\u6210\u529f\uff01");
        if (!this.sysAuditConfig.isCriticalOperationsAudit() || !this.sysAuditConfig.isRoleAudit()) {
            this.hussarBaseUserRoleBoService.removeByUserId(sysUsers.getId());
            ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
            if (HussarUtils.isNotEmpty((Object[])roleIds)) {
                for (Long roleId : roleIds) {
                    SysUserRole sysUserRole = new SysUserRole();
                    sysUserRole.setUserId(sysUsers.getId());
                    sysUserRole.setGrantedRole(roleId);
                    sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                    userRoleList.add(sysUserRole);
                }
            }
            if (ToolUtil.isNotEmpty(userRoleList)) {
                this.hussarBaseUserRoleBoService.saveBatch(userRoleList);
                if (userRoleList.size() != 1 || !((SysUserRole)userRoleList.get(0)).getGrantedRole().equals(SysUserAndRole.PUBLIC_ROLE.getValue())) {
                    stringBuilder.append("\u65b0\u589e\u7528\u6237\u89d2\u8272\u6210\u529f\uff01");
                }
            }
        }
        if (this.createUserConfigService.getCreateUserSendEmail().booleanValue() && StringUtils.isNotBlank((CharSequence)sysUsers.geteMail())) {
            CreateUserSendMailUtil.sendMail((SysUsers)sysUsers, (String)secure);
        }
        return stringBuilder.toString();
    }

    private String doProcessUserAudit(SysUsers sysUsers, String allowedIps, Long[] roleIds) {
        StringBuilder stringBuilder = new StringBuilder("");
        boolean canOperate = this.sysStruAuditService.checkCanOperate(sysUsers.getDepartmentId());
        AssertUtil.isTrue((boolean)canOperate, (String)"\u65b0\u5efa\u7528\u6237\u6240\u5728\u7684\u7ec4\u7ec7\u673a\u6784\u5b58\u5728\u672a\u5ba1\u6838\u6570\u636e\uff01");
        long userId = sysUsers.getId();
        SysUsersAudit sysUsersAudit = new SysUsersAudit();
        BeanUtils.copyProperties((Object)sysUsers, (Object)sysUsersAudit);
        sysUsersAudit.setId(null);
        sysUsersAudit.setUserId(Long.valueOf(userId));
        sysUsersAudit.setPassword(sysUsers.getPassword());
        sysUsersAudit.setCurrentStatus("0");
        sysUsersAudit.setIsAudit("0");
        this.sysUsersAuditService.save((Object)sysUsersAudit);
        this.saveUserAuditIP(userId, allowedIps, "0");
        stringBuilder.append("\u65b0\u589e\u7528\u6237\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
        if (!this.sysAuditConfig.isCriticalOperationsAudit() || !this.sysAuditConfig.isRoleAudit()) {
            ArrayList<SysUserroleAudit> sysUserroleAuditList = new ArrayList<SysUserroleAudit>();
            if (HussarUtils.isNotEmpty((Object[])roleIds)) {
                for (Long roleId : roleIds) {
                    if (ToolUtil.isEmpty((Object)roleId) || Objects.equals(roleId, SysUserAndRole.PUBLIC_ROLE.getValue())) continue;
                    SysUserroleAudit sysUserroleAudit = new SysUserroleAudit();
                    sysUserroleAudit.setUserId(sysUsers.getId());
                    sysUserroleAudit.setRoleId(roleId);
                    sysUserroleAudit.setStatus(UserRoleStatus.UserAuditButRoleNotAudit.getCode());
                    sysUserroleAudit.setOperationType("1");
                    sysUserroleAuditList.add(sysUserroleAudit);
                }
            }
            if (ToolUtil.isNotEmpty(sysUserroleAuditList)) {
                this.hussarBaseUserRoleBoService.saveBatchAudit(sysUserroleAuditList);
                if (sysUserroleAuditList.size() != 1 || !((SysUserroleAudit)sysUserroleAuditList.get(0)).getRoleId().equals(SysUserAndRole.PUBLIC_ROLE.getValue())) {
                    stringBuilder.append("\u65b0\u589e\u7528\u6237\u89d2\u8272\u6210\u529f\uff01");
                }
            }
        }
        return stringBuilder.toString();
    }

    private String wrapUser(SysUsers sysUsers) {
        LOGGER.debug("\u5b8c\u5584\u7528\u6237\u4fe1\u606f");
        sysUsers.setCorporationId(sysUsers.getDepartmentId());
        if (HussarUtils.isEmpty((Object)sysUsers.getUserOrder())) {
            Integer order = this.sysUsersMapper.getMaxOrder(sysUsers.getDepartmentId());
            order = HussarUtils.isEmpty((Object)order) ? Integer.valueOf(1) : Integer.valueOf(order + 1);
            sysUsers.setUserOrder(order);
        }
        sysUsers.setTotpKey(this.abstractOTPCredentialsMatcher.getRandomSecretBase32());
        String secure = "";
        String encodeSecure = "";
        secure = this.hussarPwdConfigService.getDefaultPassword();
        if (this.createUserConfigService.getCreateUserSendEmail().booleanValue()) {
            AssertUtil.isNotEmpty((String)sysUsers.geteMail(), (String)"\u521b\u5efa\u7528\u6237\u53d1\u9001\u90ae\u4ef6\u5f00\u542f\u65f6\uff0c\u5fc5\u987b\u586b\u5199\u90ae\u4ef6\uff01");
            if (!this.createUserConfigService.getCreateUserUseDefaultPass().booleanValue()) {
                secure = GeneratePassword.generate((String)this.hussarPwdConfigService.getPwdRule());
            }
        }
        if (!this.sysAuditConfig.isCriticalOperationsAudit() || !this.sysAuditConfig.isUserAudit()) {
            encodeSecure = this.credentialsMatcher.passwordEncode(String.valueOf(secure).getBytes());
            sysUsers.setPassword(encodeSecure);
        } else {
            sysUsers.setPassword(secure);
        }
        return secure;
    }

    private void userAuditDataExists(String userAccount) {
        LOGGER.debug("\u5224\u65ad\u65b0\u589e\u7528\u6237\u662f\u5426\u5b58\u5728\u5ba1\u6838\u6570\u636e");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SysUsersAudit::getUserAccount, (Object)userAccount)).eq(SysUsersAudit::getIsAudit, (Object)"0");
        Boolean userAccountInAudit = this.sysUsersAuditService.count((Wrapper)wrapper) > 0L;
        AssertUtil.isFalse((boolean)userAccountInAudit, (String)"\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u7528\u6237\u540d\u5b58\u5728\u672a\u5ba1\u6838\u6570\u636e\uff01\uff09");
    }

    private SysUsers initialization(AddUserDto addUserDto) {
        LOGGER.info("\u6839\u636eAddUserDto\u521d\u59cb\u5316\u7528\u6237,\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)addUserDto));
        SysUsers user = new SysUsers();
        long id = IdWorker.getId((Object)user);
        user.setId(Long.valueOf(id));
        String userAccount = StringUtils.trimToEmpty((String)addUserDto.getUserAccount());
        Long staffId = addUserDto.getStaffId();
        Long departmentId = addUserDto.getDepartmentId();
        String mail = StringUtils.trimToEmpty((String)addUserDto.getMail());
        Integer maxSessions = addUserDto.getMaxSessions();
        String weChat = StringUtils.trimToEmpty((String)addUserDto.getWeChat());
        String mobile = StringUtils.trimToEmpty((String)addUserDto.getMobile());
        String telephone = StringUtils.trimToEmpty((String)addUserDto.getTelephone());
        String accountStatus = StringUtils.trimToEmpty((String)addUserDto.getAccountStatus());
        String accountProperty = StringUtils.trimToEmpty((String)addUserDto.getAccountProperty());
        boolean isLoginTimeLimit = addUserDto.getLoginTimeLimit();
        String accessLoginStartTime = StringUtils.trimToEmpty((String)addUserDto.getAccessLoginStartTime());
        String accessLoginEndTime = StringUtils.trimToEmpty((String)addUserDto.getAccessLoginEndTime());
        String startTime = StringUtils.trimToEmpty((String)addUserDto.getStartTime());
        String endTime = StringUtils.trimToEmpty((String)addUserDto.getEndTime());
        boolean isLoginIpLimit = addUserDto.getLoginIpLimit();
        Integer securityLevel = addUserDto.getSecurityLevel();
        SysStru sysStru = (SysStru)this.sysStruMapper.selectById(staffId);
        AssertUtil.isNotNull((Object)sysStru, (String)"\u672a\u67e5\u8be2\u5230\u4eba\u5458\u4fe1\u606f");
        user.setUserName(sysStru.getOrganAlias());
        user.setUserAccount(userAccount);
        user.seteMail(mail);
        user.setAccountStatus(accountStatus);
        user.setDepartmentId(departmentId);
        user.setEmployeeId(staffId);
        user.setTypeProperty(accountProperty);
        user.setSecurityLevel(securityLevel);
        user.setIsSys("0");
        user.setIsCpublic("0");
        user.setStartTime(Java8DateUtils.convertStringToLocalDateTime((String)startTime));
        user.setExpiredTime(Java8DateUtils.convertStringToLocalDateTime((String)endTime));
        user.setTelephone(telephone);
        user.setMobile(mobile);
        user.setWeChat(weChat);
        user.setMaxSessions(maxSessions);
        user.setLoginTimeLimit(isLoginTimeLimit ? "1" : "0");
        user.setLoginIpLimit(isLoginIpLimit ? "1" : "0");
        if (HussarUtils.isNotEmpty((Object)addUserDto.getUserOrder())) {
            user.setUserOrder(addUserDto.getUserOrder());
        } else {
            Integer userOrder = this.sysUsersMapper.getMaxOrder(departmentId);
            userOrder = HussarUtils.isEmpty((Object)userOrder) ? Integer.valueOf(1) : Integer.valueOf(userOrder + 1);
            user.setUserOrder(userOrder);
        }
        if (isLoginTimeLimit) {
            user.setAccessLoginStartTime(Java8DateUtils.convertStringToLocalTime((String)accessLoginStartTime));
            user.setAccessLoginEndTime(Java8DateUtils.convertStringToLocalTime((String)accessLoginEndTime));
        }
        return user;
    }

    private boolean isCanAdd(SysUsers sysUsers) {
        boolean existAccount;
        boolean tenantFlag;
        LOGGER.debug("\u6821\u9a8c\u7528\u6237\u662f\u5426\u53ef\u4ee5\u65b0\u589e");
        boolean bl = tenantFlag = this.hussarBaseProperties.isTenantOpen() && "2".equals(this.hussarBaseProperties.getTenantUserModel());
        if (tenantFlag && (existAccount = this.sysLoginUserService.validateAccount(sysUsers.getUserAccount()).booleanValue())) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u7528\u6237\u540d\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09");
        }
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue()) {
            sysUsers.setUserAccount(sysUsers.getUserAccount().toUpperCase());
        }
        if (this.isExistAccount(sysUsers.getUserAccount())) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u7528\u6237\u540d\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SysStruAudit::getRealStruId, (Object)sysUsers.getEmployeeId())).eq(SysStruAudit::getState, (Object)"0");
        Long count = this.sysStruAuditMapper.selectCount((Wrapper)wrapper);
        if (count > 0L) {
            throw new BaseException("\u5f53\u524d\u4eba\u5458\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u65b0\u589e\uff01");
        }
        return tenantFlag;
    }

    private boolean isExistAccount(String userAccount) {
        boolean flag = false;
        List<Map<String, Object>> result = this.sysUsersMapper.isExistAccount(userAccount);
        if (result.size() > 0) {
            flag = true;
        }
        return flag;
    }
}

