/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.identity.organ.service.impl;

import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.dto.QueryStruFuncCountDto;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseStruFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseStruResourcesBoService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IGlobalService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eryuanregister.model.SysServerStru;
import com.jxdinfo.hussar.eryuanregister.service.ISysServerStruService;
import com.jxdinfo.hussar.identity.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.identity.organ.dao.SysStruRuleMapper;
import com.jxdinfo.hussar.identity.organ.dto.OrganTreeDto;
import com.jxdinfo.hussar.identity.organ.model.SysOrganType;
import com.jxdinfo.hussar.identity.organ.model.SysStru;
import com.jxdinfo.hussar.identity.organ.service.ISysEmployeeService;
import com.jxdinfo.hussar.identity.organ.service.ISysOrgService;
import com.jxdinfo.hussar.identity.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.identity.organ.service.ISysStruService;
import com.jxdinfo.hussar.identity.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.identity.organ.util.OrganUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Master
public class ISysOrgServiceImpl
implements ISysOrgService {
    @Resource
    private ISysEmployeeService sysEmployeeService;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private IGlobalService globalService;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysStruRuleMapper sysStruRuleMapper;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISysOrganTypeService organTypeService;
    @Resource
    private IHussarBaseStruResourcesBoService hussarBaseStruResourcesBoService;
    @Resource
    private IHussarBaseStruFunctionsBoService hussarBaseStruFunctionsBoService;
    @Autowired
    private ISysServerStruService sysServerStruService;

    public List<JSTreeModel> getOrgTree(String isEmployee, String isExport, Long resourceId, String type, String handle, Long parentId) {
        List list1;
        String newType = type;
        Long newParentId = parentId;
        Long newResourceId = resourceId;
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            Long empolyeeId = shiroUser.getEmployeeId();
            level = this.sysEmployeeService.selectStruLevel(empolyeeId);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.ROOT_NODE_ID);
        root.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        root.setText("\u7ec4\u7ec7\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setStruLevel("0");
        root.setType("isRoot");
        if (isGradeAdmin) {
            root.getState().put("gradeDisabled", true);
        }
        if (Boolean.parseBoolean(isExport)) {
            root.setState(false, false, true);
        }
        if (this.globalService.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)newParentId)) {
            if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)newParentId)) {
                newParentId = Constants.ROOT_NODE_ID;
                result.add(root);
            }
            list1 = this.orgMaintenanceService.getOrgTree(isEmployee, newParentId);
        } else {
            result.add(root);
            list1 = this.orgMaintenanceService.getOrgTree(isEmployee);
        }
        List list = isGradeAdmin ? this.orgMaintenanceService.getGradeStruTree(list1, level) : list1;
        if (newResourceId != null && newType != null) {
            Long treeId;
            newType = newType.trim();
            List resourceIdList = this.hussarBaseStruResourcesBoService.getResourceIdList(newResourceId, newType);
            List struResourceCount = this.hussarBaseStruResourcesBoService.getStruResourceCountMap(list, resourceIdList);
            if ("delegate".equals(handle)) {
                for (JSTreeModel jsTreeModel : list) {
                    treeId = jsTreeModel.getId();
                    if (!struResourceCount.contains(treeId)) continue;
                    jsTreeModel.setState(true, true, true);
                }
            }
            if ("retrieve".equals(handle)) {
                for (JSTreeModel jsTreeModel : list) {
                    treeId = jsTreeModel.getId();
                    if (struResourceCount.contains(treeId)) {
                        jsTreeModel.setState(true, true, false);
                        continue;
                    }
                    jsTreeModel.setState(false, false, true);
                }
            }
        }
        result.addAll(list);
        return result;
    }

    public List<Long> getResourceStruId(Long resourceId, String type) {
        if (ToolUtil.isEmpty((Object)resourceId)) {
            throw new BaseException("\u8d44\u6e90id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isEmpty((Object)type)) {
            throw new BaseException("\u8d44\u6e90\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String newType = type;
        Long newResourceId = resourceId;
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            Long empolyeeId = shiroUser.getEmployeeId();
            level = this.sysEmployeeService.selectStruLevel(empolyeeId);
        }
        List list = new ArrayList();
        List baseTreeList = new ArrayList();
        List<Long> struIdResource = new ArrayList<Long>();
        baseTreeList = this.orgMaintenanceService.getOrgTree(null);
        list = isGradeAdmin ? this.orgMaintenanceService.getGradeStruTree(baseTreeList, level) : baseTreeList;
        if (newResourceId != null && newType != null) {
            newType = newType.trim();
            List resourceIdList = this.hussarBaseStruResourcesBoService.getResourceIdList(newResourceId, newType);
            struIdResource = this.hussarBaseStruResourcesBoService.getStruResourceCountMap(list, resourceIdList);
        }
        return struIdResource;
    }

    public List<Long> getFunctionStruId(Long functionId) {
        if (ToolUtil.isEmpty((Object)functionId)) {
            throw new HussarException("\u529f\u80fdid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long newFunctionId = functionId;
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            Long empolyeeId = shiroUser.getEmployeeId();
            level = this.sysEmployeeService.selectStruLevel(empolyeeId);
        }
        List list = new ArrayList();
        List baseTreeList = new ArrayList();
        List<Long> struIdFunction = new ArrayList<Long>();
        baseTreeList = this.orgMaintenanceService.getOrgTree(null);
        list = isGradeAdmin ? this.orgMaintenanceService.getGradeStruTree(baseTreeList, level) : baseTreeList;
        if (newFunctionId != null) {
            ArrayList<Long> functionIdList = new ArrayList<Long>();
            functionIdList.add(newFunctionId);
            QueryStruFuncCountDto queryStruFuncCountDto = new QueryStruFuncCountDto();
            queryStruFuncCountDto.setList(list);
            queryStruFuncCountDto.setFunctionIdList(functionIdList);
            struIdFunction = this.hussarBaseStruFunctionsBoService.getStruFunctionCountMap(queryStruFuncCountDto);
        }
        return struIdFunction;
    }

    public List<Long> getAllParentId() {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        Long struId = shiroUser.getEmployeeId();
        List<Long> idList = new ArrayList<Long>();
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin && ToolUtil.isNotEmpty((Object)struId)) {
            idList = this.getInfo(struId, idList);
            return idList;
        }
        return idList;
    }

    public List<JSTreeModel> getOrgTreeVue(OrganTreeDto organTreeDto) {
        if (ToolUtil.isEmpty((Object)organTreeDto)) {
            throw new BaseException("\u67e5\u8be2\u7ec4\u7ec7\u6811\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String newType = organTreeDto.getType() == null ? "" : organTreeDto.getType();
        Long newParentId = organTreeDto.getParentId();
        Long newResourceId = organTreeDto.getResourceId();
        String isEmployee = organTreeDto.getIsEmployee() == null ? "" : organTreeDto.getIsEmployee();
        String handle = organTreeDto.getHandle() == null ? "" : organTreeDto.getHandle();
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            Long empolyeeId = shiroUser.getEmployeeId();
            level = this.sysEmployeeService.selectStruLevel(empolyeeId);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.ROOT_NODE_ID);
        root.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        root.setText("\u7ec4\u7ec7\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setStruLevel("0");
        root.setType("isRoot");
        if (isGradeAdmin) {
            root.getState().put("gradeDisabled", true);
        }
        if (organTreeDto.isExport()) {
            root.setState(false, false, true);
        }
        List<Object> list1 = new ArrayList();
        if (this.globalService.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)newParentId)) {
            if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)newParentId)) {
                newParentId = Constants.ROOT_NODE_ID;
                result.add(root);
            }
            list1 = this.orgMaintenanceService.getOrgTree(isEmployee, newParentId);
        } else {
            result.add(root);
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysServerStru::getServerId, securityUser.getExtendUserMap("serverId"));
            List sysServerInfoList = this.sysServerStruService.list((Wrapper)queryWrapper);
            List orgList = sysServerInfoList.stream().map(SysServerStru::getStruId).collect(Collectors.toList());
            if (ToolUtil.isNotEmpty(orgList)) {
                List sysStrus = this.sysStruMapper.selectBatchIds(orgList);
                List struFidList = sysStrus.stream().map(SysStru::getStruFid).collect(Collectors.toList());
                ArrayList<String> stringList = new ArrayList<String>();
                for (String s : struFidList) {
                    stringList.add(s + "%");
                }
                list1 = this.sysStruMapper.getOrgTreeServer(isEmployee, stringList);
            }
        }
        List list = isGradeAdmin ? this.orgMaintenanceService.getGradeStruTree(list1, level) : list1;
        if (newResourceId != null && newType != null) {
            List struResourceCount;
            newType = newType.trim();
            List resourceIdList = this.hussarBaseStruResourcesBoService.getResourceIdList(newResourceId, newType);
            if ("func".equals(newType)) {
                QueryStruFuncCountDto queryStruFuncCountDto = new QueryStruFuncCountDto();
                queryStruFuncCountDto.setList(list);
                queryStruFuncCountDto.setFunctionIdList(resourceIdList);
                struResourceCount = this.hussarBaseStruFunctionsBoService.getStruFunctionCountMap(queryStruFuncCountDto);
            } else {
                struResourceCount = this.hussarBaseStruResourcesBoService.getStruResourceCountMap(list, resourceIdList);
            }
            this.delegateAndRetrieve(handle, list, struResourceCount);
        }
        result.addAll(list);
        List listOrganType = this.organTypeService.list();
        Map mapOrganType = listOrganType.stream().collect(Collectors.toMap(SysOrganType::getOrganType, Function.identity()));
        if (CollectionUtils.isNotEmpty(result)) {
            for (JSTreeModel jsTreeModel : result) {
                if (!StringUtils.isNotBlank((CharSequence)jsTreeModel.getStruType())) continue;
                SysOrganType organType = (SysOrganType)mapOrganType.get(jsTreeModel.getStruType());
                if (HussarUtils.isNotEmpty((Object)organType)) {
                    jsTreeModel.setImgUrl(organType.getImgUrl());
                    continue;
                }
                jsTreeModel.setImgUrl("tree-menu-last-d");
            }
        }
        return result;
    }

    public List<JSTreeModel> getOrgMergeTreeVue(OrganTreeDto organTreeDto) {
        return TreeModelUtils.merge(this.getOrgTreeVue(organTreeDto));
    }

    private void delegateAndRetrieve(String handle, List<JSTreeModel> list, List<Long> struResourceCount) {
        Long treeId;
        if ("delegate".equals(handle)) {
            for (JSTreeModel jsTreeModel : list) {
                treeId = jsTreeModel.getId();
                if (!struResourceCount.contains(treeId)) continue;
                jsTreeModel.setState(true, true, true);
            }
        }
        if ("retrieve".equals(handle)) {
            for (JSTreeModel jsTreeModel : list) {
                treeId = jsTreeModel.getId();
                if (struResourceCount.contains(treeId)) {
                    jsTreeModel.setState(true, true, false);
                    continue;
                }
                jsTreeModel.setState(false, false, true);
            }
        }
    }

    public List<JSTreeModel> getOrgDepTreeVue(Long struParentId) {
        List list;
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        Long currentUserId = shiroUser.getUserId();
        Long currentStruId = shiroUser.getEmployeeId();
        Long deptId = shiroUser.getDeptId();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.ROOT_NODE_ID);
        root.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        root.setText("\u7ec4\u7ec7\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setStruLevel("0");
        root.setType("isRoot");
        root.setContainsRules("1");
        if (isGradeAdmin) {
            root.getState().put("gradeDisabled", true);
            Long empolyeeId = shiroUser.getEmployeeId();
            level = this.sysEmployeeService.selectStruLevel(empolyeeId);
            SysStru sysStru = (SysStru)this.sysStruMapper.selectById(deptId);
            String userParentFid = sysStru.getStruFid();
            String paramStruFid = "";
            int paramStruLevel = 1;
            if (struParentId.equals(0L)) {
                paramStruFid = OrganUtil.getStruFidByLevel((String)userParentFid, (int)1);
                result.add(root);
            } else {
                SysStru sysStruT = (SysStru)this.sysStruMapper.selectById(struParentId);
                paramStruLevel = sysStruT.getStruLevel() + 1;
                paramStruFid = paramStruLevel >= level ? userParentFid : OrganUtil.getStruFidByLevel((String)userParentFid, (int)paramStruLevel);
            }
            list = this.orgMaintenanceService.getGradeOrgTree(paramStruLevel, paramStruFid);
            for (JSTreeModel jsTreeModel : list) {
                String type;
                Long modelId = jsTreeModel.getId();
                String struLevelStr = jsTreeModel.getStruLevel();
                int struLevelT = 0;
                if (struLevelStr != null) {
                    struLevelT = Integer.parseInt(struLevelStr);
                }
                if (struLevelT == level - 1) {
                    jsTreeModel.getState().put("changeDisabled", true);
                }
                if (struLevelT < level) {
                    if (struLevelT >= level - 1) continue;
                    jsTreeModel.getState().put("gradeDisabled", true);
                    continue;
                }
                if (struLevelT == level) {
                    if (jsTreeModel.getPrime() != null && "0".equals(jsTreeModel.getPrime())) {
                        jsTreeModel.getState().put("isOrganRoleNode", true);
                        continue;
                    }
                    Long parent = jsTreeModel.getParent();
                    if (!deptId.equals(parent)) continue;
                    type = jsTreeModel.getType();
                    if ("ORGANROLE".equals(type)) {
                        jsTreeModel.getState().put("isOrganRoleNode", true);
                        continue;
                    }
                    if ("USER".equals(type)) {
                        if (!modelId.equals(currentUserId)) continue;
                        jsTreeModel.getState().put("currentUser", true);
                        continue;
                    }
                    if (!modelId.equals(currentStruId)) continue;
                    jsTreeModel.getState().put("currentEmployee", true);
                    continue;
                }
                Long id = jsTreeModel.getId();
                type = jsTreeModel.getType();
                if ("ORGANROLE".equals(type)) {
                    id = jsTreeModel.getParent();
                    jsTreeModel.getState().put("isOrganRoleNode", true);
                }
                if (!"USER".equals(type)) continue;
                id = jsTreeModel.getEmployeeId();
            }
        } else {
            if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)struParentId)) {
                struParentId = Constants.ROOT_NODE_ID;
                result.add(root);
            }
            list = this.orgMaintenanceService.getOrgTree(null, struParentId);
        }
        this.toSetContainsRules(list);
        result.addAll(list);
        List listOrganType = this.organTypeService.list();
        Map mapOrganType = listOrganType.stream().collect(Collectors.toMap(SysOrganType::getOrganType, Function.identity()));
        if (CollectionUtils.isNotEmpty(result)) {
            for (JSTreeModel jsTreeModel : result) {
                if (!HussarUtils.isNotBlank((CharSequence)jsTreeModel.getStruType())) continue;
                jsTreeModel.setImgUrl(((SysOrganType)mapOrganType.get(jsTreeModel.getStruType())).getImgUrl());
            }
        }
        return TreeModelUtils.merge(result);
    }

    public void toSetContainsRules(List<JSTreeModel> list) {
        List<String> stringList = this.sysStruRuleMapper.getAllSysOrganType();
        for (JSTreeModel jsTreeModel : list) {
            boolean contains = stringList.contains(jsTreeModel.getStruType());
            if (contains) {
                jsTreeModel.setContainsRules("1");
                continue;
            }
            jsTreeModel.setContainsRules("0");
        }
    }

    public List<JSTreeModel> getOrgChangeTreeById(OrganTreeDto organTreeDto) {
        List<JSTreeModel> result = this.getOrgTreeVue(organTreeDto);
        for (JSTreeModel jsTreeModel : result) {
            jsTreeModel.setChildren("false");
        }
        return TreeModelUtils.merge(result);
    }

    public List<JSTreeModel> getDelegateRetrieveTree(OrganTreeDto organTreeDto) {
        boolean isGradeAdmin;
        List<JSTreeModel> list = this.getOrgTreeVue(organTreeDto);
        List<Long> idList = this.getAllParentId();
        if (ToolUtil.isNotEmpty(idList)) {
            for (JSTreeModel jsTreeModel : list) {
                Long treeId = jsTreeModel.getId();
                if (!idList.contains(treeId)) continue;
                jsTreeModel.setState(false, false, true);
            }
        }
        if (isGradeAdmin = Objects.requireNonNull(BaseSecurityUtil.getUser()).isGradeadmin()) {
            Long struId = Objects.requireNonNull(BaseSecurityUtil.getUser()).getEmployeeId();
            Long gradeParentId = this.orgMaintenanceService.getOneOrg(struId).getId();
            List childrenStruIdList = this.sysStruService.getChildOrgId(gradeParentId, "01");
            list.forEach(o -> {
                if (!childrenStruIdList.contains(o.getId())) {
                    o.getState().put("disabled", true);
                }
            });
        }
        return TreeModelUtils.merge(list);
    }

    private List<Long> getInfo(Long struId, List<Long> idList) {
        idList.add(struId);
        SysStru sysStru = (SysStru)this.sysStruMapper.selectById(struId);
        if (ToolUtil.isNotEmpty((Object)sysStru)) {
            this.getInfo(sysStru.getParentId(), idList);
        }
        return idList;
    }
}

