/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.identity.organ.service.impl;

import com.baomidou.dynamic.datasource.annotation.Master;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.identity.organ.dto.AddOutsideOrganizationDto;
import com.jxdinfo.hussar.identity.organ.dto.EditOutsideOrganizationDto;
import com.jxdinfo.hussar.identity.organ.manager.AddBatchOutsideOrganizationManager;
import com.jxdinfo.hussar.identity.organ.manager.AddOutsideOrganizationManager;
import com.jxdinfo.hussar.identity.organ.manager.DeleteBatchOutsideOrganizationManager;
import com.jxdinfo.hussar.identity.organ.manager.DeleteOutsideOrganizationManager;
import com.jxdinfo.hussar.identity.organ.manager.EditBatchOutsideOrganizationManager;
import com.jxdinfo.hussar.identity.organ.manager.EditOutsideOrganizationManager;
import com.jxdinfo.hussar.identity.organ.service.IHussarBaseSyncOrganizationService;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Master
@Service(value="com.jxdinfo.hussar.identity.organ.service.impl.hussarBaseSyncOrganizationServiceImpl")
public class HussarBaseSyncOrganizationServiceImpl
implements IHussarBaseSyncOrganizationService {
    private static final Logger logger = LoggerFactory.getLogger(HussarBaseSyncOrganizationServiceImpl.class);
    private static final String CACHE = "hussarOrganizationJob";
    @Autowired
    private AddOutsideOrganizationManager addOutsideOrganizationManager;
    @Autowired
    private AddBatchOutsideOrganizationManager addBatchOutsideOrganizationManager;
    @Autowired
    private EditOutsideOrganizationManager editOutsideOrganizationManager;
    @Autowired
    private EditBatchOutsideOrganizationManager editBatchOutsideOrganizationManager;
    @Autowired
    private DeleteOutsideOrganizationManager deleteOutsideOrganizationManager;
    @Autowired
    private DeleteBatchOutsideOrganizationManager deleteBatchOutsideOrganizationManager;

    @HussarTransactional
    public synchronized R<AddOutsideOrganizationDto> addOrganization(AddOutsideOrganizationDto addOrganizationDto) {
        R<AddOutsideOrganizationDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error("\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
                throw new BaseException("\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE);
            r = this.addOutsideOrganizationManager.addOrganization(addOrganizationDto);
        }
        catch (BaseException e) {
            throw new BaseException("\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<AddOutsideOrganizationDto> addBatchOrganizations(List<AddOutsideOrganizationDto> organs) {
        R<AddOutsideOrganizationDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error("\u6279\u91cf\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
                throw new BaseException("\u6279\u91cf\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE);
            r = this.addBatchOutsideOrganizationManager.addBatchOrganizations(organs);
        }
        catch (BaseException e) {
            throw new BaseException("\u6279\u91cf\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<EditOutsideOrganizationDto> editOrganization(EditOutsideOrganizationDto editOrganizationDto) {
        R<EditOutsideOrganizationDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error("\u4fee\u6539\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
                throw new BaseException("\u4fee\u6539\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE);
            r = this.editOutsideOrganizationManager.editOrganization(editOrganizationDto);
        }
        catch (BaseException e) {
            throw new BaseException("\u4fee\u6539\u7ec4\u7ec7\u673a\u6784\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<EditOutsideOrganizationDto> editBatchOrganizations(List<EditOutsideOrganizationDto> organs) {
        R<EditOutsideOrganizationDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error("\u6279\u91cf\u4fee\u6539\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
                throw new BaseException("\u6279\u91cf\u4fee\u6539\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE);
            r = this.editBatchOutsideOrganizationManager.editBatchOrganizations(organs);
        }
        catch (BaseException e) {
            throw new BaseException("\u6279\u91cf\u4fee\u6539\u7ec4\u7ec7\u673a\u6784\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<String> deleteOrganization(String organCode) {
        R<String> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error("\u5220\u9664\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
                throw new BaseException("\u5220\u9664\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE);
            r = this.deleteOutsideOrganizationManager.deleteOrganization(organCode);
        }
        catch (BaseException e) {
            throw new BaseException("\u5220\u9664\u7ec4\u7ec7\u673a\u6784\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<String> deleteBatchOrganizations(List<String> organCodes) {
        R<String> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error("\u6279\u91cf\u5220\u9664\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
                throw new BaseException("\u6279\u91cf\u5220\u9664\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE);
            r = this.deleteBatchOutsideOrganizationManager.deleteBatchOrganizations(organCodes);
        }
        catch (BaseException e) {
            throw new BaseException("\u6279\u91cf\u5220\u9664\u7ec4\u7ec7\u673a\u6784\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }
}

