/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.identity.organ.service.impl;

import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.identity.organ.dto.AddOrganizationDto;
import com.jxdinfo.hussar.identity.organ.dto.EditOrganizationDto;
import com.jxdinfo.hussar.identity.organ.dto.QueryOrganizationDto;
import com.jxdinfo.hussar.identity.organ.dto.QueryTransferOrganizationListDto;
import com.jxdinfo.hussar.identity.organ.dto.QueryTransferOrganizationTreeDto;
import com.jxdinfo.hussar.identity.organ.dto.TransferOrganizationDto;
import com.jxdinfo.hussar.identity.organ.manager.AddOrganizationManager;
import com.jxdinfo.hussar.identity.organ.manager.DeleteOrganizationManager;
import com.jxdinfo.hussar.identity.organ.manager.EditOrganizationManager;
import com.jxdinfo.hussar.identity.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.identity.organ.manager.SortOrganizationManager;
import com.jxdinfo.hussar.identity.organ.manager.TransferOrganizationManager;
import com.jxdinfo.hussar.identity.organ.service.IHussarBaseOrganizationService;
import com.jxdinfo.hussar.identity.organ.vo.OrganizationInfoVo;
import com.jxdinfo.hussar.identity.organ.vo.OrganizationPartialVo;
import com.jxdinfo.hussar.identity.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.identity.organ.vo.OrganizationVo;
import com.jxdinfo.hussar.identity.organ.vo.ReadOnlyOrganizationTreeVo;
import com.jxdinfo.hussar.identity.organ.vo.SearchOrganizationVo;
import com.jxdinfo.hussar.identity.organ.vo.SelectCustomOrgTreeVo;
import com.jxdinfo.hussar.identity.organ.vo.SysStruRuleVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Master
@Service(value="com.jxdinfo.hussar.identity.organ.service.impl.hussarBaseOrganizationServiceImpl")
public class HussarBaseOrganizationServiceImpl
implements IHussarBaseOrganizationService {
    @Autowired
    private AddOrganizationManager addOrganizationManager;
    @Autowired
    private EditOrganizationManager editOrganizationManager;
    @Autowired
    private DeleteOrganizationManager deleteOrganizationManager;
    @Autowired
    private SortOrganizationManager sortOrganizationManager;
    @Autowired
    private TransferOrganizationManager transferOrganizationManager;
    @Autowired
    private QueryOrganizationManager queryOrganizationManager;

    @HussarTransactional
    public ApiResponse<Long> addOrganization(AddOrganizationDto addOrganizationDto) {
        return this.addOrganizationManager.addOrganization(addOrganizationDto);
    }

    @HussarTransactional
    public ApiResponse<String> editOrganization(EditOrganizationDto editOrganizationDto) {
        return ApiResponse.success((String)this.editOrganizationManager.editOrganization(editOrganizationDto));
    }

    @HussarTransactional
    public ApiResponse<String> deleteOrganization(Long struId) {
        return ApiResponse.success((String)this.deleteOrganizationManager.deleteOrganization(struId));
    }

    @HussarTransactional
    public ApiResponse<String> sortOrganization(List<Long> idList) {
        return ApiResponse.success((String)this.sortOrganizationManager.sortOrganization(idList));
    }

    @HussarTransactional
    public ApiResponse<String> transferOrganization(TransferOrganizationDto transferOrganizationDto) {
        return ApiResponse.success((String)this.transferOrganizationManager.transferOrganization(transferOrganizationDto));
    }

    public ApiResponse<List<OrganizationTreeVo>> getTransferOrganizationTree(QueryTransferOrganizationTreeDto queryTransferOrganizationDto) {
        return ApiResponse.success(this.queryOrganizationManager.getTransferOrganizationTree(queryTransferOrganizationDto));
    }

    public ApiResponse<List<OrganizationTreeVo>> lazyLoadOrganizationTree(Long parentId) {
        return ApiResponse.success(this.queryOrganizationManager.lazyLoadOrganizationTree(parentId));
    }

    public ApiResponse<OrganizationPartialVo> viewOrganization(Long id) {
        return ApiResponse.success((Object)this.queryOrganizationManager.viewOrganization(id));
    }

    public ApiResponse<OrganizationInfoVo> loadOrganization(Long struId) {
        return ApiResponse.success((Object)this.queryOrganizationManager.loadOrganizationById(struId));
    }

    public ApiResponse<Page<SearchOrganizationVo>> searchOrganization(PageInfo pageInfo, String name) {
        return ApiResponse.success(this.queryOrganizationManager.searchOrganization(pageInfo, name));
    }

    public ApiResponse<List<OrganizationTreeVo>> backOrganizationTree(Long organId) {
        return ApiResponse.success(this.queryOrganizationManager.backOrganizationTree(organId));
    }

    public ApiResponse<Page<OrganizationVo>> queryOrganization(PageInfo pageInfo, QueryOrganizationDto queryOrganizationDto) {
        return ApiResponse.success(this.queryOrganizationManager.queryOrganization(pageInfo, queryOrganizationDto));
    }

    @HussarTransactional
    public void organizationChange(Long orgId, Long parentId, String orgType, Integer struOrder) {
        this.transferOrganizationManager.organizationChange(orgId, parentId, orgType, struOrder);
    }

    @HussarTransactional
    public synchronized void refreshOrgan() {
        this.editOrganizationManager.refreshOrgan();
    }

    public ApiResponse<List<SysStruRuleVo>> getOrganizationTypeByParentId(Long parentId) {
        return ApiResponse.success(this.queryOrganizationManager.getOrganizationTypeByParentId(parentId));
    }

    public ApiResponse<List<OrganizationTreeVo>> getOrderOrganizationTree(Long parentId) {
        return ApiResponse.success(this.queryOrganizationManager.getOrderOrganizationTree(parentId));
    }

    public ApiResponse<OrganizationTreeVo> lazyOrganizationById(Long id) {
        return ApiResponse.success((Object)this.queryOrganizationManager.lazyOrganizationById(id));
    }

    public ApiResponse<List<ReadOnlyOrganizationTreeVo>> lazyLoadingOrganizationTreeNoPermissions(Long parentId) {
        return ApiResponse.success(this.queryOrganizationManager.lazyLoadOrganizationTreeNoPermissions(parentId));
    }

    public ApiResponse<Page<OrganizationVo>> transferOrganizationList(PageInfo pageInfo, QueryTransferOrganizationListDto queryOrganizationDto) {
        return ApiResponse.success(this.queryOrganizationManager.transferOrganizationList(pageInfo, queryOrganizationDto));
    }

    public ApiResponse<String> getOrganFname(Long struId) {
        return ApiResponse.success((Object)this.queryOrganizationManager.getOrganFname(struId), (String)"\u64cd\u4f5c\u6210\u529f");
    }

    public ApiResponse<SelectCustomOrgTreeVo> getCustomOrgTree(Long dataRightId) {
        return ApiResponse.success((Object)this.queryOrganizationManager.getCustomOrgTree(dataRightId));
    }
}

