/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.identity.organ.service.impl;

import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.identity.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.identity.organ.model.SysOffice;
import com.jxdinfo.hussar.identity.organ.model.SysOrgan;
import com.jxdinfo.hussar.identity.organ.service.IHussarBaseOrgBoService;
import com.jxdinfo.hussar.identity.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.identity.organ.service.ISysOrganService;
import com.jxdinfo.hussar.identity.organ.vo.OrganizationBo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Master
@Service(value="com.jxdinfo.hussar.identity.organ.service.impl.ussarBaseOrgBoServiceImpl")
public class HussarBaseOrgBoServiceImpl
implements IHussarBaseOrgBoService {
    @Resource
    private SysOrganMapper sysOrganMapper;
    @Autowired
    private ISysOfficeService sysOfficeService;
    @Autowired
    private ISysOrganService sysOrganService;

    public List<OrganizationBo> findOrgByStruIds(List<Long> struIds) {
        if (ToolUtil.isNotEmpty(struIds)) {
            return this.sysOrganMapper.selectOrganizationBosByIds(struIds);
        }
        return new ArrayList<OrganizationBo>();
    }

    public List<Long> queryStruIds(String struFid) {
        return this.sysOrganMapper.queryStruIds(struFid);
    }

    public List<OrganizationBo> queryOrganizationInfo(String organName) {
        return this.sysOrganMapper.queryOrganizationInfo(organName);
    }

    public void saveOfficeBatch(List<SysOffice> officeList) {
        this.sysOfficeService.saveBatch(officeList);
    }

    public void updateOfficeBatchById(List<SysOffice> officeList) {
        this.sysOfficeService.updateBatchById(officeList);
    }

    public void saveOrganBatch(List<SysOrgan> organList) {
        this.sysOrganService.saveBatch(organList);
    }

    public void updateOrganBatchById(List<SysOrgan> organList) {
        this.sysOrganService.updateBatchById(organList);
    }

    public SysOrgan getOrganById(Long id) {
        return (SysOrgan)this.sysOrganService.getById((Serializable)id);
    }

    public List<SysOrgan> getOrganByCode(String code) {
        return this.sysOrganService.list((Wrapper)new LambdaQueryWrapper().likeRight(SysOrgan::getOrganCode, (Object)code));
    }
}

