/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.identity.organ.service.impl;

import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formerlycommon.util.datasource.DataSourceUtil;
import com.jxdinfo.hussar.identity.organ.dao.AssigneeEyMapper;
import com.jxdinfo.hussar.identity.organ.model.BpmTreeModel;
import com.jxdinfo.hussar.identity.organ.service.AssigneeEyService;
import com.jxdinfo.hussar.identity.organ.vo.AssigneeEyVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
@Master
public class AssigneeEyServiceImpl
implements AssigneeEyService {
    private static Logger logger = LogManager.getLogger(AssigneeEyServiceImpl.class);
    private static final Pattern REGEX = Pattern.compile("\\@\\{([^@]|[^}]\\@)*\\}\\@");
    private static final Pattern ORGAN_CONTAINS_CHILD_REGEX = Pattern.compile("O.PARENT_ID( NOT)? CONTAINSCHILD \\('([^)])*\\)");
    public static final String ORGAN = "organ";
    public static final String USER = "user";
    public static final String MASTERCODE = "000000";
    private static final String DEFAULT_PARENTID = "11";
    @Resource
    private AssigneeEyMapper assigneeEyMapper;

    public List<BpmTreeModel> userTree(String id) {
        String serverCode = BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode") == null ? "" : BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode").toString();
        Long newId = HussarUtils.isEmpty((Object)id) ? Long.parseLong(DEFAULT_PARENTID) : Long.parseLong(id);
        if (MASTERCODE.equals(serverCode)) {
            List<BpmTreeModel> result = this.assigneeEyMapper.userTree(newId, false, null, null);
            ArrayList<Long> parentIds = new ArrayList<Long>();
            for (BpmTreeModel bpmTreeModel : result) {
                if (!ORGAN.equals(bpmTreeModel.getType())) continue;
                parentIds.add(Long.valueOf(bpmTreeModel.getId()));
            }
            if (!parentIds.isEmpty()) {
                HashSet<Long> parentIdList = new HashSet<Long>(this.assigneeEyMapper.getNotLeafParentIds(this.getInListSqlCondition(parentIds), USER));
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType()) || !parentIdList.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            }
            return result;
        }
        List<Long> organId = null;
        if (HussarUtils.isNotEmpty((Object)serverCode) && DEFAULT_PARENTID.equals(newId)) {
            newId = null;
            organId = this.assigneeEyMapper.getOrgIdByServerCode(serverCode);
        }
        List<BpmTreeModel> result = this.assigneeEyMapper.userTree(newId, false, organId, null);
        ArrayList<Long> parentIds = new ArrayList<Long>();
        for (BpmTreeModel bpmTreeModel : result) {
            if (!ORGAN.equals(bpmTreeModel.getType())) continue;
            parentIds.add(Long.valueOf(bpmTreeModel.getId()));
        }
        if (!parentIds.isEmpty()) {
            HashSet<Long> hashSet = new HashSet<Long>(this.assigneeEyMapper.getNotLeafParentIds(this.getInListSqlCondition(parentIds), USER));
            for (BpmTreeModel bpmTreeModel : result) {
                if (!ORGAN.equals(bpmTreeModel.getType()) || !hashSet.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                bpmTreeModel.setIsLeaf("false");
            }
        }
        return result;
    }

    public List<BpmTreeModel> userTree(String id, boolean isMainPost, String userId, boolean isSecurity) {
        String newId;
        String serverCode = BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode") == null ? "" : BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode").toString();
        Integer securityLevel = null;
        String string = newId = HussarUtils.isEmpty((Object)id) ? DEFAULT_PARENTID : id;
        if (ToolUtil.isNotEmpty((Object)isSecurity) && isSecurity) {
            securityLevel = ToolUtil.isNotEmpty((Object)userId) ? this.assigneeEyMapper.getSecurityLevelByEryuan(Long.parseLong(userId)) : BaseSecurityUtil.getUser().getSecurityLevel();
        }
        if (MASTERCODE.equals(serverCode)) {
            List<BpmTreeModel> result = this.assigneeEyMapper.userTree(Long.parseLong(newId), isMainPost, null, securityLevel);
            ArrayList<Long> parentIds = new ArrayList<Long>();
            for (BpmTreeModel bpmTreeModel : result) {
                if (!ORGAN.equals(bpmTreeModel.getType())) continue;
                parentIds.add(Long.valueOf(bpmTreeModel.getId()));
            }
            if (!parentIds.isEmpty()) {
                HashSet<Long> parentIdList = new HashSet<Long>(this.assigneeEyMapper.getNotLeafParentIds(this.getInListSqlCondition(parentIds), isMainPost ? "userWithMainPost" : USER));
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType()) || !parentIdList.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            }
            return result;
        }
        List<Long> organId = null;
        if (HussarUtils.isNotEmpty((Object)serverCode) && DEFAULT_PARENTID.equals(newId)) {
            newId = null;
            organId = this.assigneeEyMapper.getOrgIdByServerCode(serverCode);
        }
        List<BpmTreeModel> result = this.assigneeEyMapper.userTree(newId == null ? null : Long.valueOf(Long.parseLong(newId)), isMainPost, organId, securityLevel);
        ArrayList<Long> parentIds = new ArrayList<Long>();
        for (BpmTreeModel bpmTreeModel : result) {
            if (!ORGAN.equals(bpmTreeModel.getType())) continue;
            parentIds.add(Long.valueOf(bpmTreeModel.getId()));
        }
        if (!parentIds.isEmpty()) {
            HashSet<Long> hashSet = new HashSet<Long>(this.assigneeEyMapper.getNotLeafParentIds(this.getInListSqlCondition(parentIds), isMainPost ? "userWithMainPost" : USER));
            for (BpmTreeModel bpmTreeModel : result) {
                if (!ORGAN.equals(bpmTreeModel.getType()) || !hashSet.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                bpmTreeModel.setIsLeaf("false");
            }
        }
        return result;
    }

    public List<BpmTreeModel> deptTree(String id) {
        String serverCode;
        String newId = HussarUtils.isEmpty((Object)id) ? DEFAULT_PARENTID : id;
        String string = serverCode = BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode") == null ? "" : BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode").toString();
        if (MASTERCODE.equals(serverCode)) {
            List<BpmTreeModel> result = this.assigneeEyMapper.deptTree(Long.parseLong(newId), null);
            ArrayList<Long> parentIds = new ArrayList<Long>();
            for (BpmTreeModel bpmTreeModel : result) {
                if (!ORGAN.equals(bpmTreeModel.getType())) continue;
                parentIds.add(Long.valueOf(bpmTreeModel.getId()));
            }
            if (!parentIds.isEmpty()) {
                HashSet<Long> parentIdList = new HashSet<Long>(this.assigneeEyMapper.getNotLeafParentIds(this.getInListSqlCondition(parentIds), ORGAN));
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType()) || !parentIdList.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            }
            return result;
        }
        List<Long> organId = null;
        if (HussarUtils.isNotEmpty((Object)serverCode) && DEFAULT_PARENTID.equals(newId)) {
            newId = null;
            organId = this.assigneeEyMapper.getOrgIdByServerCode(serverCode);
        }
        List<BpmTreeModel> result = this.assigneeEyMapper.deptTree(newId == null ? null : Long.valueOf(Long.parseLong(newId)), organId);
        ArrayList<Long> parentIds = new ArrayList<Long>();
        for (BpmTreeModel bpmTreeModel : result) {
            if (!ORGAN.equals(bpmTreeModel.getType())) continue;
            parentIds.add(Long.valueOf(bpmTreeModel.getId()));
        }
        if (!parentIds.isEmpty()) {
            HashSet<Long> hashSet = new HashSet<Long>(this.assigneeEyMapper.getNotLeafParentIds(this.getInListSqlCondition(parentIds), ORGAN));
            for (BpmTreeModel bpmTreeModel : result) {
                if (!ORGAN.equals(bpmTreeModel.getType()) || !hashSet.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                bpmTreeModel.setIsLeaf("false");
            }
        }
        return result;
    }

    public List<BpmTreeModel> userDetail(List<String> userIds) {
        List<Long> longUserIds = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty(userIds)) {
            longUserIds = userIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        }
        return this.assigneeEyMapper.userDetail(this.getInListSqlCondition(longUserIds));
    }

    public List<BpmTreeModel> userDeptDetail(String userId) {
        List<BpmTreeModel> result = this.assigneeEyMapper.userDeptDetail(Long.parseLong(userId));
        for (BpmTreeModel bpmTreeModel : result) {
            if (!DEFAULT_PARENTID.equals(bpmTreeModel.getParentId())) continue;
            bpmTreeModel.setParentId(null);
        }
        return result;
    }

    public String getRealCondition(String realCondition) {
        if (realCondition.contains("CONTAINSCHILD")) {
            List<AssigneeEyVo> allOrgans = this.assigneeEyMapper.getAllOrgans();
            HashMap<String, ArrayList<String>> maps = new HashMap<String, ArrayList<String>>();
            for (AssigneeEyVo assignee : allOrgans) {
                String organId = assignee.getUserId();
                String parentId = assignee.getParentId();
                ArrayList<String> list = (ArrayList<String>)maps.get(parentId);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(organId);
                maps.put(parentId, list);
            }
            Matcher organMatcher = ORGAN_CONTAINS_CHILD_REGEX.matcher(realCondition);
            while (organMatcher.find()) {
                int i;
                String organCondition = organMatcher.group();
                String[] organConditions = organCondition.split("'");
                ArrayList<String> organIds = new ArrayList<String>();
                for (i = 1; i < organConditions.length; i += 2) {
                    organIds.add(organConditions[i]);
                }
                for (i = 0; i < organIds.size(); ++i) {
                    List addOrgans = (List)maps.get(organIds.get(i));
                    if (addOrgans == null) continue;
                    organIds.addAll(addOrgans);
                }
                organIds = new ArrayList(new HashSet(organIds));
                StringBuilder stringBuilder = new StringBuilder();
                boolean isConditionNotIn = organCondition.contains("NOT CONTAINSCHILD");
                if (isConditionNotIn) {
                    stringBuilder.append("O.PARENT_ID NOT IN (");
                } else {
                    stringBuilder.append("O.PARENT_ID IN (");
                }
                for (String s : organIds) {
                    stringBuilder.append("'").append(s).append("',");
                }
                stringBuilder.append("'')");
                String replactCondition = stringBuilder.toString();
                while (replactCondition.contains(",''")) {
                    replactCondition = replactCondition.replace(",''", "");
                }
                while (replactCondition.contains("'',")) {
                    replactCondition = replactCondition.replace("'',", "");
                }
                if (replactCondition.contains("('')")) {
                    replactCondition = isConditionNotIn ? "1=1" : "1!=1";
                }
                realCondition = realCondition.replace(organCondition, replactCondition);
            }
        }
        return realCondition;
    }

    public Integer getSecurityLevel(String userId) {
        return this.assigneeEyMapper.getSecurityLevel(HussarUtils.isNotEmpty((Object)userId) ? Long.valueOf(Long.parseLong(userId)) : null);
    }

    public String getSameLevelDeptIdByUserId(String userId) {
        if (HussarUtils.isNotEmpty((Object)userId)) {
            List<String> deptId = this.assigneeEyMapper.getSameLevelDeptIdByUserId(Long.parseLong(userId));
            return String.join((CharSequence)",", deptId);
        }
        return "";
    }

    public String getParentDeptIdByUserId(String userId) {
        if (HussarUtils.isNotEmpty((Object)userId)) {
            List<String> deptId = this.assigneeEyMapper.getParentDeptIdByUserId(Long.parseLong(userId));
            return String.join((CharSequence)",", deptId);
        }
        return "";
    }

    public String getDeptIdByUserIds(String userId) {
        if (HussarUtils.isNotEmpty((Object)userId)) {
            List<Long> longUserIds = new ArrayList<String>(Arrays.asList(userId.split(","))).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            List<String> deptId = this.assigneeEyMapper.getDeptIdByUserIds(this.getInListSqlCondition(longUserIds));
            return String.join((CharSequence)",", new HashSet<String>(deptId));
        }
        return "";
    }

    public String getSameLevelDeptIdByUserIds(String userId) {
        if (HussarUtils.isNotEmpty((Object)userId)) {
            List<Long> longUserIds = new ArrayList<String>(Arrays.asList(userId.split(","))).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            List<String> deptId = this.assigneeEyMapper.getSameLevelDeptIdByUserIds(this.getInListSqlCondition(longUserIds));
            return String.join((CharSequence)",", new HashSet<String>(deptId));
        }
        return "";
    }

    public String getParentDeptIdByUserIds(String userId) {
        if (HussarUtils.isNotEmpty((Object)userId)) {
            List<Long> longUserIds = new ArrayList<String>(Arrays.asList(userId.split(","))).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            List<String> deptId = this.assigneeEyMapper.getParentDeptIdByUserIds(this.getInListSqlCondition(longUserIds));
            return String.join((CharSequence)",", new HashSet<String>(deptId));
        }
        return "";
    }

    public List<String> getCandidateUser(String condition, Integer securityLevel, boolean isConditionFullSql) {
        if (isConditionFullSql) {
            condition = condition.replace("''", "'0'");
            return this.assigneeEyMapper.getCandidateUser(condition, null);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT O.ORGAN_ID AS userId ").append(" FROM HUSSAR_BPM_ORGAN_VIEW O ").append(" LEFT JOIN V_USER_INFO U ON O.ORGAN_ID = U.USER_ID").append("  WHERE O.ORGAN_TYPE = 'user' AND U.ACCOUNT_STATUS  <> '2' ");
        sb.append(this.getRealCondition(condition));
        String sql = sb.toString().replace("''", "'0'");
        DataSourceUtil.changeTempDs((String)"master");
        List<String> result = this.assigneeEyMapper.getCandidateUser(sql, securityLevel);
        DataSourceUtil.poll();
        return result;
    }

    public List<BpmTreeModel> queryDeptTreeByDeptName(String organName) {
        String serverCode;
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        String string = serverCode = BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode") == null ? "" : BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode").toString();
        if (MASTERCODE.equals(serverCode)) {
            List<BpmTreeModel> result = this.assigneeEyMapper.queryDeptTreeByDeptName(organName);
            ArrayList<Long> parentIds = new ArrayList<Long>();
            for (BpmTreeModel bpmTreeModel : result) {
                if (!ORGAN.equals(bpmTreeModel.getType())) continue;
                parentIds.add(Long.valueOf(bpmTreeModel.getId()));
            }
            if (!parentIds.isEmpty()) {
                HashSet<Long> parentIdList = new HashSet<Long>(this.assigneeEyMapper.getNotLeafParentIds(this.getInListSqlCondition(parentIds), ORGAN));
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType()) || !parentIdList.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            }
            return this.queryAllTreeByChildrenNode(result, 0);
        }
        ArrayList<BpmTreeModel> result = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)serverCode)) {
            List<String> organCodeId = this.assigneeEyMapper.getOrgCodeIdByServerCode(serverCode);
            result = this.assigneeEyMapper.queryServerDeptTreeByDeptName(organName, organCodeId);
        }
        ArrayList<Long> parentIds = new ArrayList<Long>();
        for (BpmTreeModel bpmTreeModel : result) {
            if (!ORGAN.equals(bpmTreeModel.getType())) continue;
            parentIds.add(Long.valueOf(bpmTreeModel.getId()));
        }
        if (!parentIds.isEmpty()) {
            HashSet<Long> hashSet = new HashSet<Long>(this.assigneeEyMapper.getNotLeafParentIds(this.getInListSqlCondition(parentIds), ORGAN));
            for (BpmTreeModel bpmTreeModel : result) {
                if (!ORGAN.equals(bpmTreeModel.getType()) || !hashSet.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                bpmTreeModel.setIsLeaf("false");
            }
        }
        return this.queryAllTreeByChildrenNode(result, 0);
    }

    public List<BpmTreeModel> queryUserTreeByUserName(String organName) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String serverCode = BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode") == null ? "" : BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode").toString();
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        if (MASTERCODE.equals(serverCode)) {
            List<BpmTreeModel> childrenNode = this.assigneeEyMapper.queryUserTreeByUserName(organName);
            return this.queryAllTreeByChildrenNode(childrenNode, 0);
        }
        if (HussarUtils.isNotEmpty((Object)serverCode)) {
            List<String> organCodeId = this.assigneeEyMapper.getOrgCodeIdByServerCode(serverCode);
            List<BpmTreeModel> childrenNode = this.assigneeEyMapper.queryServerUserTreeByUserName(organName, organCodeId);
            return this.queryAllTreeByChildrenNode(childrenNode, 0);
        }
        return new ArrayList<BpmTreeModel>();
    }

    public List<BpmTreeModel> queryUserListByUserName(String organName) {
        String serverCode;
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        String string = serverCode = BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode") == null ? "" : BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode").toString();
        if (MASTERCODE.equals(serverCode)) {
            return this.assigneeEyMapper.queryUserTreeByUserName(organName);
        }
        if (HussarUtils.isNotEmpty((Object)serverCode)) {
            List<String> organCodeId = this.assigneeEyMapper.getOrgCodeIdByServerCode(serverCode);
            return this.assigneeEyMapper.queryServerUserTreeByUserName(organName, organCodeId);
        }
        return new ArrayList<BpmTreeModel>();
    }

    public List<BpmTreeModel> queryUserTree(String organName) {
        String serverCode;
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        String string = serverCode = BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode") == null ? "" : BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode").toString();
        if (MASTERCODE.equals(serverCode)) {
            return this.assigneeEyMapper.queryUserTree(organName);
        }
        if (HussarUtils.isNotEmpty((Object)serverCode)) {
            List<String> organCodeId = this.assigneeEyMapper.getOrgCodeIdByServerCode(serverCode);
            return this.assigneeEyMapper.queryServerUserTree(organName, organCodeId);
        }
        return new ArrayList<BpmTreeModel>();
    }

    public Page<BpmTreeModel> getUserListByParentId(Page<BpmTreeModel> pages, String organId) {
        return pages.setRecords(this.assigneeEyMapper.getUserListByParentId(pages, HussarUtils.isNotEmpty((Object)organId) ? Long.valueOf(Long.parseLong(organId)) : null));
    }

    public Page<BpmTreeModel> getUserListByUserId(Page<BpmTreeModel> pages, String organId) {
        return pages.setRecords(this.assigneeEyMapper.getUserListByUserId(pages, HussarUtils.isNotEmpty((Object)organId) ? Long.valueOf(Long.parseLong(organId)) : null));
    }

    public List<BpmTreeModel> queryAssigneeAndDept(List<String> users, String organName) {
        if (HussarUtils.isEmpty(users) || HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        List<Long> longUserIds = users.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        return this.assigneeEyMapper.queryAssigneeAndDept(this.getInListSqlCondition(longUserIds), organName);
    }

    public Page<BpmTreeModel> getNodeAssigneeListByParentId(Page<BpmTreeModel> pages, String organId, List<String> users) {
        List<Object> list = this.assigneeEyMapper.getUserListByParentId(null, organId == null ? null : Long.valueOf(Long.parseLong(organId)));
        list = list.stream().filter(item -> users.contains(item.getId())).collect(Collectors.toList());
        pages.setTotal((long)list.size());
        int start = (int)((pages.getCurrent() - 1L) * pages.getSize());
        int end = (int)Math.min((long)list.size(), pages.getCurrent() * pages.getSize());
        return pages.setRecords(list.subList(start, end));
    }

    public Page<BpmTreeModel> getNodeAssigneeListByUserId(Page<BpmTreeModel> pages, String organId) {
        return pages.setRecords(this.assigneeEyMapper.getNodeAssigneeListByUserId(pages, HussarUtils.isNotEmpty((Object)organId) ? Long.valueOf(Long.parseLong(organId)) : null));
    }

    private List<BpmTreeModel> queryAllTreeByChildrenNode(List<BpmTreeModel> childrenNode, Integer type) {
        ArrayList<BpmTreeModel> result = new ArrayList<BpmTreeModel>();
        List<BpmTreeModel> allDept = this.assigneeEyMapper.getAllDept();
        HashMap<String, BpmTreeModel> deptMap = new HashMap<String, BpmTreeModel>();
        for (BpmTreeModel dept : allDept) {
            deptMap.put(dept.getId(), dept);
        }
        block1: for (BpmTreeModel bpmTreeModel : childrenNode) {
            BpmTreeModel children = bpmTreeModel;
            if (deptMap.containsKey(children.getId())) {
                children = (BpmTreeModel)deptMap.get(children.getId());
            }
            while (true) {
                if (!deptMap.containsKey(children.getParentId())) {
                    int i;
                    for (BpmTreeModel rootNode : result) {
                        if (!rootNode.getId().equals(children.getId())) continue;
                        continue block1;
                    }
                    if (ORGAN.equals(children.getType())) {
                        for (i = 0; i < result.size(); ++i) {
                            if (USER.equals(((BpmTreeModel)result.get(i)).getType())) {
                                result.add(i, children);
                                continue block1;
                            }
                            if (Integer.parseInt(((BpmTreeModel)result.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            result.add(i, children);
                            continue block1;
                        }
                    } else {
                        for (i = 0; i < result.size(); ++i) {
                            if (!USER.equals(((BpmTreeModel)result.get(i)).getType()) || Integer.parseInt(((BpmTreeModel)result.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            result.add(i, children);
                            continue block1;
                        }
                    }
                    result.add(children);
                    continue block1;
                }
                BpmTreeModel parent = (BpmTreeModel)deptMap.get(children.getParentId());
                ArrayList<BpmTreeModel> childrenList = parent.getChildrenList();
                if (!HussarUtils.isEmpty((Object)childrenList)) {
                    int i;
                    for (BpmTreeModel parentChildrenList : childrenList) {
                        if (!parentChildrenList.getId().equals(children.getId())) continue;
                        continue block1;
                    }
                    if (ORGAN.equals(children.getType())) {
                        for (i = 0; i < childrenList.size(); ++i) {
                            if (USER.equals(((BpmTreeModel)childrenList.get(i)).getType())) {
                                childrenList.add(i, children);
                                continue block1;
                            }
                            if (Integer.parseInt(((BpmTreeModel)childrenList.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            childrenList.add(i, children);
                            continue block1;
                        }
                    } else {
                        for (i = 0; i < childrenList.size(); ++i) {
                            if (!USER.equals(((BpmTreeModel)childrenList.get(i)).getType()) || Integer.parseInt(((BpmTreeModel)childrenList.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            childrenList.add(i, children);
                            continue block1;
                        }
                    }
                    childrenList.add(children);
                    continue block1;
                }
                childrenList = new ArrayList<BpmTreeModel>();
                childrenList.add(children);
                parent.setChildrenList(childrenList);
                children = parent;
            }
        }
        return result;
    }

    private List<List<Long>> getInListSqlCondition(List<Long> longList) {
        ArrayList<List<Long>> result = new ArrayList<List<Long>>();
        int size = longList.size();
        for (int i = 0; i < size; i += 1000) {
            List<Long> list = longList.subList(i, Math.min(i + 1000, size));
            result.add(list);
        }
        return result;
    }
}

