/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.identity.organ.service.impl;

import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formerlycommon.util.datasource.DataSourceUtil;
import com.jxdinfo.hussar.identity.common.properties.BpmConstantEyProperties;
import com.jxdinfo.hussar.identity.common.properties.LcdpBpmEyProperties;
import com.jxdinfo.hussar.identity.exception.PublicClientException;
import com.jxdinfo.hussar.identity.organ.dao.AssigneeChooseEyMapper;
import com.jxdinfo.hussar.identity.organ.dao.AssigneeEyMapper;
import com.jxdinfo.hussar.identity.organ.dto.AssigneeChooseDto;
import com.jxdinfo.hussar.identity.organ.dto.IdentityDto;
import com.jxdinfo.hussar.identity.organ.dto.NodeAssigneeQueryDto;
import com.jxdinfo.hussar.identity.organ.model.BpmTreeModel;
import com.jxdinfo.hussar.identity.organ.model.BpmUserMsg;
import com.jxdinfo.hussar.identity.organ.service.AssigneeEyService;
import com.jxdinfo.hussar.identity.organ.service.IAssigneeChooseEyService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@Master
public class AssigneeChooseEyServiceImpl
implements IAssigneeChooseEyService {
    @Autowired
    private LcdpBpmEyProperties lcdpBpmProperties;
    @Resource
    AssigneeChooseEyMapper assigneeChooseEyMapper;
    @Autowired
    private BpmConstantEyProperties bpmConstantProperties;
    @Resource
    private AssigneeEyMapper assigneeEyMapper;
    @Resource
    private AssigneeEyService assigneeEyService;
    private static final String DEFAULT_PARENTID = "11";
    private static final String DEFAULT_ORGAN_PARENTID = "1";
    public static final String ORGAN = "organ";
    public static final String USER = "user";
    public static final String MASTERCODE = "000000";

    public List<BpmTreeModel> userTree(String id, boolean isMainPost, String userId, boolean isSecurity) {
        String serverCode = BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode") == null ? "" : BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode").toString();
        String newId = StringUtils.isEmpty((Object)id) ? DEFAULT_PARENTID : id;
        Integer securityLevel = null;
        if (ToolUtil.isNotEmpty((Object)isSecurity) && isSecurity) {
            securityLevel = ToolUtil.isNotEmpty((Object)userId) ? this.assigneeChooseEyMapper.getSecurityLevelByEryuan(Long.parseLong(userId)) : BaseSecurityUtil.getUser().getSecurityLevel();
        }
        List<Long> organId = null;
        try {
            if (MASTERCODE.equals(serverCode)) {
                List<BpmTreeModel> result = this.assigneeChooseEyMapper.userTree(Long.parseLong(newId), isMainPost, null, securityLevel);
                ArrayList<Long> parentIds = new ArrayList<Long>();
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType())) continue;
                    parentIds.add(Long.valueOf(bpmTreeModel.getId()));
                }
                if (!parentIds.isEmpty()) {
                    HashSet<Long> parentIdList = new HashSet<Long>(this.assigneeChooseEyMapper.getNotLeafParentIds(this.getInListSqlCondition(parentIds), isMainPost ? "userWithMainPost" : USER));
                    for (BpmTreeModel bpmTreeModel : result) {
                        if (!ORGAN.equals(bpmTreeModel.getType()) || !parentIdList.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                        bpmTreeModel.setIsLeaf("false");
                    }
                }
                return result;
            }
            if (HussarUtils.isNotEmpty((Object)serverCode) && DEFAULT_PARENTID.equals(newId)) {
                newId = null;
                organId = this.assigneeChooseEyMapper.getOrgIdByServerCode(serverCode);
            }
            List<BpmTreeModel> result = this.assigneeChooseEyMapper.userTree(newId == null ? null : Long.valueOf(Long.parseLong(newId)), isMainPost, organId, securityLevel);
            ArrayList<Long> parentIds = new ArrayList<Long>();
            for (BpmTreeModel bpmTreeModel : result) {
                if (!ORGAN.equals(bpmTreeModel.getType())) continue;
                parentIds.add(Long.valueOf(bpmTreeModel.getId()));
            }
            if (!parentIds.isEmpty()) {
                HashSet<Long> parentIdList = new HashSet<Long>(this.assigneeChooseEyMapper.getNotLeafParentIds(this.getInListSqlCondition(parentIds), isMainPost ? "userWithMainPost" : USER));
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType()) || !parentIdList.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
        }
    }

    public List<BpmTreeModel> deptTree(String id, boolean isInterface) {
        String newId = StringUtils.isEmpty((Object)id) ? DEFAULT_PARENTID : id;
        String serverCode = BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode") == null ? "" : BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode").toString();
        try {
            if (MASTERCODE.equals(serverCode)) {
                List<BpmTreeModel> result = this.assigneeChooseEyMapper.deptTree(Long.parseLong(newId), null);
                ArrayList<Long> parentIds = new ArrayList<Long>();
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType())) continue;
                    parentIds.add(Long.valueOf(bpmTreeModel.getId()));
                }
                if (!parentIds.isEmpty()) {
                    HashSet<Long> parentIdList = new HashSet<Long>(this.assigneeChooseEyMapper.getNotLeafParentIds(this.getInListSqlCondition(parentIds), ORGAN));
                    for (BpmTreeModel bpmTreeModel : result) {
                        if (!ORGAN.equals(bpmTreeModel.getType()) || !parentIdList.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                        bpmTreeModel.setIsLeaf("false");
                    }
                }
                return result;
            }
            List<Long> organId = null;
            if (HussarUtils.isNotEmpty((Object)serverCode) && DEFAULT_PARENTID.equals(newId)) {
                newId = null;
                organId = this.assigneeChooseEyMapper.getOrgIdByServerCode(serverCode);
            }
            List<BpmTreeModel> result = this.assigneeChooseEyMapper.deptTree(newId == null ? null : Long.valueOf(Long.parseLong(newId)), organId);
            ArrayList<Long> parentIds = new ArrayList<Long>();
            for (BpmTreeModel bpmTreeModel : result) {
                if (!ORGAN.equals(bpmTreeModel.getType())) continue;
                parentIds.add(Long.valueOf(bpmTreeModel.getId()));
            }
            if (!parentIds.isEmpty()) {
                HashSet<Long> hashSet = new HashSet<Long>(this.assigneeChooseEyMapper.getNotLeafParentIds(this.getInListSqlCondition(parentIds), ORGAN));
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType()) || !hashSet.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
        }
    }

    public List<BpmTreeModel> userDetail(List<String> userIds, boolean isInterface) {
        if ((userIds = new ArrayList<String>(new HashSet<String>(userIds))) != null) {
            ArrayList<String> removeList = new ArrayList<String>();
            removeList.add(null);
            removeList.add("null");
            userIds.removeAll(removeList);
        }
        if (HussarUtils.isEmpty(userIds)) {
            return new ArrayList<BpmTreeModel>();
        }
        ArrayList<Long> userIdL = new ArrayList<Long>();
        for (String str : userIds) {
            if (!ToolUtil.isNotEmpty((Object)str)) continue;
            userIdL.add(Long.parseLong(str));
        }
        try {
            return this.assigneeChooseEyMapper.userDetail(this.getInListSqlCondition(userIdL));
        }
        catch (Exception e) {
            throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
        }
    }

    public String getUserNames(List<String> userIds) {
        StringBuilder result = new StringBuilder();
        List<BpmTreeModel> list = this.userDetail(userIds, false);
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                result.append(bpmTreeModel.getLabel()).append(",");
            }
            result = new StringBuilder(result.substring(0, result.length() - 1));
        }
        return result.toString();
    }

    public List<String> getEntrustUserNames(List<IdentityDto> userIds) {
        ArrayList<String> users = new ArrayList<String>();
        for (int i = 0; i < userIds.size(); ++i) {
            if (DEFAULT_ORGAN_PARENTID.equals(userIds.get(i).getTaskState()) || "2".equals(userIds.get(i).getTaskState())) {
                users.add(userIds.get(i).getUserId());
                users.add(userIds.get(i).getMandator());
                continue;
            }
            users.add(userIds.get(i).getUserId());
        }
        Map<String, String> map = this.getUserListByUserId(users);
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < userIds.size(); ++i) {
            if (DEFAULT_ORGAN_PARENTID.equals(userIds.get(i).getTaskState()) || "2".equals(userIds.get(i).getTaskState())) {
                result.add(map.get(userIds.get(i).getUserId()) + "(" + map.get(userIds.get(i).getMandator()) + ")");
                continue;
            }
            result.add(map.get(userIds.get(i).getUserId()));
        }
        return result;
    }

    public List<Map<String, String>> getUserListByUserIdWithSelect(List<String> userList) {
        List<BpmTreeModel> list = this.userDetail(userList, true);
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                HashMap<String, String> mapSelect = new HashMap<String, String>(2);
                mapSelect.put("id", bpmTreeModel.getId());
                mapSelect.put("name", bpmTreeModel.getLabel());
                resultList.add(mapSelect);
            }
        }
        return resultList;
    }

    public Map<String, String> getUserListByUserId(List<String> userIds) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<BpmTreeModel> list = this.userDetail(userIds, false);
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                map.put(bpmTreeModel.getId(), bpmTreeModel.getLabel());
            }
        }
        return map;
    }

    public List<String> getCandidateUser(String condition, Integer securityLevel, boolean isConditionFullSql) {
        if (isConditionFullSql) {
            condition = condition.replace("''", "'0'");
            return this.assigneeEyMapper.getCandidateUser(condition, null);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT O.ORGAN_ID AS userId ").append(" FROM HUSSAR_BPM_ORGAN_VIEW O ").append("  LEFT JOIN HUSSAR_BPM_USER_ROLE_VIEW R ON R.USER_ID = O.ORGAN_ID ").append("  WHERE O.ORGAN_TYPE = 'user'  ");
        sb.append(this.assigneeEyService.getRealCondition(condition));
        String sql = sb.toString().replace("''", "'0'");
        DataSourceUtil.changeTempDs((String)"master");
        List<String> result = this.assigneeEyMapper.getCandidateUser(sql, securityLevel);
        DataSourceUtil.poll();
        return result;
    }

    public Map<String, Object> getSystemInfo(String systemId) {
        DataSourceUtil.changeTempDs((String)"master");
        Map<String, Object> result = this.assigneeEyMapper.getSystemInfo(systemId);
        DataSourceUtil.poll();
        return result;
    }

    public Map<String, String> getUserIdCardListByUserId(List<String> userIds) {
        if ((userIds = new ArrayList<String>(new HashSet<String>(userIds))) != null) {
            ArrayList<String> removeList = new ArrayList<String>();
            removeList.add(null);
            removeList.add("null");
            userIds.removeAll(removeList);
        }
        if (HussarUtils.isEmpty(userIds)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        List<Map<String, Object>> list = this.assigneeEyMapper.getUserIdCardListByUserId(userIds);
        if (list != null && !list.isEmpty()) {
            for (Map<String, Object> bo : list) {
                map.put(bo.get("ID").toString(), bo.get("IDCARD") == null ? "" : bo.get("IDCARD").toString());
            }
        }
        return map;
    }

    public Integer getSecurityLevel(String userId, String url) {
        return this.assigneeChooseEyMapper.getSecurityLevel(HussarUtils.isNotEmpty((Object)userId) ? Long.valueOf(Long.parseLong(userId)) : null);
    }

    public String getSameLevelDeptIdByUserId(String userId) {
        if (HussarUtils.isNotEmpty((Object)userId)) {
            List<String> deptId = this.assigneeChooseEyMapper.getSameLevelDeptIdByUserId(Long.parseLong(userId));
            return String.join((CharSequence)",", deptId);
        }
        return "";
    }

    public String getParentDeptIdByUserId(String userId) {
        if (HussarUtils.isNotEmpty((Object)userId)) {
            String serverCode;
            String string = serverCode = BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode") == null ? "" : BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode").toString();
            if (MASTERCODE.equals(serverCode)) {
                List<String> deptId = this.assigneeChooseEyMapper.getParentDeptIdByUserId(Long.parseLong(userId));
                return String.join((CharSequence)",", deptId);
            }
            if (HussarUtils.isNotEmpty((Object)serverCode)) {
                List<String> organCodeId = this.assigneeChooseEyMapper.getOrgCodeIdByServerCode(serverCode);
                List<String> deptId = this.assigneeChooseEyMapper.getServerParentDeptIdByUserId(Long.parseLong(userId), organCodeId);
                return String.join((CharSequence)",", deptId);
            }
            return "";
        }
        return "";
    }

    public String getDeptIdByUserIds(String userId) {
        if (HussarUtils.isNotEmpty((Object)userId)) {
            ArrayList<String> users = new ArrayList<String>(Arrays.asList(userId.split(",")));
            List<Long> longUserIds = users.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            List<String> deptId = this.assigneeChooseEyMapper.getDeptIdByUserIds(this.getInListSqlCondition(longUserIds));
            return String.join((CharSequence)",", new HashSet<String>(deptId));
        }
        return "";
    }

    public String getSameLevelDeptIdByUserIds(String userId) {
        if (HussarUtils.isNotEmpty((Object)userId)) {
            ArrayList<String> users = new ArrayList<String>(Arrays.asList(userId.split(",")));
            List<Long> longUserIds = users.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            List<String> deptId = this.assigneeChooseEyMapper.getSameLevelDeptIdByUserIds(this.getInListSqlCondition(longUserIds));
            return String.join((CharSequence)",", new HashSet<String>(deptId));
        }
        return "";
    }

    public String getParentDeptIdByUserIds(String userId) {
        if (HussarUtils.isNotEmpty((Object)userId)) {
            String serverCode;
            String string = serverCode = BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode") == null ? "" : BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode").toString();
            if (MASTERCODE.equals(serverCode)) {
                ArrayList<String> users = new ArrayList<String>(Arrays.asList(userId.split(",")));
                List<Long> longUserIds = users.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                List<String> deptId = this.assigneeChooseEyMapper.getParentDeptIdByUserIds(this.getInListSqlCondition(longUserIds));
                return String.join((CharSequence)",", new HashSet<String>(deptId));
            }
            if (HussarUtils.isNotEmpty((Object)serverCode)) {
                List<String> organCodeId = this.assigneeChooseEyMapper.getOrgCodeIdByServerCode(serverCode);
                ArrayList<String> users = new ArrayList<String>(Arrays.asList(userId.split(",")));
                List<Long> longUserIds = users.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                List<String> deptId = this.assigneeChooseEyMapper.getServerParentDeptIdByUserIds(this.getInListSqlCondition(longUserIds), organCodeId);
                return String.join((CharSequence)",", new HashSet<String>(deptId));
            }
            return "";
        }
        return "";
    }

    public String getStarterDept(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return null;
        }
        List<BpmTreeModel> list = this.userDeptDetail(userId, true);
        StringBuilder stringBuilder = new StringBuilder();
        for (BpmTreeModel bpmTreeModel : list) {
            if (bpmTreeModel.getParentId() == null) continue;
            stringBuilder.append(",").append(bpmTreeModel.getParentId());
        }
        String result = stringBuilder.toString();
        if (result.length() > 0) {
            result = result.substring(1);
        }
        return result;
    }

    public List<BpmTreeModel> queryUserTree(String organName) {
        String serverCode;
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        String string = serverCode = BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode") == null ? "" : BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode").toString();
        if (MASTERCODE.equals(serverCode)) {
            return this.assigneeChooseEyMapper.queryUserTree(organName);
        }
        if (HussarUtils.isNotEmpty((Object)serverCode)) {
            List<String> organCodeId = this.assigneeChooseEyMapper.getOrgCodeIdByServerCode(serverCode);
            return this.assigneeChooseEyMapper.queryServerUserTree(organName, organCodeId);
        }
        return new ArrayList<BpmTreeModel>();
    }

    public List<BpmTreeModel> queryUserTreeByUserName(String organName) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String serverCode = BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode") == null ? "" : BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode").toString();
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        if (MASTERCODE.equals(serverCode)) {
            List<BpmTreeModel> childrenNode = this.assigneeChooseEyMapper.queryUserTreeByUserName(organName);
            return this.queryAllTreeByChildrenNode(childrenNode, 0);
        }
        if (HussarUtils.isNotEmpty((Object)serverCode)) {
            List<String> organCodeId = this.assigneeChooseEyMapper.getOrgCodeIdByServerCode(serverCode);
            List<BpmTreeModel> childrenNode = this.assigneeChooseEyMapper.queryServerUserTreeByUserName(organName, organCodeId);
            return this.queryAllTreeByChildrenNode(childrenNode, 0);
        }
        return new ArrayList<BpmTreeModel>();
    }

    public Page<BpmTreeModel> queryUserListByPage(Page<BpmTreeModel> pages, BpmTreeModel bpmTreeModel) {
        ArrayList<String> organCodeId = new ArrayList();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        if (HussarUtils.isNotEmpty((Object)securityUser)) {
            organCodeId = this.assigneeChooseEyMapper.getOrgCodeIdByServerCode(securityUser.getExtendUserMap("serverCode").toString());
        }
        if (HussarUtils.isEmpty((Object)bpmTreeModel.getId()) || HussarUtils.isEmpty((Object)bpmTreeModel.getType())) {
            return pages.setRecords(this.assigneeChooseEyMapper.getUserListByParentId(pages, null, organCodeId));
        }
        if (ORGAN.equals(bpmTreeModel.getType())) {
            return pages.setRecords(this.assigneeChooseEyMapper.getUserListByParentId(pages, Long.parseLong(bpmTreeModel.getId()), organCodeId));
        }
        if (USER.equals(bpmTreeModel.getType())) {
            return pages.setRecords(this.assigneeChooseEyMapper.getUserListByUserId(pages, Long.parseLong(bpmTreeModel.getId()), organCodeId));
        }
        return pages.setRecords(new ArrayList());
    }

    public List<BpmTreeModel> queryDeptTreeByChildren(BpmTreeModel bpmTreeModel) {
        if (HussarUtils.isEmpty((Object)bpmTreeModel.getId()) || HussarUtils.isEmpty((Object)bpmTreeModel.getParentId())) {
            return new ArrayList<BpmTreeModel>();
        }
        List<BpmTreeModel> allDept = this.assigneeChooseEyMapper.getAllDept();
        HashMap<String, BpmTreeModel> deptmap = new HashMap<String, BpmTreeModel>();
        for (BpmTreeModel dept : allDept) {
            deptmap.put(dept.getId(), dept);
        }
        if (USER.equals(bpmTreeModel.getType())) {
            if (HussarUtils.isEmpty((Object)(bpmTreeModel = (BpmTreeModel)deptmap.get(bpmTreeModel.getParentId())))) {
                return new ArrayList<BpmTreeModel>();
            }
        } else if (ORGAN.equals(bpmTreeModel.getType())) {
            bpmTreeModel = (BpmTreeModel)deptmap.get(bpmTreeModel.getId());
        }
        while (deptmap.containsKey(bpmTreeModel.getParentId())) {
            ArrayList<BpmTreeModel> children = new ArrayList<BpmTreeModel>();
            children.add(bpmTreeModel);
            bpmTreeModel = ((BpmTreeModel)deptmap.get(bpmTreeModel.getParentId())).setChildrenList(children);
        }
        ArrayList<BpmTreeModel> result = new ArrayList<BpmTreeModel>();
        result.add(bpmTreeModel);
        return result;
    }

    public List<BpmTreeModel> queryAssigneeAndDept(List<String> users, String organName) {
        if (HussarUtils.isEmpty(users) || HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        List<Long> longUserIds = users.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        return this.assigneeChooseEyMapper.queryAssigneeAndDept(this.getInListSqlCondition(longUserIds), organName);
    }

    public Page<BpmTreeModel> queryNodeAssigneeListByPage(NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        Page pages = nodeAssigneeQueryDto.getPages();
        List users = nodeAssigneeQueryDto.getUsers();
        ArrayList<Long> longUsers = new ArrayList<Long>();
        for (String user : users) {
            longUsers.add(Long.parseLong(user));
        }
        if (HussarUtils.isEmpty((Object)nodeAssigneeQueryDto.getId()) || HussarUtils.isEmpty((Object)nodeAssigneeQueryDto.getType())) {
            return pages.setRecords(this.assigneeChooseEyMapper.getNodeAssigneeListByParentId((Page<BpmTreeModel>)pages, null, this.getInListSqlCondition(longUsers)));
        }
        if (ORGAN.equals(nodeAssigneeQueryDto.getType())) {
            List<Object> list = this.assigneeChooseEyMapper.getUserListByParentId(null, Long.parseLong(nodeAssigneeQueryDto.getId()), null);
            list = list.stream().filter(item -> users.contains(item.getId())).collect(Collectors.toList());
            pages.setTotal((long)list.size());
            int start = (int)((pages.getCurrent() - 1L) * pages.getSize());
            int end = (int)Math.min((long)list.size(), pages.getCurrent() * pages.getSize());
            return pages.setRecords(list.subList(start, end));
        }
        if (USER.equals(nodeAssigneeQueryDto.getType())) {
            return pages.setRecords(this.assigneeChooseEyMapper.getNodeAssigneeListByUserId((Page<BpmTreeModel>)pages, Long.parseLong(nodeAssigneeQueryDto.getId())));
        }
        return pages.setRecords(new ArrayList());
    }

    public List<BpmTreeModel> queryDeptTreeByDeptName(String organName) {
        String serverCode;
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        String string = serverCode = BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode") == null ? "" : BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode").toString();
        if (MASTERCODE.equals(serverCode)) {
            List<BpmTreeModel> result = this.assigneeChooseEyMapper.queryDeptTreeByDeptName(organName, null);
            ArrayList<Long> parentIds = new ArrayList<Long>();
            for (BpmTreeModel bpmTreeModel : result) {
                if (!ORGAN.equals(bpmTreeModel.getType())) continue;
                parentIds.add(Long.valueOf(bpmTreeModel.getId()));
            }
            if (!parentIds.isEmpty()) {
                HashSet<Long> parentIdList = new HashSet<Long>(this.assigneeChooseEyMapper.getNotLeafParentIds(this.getInListSqlCondition(parentIds), ORGAN));
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType()) || !parentIdList.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            }
            return this.queryAllTreeByChildrenNode(result, 0);
        }
        ArrayList<BpmTreeModel> result = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)serverCode)) {
            List<String> organCodeId = this.assigneeChooseEyMapper.getOrgCodeIdByServerCode(serverCode);
            result = this.assigneeChooseEyMapper.queryServerDeptTreeByDeptName(organName, organCodeId);
        }
        ArrayList<Long> parentIds = new ArrayList<Long>();
        for (BpmTreeModel bpmTreeModel : result) {
            if (!ORGAN.equals(bpmTreeModel.getType())) continue;
            parentIds.add(Long.valueOf(bpmTreeModel.getId()));
        }
        if (!parentIds.isEmpty()) {
            HashSet<Long> hashSet = new HashSet<Long>(this.assigneeChooseEyMapper.getNotLeafParentIds(this.getInListSqlCondition(parentIds), ORGAN));
            for (BpmTreeModel bpmTreeModel : result) {
                if (!ORGAN.equals(bpmTreeModel.getType()) || !hashSet.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                bpmTreeModel.setIsLeaf("false");
            }
        }
        return this.queryAllTreeByChildrenNode(result, 0);
    }

    public List<BpmTreeModel> queryUserListByUserName(String organName) {
        String serverCode;
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        String string = serverCode = BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode") == null ? "" : BaseSecurityUtil.getUser().getExtendUserMap().get("serverCode").toString();
        if (MASTERCODE.equals(serverCode)) {
            return this.assigneeChooseEyMapper.queryUserTreeByUserName(organName);
        }
        if (HussarUtils.isNotEmpty((Object)serverCode)) {
            List<String> organCodeId = this.assigneeChooseEyMapper.getOrgCodeIdByServerCode(serverCode);
            return this.assigneeChooseEyMapper.queryServerUserTreeByUserName(organName, organCodeId);
        }
        return new ArrayList<BpmTreeModel>();
    }

    public List<AssigneeChooseDto> getUserAndAccountListByUserId(List<String> userIds) {
        ArrayList<Long> longUsers = new ArrayList<Long>();
        for (String user : userIds) {
            longUsers.add(Long.parseLong(user));
        }
        return this.assigneeChooseEyMapper.getUserAndAccountListByUserId(this.getInListSqlCondition(longUsers));
    }

    public List<BpmUserMsg> getUserMsgByUserIds(List<String> userIds) {
        if (HussarUtils.isEmpty(userIds)) {
            return new ArrayList<BpmUserMsg>();
        }
        List<Long> ids = userIds.stream().map(Long::parseLong).collect(Collectors.toList());
        return this.assigneeChooseEyMapper.getUserMsgByUserIds(this.getInListSqlCondition(ids));
    }

    public List<Map<String, String>> getUserInfoListByUserIdWithSelect(List<String> userList, String tenantId) {
        List<BpmTreeModel> list = this.userInfoDeptDetail(userList, tenantId, true);
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        if (list != null && list.size() > 0) {
            for (BpmTreeModel bpmTreeModel : list) {
                HashMap<String, String> mapSelect = new HashMap<String, String>(3);
                mapSelect.put("id", bpmTreeModel.getId());
                mapSelect.put("name", bpmTreeModel.getLabel());
                mapSelect.put("departmentId", bpmTreeModel.getParentId());
                resultList.add(mapSelect);
            }
        }
        return resultList;
    }

    private List<List<Long>> getInListSqlCondition(List<Long> longList) {
        ArrayList<List<Long>> result = new ArrayList<List<Long>>();
        int size = longList.size();
        for (int i = 0; i < size; i += 1000) {
            List<Long> list = longList.subList(i, Math.min(i + 1000, size));
            result.add(list);
        }
        return result;
    }

    private List<BpmTreeModel> userDeptDetail(String userId, boolean isInterface) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return new ArrayList<BpmTreeModel>();
        }
        try {
            List<BpmTreeModel> result = this.assigneeChooseEyMapper.userDeptDetail(Long.parseLong(userId));
            for (BpmTreeModel bpmTreeModel : result) {
                if (!DEFAULT_PARENTID.equals(bpmTreeModel.getParentId())) continue;
                bpmTreeModel.setParentId(null);
            }
            return result;
        }
        catch (Exception e) {
            throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
        }
    }

    private List<BpmTreeModel> queryAllTreeByChildrenNode(List<BpmTreeModel> childrenNode, Integer type) {
        ArrayList<BpmTreeModel> result = new ArrayList<BpmTreeModel>();
        List<BpmTreeModel> allDept = this.assigneeChooseEyMapper.getAllDept();
        HashMap<String, BpmTreeModel> deptMap = new HashMap<String, BpmTreeModel>();
        for (BpmTreeModel dept : allDept) {
            deptMap.put(dept.getId(), dept);
        }
        block1: for (BpmTreeModel bpmTreeModel : childrenNode) {
            BpmTreeModel children = bpmTreeModel;
            if (deptMap.containsKey(children.getId())) {
                children = (BpmTreeModel)deptMap.get(children.getId());
            }
            while (true) {
                if (!deptMap.containsKey(children.getParentId())) {
                    int i;
                    for (BpmTreeModel rootNode : result) {
                        if (!rootNode.getId().equals(children.getId())) continue;
                        continue block1;
                    }
                    if (ORGAN.equals(children.getType())) {
                        for (i = 0; i < result.size(); ++i) {
                            if (USER.equals(((BpmTreeModel)result.get(i)).getType())) {
                                result.add(i, children);
                                continue block1;
                            }
                            if (Integer.parseInt(((BpmTreeModel)result.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            result.add(i, children);
                            continue block1;
                        }
                    } else {
                        for (i = 0; i < result.size(); ++i) {
                            if (!USER.equals(((BpmTreeModel)result.get(i)).getType()) || Integer.parseInt(((BpmTreeModel)result.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            result.add(i, children);
                            continue block1;
                        }
                    }
                    result.add(children);
                    continue block1;
                }
                BpmTreeModel parent = (BpmTreeModel)deptMap.get(children.getParentId());
                ArrayList<BpmTreeModel> childrenList = parent.getChildrenList();
                if (!HussarUtils.isEmpty((Object)childrenList)) {
                    int i;
                    for (BpmTreeModel parentChildrenList : childrenList) {
                        if (!parentChildrenList.getId().equals(children.getId())) continue;
                        continue block1;
                    }
                    if (ORGAN.equals(children.getType())) {
                        for (i = 0; i < childrenList.size(); ++i) {
                            if (USER.equals(((BpmTreeModel)childrenList.get(i)).getType())) {
                                childrenList.add(i, children);
                                continue block1;
                            }
                            if (Integer.parseInt(((BpmTreeModel)childrenList.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            childrenList.add(i, children);
                            continue block1;
                        }
                    } else {
                        for (i = 0; i < childrenList.size(); ++i) {
                            if (!USER.equals(((BpmTreeModel)childrenList.get(i)).getType()) || Integer.parseInt(((BpmTreeModel)childrenList.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            childrenList.add(i, children);
                            continue block1;
                        }
                    }
                    childrenList.add(children);
                    continue block1;
                }
                childrenList = new ArrayList<BpmTreeModel>();
                childrenList.add(children);
                parent.setChildrenList(childrenList);
                children = parent;
            }
        }
        return result;
    }

    private List<BpmTreeModel> userInfoDeptDetail(List<String> userId, String tenantId, boolean isInterface) {
        if (ToolUtil.isEmpty(userId)) {
            return null;
        }
        return this.assigneeChooseEyMapper.userInfoDeptDetail(userId);
    }
}

