/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.identity.organ.manager.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.ConditionUtils;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.identity.audit.model.SysStruAudit;
import com.jxdinfo.hussar.identity.bspinterface.service.ISysOrgEventService;
import com.jxdinfo.hussar.identity.organ.dao.SysStruRuleMapper;
import com.jxdinfo.hussar.identity.organ.dto.TransferStaffDto;
import com.jxdinfo.hussar.identity.organ.manager.TransferOrganizationManager;
import com.jxdinfo.hussar.identity.organ.manager.TransferStaffManager;
import com.jxdinfo.hussar.identity.organ.manager.impl.CommonStaffManager;
import com.jxdinfo.hussar.identity.organ.model.SysStru;
import com.jxdinfo.hussar.identity.organ.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.identity.organ.model.SysStruRule;
import com.jxdinfo.hussar.identity.user.model.SysUsers;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Master
@Repository(value="com.jxdinfo.hussar.identity.organ.manager.impl.transferStaffManagerImpl")
public class TransferStaffManagerImpl
extends CommonStaffManager
implements TransferStaffManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransferStaffManagerImpl.class);
    @Resource
    private SysStruRuleMapper sysStruRuleMapper;
    @Autowired
    ISysOrgEventService sysOrgEventService;
    @Autowired
    private TransferOrganizationManager transferOrganizationManager;

    @Override
    public String transferStaff(TransferStaffDto transferStaffDto) {
        LOGGER.info("\u6267\u884c\u4eba\u5458\u8f6c\u79fb,\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)transferStaffDto));
        String validateMsg = this.validateService.validate((Object)transferStaffDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        Long oldId = transferStaffDto.getOldId();
        Long newId = transferStaffDto.getNewId();
        SysStru oldSysStru = (SysStru)this.sysStruMapper.selectById(oldId);
        SysStru newSysStru = (SysStru)this.sysStruMapper.selectById(newId);
        AssertUtil.isNotNull((Object)oldSysStru, (String)"\u672a\u67e5\u8be2\u5230\u9700\u8981\u8f6c\u79fb\u7684\u4eba\u5458\u4fe1\u606f");
        AssertUtil.isTrue((boolean)oldSysStru.getStruType().equals("9"), (String)"\u67e5\u8be2\u5230\u6570\u636e\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u4e0d\u5339\u914d");
        AssertUtil.isNotNull((Object)newSysStru, (String)"\u672a\u67e5\u8be2\u5230\u8981\u8f6c\u79fb\u5230\u7684\u7ec4\u7ec7\u673a\u6784");
        this.validateTransferOrganization(oldSysStru, newSysStru);
        this.sysOrgEventService.beforeOrgChange(oldId, newId);
        String msg = this.doTransfer(oldSysStru, newSysStru);
        this.sysOrgEventService.afterOrgChange(oldId, newId);
        return msg;
    }

    private String doTransfer(SysStru oldSysStru, SysStru newSysStru) {
        LOGGER.info("\u6267\u884c\u771f\u6b63\u7684\u4eba\u5458\u8f6c\u79fb\uff0c{}->{}", (Object)oldSysStru.getId(), (Object)newSysStru.getId());
        String msg = "";
        String orgType = oldSysStru.getStruType();
        Long orgId = oldSysStru.getId();
        Long parentId = newSysStru.getId();
        Integer changeLevel = newSysStru.getStruLevel();
        List sysUsersList = new ArrayList();
        if ("9".equals(orgType)) {
            sysUsersList = this.sysUsersMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getEmployeeId, (Object)orgId));
            AtomicReference<Integer> userOrder = new AtomicReference<Integer>(this.sysUsersService.getMaxOrder(parentId));
            if (ToolUtil.isEmpty((Object)userOrder.get())) {
                userOrder.set(1);
            } else {
                userOrder.set(userOrder.get() + 1);
            }
            for (SysUsers sysUsers : sysUsersList) {
                ConditionUtils.isTrue((boolean)HussarUtils.isNotEmpty((Object)sysUsers)).handle(() -> {
                    if (this.sysUsersAuditService.adjustEdit(sysUsers.getId())) {
                        throw new BaseException("\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u8f6c\u79fb\uff01");
                    }
                    sysUsers.setCorporationId(parentId);
                    sysUsers.setDepartmentId(parentId);
                    sysUsers.setUserOrder(userOrder.getAndSet((Integer)userOrder.get() + 1));
                });
            }
        }
        AtomicReference<Integer> orderTree = new AtomicReference<Integer>(1);
        Integer maxOrder = this.sysStruMapper.getMaxOrderById(parentId);
        ConditionUtils.isTrue((boolean)HussarUtils.isNotEmpty((Object)maxOrder)).handle(() -> orderTree.set(maxOrder + 1));
        Integer struOrder = orderTree.get();
        Integer level = changeLevel + 1;
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            SysStru sysStru = (SysStru)this.sysStruMapper.selectById(orgId);
            SysStruAudit sysStruAudit = new SysStruAudit();
            CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
            sysStruAudit.setId(null);
            sysStruAudit.setInUse("4");
            sysStruAudit.setStruOrder(struOrder);
            sysStruAudit.setRealStruId(sysStru.getId());
            sysStruAudit.setState("0");
            sysStruAudit.setStruLevel(level);
            sysStruAudit.setParentId(parentId);
            this.sysStruAuditService.save((Object)sysStruAudit);
            msg = "\u8f6c\u79fb\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01";
        } else {
            this.transferOrganizationManager.organizationChange(orgId, parentId, orgType, struOrder);
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.eq(SysStruAssistOrgan::getStruId, (Object)orgId)).eq(SysStruAssistOrgan::getAssistParentId, (Object)parentId);
            this.sysStruAssistOrganMapper.delete((Wrapper)wrapper);
            if (ToolUtil.isNotEmpty(sysUsersList)) {
                for (SysUsers sysUsers : sysUsersList) {
                    this.sysUsersMapper.updateById(sysUsers);
                }
            }
            msg = "\u8f6c\u79fb\u6210\u529f\uff01";
        }
        return msg;
    }

    private void validateTransferOrganization(SysStru oldSysStru, SysStru newSysStru) {
        LOGGER.debug("\u6267\u884c\u662f\u5426\u53ef\u4ee5\u8f6c\u79fb\u6821\u9a8c");
        this.whetherComplianceWithOrganizationRule(oldSysStru, newSysStru);
        this.existsAuditData(oldSysStru.getId(), newSysStru.getId());
    }

    private void existsAuditData(Long oldId, Long newId) {
        if (!this.sysStruAuditService.checkCanOperate(oldId)) {
            throw new BaseException("\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u8f6c\u79fb\uff01");
        }
        if (!this.sysStruAuditService.checkCanOperate(newId)) {
            throw new BaseException("\u8f6c\u79fb\u540e\u7684\u7ec4\u7ec7\u673a\u6784\u5b58\u5728\u672a\u5ba1\u6838\u7684\u6570\u636e\uff0c\u7981\u6b62\u8f6c\u79fb\uff01");
        }
    }

    private void whetherComplianceWithOrganizationRule(SysStru oldSysStru, SysStru newSysStru) {
        String oldOrganType = oldSysStru.getStruType();
        String newOrganType = newSysStru.getStruType();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysStruRule::getSysOrganType, (Object)newOrganType);
        wrapper.eq(SysStruRule::getOrganType, (Object)oldOrganType);
        long count = this.sysStruRuleMapper.selectCount((Wrapper)wrapper);
        if (count == 0L) {
            throw new BaseException("\u8f6c\u79fb\u5931\u8d25\uff01\uff08\u8be5\u8f6c\u79fb\u4e0d\u7b26\u5408\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\uff01\uff09");
        }
    }
}

