/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.identity.organ.manager.impl;

import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.identity.audit.dao.SysStruAuditMapper;
import com.jxdinfo.hussar.identity.audit.dto.QueryAuditOrganizationDto;
import com.jxdinfo.hussar.identity.audit.model.SysStruAudit;
import com.jxdinfo.hussar.identity.audit.vo.AuditOrganizationData;
import com.jxdinfo.hussar.identity.audit.vo.AuditOrganizationDetailVo;
import com.jxdinfo.hussar.identity.audit.vo.AuditOrganizationListVo;
import com.jxdinfo.hussar.identity.organ.dao.SysOfficeMapper;
import com.jxdinfo.hussar.identity.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.identity.organ.dao.SysOrganTypeMapper;
import com.jxdinfo.hussar.identity.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.identity.organ.manager.QueryAuditOrganizationManager;
import com.jxdinfo.hussar.identity.organ.model.SysOffice;
import com.jxdinfo.hussar.identity.organ.model.SysOrgan;
import com.jxdinfo.hussar.identity.organ.model.SysOrganType;
import com.jxdinfo.hussar.identity.organ.model.SysStru;
import com.jxdinfo.hussar.identity.organ.util.OrganUtil;
import com.jxdinfo.hussar.identity.user.dao.SysUsersMapper;
import com.jxdinfo.hussar.identity.user.model.SysUsers;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

@Master
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.queryAuditOrganizationManagerImpl")
public class QueryAuditOrganizationManagerImpl
implements QueryAuditOrganizationManager {
    @Resource
    private SysStruAuditMapper sysStruAuditMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysOrganMapper sysOrganMapper;
    @Resource
    private SysOrganTypeMapper sysOrganTypeMapper;
    @Resource
    private SysOfficeMapper sysOfficeMapper;
    @Resource
    private SysUsersMapper sysUsersMapper;

    @Override
    public Page<AuditOrganizationListVo> queryOrganizationAudit(PageInfo pageInfo, QueryAuditOrganizationDto queryAuditOrganizationDto) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("organName", SqlQueryUtil.transferSpecialChar((String)queryAuditOrganizationDto.getOrganName()));
        queryParams.put("type", queryAuditOrganizationDto.getState());
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        List<AuditOrganizationListVo> auditOrganizationVos = this.sysStruAuditMapper.queryOrganizationAudit((Page<AuditOrganizationListVo>)page, queryParams);
        page.setRecords(auditOrganizationVos);
        return page;
    }

    @Override
    public AuditOrganizationDetailVo viewOrganAudit(Long id) {
        AuditOrganizationDetailVo vo = new AuditOrganizationDetailVo();
        AuditOrganizationData oldData = vo.getOldData();
        AuditOrganizationData newData = vo.getNewData();
        SysStruAudit sysStruAudit = (SysStruAudit)this.sysStruAuditMapper.selectById(id);
        AssertUtil.isNotNull((Object)sysStruAudit, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u673a\u6784\u5ba1\u6838\u4fe1\u606f");
        Long struId = sysStruAudit.getId();
        String type = sysStruAudit.getInUse();
        Long realStruId = sysStruAudit.getRealStruId();
        if ("1".equals(type)) {
            newData = this.sysStruAuditMapper.getAuditOrganizationDataById(struId);
            newData.setParentName(OrganUtil.getShortParentName((String)newData.getParentName()));
            vo.setNewData(newData);
        } else if ("2".equals(type)) {
            newData = this.sysStruAuditMapper.getAuditOrganizationDataById(struId);
            newData.setParentName(OrganUtil.getShortParentName((String)newData.getParentName()));
            oldData = this.getOrganizationDataById(realStruId);
            oldData.setParentName(OrganUtil.getShortParentName((String)oldData.getParentName()));
        } else if ("3".equals(type)) {
            oldData = this.getOrganizationDataById(realStruId);
            oldData.setParentName(OrganUtil.getShortParentName((String)oldData.getParentName()));
        } else if ("4".equals(type)) {
            oldData = this.getOrganizationDataById(realStruId);
            oldData.setParentName(OrganUtil.getShortParentName((String)oldData.getParentName()));
            BeanUtils.copyProperties((Object)oldData, (Object)newData);
            Long parentId = sysStruAudit.getParentId();
            SysStru struTemp = (SysStru)this.sysStruMapper.selectById(parentId);
            AssertUtil.isNotNull((Object)struTemp, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u7ed3\u6784\u4fe1\u606f");
            SysOrgan organTemp = (SysOrgan)this.sysOrganMapper.selectById(struTemp.getOrganId());
            AssertUtil.isNotNull((Object)organTemp, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f");
            newData.setParentName(organTemp.getOrganName());
        }
        vo.setOldData(oldData);
        vo.setNewData(newData);
        return vo;
    }

    private AuditOrganizationData getOrganizationDataById(Long realStruId) {
        AuditOrganizationData data = new AuditOrganizationData();
        SysStru stru = (SysStru)this.sysStruMapper.selectById(realStruId);
        SysOrgan organ = (SysOrgan)this.sysOrganMapper.selectById(stru.getOrganId());
        data.setOrganAlias(stru.getOrganAlias());
        data.setOrganName(organ.getOrganName());
        data.setParentName(organ.getOrganFname());
        LambdaQueryWrapper organtypeWrapper = new LambdaQueryWrapper();
        organtypeWrapper.eq(SysOrganType::getOrganType, (Object)stru.getStruType());
        SysOrganType organType = (SysOrganType)this.sysOrganTypeMapper.selectOne((Wrapper)organtypeWrapper);
        data.setTypeName(organType.getTypeName());
        data.setShortName(organ.getShortName());
        data.setOrganCode(organ.getOrganCode());
        LambdaQueryWrapper officeWrapper = new LambdaQueryWrapper();
        officeWrapper.eq(SysOffice::getStruId, (Object)realStruId);
        SysOffice sysOffice = (SysOffice)this.sysOfficeMapper.selectOne((Wrapper)officeWrapper);
        data.setOfficeAddress(sysOffice.getOfficeAddress());
        data.setOfficeAlias(sysOffice.getOfficeAlias());
        Long principalId = stru.getPrincipalId();
        if (HussarUtils.isNotEmpty((Object)principalId)) {
            SysUsers sysUsers = (SysUsers)this.sysUsersMapper.selectById(principalId);
            data.setUserName(sysUsers.getUserName());
        }
        return data;
    }
}

