/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.identity.organ.manager.impl;

import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.identity.organ.dto.EditOutsideOrganizationDto;
import com.jxdinfo.hussar.identity.organ.manager.EditOutsideOrganizationManager;
import com.jxdinfo.hussar.identity.organ.manager.impl.CommonOutsideOrganizationManager;
import com.jxdinfo.hussar.identity.organ.model.SysOffice;
import com.jxdinfo.hussar.identity.organ.model.SysOrgan;
import com.jxdinfo.hussar.identity.organ.model.SysStru;
import com.jxdinfo.hussar.identity.organ.util.OrganUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

@Master
@Repository(value="com.jxdinfo.hussar.identity.organ.manager.impl.editOutsideOrganizationManagerImpl")
public class EditOutsideOrganizationManagerImpl
extends CommonOutsideOrganizationManager
implements EditOutsideOrganizationManager {
    @Override
    public R<EditOutsideOrganizationDto> editOrganization(EditOutsideOrganizationDto editOrganizationDto) {
        R result = new R();
        List errors = OrganUtil.validateOne((Object)editOrganizationDto);
        String organCode = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganCode());
        SysOrgan sysOrganTemp = (SysOrgan)this.organService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysOrgan::getOrganCode, (Object)StringUtils.trimToEmpty((String)organCode))).ne(SysOrgan::getOrganType, (Object)"9"));
        if (sysOrganTemp == null) {
            OrganUtil.addErrorMsg((List)errors, (Object)editOrganizationDto, (String)"organCode", (String[])new String[]{"\u672a\u67e5\u8be2\u5230\u8be5\u7ec4\u7ec7\u673a\u6784\u7f16\u7801"});
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            SysOffice sysOffice = new SysOffice();
            SysOrgan sysOrgan = new SysOrgan();
            BeanUtils.copyProperties((Object)sysOrganTemp, (Object)sysOrgan);
            SysStru sysStru = new SysStru();
            this.initializationEdit(editOrganizationDto, sysStru, sysOrgan, sysOffice);
            this.sysStruMapper.updateById(sysStru);
            this.organService.updateById((Object)sysOrgan);
            if (HussarUtils.isNotEmpty((Object)sysOffice)) {
                this.sysOfficeService.updateById((Object)sysOffice);
            }
            result.setSuccess(true);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysStru.getId(), sysOrgan.getOrganCode())}));
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    private void initializationEdit(EditOutsideOrganizationDto editOrganizationDto, SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        String organName = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganName());
        String organAlias = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganAlias());
        String userAccount = StringUtils.trimToEmpty((String)editOrganizationDto.getUserAccount());
        String organShortName = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganShortName());
        String organDescription = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganDescription());
        String struOrderStr = StringUtils.trimToEmpty((String)(editOrganizationDto.getStruOrder() == null ? "" : editOrganizationDto.getStruOrder().toString()));
        String organAddress = editOrganizationDto.getOrganAddress();
        String currentFname = sysOrgan.getOrganFname();
        String newFname = currentFname.substring(0, currentFname.lastIndexOf("/")) + "/" + editOrganizationDto.getOrganName().trim();
        if (!Objects.equals(editOrganizationDto.getOrganName().trim(), sysOrgan.getOrganName())) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.likeRight(SysOrgan::getOrganFcode, (Object)sysOrgan.getOrganFcode());
            wrapper.ne(SysOrgan::getId, (Object)sysOrgan.getId());
            List sysOrgans = this.organService.list((Wrapper)wrapper);
            for (SysOrgan temp : sysOrgans) {
                temp.setOrganFname(temp.getOrganFname().replaceFirst(currentFname, newFname));
            }
            this.organService.updateBatchById((Collection)sysOrgans);
        }
        SysStru sysStruT = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getOrganId, (Object)sysOrgan.getId()));
        Long struId = sysStruT.getId();
        SysOffice sysOfficeT = (SysOffice)this.sysOfficeService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysOffice::getStruId, (Object)struId));
        BeanUtils.copyProperties((Object)sysStruT, (Object)sysStru);
        BeanUtils.copyProperties((Object)sysOfficeT, (Object)sysOffice);
        if (StringUtils.isNotBlank((CharSequence)organAlias)) {
            sysStru.setOrganAlias(organAlias);
        }
        if (StringUtils.isNotBlank((CharSequence)userAccount)) {
            Long userId = this.getUserId(userAccount);
            sysStru.setPrincipalId(userId);
        }
        if (StringUtils.isNotBlank((CharSequence)struOrderStr)) {
            sysStru.setStruOrder(Integer.valueOf(Integer.parseInt(struOrderStr)));
            String oldSeq = sysStru.getStruSeq();
            String newSeq = oldSeq.substring(0, oldSeq.lastIndexOf("/")) + "/" + String.format("%04d", struOrderStr);
            sysStru.setStruSeq(newSeq);
        }
        if (StringUtils.isNotBlank((CharSequence)organName)) {
            sysOrgan.setOrganName(organName);
        }
        sysOrgan.setOrganFname(sysOrgan.getOrganFname().replaceFirst(currentFname, newFname));
        if (StringUtils.isNotBlank((CharSequence)organShortName)) {
            sysOrgan.setShortName(organShortName);
        }
        if (StringUtils.isNotBlank((CharSequence)organAddress)) {
            sysOffice.setOfficeAddress(organAddress);
        }
        if (StringUtils.isNotBlank((CharSequence)organDescription)) {
            sysOffice.setOfficeAlias(organDescription);
        }
    }
}

