/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.identity.organ.manager.impl;

import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.identity.audit.model.SysStruAssistOrganAudit;
import com.jxdinfo.hussar.identity.audit.model.SysStruAudit;
import com.jxdinfo.hussar.identity.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.identity.organ.manager.DeleteOrganizationManager;
import com.jxdinfo.hussar.identity.organ.manager.impl.CommonOrganizationManager;
import com.jxdinfo.hussar.identity.organ.model.SysStru;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Master
@Repository(value="com.jxdinfo.hussar.identity.organ.manager.impl.deleteOrganizationManagerImpl")
public class DeleteOrganizationManagerImpl
extends CommonOrganizationManager
implements DeleteOrganizationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteOrganizationManagerImpl.class);

    @Override
    public String deleteOrganization(Long struId) {
        LOGGER.info("\u5220\u9664\u7ec4\u7ec7\u673a\u6784\uff1a{}", (Object)struId);
        if (struId == null) {
            throw new BaseException("\u8981\u5220\u9664\u7684\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.beforeDeleteOrganization(struId);
        this.judgeWhetherItCanBeDelete(struId);
        String result = this.doDelete(struId);
        this.afterDeleteOrganization(struId);
        return result;
    }

    private void afterDeleteOrganization(Long struId) {
        LOGGER.info("\u8c03\u7528\u7ec4\u7ec7\u673a\u6784\u5220\u9664\u4e4b\u540e\u7684\u65b9\u6cd5");
        this.sysOrgEventService.afterDel(struId);
    }

    private String doDelete(Long struId) {
        LOGGER.info("\u6267\u884c\u5220\u9664\u6570\u636e");
        String msg = "";
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            LOGGER.debug("\u5220\u9664\u7ec4\u7ec7\u673a\u6784\u9700\u8981\u5ba1\u6838");
            SysStru sysStru = (SysStru)this.sysStruMapper.selectById(struId);
            SysStruAudit sysStruAudit = new SysStruAudit();
            CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
            sysStruAudit.setId(null);
            sysStruAudit.setRealStruId(sysStru.getId());
            sysStruAudit.setState("0");
            sysStruAudit.setInUse("3");
            this.sysStruAuditService.save((Object)sysStruAudit);
            msg = "\u5220\u9664\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01";
        } else {
            LOGGER.debug("\u5220\u9664\u7ec4\u7ec7\u673a\u6784\u4e0d\u9700\u8981\u5ba1\u6838");
            boolean flag = this.delOrganByStruId(struId);
            msg = flag ? "\u5220\u9664\u6210\u529f\uff01" : "\u5220\u9664\u5931\u8d25\uff01";
        }
        return msg;
    }

    private void judgeWhetherItCanBeDelete(Long struId) {
        LOGGER.info("\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u5220\u9664");
        List<Map<String, Object>> orgList = this.sysStruMapper.getOrgListByParentId(struId);
        if (HussarUtils.isNotEmpty(orgList)) {
            throw new BaseException("\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u4e0b\u7ea7\u7ec4\u7ec7\u673a\u6784\u6216\u4eba\u5458\uff01");
        }
        List<Map<String, Object>> userList = this.sysUsersMapper.getUsersByOrgId(struId);
        if (HussarUtils.isNotEmpty(userList)) {
            throw new BaseException("\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u5173\u8054\u7528\u6237\uff01");
        }
        List roleList = this.hussarBaseRoleBoService.getRolesByOrgId(struId);
        if (HussarUtils.isNotEmpty((Object)roleList)) {
            throw new BaseException("\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u5173\u8054\u89d2\u8272\uff01");
        }
        List noRoleList = this.hussarBaseConfRolesBoService.getRolesByOrgId(struId);
        if (HussarUtils.isNotEmpty((Object)noRoleList)) {
            throw new BaseException("\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u5173\u8054\u4e0d\u76f8\u5bb9\u89d2\u8272\uff01");
        }
        List assistOrganChildrenList = this.sysStruAssistOrganService.getAssistOrganByParent(struId);
        if (HussarUtils.isNotEmpty((Object)assistOrganChildrenList)) {
            throw new BaseException("\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u4e0b\u7ea7\u517c\u4efb\u4eba\u5458\uff01");
        }
        if (!this.sysStruAuditService.checkCanOperate(struId)) {
            throw new BaseException("\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u5220\u9664\uff01");
        }
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.eq(SysStruAudit::getParentId, (Object)struId);
        wrapper1.eq(SysStruAudit::getState, (Object)"0");
        ArrayList<String> inUseList = new ArrayList<String>();
        inUseList.add("1");
        inUseList.add("4");
        wrapper1.in(SysStruAudit::getInUse, inUseList);
        List list1 = this.sysStruAuditService.list((Wrapper)wrapper1);
        if (HussarUtils.isNotEmpty((Object)list1)) {
            throw new BaseException("\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u672a\u5ba1\u6838\u7684\u4e0b\u7ea7\u7ec4\u7ec7\u673a\u6784\u6216\u4eba\u5458\uff01");
        }
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(SysUsersAudit::getDepartmentId, (Object)struId);
        wrapper2.eq(SysUsersAudit::getIsAudit, (Object)"0");
        ArrayList<String> currentStatusList1 = new ArrayList<String>();
        currentStatusList1.add("0");
        currentStatusList1.add("3");
        currentStatusList1.add("1");
        wrapper2.in(SysUsersAudit::getCurrentStatus, currentStatusList1);
        List list2 = this.sysUsersAuditService.list((Wrapper)wrapper2);
        if (HussarUtils.isNotEmpty((Object)list2)) {
            throw new BaseException("\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5173\u8054\u7528\u6237\uff01");
        }
        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
        wrapper3.eq(SysUsersAudit::getEmployeeId, (Object)struId);
        wrapper3.eq(SysUsersAudit::getIsAudit, (Object)"0");
        ArrayList<String> currentStatusList2 = new ArrayList<String>();
        currentStatusList2.add("0");
        currentStatusList2.add("1");
        wrapper3.in(SysUsersAudit::getCurrentStatus, currentStatusList2);
        List list3 = this.sysUsersAuditService.list((Wrapper)wrapper3);
        if (HussarUtils.isNotEmpty((Object)list3)) {
            throw new BaseException("\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5173\u8054\u7528\u6237\uff01");
        }
        LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
        wrapper4.eq(SysStruAssistOrganAudit::getAssistParentId, (Object)struId);
        wrapper4.eq(SysStruAssistOrganAudit::getState, (Object)"0");
        List list4 = this.sysStruAssistOrganAuditService.list((Wrapper)wrapper4);
        if (HussarUtils.isNotEmpty((Object)list4)) {
            throw new BaseException("\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u672a\u5ba1\u6838\u7684\u4eba\u5458\uff01");
        }
    }

    private void beforeDeleteOrganization(Long struId) {
        LOGGER.info("\u8c03\u7528\u7ec4\u7ec7\u673a\u6784\u5220\u9664\u4e4b\u524d\u7684\u65b9\u6cd5");
        this.sysOrgEventService.beforeDel(struId);
    }
}

