/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.identity.organ.manager.impl;

import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.ConditionUtils;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.identity.audit.model.SysOfficeAudit;
import com.jxdinfo.hussar.identity.audit.model.SysOrganAudit;
import com.jxdinfo.hussar.identity.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.identity.audit.model.SysStruAssistOrganAudit;
import com.jxdinfo.hussar.identity.audit.model.SysStruAudit;
import com.jxdinfo.hussar.identity.audit.service.ISysOfficeAuditService;
import com.jxdinfo.hussar.identity.audit.service.ISysStaffAuditService;
import com.jxdinfo.hussar.identity.organ.dto.StruOrganRelationDto;
import com.jxdinfo.hussar.identity.organ.manager.AddOrganizationManager;
import com.jxdinfo.hussar.identity.organ.manager.ApprovedAuditStaffManager;
import com.jxdinfo.hussar.identity.organ.manager.TransferOrganizationManager;
import com.jxdinfo.hussar.identity.organ.manager.impl.CommonStaffAuditManager;
import com.jxdinfo.hussar.identity.organ.model.SysOffice;
import com.jxdinfo.hussar.identity.organ.model.SysOrgan;
import com.jxdinfo.hussar.identity.organ.model.SysStaff;
import com.jxdinfo.hussar.identity.organ.model.SysStru;
import com.jxdinfo.hussar.identity.organ.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.identity.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.identity.organ.service.ISysOrganService;
import com.jxdinfo.hussar.identity.organ.service.ISysStaffService;
import com.jxdinfo.hussar.identity.organ.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.identity.organ.service.ISysStruService;
import com.jxdinfo.hussar.identity.user.model.SysUsers;
import com.jxdinfo.hussar.identity.user.service.ISysUsersService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Master
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.approvedAuditStaffManagerImpl")
public class ApprovedAuditStaffManagerImpl
extends CommonStaffAuditManager
implements ApprovedAuditStaffManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApprovedAuditStaffManagerImpl.class);
    @Autowired
    private ISysUsersService sysUsersService;
    @Autowired
    private ISysStruService sysStruService;
    @Autowired
    private ISysOrganService sysOrganService;
    @Autowired
    private ISysOfficeAuditService sysOfficeAuditService;
    @Autowired
    private ISysStaffAuditService sysStaffAuditService;
    @Autowired
    private ISysStaffService sysStaffService;
    @Autowired
    private ISysOfficeService sysOfficeService;
    @Autowired
    private ISysStruAssistOrganService sysStruAssistOrganService;
    @Autowired
    AddOrganizationManager addOrganizationManager;
    @Autowired
    private TransferOrganizationManager transferOrganizationManager;

    @Override
    @HussarTransactional
    public String approved(Long id) {
        boolean flag;
        LOGGER.info("\u4eba\u5458\u5ba1\u6838\u901a\u8fc7\uff1a{}", (Object)id);
        SysStruAudit strumAudit = this.getSysStruAuditByStruid(id);
        Long organId = strumAudit.getOrganId();
        String inUse = strumAudit.getInUse();
        if ("3".equals(inUse) || "4".equals(inUse)) {
            SysStru sysStru = new SysStru();
            CopyPropertieUtils.copyProperties((Object)sysStru, (Object)strumAudit);
            sysStru.setId(strumAudit.getRealStruId());
            flag = this.doAuditDeleteAndChange(strumAudit, sysStru, inUse);
        } else {
            flag = this.doAuditAddAndUpdate(strumAudit, inUse);
        }
        AssertUtil.isTrue((boolean)flag, (String)"\u901a\u8fc7\u5931\u8d25\uff01");
        return "\u901a\u8fc7\u6210\u529f\uff01";
    }

    private boolean doAuditAddAndUpdate(SysStruAudit sysStruAudit, String inUse) {
        SysStaffAudit sysStaffAudit;
        boolean flag = true;
        Long realStruId = sysStruAudit.getRealStruId();
        boolean officeFlag = true;
        boolean staffFlag = true;
        SysOrganAudit sysOrganAudit = (SysOrganAudit)this.sysOrganAuditMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysOrganAudit::getId, (Object)sysStruAudit.getOrganId()));
        SysStru sysStru = new SysStru();
        CopyPropertieUtils.copyProperties((Object)sysStru, (Object)sysStruAudit);
        sysStru.setId(sysStruAudit.getRealStruId());
        if (!"1".equals(inUse)) {
            sysStru.setOrganId(sysOrganAudit.getRealOrganId());
        }
        boolean struFlag = this.sysStruService.saveOrUpdate((Object)sysStru);
        flag &= struFlag;
        SysOrgan sysOrgan = new SysOrgan();
        CopyPropertieUtils.copyProperties((Object)sysOrgan, (Object)sysOrganAudit);
        if ("2".equals(inUse)) {
            sysOrgan.setId(sysOrganAudit.getRealOrganId());
        } else {
            sysOrgan.setId(sysStru.getOrganId());
        }
        this.addOrganizationManager.wrapAddOrgan(sysStru, sysOrgan);
        boolean organFlag = this.sysOrganService.saveOrUpdate((Object)sysOrgan);
        flag &= organFlag;
        List assistOrganAudits = this.sysStruAssistOrganAuditMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysStruAssistOrganAudit::getStruId, (Object)realStruId));
        ArrayList<Long> idList = new ArrayList<Long>();
        for (SysStruAssistOrganAudit assistOrganAudit : assistOrganAudits) {
            idList.add(assistOrganAudit.getAssistParentId());
        }
        String join = StringUtils.join(idList, (String)",");
        StruOrganRelationDto struOrganRelationDto = new StruOrganRelationDto();
        struOrganRelationDto.setOrganIds(join);
        struOrganRelationDto.setSysStruId(realStruId);
        this.sysStruAssistOrganService.saveAssistOrgan(struOrganRelationDto);
        this.sysStruAssistOrganAuditMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysStruAssistOrganAudit::getStruId, (Object)realStruId));
        this.sysUsersService.update(null, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysUsers::getEmployeeId, (Object)sysStru.getId())).set(SysUsers::getUserName, (Object)sysOrgan.getOrganName()));
        SysOfficeAudit sysOfficeAudit = (SysOfficeAudit)this.sysOfficeAuditService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysOfficeAudit::getStruId, (Object)sysStruAudit.getId()));
        if (ToolUtil.isNotEmpty((Object)sysOfficeAudit)) {
            SysOffice sysOffice = new SysOffice();
            CopyPropertieUtils.copyProperties((Object)sysOffice, (Object)sysOfficeAudit);
            sysOffice.setStruId(sysStru.getId());
            sysOffice.setId(sysOfficeAudit.getRealOfficeId());
            officeFlag = this.sysOfficeService.saveOrUpdate((Object)sysOffice);
            flag &= officeFlag;
        }
        if (ToolUtil.isNotEmpty((Object)(sysStaffAudit = (SysStaffAudit)this.sysStaffAuditService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStaffAudit::getStruId, (Object)sysStruAudit.getId()))))) {
            SysStaff sysStaff = new SysStaff();
            CopyPropertieUtils.copyProperties((Object)sysStaff, (Object)sysStaffAudit);
            sysStaff.setStruId(sysStru.getId());
            sysStaff.setId(sysStaffAudit.getRealStaffId());
            staffFlag = this.sysStaffService.saveOrUpdate((Object)sysStaff);
            flag &= staffFlag;
        }
        sysStruAudit.setState("1");
        boolean stateFlag = this.sysStruAuditMapper.updateById(sysStruAudit) > 0;
        return flag &= stateFlag;
    }

    private boolean doAuditDeleteAndChange(SysStruAudit sysStruAudit, SysStru sysStru, String inUse) {
        boolean isStaff = Objects.equals("9", sysStru.getStruType());
        Long realStruId = sysStru.getId();
        if ("3".equals(inUse)) {
            if (isStaff) {
                this.sysStruAssistOrganMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysStruAssistOrgan::getStruId, (Object)realStruId));
            } else {
                this.hussarBaseStruRoleAuditBoService.deleteByStruId(realStruId);
            }
        } else if (isStaff) {
            this.sysStruAssistOrganMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruAssistOrgan::getStruId, (Object)realStruId)).eq(SysStruAssistOrgan::getAssistParentId, (Object)sysStru.getParentId()));
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(SysUsers::getEmployeeId, (Object)realStruId);
            List usersListOfOrganChange = this.sysUsersService.list((Wrapper)wrapper);
            for (SysUsers sysUsers : usersListOfOrganChange) {
                sysUsers.setDepartmentId(sysStru.getParentId());
                sysUsers.setCorporationId(sysStru.getParentId());
            }
            this.sysUsersService.saveOrUpdateBatch((Collection)usersListOfOrganChange);
        }
        if ("4".equals(inUse)) {
            AtomicReference<Integer> orderTree = new AtomicReference<Integer>(1);
            Integer maxOrder = this.sysStruMapper.getMaxOrderById(sysStru.getParentId());
            ConditionUtils.isTrue((boolean)HussarUtils.isNotEmpty((Object)maxOrder)).handle(() -> orderTree.set(maxOrder + 1));
            Integer struOrder = orderTree.get();
            this.transferOrganizationManager.organizationChange(sysStru.getId(), sysStru.getParentId(), sysStru.getStruType(), struOrder);
        }
        if ("3".equals(inUse)) {
            this.delStaffByStru(sysStru);
        }
        sysStruAudit.setState("1");
        this.sysStruAuditMapper.updateById(sysStruAudit);
        if ("3".equals(inUse)) {
            this.sysStruAuditMapper.updateStates(sysStruAudit.getRealStruId());
        }
        return true;
    }
}

