/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.identity.organ.manager.impl;

import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.ConditionUtils;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.identity.audit.model.SysOfficeAudit;
import com.jxdinfo.hussar.identity.audit.model.SysOrganAudit;
import com.jxdinfo.hussar.identity.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.identity.audit.model.SysStruAudit;
import com.jxdinfo.hussar.identity.organ.manager.ApprovedAuditOrganizationManager;
import com.jxdinfo.hussar.identity.organ.manager.impl.CommonOrganizationAuditManager;
import com.jxdinfo.hussar.identity.organ.model.SysOffice;
import com.jxdinfo.hussar.identity.organ.model.SysOrgan;
import com.jxdinfo.hussar.identity.organ.model.SysStaff;
import com.jxdinfo.hussar.identity.organ.model.SysStru;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Master
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.approvedAuditOrganizationManagerImpl")
public class ApprovedAuditOrganizationManagerImpl
extends CommonOrganizationAuditManager
implements ApprovedAuditOrganizationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApprovedAuditOrganizationManagerImpl.class);

    @Override
    @HussarTransactional
    public String approved(Long id) {
        boolean flag;
        LOGGER.info("\u7ec4\u7ec7\u673a\u6784\u5ba1\u6838\u901a\u8fc7\uff1a{}", (Object)id);
        SysStruAudit strumAudit = this.getSysStruAuditByStruid(id);
        Long organId = strumAudit.getOrganId();
        String inUse = strumAudit.getInUse();
        if ("3".equals(inUse) || "4".equals(inUse)) {
            SysStru sysStru = new SysStru();
            CopyPropertieUtils.copyProperties((Object)sysStru, (Object)strumAudit);
            sysStru.setId(strumAudit.getRealStruId());
            flag = this.doAuditDeleteAndChange(strumAudit, sysStru, inUse);
        } else {
            flag = this.doAuditAddAndUpdate(strumAudit, organId, inUse);
        }
        AssertUtil.isTrue((boolean)flag, (String)"\u901a\u8fc7\u5931\u8d25\uff01");
        return "\u901a\u8fc7\u6210\u529f\uff01";
    }

    private boolean doAuditAddAndUpdate(SysStruAudit struAudit, Long organId, String inUse) {
        SysStaffAudit sysStaffAudit;
        int level;
        boolean flag = true;
        SysOrganAudit sysOrganAudit = (SysOrganAudit)this.sysOrganAuditMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysOrganAudit::getId, (Object)organId));
        SysStru sysStru = new SysStru();
        CopyPropertieUtils.copyProperties((Object)sysStru, (Object)struAudit);
        sysStru.setId(struAudit.getRealStruId());
        if (!"1".equals(inUse)) {
            sysStru.setOrganId(sysOrganAudit.getRealOrganId());
        }
        if ("1".equals(inUse) && (level = sysStru.getStruLevel().intValue()) > 1) {
            SysStru pSysStru = (SysStru)this.sysStruMapper.selectById(sysStru.getParentId());
            pSysStru.setIsLeaf("N");
            this.sysStruMapper.updateById(pSysStru);
        }
        SysOrgan sysOrgan = new SysOrgan();
        CopyPropertieUtils.copyProperties((Object)sysOrgan, (Object)sysOrganAudit);
        if ("2".equals(inUse)) {
            sysOrgan.setId(sysOrganAudit.getRealOrganId());
            SysOrgan tempOrgan = (SysOrgan)this.sysOrganService.getById((Serializable)sysOrgan.getId());
            if (!Objects.equals(sysOrganAudit.getOrganName().trim(), tempOrgan.getOrganName())) {
                String currentFname = tempOrgan.getOrganFname();
                String newFname = currentFname.substring(0, currentFname.lastIndexOf("/")) + "/" + sysOrganAudit.getOrganName().trim();
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.likeRight(SysOrgan::getOrganFcode, (Object)tempOrgan.getOrganFcode());
                wrapper.ne(SysOrgan::getId, (Object)tempOrgan.getId());
                List sysOrgans = this.sysOrganService.list((Wrapper)wrapper);
                for (SysOrgan temp : sysOrgans) {
                    temp.setOrganFname(temp.getOrganFname().replaceFirst(currentFname, newFname));
                }
                this.sysOrganService.updateBatchById((Collection)sysOrgans);
            }
        } else {
            sysOrgan.setId(sysStru.getOrganId());
        }
        this.addOrganizationManager.wrapAddOrgan(sysStru, sysOrgan, !"2".equals(inUse));
        boolean struFlag = this.sysStruService.saveOrUpdate((Object)sysStru);
        flag &= struFlag;
        boolean organFlag = this.sysOrganService.saveOrUpdate((Object)sysOrgan);
        flag &= organFlag;
        SysOfficeAudit sysOfficeAudit = (SysOfficeAudit)this.sysOfficeAuditService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysOfficeAudit::getStruId, (Object)struAudit.getId()));
        if (ToolUtil.isNotEmpty((Object)sysOfficeAudit)) {
            SysOffice sysOffice = new SysOffice();
            CopyPropertieUtils.copyProperties((Object)sysOffice, (Object)sysOfficeAudit);
            sysOffice.setStruId(sysStru.getId());
            sysOffice.setId(sysOfficeAudit.getRealOfficeId());
            boolean officeFlag = this.sysOfficeService.saveOrUpdate((Object)sysOffice);
            flag &= officeFlag;
        }
        if (ToolUtil.isNotEmpty((Object)(sysStaffAudit = (SysStaffAudit)this.sysStaffAuditService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStaffAudit::getStruId, (Object)struAudit.getId()))))) {
            SysStaff sysStaff = new SysStaff();
            CopyPropertieUtils.copyProperties((Object)sysStaff, (Object)sysStaffAudit);
            sysStaff.setStruId(sysStru.getId());
            sysStaff.setId(sysStaffAudit.getRealStaffId());
            boolean staffFlag = this.sysStaffService.saveOrUpdate((Object)sysStaff);
            flag &= staffFlag;
        }
        struAudit.setState("1");
        boolean stateFlag = this.sysStruAuditMapper.updateById(struAudit) > 0;
        return flag &= stateFlag;
    }

    private boolean doAuditDeleteAndChange(SysStruAudit struAudit, SysStru sysStru, String inUse) {
        boolean flag2;
        boolean flag1 = false;
        if ("4".equals(inUse)) {
            AtomicReference<Integer> orderTree = new AtomicReference<Integer>(1);
            Integer maxOrder = this.sysStruMapper.getMaxOrderById(sysStru.getParentId());
            ConditionUtils.isTrue((boolean)HussarUtils.isNotEmpty((Object)maxOrder)).handle(() -> orderTree.set(maxOrder + 1));
            Integer struOrder = orderTree.get();
            this.transferOrganizationManager.organizationChange(struAudit.getRealStruId(), struAudit.getParentId(), struAudit.getStruType(), struOrder);
            flag1 = true;
        }
        if ("3".equals(inUse)) {
            flag1 = this.delOrganByStruId(sysStru.getId());
        }
        struAudit.setState("1");
        boolean bl = flag2 = this.sysStruAuditMapper.updateById(struAudit) > 0;
        if ("3".equals(inUse)) {
            this.sysStruAuditMapper.updateStates(struAudit.getRealStruId());
        }
        return flag1 && flag2;
    }
}

