/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.identity.organ.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.identity.organ.feign.RemoteAssigneeChooseEyService;
import com.jxdinfo.hussar.identity.organ.model.BpmTreeModel;
import com.jxdinfo.hussar.identity.organ.service.AssigneeEyService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/remoteEyAssignee"})
public class RemoteAssigneeEyController
implements RemoteAssigneeChooseEyService {
    @Autowired
    private AssigneeEyService assigneeService;

    @GetMapping(value={"/user"})
    public List<BpmTreeModel> userTree(@RequestParam(value="id", defaultValue="11") String id, @RequestParam(value="isMainPost") boolean isMainPost, @RequestParam(value="userId") String userId, @RequestParam(value="isSecurity") boolean isSecurity) {
        return this.assigneeService.userTree(id, isMainPost, userId, isSecurity);
    }

    @GetMapping(value={"/dept"})
    public List<BpmTreeModel> deptTree(@RequestParam String id) {
        return this.assigneeService.deptTree(id);
    }

    @GetMapping(value={"/userDetail"})
    public List<BpmTreeModel> userDetail(@RequestParam(value="userIds") String userIds) {
        if (StringUtils.isEmpty((Object)userIds)) {
            return new ArrayList<BpmTreeModel>();
        }
        return this.assigneeService.userDetail(Arrays.asList(userIds.split(",")));
    }

    @GetMapping(value={"/userDeptDetail"})
    public List<BpmTreeModel> userDeptDetail(@RequestParam(value="userId") String userId) {
        if (StringUtils.isEmpty((Object)userId)) {
            return new ArrayList<BpmTreeModel>();
        }
        return this.assigneeService.userDeptDetail(userId);
    }

    @GetMapping(value={"/getRealCondition"})
    public String getRealCondition(@RequestParam(value="condition") String condition) {
        return this.assigneeService.getRealCondition(condition);
    }

    @GetMapping(value={"/getSecurityLevel"})
    public String getSecurityLevel(@RequestParam(value="userId") String userId) {
        return String.valueOf(this.assigneeService.getSecurityLevel(userId));
    }

    @PostMapping(value={"/queryDeptTreeByDeptName"})
    public List<BpmTreeModel> queryDeptTreeByDeptName(@RequestParam(value="organName") String organName) {
        return this.assigneeService.queryDeptTreeByDeptName(organName);
    }

    @PostMapping(value={"/queryUserTreeByUserName"})
    public List<BpmTreeModel> queryUserTreeByUserName(@RequestParam(value="organName") String organName) {
        return this.assigneeService.queryUserTreeByUserName(organName);
    }

    @PostMapping(value={"/queryUserListByUserName"})
    public List<BpmTreeModel> queryUserListByUserName(@RequestParam(value="organName") String organName) {
        return this.assigneeService.queryUserListByUserName(organName);
    }

    @PostMapping(value={"/queryUserTree"})
    public List<BpmTreeModel> queryUserTree(@RequestParam(value="organName") String organName) {
        return this.assigneeService.queryUserTree(organName);
    }

    @PostMapping(value={"/getUserListByParentId"})
    public Page<BpmTreeModel> getUserListByParentId(@RequestBody Page<BpmTreeModel> page, @RequestParam(value="organId", required=false) String organId) {
        return this.assigneeService.getUserListByParentId(page, organId);
    }

    @PostMapping(value={"/getUserListByUserId"})
    public Page<BpmTreeModel> getUserListByUserId(@RequestBody Page<BpmTreeModel> page, @RequestParam(value="organId", required=false) String organId) {
        return this.assigneeService.getUserListByUserId(page, organId);
    }

    @PostMapping(value={"/queryAssigneeAndDept"})
    public List<BpmTreeModel> queryAssigneeAndDept(@RequestBody List<String> users, @RequestParam(value="organName", required=false) String organName) {
        return this.assigneeService.queryAssigneeAndDept(users, organName);
    }

    @PostMapping(value={"/getNodeAssigneeListByParentId"})
    public Page<BpmTreeModel> getNodeAssigneeListByParentId(@RequestBody Page<BpmTreeModel> pages, @RequestParam(value="organId", required=false) String organId, @RequestParam(value="users") String users) {
        return this.assigneeService.getNodeAssigneeListByParentId(pages, organId, Arrays.asList(users.split(",")));
    }

    @PostMapping(value={"/getNodeAssigneeListByUserId"})
    public Page<BpmTreeModel> getNodeAssigneeListByUserId(@RequestBody Page<BpmTreeModel> pages, @RequestParam(value="organId", required=false) String organId, @RequestParam(value="users") String users) {
        return this.assigneeService.getNodeAssigneeListByUserId(pages, organId);
    }

    @PostMapping(value={"/getSameLevelDeptIdByUserId"})
    public String getSameLevelDeptIdByUserId(@RequestParam(value="userId") String userId) {
        return this.assigneeService.getSameLevelDeptIdByUserId(userId);
    }

    @PostMapping(value={"/getParentDeptIdByUserId"})
    public String getParentDeptIdByUserId(@RequestParam(value="userId") String userId) {
        return this.assigneeService.getParentDeptIdByUserId(userId);
    }

    @PostMapping(value={"/getDeptIdByUserIds"})
    public String getDeptIdByUserIds(@RequestParam(value="userId") String userId) {
        return this.assigneeService.getDeptIdByUserIds(userId);
    }

    @PostMapping(value={"/getSameLevelDeptIdByUserIds"})
    public String getSameLevelDeptIdByUserIds(@RequestParam(value="userId") String userId) {
        return this.assigneeService.getSameLevelDeptIdByUserIds(userId);
    }

    @PostMapping(value={"/getParentDeptIdByUserIds"})
    public String getParentDeptIdByUserIds(@RequestParam(value="userId") String userId) {
        return this.assigneeService.getParentDeptIdByUserIds(userId);
    }

    @GetMapping(value={"/getCandidateUser"})
    public List<String> getCandidateUser(@RequestParam(value="condition") String condition, @RequestParam(value="securityLevel", required=false) Integer securityLevel, @RequestParam(value="isConditionFullSql") boolean isConditionFullSql) {
        return this.assigneeService.getCandidateUser(condition, securityLevel, isConditionFullSql);
    }
}

