/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.identity.organ.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.identity.organ.dto.AddStaffDto;
import com.jxdinfo.hussar.identity.organ.dto.EditStaffDto;
import com.jxdinfo.hussar.identity.organ.dto.QueryAssistPostDto;
import com.jxdinfo.hussar.identity.organ.dto.QueryStaffDto;
import com.jxdinfo.hussar.identity.organ.dto.TransferStaffDto;
import com.jxdinfo.hussar.identity.organ.service.IHussarBaseStaffService;
import com.jxdinfo.hussar.identity.organ.vo.OrganizationVo;
import com.jxdinfo.hussar.identity.organ.vo.StaffInfoVo;
import com.jxdinfo.hussar.identity.organ.vo.StaffListVo;
import com.jxdinfo.hussar.identity.organ.vo.StaffPartialVo;
import com.jxdinfo.hussar.identity.organ.vo.StaffTreeVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import com.jxdinfo.hussar.support.security.core.annotation.CheckSafe;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u65b0\u7248\u4eba\u5458\u7ba1\u7406"})
@RestController(value="com.jxdinfo.hussar.identity.organ.controller.hussarBaseStaffController")
@RequestMapping(value={"/hussarBase/authorization/staff"})
public class HussarBaseStaffController {
    @Autowired
    private IHussarBaseStaffService staffService;

    @ApiOperation(value="\u61d2\u52a0\u8f7d\u4eba\u5458\u90e8\u95e8\u7684\u4e0b\u7ea7\u90e8\u95e8", notes="\u61d2\u52a0\u8f7d\u4eba\u5458\u90e8\u95e8\u7684\u4e0b\u7ea7\u90e8\u95e8")
    @CheckPermission(value={"hussarBase:authorization:staff:lazyLoadingStaffTree"})
    @GetMapping(value={"/lazyLoadingStaffTree"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u61d2\u52a0\u8f7d\u4eba\u5458\u90e8\u95e8\u7684\u4e0b\u7ea7\u90e8\u95e8", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<StaffTreeVo>> lazyLoadingStaffTree(@ApiParam(value="\u4eba\u5458\u6240\u5728\u673a\u6784id") @RequestParam Long parentId) {
        return this.staffService.lazyLoadingStaffTree(parentId);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u5458\u5de5\u4fe1\u606f\u5217\u8868", notes="\u83b7\u53d6\u5f53\u524d\u5458\u5de5\u4fe1\u606f\u5217\u8868")
    @CheckPermission(value={"hussarBase:authorization:staff:staffList"})
    @GetMapping(value={"/staffList"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u83b7\u53d6\u5f53\u524d\u5458\u5de5\u4fe1\u606f\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<StaffListVo>> staffList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u4eba\u5458dto") QueryStaffDto queryStaffDto) {
        return this.staffService.queryStaff(pageInfo, queryStaffDto);
    }

    @ApiOperation(value="\u67e5\u8be2\u9700\u8981\u6392\u5e8f\u7684\u4eba\u5458\u6811", notes="\u67e5\u8be2\u9700\u8981\u6392\u5e8f\u7684\u4eba\u5458\u6811")
    @CheckPermission(value={"hussarBase:authorization:staff:getOrderStaffTree"})
    @GetMapping(value={"/getOrderStaffTree"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u67e5\u8be2\u9700\u8981\u6392\u5e8f\u7684\u7ec4\u7ec7\u673a\u6784\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<StaffTreeVo>> getOrderStaffTree(@ApiParam(value="\u4e0a\u7ea7") @RequestParam Long parentId) {
        return this.staffService.getOrderStaffTree(parentId);
    }

    @ApiOperation(value="\u9009\u62e9\u4eba\u5458", notes="\u9009\u62e9\u4eba\u5458")
    @GetMapping(value={"/selectStaffTree"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u9009\u62e9\u4eba\u5458", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<StaffTreeVo>> selectStaffTree(@ApiParam(value="\u4e0a\u7ea7") @RequestParam Long parentId) {
        return this.staffService.selectStaffTree(parentId);
    }

    @ApiOperation(value="\u70b9\u51fb\u7ec4\u7ec7\u673a\u6784\u8fd4\u56de\u4eba\u5458\u7ec4\u7ec7\u673a\u6784\u6811", notes="\u70b9\u51fb\u7ec4\u7ec7\u673a\u6784\u8fd4\u56de\u4eba\u5458\u7ec4\u7ec7\u673a\u6784\u6811")
    @CheckPermission(value={"hussarBase:authorization:staff:backStaffTree"})
    @GetMapping(value={"/backStaffTree"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u70b9\u51fb\u7ec4\u7ec7\u673a\u6784\u8fd4\u56de\u7ec4\u7ec7\u673a\u6784\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<StaffTreeVo>> backStaffTree(@ApiParam(value="\u9009\u4e2d\u8282\u70b9") @RequestParam(value="id") Long id) {
        return this.staffService.backStaffTree(id);
    }

    @ApiOperation(value="\u65b0\u589e\u4eba\u5458", notes="\u65b0\u589e\u4eba\u5458")
    @PostMapping(value={"/addStaff"})
    @CheckPermission(value={"hussarBase:authorization:staff:addStaff"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u65b0\u589e\u4eba\u5458", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Long> addStaff(@ApiParam(value="\u65b0\u589e\u4eba\u5458DTO") @RequestBody AddStaffDto addStaffDto) {
        return this.staffService.addStaff(addStaffDto);
    }

    @ApiOperation(value="\u4fee\u6539\u4eba\u5458", notes="\u4fee\u6539\u4eba\u5458")
    @PostMapping(value={"/editStaff"})
    @CheckPermission(value={"hussarBase:authorization:staff:editStaff"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u4fee\u6539\u4eba\u5458", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> editStaff(@ApiParam(value="\u4fee\u6539\u4eba\u5458DTO") @RequestBody EditStaffDto editStaffDto) {
        return this.staffService.editStaff(editStaffDto);
    }

    @ApiOperation(value="\u4eba\u5458\u4fe1\u606f\u67e5\u770b", notes="\u4eba\u5458\u4fe1\u606f\u67e5\u770b")
    @GetMapping(value={"/viewStaff"})
    @CheckPermission(value={"hussarBase:authorization:staff:viewStaff"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u4eba\u5458\u4fe1\u606f\u67e5\u770b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<StaffPartialVo> viewStaff(@ApiParam(value="\u4eba\u5458ID") @RequestParam Long id) {
        return this.staffService.viewStaff(id);
    }

    @ApiOperation(value="\u6839\u636eID\u83b7\u53d6\u4eba\u5458\u8be6\u7ec6\u4fe1\u606f", notes="\u6839\u636eID\u83b7\u53d6\u4eba\u5458\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/loadStaff"})
    @CheckPermission(value={"hussarBase:authorization:staff:loadStaff"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u6839\u636eID\u83b7\u53d6\u4eba\u5458\u8be6\u7ec6\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<StaffInfoVo> loadStaff(@ApiParam(value="\u4eba\u5458ID") @RequestParam Long id) {
        return this.staffService.loadStaff(id);
    }

    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u4eba\u5458", notes="\u6839\u636eID\u5220\u9664\u4eba\u5458")
    @CheckPermission(value={"hussarBase:authorization:staff:deleteStaff"})
    @PostMapping(value={"/deleteStaff"})
    @CheckSafe
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u6839\u636eID\u5220\u9664\u4eba\u5458", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<String> deleteStaff(@ApiParam(value="\u4eba\u5458ID") @RequestBody Long id) {
        return this.staffService.deleteStaff(id);
    }

    @ApiOperation(value="\u4fdd\u5b58\u4eba\u5458\u6392\u5e8f", notes="\u4fdd\u5b58\u4eba\u5458\u6392\u5e8f")
    @PostMapping(value={"/sortStaff"})
    @CheckPermission(value={"hussarBase:authorization:staff:sortStaff"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u4eba\u5458\u6392\u5e8f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> sortStaff(@ApiParam(value="\u4eba\u5458id\u96c6\u5408") @RequestBody List<Long> idList) {
        return this.staffService.sortStaff(idList);
    }

    @ApiOperation(value="\u8f6c\u79fb\u4eba\u5458", notes="\u8f6c\u79fb\u4eba\u5458")
    @PostMapping(value={"/transferStaff"})
    @CheckPermission(value={"hussarBase:authorization:staff:transferStaff"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u8f6c\u79fb\u4eba\u5458", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> transferStaff(@ApiParam(value="\u7ec4\u7ec7\u8f6c\u79fbdto") @RequestBody TransferStaffDto transferStaffDto) {
        return this.staffService.transferStaff(transferStaffDto);
    }

    @ApiOperation(value="\u6839\u636e\u4eba\u5458ID\u83b7\u53d6\u517c\u804c\u5c97\u4f4d\u5217\u8868", notes="\u6839\u636e\u4eba\u5458ID\u83b7\u53d6\u517c\u804c\u5c97\u4f4d\u5217\u8868")
    @GetMapping(value={"/loadAssistPostByStaffId"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u6839\u636e\u4eba\u5458ID\u83b7\u53d6\u517c\u804c\u5c97\u4f4d\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<OrganizationVo>> loadAssistPostByStaffId(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u517c\u804c\u5c97\u4f4dDTO") QueryAssistPostDto queryAssistPostDto) {
        return this.staffService.loadAssistPostByStaffId(pageInfo, queryAssistPostDto);
    }
}

