/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.identity.organ.controller;

import com.jxdinfo.hussar.identity.organ.model.BpmTreeModel;
import com.jxdinfo.hussar.identity.organ.service.AssigneeEyService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/assignee"})
public class AssigneeEyController {
    @Autowired
    private AssigneeEyService assigneeEyService;

    @GetMapping(value={"/user"})
    public List<BpmTreeModel> userTree(@RequestParam(value="id", defaultValue="11") String id) {
        return this.assigneeEyService.userTree(id, false, null, false);
    }

    @GetMapping(value={"/dept"})
    public List<BpmTreeModel> deptTree(@RequestParam String id) {
        return this.assigneeEyService.deptTree(id);
    }

    @GetMapping(value={"/userDetail"})
    public List<BpmTreeModel> userDetail(String userIds) {
        if (StringUtils.isEmpty((Object)userIds)) {
            return new ArrayList<BpmTreeModel>();
        }
        return this.assigneeEyService.userDetail(Arrays.asList(userIds.split(",")));
    }

    @GetMapping(value={"/userDeptDetail"})
    public List<BpmTreeModel> userDeptDetail(String userId) {
        if (StringUtils.isEmpty((Object)userId)) {
            return new ArrayList<BpmTreeModel>();
        }
        return this.assigneeEyService.userDeptDetail(userId);
    }

    @GetMapping(value={"/getRealCondition"})
    public String getRealCondition(String condition, String serviceName, Map<String, String> processInfo) {
        return this.assigneeEyService.getRealCondition(condition);
    }

    @GetMapping(value={"/getSecurityLevel"})
    public String getSecurityLevel(String userId) {
        return String.valueOf(this.assigneeEyService.getSecurityLevel(userId));
    }
}

