/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.sdk.server.service.impl.permission;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRole;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.service.ISysPostRoleService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostService;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.iam.common.server.util.ApplicationUtils;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkQueryRoleDto;
import com.jxdinfo.hussar.iam.sdk.api.enums.SdkDelStatusEnum;
import com.jxdinfo.hussar.iam.sdk.api.service.permission.IHussarIamSdkRoleService;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkOrganRoleVo;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkPostRoleVo;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkRoleGroupVo;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkRoleSourceDetailVo;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkRoleVo;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkUserRelateRoleDetailVo;
import com.jxdinfo.hussar.iam.sdk.server.dao.permission.HussarIamRoleMapper;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HussarIamSdkRoleServiceImpl
implements IHussarIamSdkRoleService {
    @Autowired
    private ISysRoleGroupService sysRoleGroupService;
    @Autowired
    private ISysRolesService sysRolesService;
    @Autowired
    private ISysPostRoleService sysPostRoleService;
    @Autowired
    private ISysStruRoleService sysStruRoleService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private ISysStruUserService sysStruUserService;
    @Autowired
    private ISysUserPostService sysUserPostService;
    @Resource
    private HussarIamRoleMapper hussarIamRoleMapper;

    public List<IamSdkRoleGroupVo> groupList(String groupName) {
        ArrayList<IamSdkRoleGroupVo> result = new ArrayList<IamSdkRoleGroupVo>();
        Long appId = ApplicationUtils.getApplicationId();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(HussarUtils.isNotEmpty((Object)groupName), SysRoleGroup::getGroupName, (Object)groupName)).eq(SysRoleGroup::getAppId, (Object)appId)).orderByAsc(HussarBaseEntity::getCreateTime);
        List roleGroups = this.sysRoleGroupService.list((Wrapper)wrapper);
        if (HussarUtils.isNotEmpty((Object)roleGroups)) {
            for (SysRoleGroup group : roleGroups) {
                IamSdkRoleGroupVo groupVo = new IamSdkRoleGroupVo();
                groupVo.setId(group.getId());
                groupVo.setName(group.getGroupName());
                result.add(groupVo);
            }
        }
        return result;
    }

    public List<IamSdkRoleVo> getByPostId(Long postId) {
        List<IamSdkRoleVo> result = new ArrayList<IamSdkRoleVo>();
        Long appId = ApplicationUtils.getApplicationId();
        List postRoles = this.sysPostRoleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPostRole::getPostId, (Object)postId)).eq(HussarDelflagEntity::getDelFlag, (Object)SdkDelStatusEnum.NORMAL.getStatus()));
        if (HussarUtils.isEmpty((Object)postRoles)) {
            return Collections.emptyList();
        }
        List<Long> roleIds = postRoles.stream().map(SysPostRole::getRoleId).distinct().collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(roleIds)) {
            result = this.getRoleVoByRoleIds(roleIds, appId);
        }
        return result;
    }

    public List<IamSdkRoleVo> getByOrganId(Long organId) {
        List<IamSdkRoleVo> result = new ArrayList<IamSdkRoleVo>();
        Long appId = ApplicationUtils.getApplicationId();
        List struRoles = this.sysStruRoleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruRole::getStruId, (Object)organId)).eq(HussarDelflagEntity::getDelFlag, (Object)SdkDelStatusEnum.NORMAL.getStatus()));
        if (HussarUtils.isEmpty((Object)struRoles)) {
            return Collections.emptyList();
        }
        List<Long> roleIds = struRoles.stream().map(SysStruRole::getGrantedRole).distinct().collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(roleIds)) {
            result = this.getRoleVoByRoleIds(roleIds, appId);
        }
        return result;
    }

    public List<IamSdkRoleVo> getByUserId(Long userId) {
        List<IamSdkRoleVo> result = new ArrayList<IamSdkRoleVo>();
        Long appId = ApplicationUtils.getApplicationId();
        List userRoles = this.sysUserRoleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)userId)).eq(SysUserRole::getAdminOption, (Object)"1"));
        if (HussarUtils.isEmpty((Object)userRoles)) {
            return Collections.emptyList();
        }
        List<Long> roleIds = userRoles.stream().map(SysUserRole::getGrantedRole).distinct().collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(roleIds)) {
            result = this.getRoleVoByRoleIds(roleIds, appId);
        }
        return result;
    }

    public IamSdkUserRelateRoleDetailVo getUserRelateRoleDetail(Long userId) {
        Long appId = ApplicationUtils.getApplicationId();
        IamSdkUserRelateRoleDetailVo result = new IamSdkUserRelateRoleDetailVo();
        IamSdkRoleSourceDetailVo roleSourceDetail = new IamSdkRoleSourceDetailVo();
        ArrayList<Object> roleIdList = new ArrayList<Object>();
        List<Object> allRoles = new ArrayList();
        List<Object> postRoles = new ArrayList();
        List<Object> organRoles = new ArrayList();
        List<IamSdkRoleVo> roles = this.getByUserId(userId);
        roleSourceDetail.setRoles(roles);
        List userRoles = this.sysUserRoleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)userId)).eq(SysUserRole::getAdminOption, (Object)"1"));
        List roleIds = userRoles.stream().map(SysUserRole::getGrantedRole).distinct().collect(Collectors.toList());
        roleIdList.addAll(roleIds);
        List struUsers = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)userId)).eq(HussarDelflagEntity::getDelFlag, (Object)SdkDelStatusEnum.NORMAL.getStatus()));
        List<Long> struIds = struUsers.stream().map(SysStruUser::getStruId).distinct().collect(Collectors.toList());
        if (HussarUtils.isEmpty(struIds)) {
            roleSourceDetail.setOrganRoles(organRoles);
        } else {
            List struRoles = this.sysStruRoleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruRole::getStruId, struIds)).eq(HussarDelflagEntity::getDelFlag, (Object)SdkDelStatusEnum.NORMAL.getStatus()));
            if (HussarUtils.isEmpty((Object)struRoles)) {
                roleSourceDetail.setOrganRoles(organRoles);
            } else {
                List<Long> sRoleIds = struRoles.stream().map(SysStruRole::getGrantedRole).distinct().collect(Collectors.toList());
                roleIdList.addAll(sRoleIds);
                organRoles = this.getRoleVoByOrganIds(struIds, struRoles, sRoleIds, appId);
                roleSourceDetail.setOrganRoles(organRoles);
            }
        }
        List userPosts = this.sysUserPostService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserPost::getUserId, (Object)userId)).eq(HussarDelflagEntity::getDelFlag, (Object)SdkDelStatusEnum.NORMAL.getStatus()));
        List<Long> postIds = userPosts.stream().map(SysUserPost::getPostId).distinct().collect(Collectors.toList());
        if (HussarUtils.isEmpty(postIds)) {
            roleSourceDetail.setPostRoles(postRoles);
        } else {
            List postRoleList = this.sysPostRoleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysPostRole::getPostId, postIds)).eq(HussarDelflagEntity::getDelFlag, (Object)SdkDelStatusEnum.NORMAL.getStatus()));
            if (HussarUtils.isEmpty((Object)postRoleList)) {
                roleSourceDetail.setPostRoles(postRoles);
            } else {
                List<Long> pRoleIds = postRoleList.stream().map(SysPostRole::getRoleId).distinct().collect(Collectors.toList());
                roleIdList.addAll(pRoleIds);
                postRoles = this.getRoleVoByPostIds(postIds, postRoleList, pRoleIds, appId);
                roleSourceDetail.setPostRoles(postRoles);
            }
        }
        result.setRoleSourceDetail(roleSourceDetail);
        List<Long> list = roleIdList.stream().distinct().collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(list)) {
            allRoles = this.getRoleVoByRoleIds(list, appId);
        }
        result.setRoles(allRoles);
        return result;
    }

    public List<IamSdkRoleVo> roleList(IamSdkQueryRoleDto queryRoleDto) {
        Long appId = ApplicationUtils.getApplicationId();
        Long groupId = queryRoleDto.getGroupId();
        String roleName = queryRoleDto.getRoleName();
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("groupId", groupId);
        queryParams.put("roleName", roleName);
        queryParams.put("appId", appId);
        return this.hussarIamRoleMapper.roleList(queryParams);
    }

    public Page<IamSdkRoleVo> rolePage(IamSdkQueryRoleDto queryRoleDto) {
        Long appId = ApplicationUtils.getApplicationId();
        Long current = queryRoleDto.getCurrent();
        Long size = queryRoleDto.getSize();
        Long groupId = queryRoleDto.getGroupId();
        String roleName = queryRoleDto.getRoleName();
        Page page = new Page();
        page.setCurrent(current.longValue());
        page.setSize(size.longValue());
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("groupId", groupId);
        queryParams.put("roleName", roleName);
        queryParams.put("appId", appId);
        List<IamSdkRoleVo> roleList = this.hussarIamRoleMapper.rolePage((Page<IamSdkRoleVo>)page, queryParams);
        page.setRecords(roleList);
        return page;
    }

    private List<IamSdkRoleVo> getRoleVoByRoleIds(List<Long> roleIds, Long appId) {
        ArrayList<IamSdkRoleVo> result = new ArrayList<IamSdkRoleVo>();
        LambdaQueryWrapper relationWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysRoles::getId, roleIds);
        ((LambdaQueryWrapper)relationWrapper.eq(SysRoles::getAppId, (Object)appId)).orderByAsc(SysRoles::getRoleOrder);
        List rolesList = this.sysRolesService.list((Wrapper)relationWrapper);
        if (HussarUtils.isNotEmpty((Object)rolesList)) {
            for (SysRoles role : rolesList) {
                IamSdkRoleVo roleVo = new IamSdkRoleVo();
                roleVo.setId(role.getId());
                roleVo.setName(role.getRoleName());
                roleVo.setGroupId(role.getGroupId());
                result.add(roleVo);
            }
        }
        return result;
    }

    private List<IamSdkOrganRoleVo> getRoleVoByOrganIds(List<Long> organIds, List<SysStruRole> struRoles, List<Long> roleIds, Long appId) {
        ArrayList<IamSdkOrganRoleVo> result = new ArrayList<IamSdkOrganRoleVo>();
        Map struRoleIds = struRoles.stream().collect(Collectors.groupingBy(SysStruRole::getStruId, Collectors.mapping(SysStruRole::getGrantedRole, Collectors.toList())));
        LambdaQueryWrapper relationWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysRoles::getId, roleIds);
        ((LambdaQueryWrapper)relationWrapper.eq(SysRoles::getAppId, (Object)appId)).orderByAsc(SysRoles::getRoleOrder);
        List rolesList = this.sysRolesService.list((Wrapper)relationWrapper);
        Map map = rolesList.stream().collect(Collectors.toMap(SysRoles::getId, Function.identity()));
        if (HussarUtils.isNotEmpty((Object)rolesList)) {
            for (Long struId : organIds) {
                List roleIdList = struRoleIds.get(struId);
                if (!HussarUtils.isNotEmpty(roleIdList)) continue;
                ArrayList<IamSdkRoleVo> roleVos = new ArrayList<IamSdkRoleVo>();
                for (Long roleId : roleIdList) {
                    IamSdkRoleVo roleVo = new IamSdkRoleVo();
                    SysRoles role = (SysRoles)map.get(roleId);
                    if (HussarUtils.isEmpty((Object)role)) continue;
                    roleVo.setId(role.getId());
                    roleVo.setName(role.getRoleName());
                    roleVo.setGroupId(role.getGroupId());
                    roleVos.add(roleVo);
                }
                if (!HussarUtils.isNotEmpty(roleVos)) continue;
                IamSdkOrganRoleVo vo = new IamSdkOrganRoleVo();
                vo.setOrganId(struId);
                vo.setRoles(roleVos);
                result.add(vo);
            }
        }
        return result;
    }

    private List<IamSdkPostRoleVo> getRoleVoByPostIds(List<Long> postIds, List<SysPostRole> postRoles, List<Long> roleIds, Long appId) {
        ArrayList<IamSdkPostRoleVo> result = new ArrayList<IamSdkPostRoleVo>();
        Map postRoleIds = postRoles.stream().collect(Collectors.groupingBy(SysPostRole::getPostId, Collectors.mapping(SysPostRole::getRoleId, Collectors.toList())));
        LambdaQueryWrapper relationWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysRoles::getId, roleIds);
        ((LambdaQueryWrapper)relationWrapper.eq(SysRoles::getAppId, (Object)appId)).orderByAsc(SysRoles::getRoleOrder);
        List rolesList = this.sysRolesService.list((Wrapper)relationWrapper);
        Map map = rolesList.stream().collect(Collectors.toMap(SysRoles::getId, Function.identity()));
        if (HussarUtils.isNotEmpty((Object)rolesList)) {
            for (Long postId : postIds) {
                List roleIdList = postRoleIds.get(postId);
                if (!HussarUtils.isNotEmpty(roleIdList)) continue;
                ArrayList<IamSdkRoleVo> roleVos = new ArrayList<IamSdkRoleVo>();
                for (Long roleId : roleIdList) {
                    IamSdkRoleVo roleVo = new IamSdkRoleVo();
                    SysRoles role = (SysRoles)map.get(roleId);
                    if (HussarUtils.isEmpty((Object)role)) continue;
                    roleVo.setId(role.getId());
                    roleVo.setName(role.getRoleName());
                    roleVo.setGroupId(role.getGroupId());
                    roleVos.add(roleVo);
                }
                if (!HussarUtils.isNotEmpty(roleVos)) continue;
                IamSdkPostRoleVo vo = new IamSdkPostRoleVo();
                vo.setPostId(postId);
                vo.setRoles(roleVos);
                result.add(vo);
            }
        }
        return result;
    }
}

