/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.sdk.server.service.impl.permission;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.iam.common.api.exception.IamSdkPermissionException;
import com.jxdinfo.hussar.iam.common.server.util.ApplicationUtils;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkQueryFunctionDto;
import com.jxdinfo.hussar.iam.sdk.api.service.permission.IHussarIamSdkFunctionService;
import com.jxdinfo.hussar.iam.sdk.api.service.permission.IHussarIamSdkRoleService;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkFunctionModuleVo;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkFunctionVo;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkRoleVo;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkUserRelateRoleDetailVo;
import com.jxdinfo.hussar.iam.sdk.server.dao.permission.HussarIamFunctionMapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.iam.sdk.server.hussarIamSdkFunctionServiceImpl")
public class HussarIamSdkFunctionServiceImpl
implements IHussarIamSdkFunctionService {
    @Autowired
    private ISysRoleFunctionsService sysRoleFunctionsService;
    @Autowired
    private ISysFunctionsService sysFunctionsService;
    @Autowired
    private ISysFunctionModulesService sysFunctionModulesService;
    @Resource
    private HussarIamFunctionMapper hussarIamFunctionMapper;
    @Autowired
    private IHussarIamSdkRoleService hussarIamSdkRoleService;

    public List<IamSdkFunctionVo> getByUserId(Long userId) {
        IamSdkUserRelateRoleDetailVo userRelateRoleDetail = this.hussarIamSdkRoleService.getUserRelateRoleDetail(userId);
        List roles = userRelateRoleDetail.getRoles();
        List<Long> roleIds = roles.stream().map(IamSdkRoleVo::getId).collect(Collectors.toList());
        return this.getByRoleIds(roleIds);
    }

    public List<IamSdkFunctionVo> getByRoleId(Long roleId) {
        if (HussarUtils.isEmpty((Object)roleId)) {
            throw new IamSdkPermissionException("\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList<Long> roleIds = new ArrayList<Long>();
        roleIds.add(roleId);
        return this.getByRoleIds(roleIds);
    }

    public List<IamSdkFunctionVo> getByRoleIds(List<Long> roleIds) {
        if (HussarUtils.isEmpty(roleIds)) {
            throw new IamSdkPermissionException("\u89d2\u8272id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Long appId = ApplicationUtils.getApplicationId();
        List functions = this.sysFunctionsService.list((Wrapper)new LambdaQueryWrapper().eq(SysFunctions::getApplicationId, (Object)appId));
        Map<Long, SysFunctions> funcMap = functions.stream().collect(Collectors.toMap(SysFunctions::getId, f -> f));
        List funcIds = functions.stream().map(SysFunctions::getId).collect(Collectors.toList());
        LambdaQueryWrapper multiQueryWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysRoleFunctions::getFunctionId, funcIds);
        multiQueryWrapper.in(SysRoleFunctions::getRoleId, roleIds);
        List sysRoleFunctions = this.sysRoleFunctionsService.list((Wrapper)multiQueryWrapper);
        ArrayList<IamSdkFunctionVo> functionVos = new ArrayList<IamSdkFunctionVo>();
        if (HussarUtils.isNotEmpty((Object)sysRoleFunctions)) {
            sysRoleFunctions.forEach(roleFunction -> {
                IamSdkFunctionVo vo = new IamSdkFunctionVo();
                Long funcId = roleFunction.getFunctionId();
                vo.setFunctionId(funcId);
                vo.setFunctionName(((SysFunctions)funcMap.get(funcId)).getFunctionName());
                vo.setFunctionCode(((SysFunctions)funcMap.get(funcId)).getFunctionCode());
                functionVos.add(vo);
            });
        }
        return functionVos;
    }

    public List<IamSdkFunctionVo> list(IamSdkQueryFunctionDto iamSdkQueryFunctionDto) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("appId", ApplicationUtils.getApplicationId());
        queryParams.put("functionName", StringUtil.trimToEmpty((CharSequence)iamSdkQueryFunctionDto.getFunctionName()));
        queryParams.put("functionCode", StringUtil.trimToEmpty((CharSequence)iamSdkQueryFunctionDto.getFunctionCode()));
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        Long moduleId = iamSdkQueryFunctionDto.getModuleId();
        if (HussarUtils.isNotEmpty((Object)moduleId)) {
            queryParams.put("moduleId", moduleId);
        }
        return this.hussarIamFunctionMapper.getFunctionList(queryParams);
    }

    public Page<IamSdkFunctionVo> page(IamSdkQueryFunctionDto iamSdkQueryFunctionDto) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("appId", ApplicationUtils.getApplicationId());
        queryParams.put("functionName", StringUtil.trimToEmpty((CharSequence)iamSdkQueryFunctionDto.getFunctionName()));
        queryParams.put("functionCode", StringUtil.trimToEmpty((CharSequence)iamSdkQueryFunctionDto.getFunctionCode()));
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        Long moduleId = iamSdkQueryFunctionDto.getModuleId();
        if (HussarUtils.isNotEmpty((Object)moduleId)) {
            queryParams.put("moduleId", moduleId);
        }
        PageInfo pageInfo = new PageInfo(iamSdkQueryFunctionDto.getCurrent().longValue(), iamSdkQueryFunctionDto.getSize().longValue());
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        return this.hussarIamFunctionMapper.getFunctionPageList((Page<IamSdkFunctionVo>)page, queryParams);
    }

    public List<IamSdkFunctionModuleVo> getFunctionModule(Long moduleId) {
        ArrayList<IamSdkFunctionModuleVo> result = new ArrayList<IamSdkFunctionModuleVo>();
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)moduleId)) {
            lambdaQueryWrapper.eq(SysFunctionModules::getParentModuleId, (Object)moduleId);
        }
        lambdaQueryWrapper.eq(SysFunctionModules::getApplicationId, (Object)ApplicationUtils.getApplicationId());
        lambdaQueryWrapper.orderByAsc(SysFunctionModules::getSeq);
        List functionModules = this.sysFunctionModulesService.list((Wrapper)lambdaQueryWrapper);
        if (HussarUtils.isNotEmpty((Object)functionModules)) {
            functionModules.forEach(module -> {
                IamSdkFunctionModuleVo vo = new IamSdkFunctionModuleVo();
                vo.setFunctionModuleId(module.getId());
                vo.setFunctionModuleName(module.getFunctionModuleName());
                vo.setFunctionModuleCode(module.getFunctionModuleCode());
                vo.setParentModuleId(module.getParentModuleId());
                vo.setSeq(module.getSeq());
                result.add(vo);
            });
        }
        return result;
    }
}

