/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.sdk.server.controller.sync;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.iam.common.api.response.IamSdkApiResponse;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkPageInfo;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkUserDto;
import com.jxdinfo.hussar.iam.sdk.api.service.sync.IHussarIamSdkSyncUserService;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkDataMapping;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkUserInfoVo;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u7528\u6237\u540c\u6b65\u63a5\u53e3")
@RestController
@RequestMapping(value={"/iam/sdk/sync/user"})
public class HussarIamSdkSyncUserController {
    @Resource
    private IHussarIamSdkSyncUserService hussarIamSdkSyncUserService;

    @ApiOperation(value="\u7528\u6237\u540c\u6b65-\u5206\u9875\u83b7\u53d6\u7528\u6237", notes="\u7528\u6237\u540c\u6b65-\u5206\u9875\u83b7\u53d6\u7528\u6237")
    @AuditLog(moduleName="\u7528\u6237\u540c\u6b65\u63a5\u53e3", eventDesc="\u7528\u6237\u540c\u6b65-\u5206\u9875\u83b7\u53d6\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:sync:user:getAllUserInfo"})
    @PostMapping(value={"/getAllUserInfo"})
    public IamSdkApiResponse<Page<IamSdkUserInfoVo>> getAllUserInfo(@RequestBody IamSdkPageInfo pageInfo) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkSyncUserService.getAllUserInfo(pageInfo));
    }

    @ApiOperation(value="\u7528\u6237\u540c\u6b65-\u65b0\u589e\u7528\u6237", notes="\u7528\u6237\u540c\u6b65-\u65b0\u589e\u7528\u6237")
    @AuditLog(moduleName="\u7528\u6237\u540c\u6b65\u63a5\u53e3", eventDesc="\u7528\u6237\u540c\u6b65-\u65b0\u589e\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CheckPermission(value={"iamSdk:sync:user:addUser"})
    @PostMapping(value={"/addUser"})
    public IamSdkApiResponse<IamSdkDataMapping> addUser(@RequestBody IamSdkUserDto userDto) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkSyncUserService.addUser(userDto));
    }

    @ApiOperation(value="\u7528\u6237\u540c\u6b65-\u4fee\u6539\u7528\u6237", notes="\u7528\u6237\u540c\u6b65-\u4fee\u6539\u7528\u6237")
    @AuditLog(moduleName="\u7528\u6237\u540c\u6b65\u63a5\u53e3", eventDesc="\u7528\u6237\u540c\u6b65-\u4fee\u6539\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CheckPermission(value={"iamSdk:sync:user:editUser"})
    @PostMapping(value={"/editUser"})
    public IamSdkApiResponse<Boolean> editUser(@RequestBody IamSdkUserDto userDto) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkSyncUserService.editUser(userDto));
    }

    @ApiOperation(value="\u7528\u6237\u540c\u6b65-\u5220\u9664\u7528\u6237", notes="\u7528\u6237\u540c\u6b65-\u5220\u9664\u7528\u6237")
    @AuditLog(moduleName="\u7528\u6237\u540c\u6b65\u63a5\u53e3", eventDesc="\u7528\u6237\u540c\u6b65-\u5220\u9664\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    @CheckPermission(value={"iamSdk:sync:user:deleteUser"})
    @PostMapping(value={"/deleteUser"})
    public IamSdkApiResponse<Boolean> deleteUser(@RequestBody String userId) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkSyncUserService.deleteUser(userId));
    }
}

