/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.sdk.server.controller.permission;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.iam.common.api.response.IamSdkApiResponse;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkQueryRoleDto;
import com.jxdinfo.hussar.iam.sdk.api.service.permission.IHussarIamSdkRoleService;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkRoleGroupVo;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkRoleVo;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkUserRelateRoleDetailVo;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/sdk/role"})
@Api(tags={"\u89d2\u8272\u5bf9\u5916\u63a5\u53e3"})
public class HussarIamSdkRoleController {
    @Autowired
    private IHussarIamSdkRoleService hussarIamSdkRoleService;

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u5e94\u7528\u4e0b\u89d2\u8272\u5206\u7ec4\u5217\u8868", notes="\u83b7\u53d6\u5f53\u524d\u5e94\u7528\u4e0b\u89d2\u8272\u5206\u7ec4\u5217\u8868")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u83b7\u53d6\u5f53\u524d\u5e94\u7528\u4e0b\u89d2\u8272\u5206\u7ec4\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:role:groupList"})
    @PostMapping(value={"/groupList"})
    public IamSdkApiResponse<List<IamSdkRoleGroupVo>> groupList(@RequestBody(required=false) String groupName) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkRoleService.groupList(groupName));
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u5e94\u7528\u4e0b\u5c97\u4f4d\u5173\u8054\u7684\u89d2\u8272\u5217\u8868", notes="\u67e5\u8be2\u5f53\u524d\u5e94\u7528\u4e0b\u5c97\u4f4d\u5173\u8054\u7684\u89d2\u8272\u5217\u8868")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u67e5\u8be2\u5f53\u524d\u5e94\u7528\u4e0b\u5c97\u4f4d\u5173\u8054\u7684\u89d2\u8272\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:role:getByPostId"})
    @PostMapping(value={"/getByPostId"})
    public IamSdkApiResponse<List<IamSdkRoleVo>> getByPostId(@RequestBody Long postId) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkRoleService.getByPostId(postId));
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u5e94\u7528\u4e0b\u7ec4\u7ec7\u5173\u8054\u7684\u89d2\u8272\u5217\u8868", notes="\u67e5\u8be2\u5f53\u524d\u5e94\u7528\u4e0b\u7ec4\u7ec7\u5173\u8054\u7684\u89d2\u8272\u5217\u8868")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u67e5\u8be2\u5f53\u524d\u5e94\u7528\u4e0b\u7ec4\u7ec7\u5173\u8054\u7684\u89d2\u8272\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:role:getByOrganId"})
    @PostMapping(value={"/getByOrganId"})
    public IamSdkApiResponse<List<IamSdkRoleVo>> getByOrganId(@RequestBody Long organId) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkRoleService.getByOrganId(organId));
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u5e94\u7528\u4e0b\u7528\u6237\u76f4\u63a5\u5173\u8054\u7684\u89d2\u8272\u5217\u8868", notes="\u67e5\u8be2\u5f53\u524d\u5e94\u7528\u4e0b\u7528\u6237\u76f4\u63a5\u5173\u8054\u7684\u89d2\u8272\u5217\u8868")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u67e5\u8be2\u5f53\u524d\u5e94\u7528\u4e0b\u7528\u6237\u76f4\u63a5\u5173\u8054\u7684\u89d2\u8272\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:role:getByUserId"})
    @PostMapping(value={"/getByUserId"})
    public IamSdkApiResponse<List<IamSdkRoleVo>> getByUserId(@RequestBody Long userId) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkRoleService.getByUserId(userId));
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u5e94\u7528\u4e0b\u7528\u6237\u5173\u8054\u89d2\u8272\u5217\u8868", notes="\u83b7\u53d6\u5f53\u524d\u5e94\u7528\u4e0b\u7528\u6237\u5173\u8054\u89d2\u8272\u5217\u8868")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u83b7\u53d6\u5f53\u524d\u5e94\u7528\u4e0b\u7528\u6237\u5173\u8054\u89d2\u8272\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:role:getUserRelateRoleDetail"})
    @PostMapping(value={"/getUserRelateRoleDetail"})
    public IamSdkApiResponse<IamSdkUserRelateRoleDetailVo> getUserRelateRoleDetail(@RequestBody Long userId) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkRoleService.getUserRelateRoleDetail(userId));
    }

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u5f53\u524d\u5e94\u7528\u4e0b\u89d2\u8272\u5217\u8868", notes="\u6761\u4ef6\u67e5\u8be2\u5f53\u524d\u5e94\u7528\u4e0b\u89d2\u8272\u5217\u8868")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u6761\u4ef6\u67e5\u8be2\u5f53\u524d\u5e94\u7528\u4e0b\u89d2\u8272\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:role:list"})
    @PostMapping(value={"/list"})
    public IamSdkApiResponse<List<IamSdkRoleVo>> list(@RequestBody IamSdkQueryRoleDto queryRoleDto) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkRoleService.roleList(queryRoleDto));
    }

    @ApiOperation(value="\u5206\u9875\u6761\u4ef6\u67e5\u8be2\u89d2\u8272\u5217\u8868", notes="\u5206\u9875\u6761\u4ef6\u67e5\u8be2\u89d2\u8272\u5217\u8868")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u5206\u9875\u6761\u4ef6\u67e5\u8be2\u89d2\u8272\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:role:page"})
    @PostMapping(value={"/page"})
    public IamSdkApiResponse<Page<IamSdkRoleVo>> page(@RequestBody IamSdkQueryRoleDto queryRoleDto) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkRoleService.rolePage(queryRoleDto));
    }
}

