/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.sdk.server.controller.permission;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.iam.common.api.response.IamSdkApiResponse;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkCheckResourceDto;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkCheckUrlDto;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkQueryResourceDto;
import com.jxdinfo.hussar.iam.sdk.api.service.permission.IHussarIamSdkResourceService;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkResourceModuleVo;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkResourceVo;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/sdk/resource"})
@Api(tags={"\u8d44\u6e90\u5bf9\u5916\u63a5\u53e3"})
public class HussarIamSdkResourceController {
    @Autowired
    private IHussarIamSdkResourceService hussarIamSdkResourceService;

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5173\u8054\u7684\u8d44\u6e90\u5217\u8868", notes="\u83b7\u53d6\u7528\u6237\u5173\u8054\u7684\u8d44\u6e90\u5217\u8868")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6\u7528\u6237\u5173\u8054\u7684\u8d44\u6e90\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:resource:getByUserId"})
    @PostMapping(value={"/getByUserId"})
    public IamSdkApiResponse<List<IamSdkResourceVo>> getByUserId(@RequestBody Long userId) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkResourceService.getByUserId(userId));
    }

    @ApiOperation(value="\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u67d0\u8d44\u6e90\u7684\u4f7f\u7528\u6743\u9650", notes="\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u67d0\u8d44\u6e90\u7684\u4f7f\u7528\u6743\u9650")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u67d0\u8d44\u6e90\u7684\u4f7f\u7528\u6743\u9650", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:resource:checkAuthority"})
    @PostMapping(value={"/checkAuthority"})
    public IamSdkApiResponse<Boolean> checkAuthority(@RequestBody IamSdkCheckResourceDto iamSdkCheckResourceDto) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkResourceService.checkAuthority(iamSdkCheckResourceDto));
    }

    @ApiOperation(value="\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u67d0\u63a5\u53e3\u7684\u4f7f\u7528\u6743\u9650", notes="\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u67d0\u63a5\u53e3\u7684\u4f7f\u7528\u6743\u9650")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u67d0\u63a5\u53e3\u7684\u4f7f\u7528\u6743\u9650", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:resource:checkUrlAuthority"})
    @PostMapping(value={"/checkUrlAuthority"})
    public IamSdkApiResponse<Boolean> checkUrlAuthority(@RequestBody IamSdkCheckUrlDto iamSdkCheckUrlDto) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkResourceService.checkUrlAuthority(iamSdkCheckUrlDto));
    }

    @ApiOperation(value="\u83b7\u53d6\u529f\u80fd\u4e0b\u7684\u8d44\u6e90\u5217\u8868", notes="\u83b7\u53d6\u529f\u80fd\u4e0b\u7684\u8d44\u6e90\u5217\u8868")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6\u529f\u80fd\u4e0b\u7684\u8d44\u6e90\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:resource:getByFunctionId"})
    @PostMapping(value={"/getByFunctionId"})
    public IamSdkApiResponse<List<IamSdkResourceVo>> getByFunctionId(@RequestBody Long functionId) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkResourceService.getByFunctionId(functionId));
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5173\u8054\u7684\u8d44\u6e90\u5217\u8868", notes="\u83b7\u53d6\u89d2\u8272\u5173\u8054\u7684\u8d44\u6e90\u5217\u8868")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6\u89d2\u8272\u5173\u8054\u7684\u8d44\u6e90\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:resource:getByRoleId"})
    @PostMapping(value={"/getByRoleId"})
    public IamSdkApiResponse<List<IamSdkResourceVo>> getByRoleId(@RequestBody Long roleId) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkResourceService.getByRoleId(roleId));
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u96c6\u5408\u5173\u8054\u7684\u8d44\u6e90\u5217\u8868", notes="\u83b7\u53d6\u89d2\u8272\u96c6\u5408\u5173\u8054\u7684\u8d44\u6e90\u5217\u8868")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6\u89d2\u8272\u96c6\u5408\u5173\u8054\u7684\u8d44\u6e90\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:resource:getByRoleIds"})
    @PostMapping(value={"/getByRoleIds"})
    public IamSdkApiResponse<List<IamSdkResourceVo>> getByRoleIds(@RequestBody List<Long> roleIds) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkResourceService.getByRoleIds(roleIds));
    }

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u8d44\u6e90\u5217\u8868", notes="\u6761\u4ef6\u67e5\u8be2\u8d44\u6e90\u5217\u8868")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u6761\u4ef6\u67e5\u8be2\u8d44\u6e90\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:resource:list"})
    @PostMapping(value={"/list"})
    public IamSdkApiResponse<List<IamSdkResourceVo>> list(@RequestBody IamSdkQueryResourceDto iamSdkQueryResourceDto) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkResourceService.list(iamSdkQueryResourceDto));
    }

    @ApiOperation(value="\u5206\u9875\u6761\u4ef6\u67e5\u8be2\u8d44\u6e90\u5217\u8868", notes="\u5206\u9875\u6761\u4ef6\u67e5\u8be2\u8d44\u6e90\u5217\u8868")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u5206\u9875\u6761\u4ef6\u67e5\u8be2\u8d44\u6e90\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:resource:page"})
    @PostMapping(value={"/page"})
    public IamSdkApiResponse<Page<IamSdkResourceVo>> page(@RequestBody IamSdkQueryResourceDto iamSdkQueryResourceDto) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkResourceService.page(iamSdkQueryResourceDto));
    }

    @ApiOperation(value="\u83b7\u53d6\u8d44\u6e90\u6a21\u5757\u5217\u8868", notes="\u83b7\u53d6\u8d44\u6e90\u6a21\u5757\u5217\u8868")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6\u8d44\u6e90\u6a21\u5757\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamSdk:resource:getResourceModule"})
    @PostMapping(value={"/getResourceModule"})
    public IamSdkApiResponse<List<IamSdkResourceModuleVo>> getResourceModule(@RequestBody(required=false) Long moduleId) {
        return IamSdkApiResponse.success((Object)this.hussarIamSdkResourceService.getResourceModule(moduleId));
    }
}

