/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.sdk.server.service.impl.sync;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkPageInfo;
import com.jxdinfo.hussar.iam.sdk.api.service.sync.IHussarIamSdkSyncStaffService;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkStaffInfoVo;
import com.jxdinfo.hussar.iam.sdk.server.dao.identity.HussarIamStaffMapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.iam.sdk.server.service.impl.sync.hussarIamSdkSyncStaffServiceImpl")
public class HussarIamSdkSyncStaffServiceImpl
implements IHussarIamSdkSyncStaffService {
    @Resource
    private HussarIamStaffMapper hussarIamStaffMapper;
    @Resource
    private ISysStruStaffService sysStruStaffService;

    public Page<IamSdkStaffInfoVo> getAllStaffInfo(IamSdkPageInfo pageInfo) {
        Page page = HussarPageUtils.convert((PageInfo)((PageInfo)JSON.parseObject((String)JSON.toJSONString((Object)pageInfo), PageInfo.class)));
        List<IamSdkStaffInfoVo> list = this.hussarIamStaffMapper.getAllStaffInfo((Page<IamSdkStaffInfoVo>)page);
        if (HussarUtils.isEmpty(list)) {
            page.setRecords(list);
            return page;
        }
        List staffIds = list.stream().map(IamSdkStaffInfoVo::getStaffId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = LambdaQueryUtil.getMultiQueryWrapper(SysStruStaff::getStaffId, staffIds);
        List struStaffs = this.sysStruStaffService.list((Wrapper)wrapper);
        if (HussarUtils.isNotEmpty((Object)struStaffs)) {
            Map map = struStaffs.stream().collect(Collectors.groupingBy(SysStruStaff::getStaffId, Collectors.mapping(SysStruStaff::getStruId, Collectors.toList())));
            for (IamSdkStaffInfoVo vo : list) {
                List struIds = map.get(vo.getStaffId());
                if (!HussarUtils.isNotEmpty(struIds)) continue;
                vo.setStruIds(struIds);
            }
        }
        page.setRecords(list);
        return page;
    }
}

