/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.sdk.server.service.impl.identity;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.iam.common.api.constans.IamSdkConstant;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkQueryOrganDto;
import com.jxdinfo.hussar.iam.sdk.api.enums.SdkDelStatusEnum;
import com.jxdinfo.hussar.iam.sdk.api.enums.SdkOrganEnum;
import com.jxdinfo.hussar.iam.sdk.api.exception.IamSdkOrganException;
import com.jxdinfo.hussar.iam.sdk.api.service.identity.IHussarIadSdkOrganService;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkOrganTypeVo;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkOrganVo;
import com.jxdinfo.hussar.iam.sdk.server.dao.identity.HussarIamStruMapper;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HussarIadSdkOrganServiceImpl
implements IHussarIadSdkOrganService {
    @Autowired
    private ISysOrganTypeService sysOrganTypeService;
    @Autowired
    private ISysStruService sysStruService;
    @Autowired
    private ISysOrganService sysOrganService;
    @Autowired
    private ISysOfficeService sysOfficeService;
    @Autowired
    private ISysStruUserService sysStruUserService;
    @Autowired
    private ISysStruRoleService sysStruRoleService;
    @Autowired
    private ISysStruStaffService sysStruStaffService;
    @Autowired
    private HussarIamStruMapper hussarIamStruMapper;

    public List<IamSdkOrganTypeVo> typeList() {
        ArrayList<IamSdkOrganTypeVo> sdkOrganTypeVOList = new ArrayList<IamSdkOrganTypeVo>();
        List list = this.sysOrganTypeService.list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return sdkOrganTypeVOList;
        }
        list.forEach(sysOrganType -> {
            IamSdkOrganTypeVo iamSdkOrganTypeVO = new IamSdkOrganTypeVo();
            iamSdkOrganTypeVO.setId(sysOrganType.getId());
            iamSdkOrganTypeVO.setCode(sysOrganType.getOrganType());
            iamSdkOrganTypeVO.setName(sysOrganType.getTypeName());
            iamSdkOrganTypeVO.setParentCode(sysOrganType.getParentType());
            sdkOrganTypeVOList.add(iamSdkOrganTypeVO);
        });
        return sdkOrganTypeVOList;
    }

    public List<IamSdkOrganVo> directSubList(Long parentId) {
        ArrayList<IamSdkOrganVo> sdkOrganTypeVOList = new ArrayList<IamSdkOrganVo>();
        if (Objects.isNull(parentId)) {
            throw new IamSdkOrganException("\u7236\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper sysStruLambdaQueryWrapper = new LambdaQueryWrapper();
        sysStruLambdaQueryWrapper.eq(SysStru::getParentId, (Object)parentId);
        List sysStruList = this.sysStruService.list((Wrapper)sysStruLambdaQueryWrapper);
        AssertUtil.isNotEmpty((Collection)sysStruList, (String)"\u7ec4\u7ec7\u7ed3\u6784\u83b7\u53d6\u5931\u8d25");
        Set organIds = sysStruList.stream().map(SysStru::getOrganId).collect(Collectors.toSet());
        LambdaQueryWrapper sysOrganLambdaQueryWrapper = new LambdaQueryWrapper();
        sysOrganLambdaQueryWrapper.in(SysOrgan::getId, organIds);
        if (IamSdkConstant.WITHOUT_PARENT_ORGANT_ID.equals(parentId)) {
            sysOrganLambdaQueryWrapper.eq(SysOrgan::getOrganProperty, (Object)0);
        }
        if (IamSdkConstant.INTERNAL_PARENT_ORGANT_ID.equals(parentId)) {
            sysOrganLambdaQueryWrapper.eq(SysOrgan::getOrganProperty, (Object)1);
        }
        List sysOrganList = this.sysOrganService.list((Wrapper)sysOrganLambdaQueryWrapper);
        AssertUtil.isNotEmpty((Collection)sysOrganList, (String)"\u7ec4\u7ec7\u673a\u6784\u83b7\u53d6\u5931\u8d25");
        Set struIds = sysStruList.stream().map(SysStru::getId).collect(Collectors.toSet());
        List sysOfficeList = this.sysOfficeService.getSysOfficeByStruId(new ArrayList(struIds));
        AssertUtil.isNotEmpty((Collection)sysOfficeList, (String)"\u7ec4\u7ec7\u673a\u6784\u6269\u5c55\u6570\u636e\u83b7\u53d6\u5931\u8d25");
        Map organMap = sysOrganList.stream().collect(Collectors.toMap(SysOrgan::getId, Function.identity(), (oldVal, newVal) -> newVal));
        Map sysOfficeMap = sysOfficeList.stream().collect(Collectors.toMap(SysOffice::getStruId, Function.identity(), (oldVal, newVal) -> newVal));
        sysStruList.stream().forEach(sysStru -> {
            if (MapUtils.isNotEmpty((Map)organMap) && organMap.containsKey(sysStru.getOrganId())) {
                SysOrgan sysOrgan = (SysOrgan)organMap.get(sysStru.getOrganId());
                IamSdkOrganVo iamSdkOrganVO = new IamSdkOrganVo();
                iamSdkOrganVO.setOrganId(sysStru.getOrganId());
                iamSdkOrganVO.setParentId(sysStru.getParentId());
                iamSdkOrganVO.setOrganAlias(sysStru.getOrganAlias());
                iamSdkOrganVO.setOrganName(sysOrgan.getOrganName());
                iamSdkOrganVO.setOrganFullName(sysOrgan.getOrganName());
                iamSdkOrganVO.setOrganCode(sysOrgan.getOrganCode());
                iamSdkOrganVO.setOrganFullCode(sysOrgan.getOrganCode());
                iamSdkOrganVO.setOrganType(sysOrgan.getOrganType());
                iamSdkOrganVO.setOrganShortName(sysOrgan.getShortName());
                if (MapUtils.isNotEmpty((Map)sysOfficeMap) && sysOfficeMap.containsKey(sysStru.getId())) {
                    SysOffice sysOffice = (SysOffice)sysOfficeMap.get(sysStru.getId());
                    iamSdkOrganVO.setOrganAddress(sysOffice.getOfficeAddress());
                }
                sdkOrganTypeVOList.add(iamSdkOrganVO);
            }
        });
        return sdkOrganTypeVOList;
    }

    public List<IamSdkOrganVo> getByIds(List<Long> organIds) {
        if (CollectionUtils.isEmpty(organIds)) {
            throw new IamSdkOrganException("\u7ec4\u7ec7id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList<IamSdkOrganVo> sdkOrganTypeVOList = new ArrayList<IamSdkOrganVo>();
        LambdaQueryWrapper sysStruLambdaQueryWrapper = new LambdaQueryWrapper();
        sysStruLambdaQueryWrapper.in(SysStru::getOrganId, organIds);
        List sysStruList = this.sysStruService.list((Wrapper)sysStruLambdaQueryWrapper);
        AssertUtil.isNotEmpty((Collection)sysStruList, (String)"\u7ec4\u7ec7\u7ed3\u6784\u83b7\u53d6\u5931\u8d25");
        Map<String, List> resultMap = this.getStruAndOrangMap(sysStruList, organIds);
        this.buildIamSdkOrganVOList(resultMap, sdkOrganTypeVOList);
        return sdkOrganTypeVOList;
    }

    public List<IamSdkOrganVo> getByUserId(Long userId) {
        if (Objects.isNull(userId)) {
            throw new IamSdkOrganException("\u7528\u6237id \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList<IamSdkOrganVo> sdkOrganTypeVOList = new ArrayList<IamSdkOrganVo>();
        LambdaQueryWrapper sysStruUserLambdaQueryWrapper = new LambdaQueryWrapper();
        sysStruUserLambdaQueryWrapper.eq(SysStruUser::getUserId, (Object)userId);
        sysStruUserLambdaQueryWrapper.eq(HussarDelflagEntity::getDelFlag, (Object)SdkDelStatusEnum.NORMAL.getStatus());
        List sysStruUserList = this.sysStruUserService.list((Wrapper)sysStruUserLambdaQueryWrapper);
        AssertUtil.isNotEmpty((Collection)sysStruUserList, (String)"\u7ec4\u7ec7\u7528\u6237\u5173\u7cfb\u4e0d\u5b58\u5728");
        Set<Long> struList = sysStruUserList.stream().map(SysStruUser::getStruId).collect(Collectors.toSet());
        Map<String, List> resultMap = this.getStruAndOrangMap(struList);
        this.buildIamSdkOrganVOList(resultMap, sdkOrganTypeVOList);
        return sdkOrganTypeVOList;
    }

    public List<IamSdkOrganVo> list(IamSdkQueryOrganDto queryOrganDTO) {
        if (Objects.isNull(queryOrganDTO)) {
            throw new IamSdkOrganException("\u7ec4\u7ec7\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<IamSdkOrganVo> sdkOrganVOList = this.hussarIamStruMapper.queryChildStruList(queryOrganDTO);
        return CollectionUtils.isEmpty(sdkOrganVOList) ? Lists.newArrayList() : sdkOrganVOList;
    }

    public Page<IamSdkOrganVo> page(IamSdkQueryOrganDto queryOrganDTO) {
        Map<String, Object> queryParamMap;
        List<IamSdkOrganVo> pageList;
        Page iamSdkOrganVoPage;
        if (Objects.isNull(queryOrganDTO)) {
            throw new IamSdkOrganException("\u7ec4\u7ec7\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Long current = queryOrganDTO.getCurrent();
        Long size = queryOrganDTO.getSize();
        if (Objects.isNull(queryOrganDTO.getCurrent()) || Objects.isNull(queryOrganDTO.getSize())) {
            current = 1L;
            size = 15L;
        }
        iamSdkOrganVoPage.setRecords((List)(CollectionUtils.isEmpty(pageList = this.hussarIamStruMapper.page((Page<IamSdkOrganVo>)(iamSdkOrganVoPage = new Page(current.longValue(), size.longValue())), queryParamMap = this.buildQueryOrganMap(queryOrganDTO))) ? Lists.newArrayList() : pageList));
        return iamSdkOrganVoPage;
    }

    public List<IamSdkOrganVo> allSubList(IamSdkQueryOrganDto queryOrganDTO) {
        if (Objects.isNull(queryOrganDTO)) {
            throw new IamSdkOrganException("\u7ec4\u7ec7\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Map<String, Object> queryParamMap = this.buildQueryOrganMap(queryOrganDTO);
        List<IamSdkOrganVo> iamSdkOrganVos = this.hussarIamStruMapper.queryAllStuList(queryParamMap);
        if (CollectionUtils.isEmpty(iamSdkOrganVos)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        List struFids = iamSdkOrganVos.stream().map(IamSdkOrganVo::getStruFid).collect(Collectors.toList());
        struFids.stream().forEach(strFid -> ((LambdaQueryWrapper)queryWrapper.or()).likeRight(SysStru::getStruFid, strFid));
        List sysStruList = this.sysStruService.list((Wrapper)queryWrapper);
        AssertUtil.isNotEmpty((Collection)sysStruList, (String)"\u7ec4\u7ec7\u7ed3\u6784\u4e0d\u5b58\u5728");
        ArrayList<IamSdkOrganVo> sdkOrganTypeVOList = new ArrayList<IamSdkOrganVo>();
        Set<Long> struList = sysStruList.stream().map(SysStru::getId).collect(Collectors.toSet());
        Map<String, List> resultMap = this.getStruAndOrangMap(struList);
        this.buildIamSdkOrganVOList(resultMap, sdkOrganTypeVOList);
        return sdkOrganTypeVOList;
    }

    public Page<IamSdkOrganVo> allSubPage(IamSdkQueryOrganDto queryOrganDTO) {
        if (Objects.isNull(queryOrganDTO)) {
            throw new IamSdkOrganException("\u7ec4\u7ec7\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Long current = queryOrganDTO.getCurrent();
        Long size = queryOrganDTO.getSize();
        if (Objects.isNull(queryOrganDTO.getCurrent()) || Objects.isNull(queryOrganDTO.getSize())) {
            current = 1L;
            size = 15L;
        }
        Page iamSdkOrganVoPage = new Page(current.longValue(), size.longValue());
        ArrayList<IamSdkOrganVo> sdkOrganTypeVOList = new ArrayList<IamSdkOrganVo>();
        Map<String, Object> queryParamMap = this.buildQueryOrganMap(queryOrganDTO);
        List<IamSdkOrganVo> pageList = this.hussarIamStruMapper.page((Page<IamSdkOrganVo>)iamSdkOrganVoPage, queryParamMap);
        if (CollectionUtils.isEmpty(pageList)) {
            return iamSdkOrganVoPage;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        List struFids = pageList.stream().map(IamSdkOrganVo::getStruFid).collect(Collectors.toList());
        struFids.stream().forEach(strFid -> ((LambdaQueryWrapper)queryWrapper.or()).likeRight(SysStru::getStruFid, strFid));
        List sysStruList = this.sysStruService.list((Wrapper)queryWrapper);
        AssertUtil.isNotEmpty((Collection)sysStruList, (String)"\u7ec4\u7ec7\u7ed3\u6784\u4e0d\u5b58\u5728");
        Set<Long> struList = sysStruList.stream().map(SysStru::getId).collect(Collectors.toSet());
        Map<String, List> resultMap = this.getStruAndOrangMap(struList);
        this.buildIamSdkOrganVOList(resultMap, sdkOrganTypeVOList);
        return iamSdkOrganVoPage.setRecords(CollectionUtils.isEmpty((Collection)sysStruList) ? Lists.newArrayList() : sdkOrganTypeVOList);
    }

    public List<IamSdkOrganVo> getByRoleId(Long roleId) {
        if (Objects.isNull(roleId)) {
            throw new IamSdkOrganException("\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList<IamSdkOrganVo> sdkOrganTypeVOList = new ArrayList<IamSdkOrganVo>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysStruRole::getGrantedRole, (Object)roleId);
        queryWrapper.eq(HussarDelflagEntity::getDelFlag, (Object)SdkDelStatusEnum.NORMAL.getStatus());
        List sysStruRoleList = this.sysStruRoleService.list((Wrapper)queryWrapper);
        AssertUtil.isNotEmpty((Collection)sysStruRoleList, (String)"\u7ec4\u7ec7\u673a\u6784\u5173\u8054\u89d2\u8272\u5173\u7cfb\u83b7\u53d6\u5931\u8d25");
        Set<Long> struIds = sysStruRoleList.stream().map(SysStruRole::getStruId).collect(Collectors.toSet());
        Map<String, List> resultMap = this.getStruAndOrangMap(struIds);
        this.buildIamSdkOrganVOList(resultMap, sdkOrganTypeVOList);
        return sdkOrganTypeVOList;
    }

    public List<IamSdkOrganVo> getByStaffId(Long staffId) {
        if (Objects.isNull(staffId)) {
            throw new IamSdkOrganException("\u4eba\u5458id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList<IamSdkOrganVo> sdkOrganTypeVOList = new ArrayList<IamSdkOrganVo>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysStruStaff::getStaffId, (Object)staffId);
        queryWrapper.eq(HussarDelflagEntity::getDelFlag, (Object)SdkDelStatusEnum.NORMAL.getStatus());
        List sysStruStaffList = this.sysStruStaffService.list((Wrapper)queryWrapper);
        AssertUtil.isNotEmpty((Collection)sysStruStaffList, (String)"\u7ec4\u7ec7\u673a\u6784\u4e0e\u4eba\u5458\u5173\u8054\u5173\u7cfb\u83b7\u53d6\u5931\u8d25");
        Set<Long> struIds = sysStruStaffList.stream().map(SysStruStaff::getStruId).collect(Collectors.toSet());
        Map<String, List> resultMap = this.getStruAndOrangMap(struIds);
        this.buildIamSdkOrganVOList(resultMap, sdkOrganTypeVOList);
        return sdkOrganTypeVOList;
    }

    private Map<String, List> getStruAndOrangMap(Set<Long> struIds) {
        HashMap<String, List> resultMap = new HashMap<String, List>();
        List sysStruList = this.sysStruService.getStruByStruIds(new ArrayList<Long>(struIds));
        AssertUtil.isNotEmpty((Collection)sysStruList, (String)"\u7ec4\u7ec7\u7ed3\u6784\u83b7\u53d6\u5931\u8d25");
        Set organIdList = sysStruList.stream().map(SysStru::getOrganId).collect(Collectors.toSet());
        List sysOrganList = this.sysOrganService.getOrgansByOrganIds(new ArrayList(organIdList));
        AssertUtil.isNotEmpty((Collection)sysOrganList, (String)"\u7ec4\u7ec7\u673a\u6784\u83b7\u53d6\u5931\u8d25");
        List sysOfficeList = this.sysOfficeService.getSysOfficeByStruId(new ArrayList<Long>(struIds));
        AssertUtil.isNotEmpty((Collection)sysOfficeList, (String)"\u7ec4\u7ec7\u673a\u6784\u6269\u5c55\u6570\u636e\u83b7\u53d6\u5931\u8d25");
        resultMap.put(SdkOrganEnum.SYS_STU_LIST.getName(), sysStruList);
        resultMap.put(SdkOrganEnum.SYS_ORGAN_LIST.getName(), sysOrganList);
        resultMap.put(SdkOrganEnum.SYS_OFFICE_LIST.getName(), sysOfficeList);
        return resultMap;
    }

    private Map<String, List> getStruAndOrangMap(List<SysStru> sysStruList, List<Long> organIds) {
        HashMap<String, List> resultMap = new HashMap<String, List>();
        List sysOrganList = this.sysOrganService.getOrgansByOrganIds(organIds);
        AssertUtil.isNotEmpty((Collection)sysOrganList, (String)"\u7ec4\u7ec7\u673a\u6784\u83b7\u53d6\u5931\u8d25");
        Set struIds = sysStruList.stream().map(SysStru::getId).collect(Collectors.toSet());
        List sysOfficeList = this.sysOfficeService.getSysOfficeByStruId(new ArrayList(struIds));
        AssertUtil.isNotEmpty((Collection)sysOfficeList, (String)"\u7ec4\u7ec7\u673a\u6784\u6269\u5c55\u6570\u636e\u83b7\u53d6\u5931\u8d25");
        resultMap.put(SdkOrganEnum.SYS_STU_LIST.getName(), sysStruList);
        resultMap.put(SdkOrganEnum.SYS_ORGAN_LIST.getName(), sysOrganList);
        resultMap.put(SdkOrganEnum.SYS_OFFICE_LIST.getName(), sysOfficeList);
        return resultMap;
    }

    private void buildIamSdkOrganVOList(Map<String, List> resultMap, List<IamSdkOrganVo> sdkOrganVOList) {
        if (!resultMap.containsKey(SdkOrganEnum.SYS_STU_LIST.getName()) || !resultMap.containsKey(SdkOrganEnum.SYS_ORGAN_LIST.getName()) || !resultMap.containsKey(SdkOrganEnum.SYS_OFFICE_LIST.getName()) || CollectionUtils.isEmpty((Collection)resultMap.get(SdkOrganEnum.SYS_STU_LIST.getName())) || CollectionUtils.isEmpty((Collection)resultMap.get(SdkOrganEnum.SYS_ORGAN_LIST.getName())) || CollectionUtils.isEmpty((Collection)resultMap.get(SdkOrganEnum.SYS_OFFICE_LIST.getName()))) {
            return;
        }
        List sysStruList = resultMap.get(SdkOrganEnum.SYS_STU_LIST.getName());
        List sysOrganList = resultMap.get(SdkOrganEnum.SYS_ORGAN_LIST.getName());
        List sysOfficeList = resultMap.get(SdkOrganEnum.SYS_OFFICE_LIST.getName());
        Map organMap = sysOrganList.stream().collect(Collectors.toMap(SysOrgan::getId, Function.identity(), (oldVal, newVal) -> newVal));
        Map sysOfficeMap = sysOfficeList.stream().collect(Collectors.toMap(SysOffice::getStruId, Function.identity(), (oldVal, newVal) -> newVal));
        sysStruList.stream().forEach(sysStru -> {
            if (MapUtils.isNotEmpty((Map)organMap) && organMap.containsKey(sysStru.getOrganId())) {
                SysOrgan sysOrgan = (SysOrgan)organMap.get(sysStru.getOrganId());
                IamSdkOrganVo iamSdkOrganVO = new IamSdkOrganVo();
                iamSdkOrganVO.setOrganId(sysStru.getOrganId());
                iamSdkOrganVO.setParentId(sysStru.getParentId());
                iamSdkOrganVO.setOrganAlias(sysStru.getOrganAlias());
                iamSdkOrganVO.setOrganName(sysOrgan.getOrganName());
                iamSdkOrganVO.setOrganFullName(sysOrgan.getOrganName());
                iamSdkOrganVO.setOrganCode(sysOrgan.getOrganCode());
                iamSdkOrganVO.setOrganFullCode(sysOrgan.getOrganCode());
                iamSdkOrganVO.setOrganType(sysOrgan.getOrganType());
                iamSdkOrganVO.setOrganShortName(sysOrgan.getShortName());
                if (MapUtils.isNotEmpty((Map)sysOfficeMap) && sysOfficeMap.containsKey(sysStru.getId())) {
                    SysOffice sysOffice = (SysOffice)sysOfficeMap.get(sysStru.getId());
                    iamSdkOrganVO.setOrganDescription(sysOffice.getOfficeAlias());
                    iamSdkOrganVO.setOrganAddress(sysOffice.getOfficeAddress());
                }
                sdkOrganVOList.add(iamSdkOrganVO);
            }
        });
    }

    private Map<String, Object> buildQueryOrganMap(IamSdkQueryOrganDto queryOrganDTO) {
        HashMap<String, Object> queryParamsMap = new HashMap<String, Object>();
        queryParamsMap.put(SdkOrganEnum.ORGAN_CODE.getName(), queryOrganDTO.getOrganCode());
        queryParamsMap.put(SdkOrganEnum.ORGAN_NAME.getName(), queryOrganDTO.getOrganName());
        queryParamsMap.put(SdkOrganEnum.ORGAN_TYPES.getName(), queryOrganDTO.getOrganTypes());
        queryParamsMap.put(SdkOrganEnum.ORGAN_PARENT_IDS.getName(), queryOrganDTO.getParentIds());
        return queryParamsMap;
    }
}

