/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.sdk.server.service.impl.sync;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysStaffAuditService;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUserAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPostAudit;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostService;
import com.jxdinfo.hussar.authorization.sysuserip.model.SysUserIp;
import com.jxdinfo.hussar.authorization.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ICreateUserConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.staffmanager.StaffChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.usermanager.UserChangeNotify;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkPageInfo;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkUserDto;
import com.jxdinfo.hussar.iam.sdk.api.model.SyncStru;
import com.jxdinfo.hussar.iam.sdk.api.model.SyncUser;
import com.jxdinfo.hussar.iam.sdk.api.service.sync.IHussarIamSdkSyncUserService;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkBasePostVo;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkDataMapping;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkUserInfoVo;
import com.jxdinfo.hussar.iam.sdk.server.dao.account.HussarIamUserMapper;
import com.jxdinfo.hussar.iam.sdk.server.dao.identity.HussarIamStaffMapper;
import com.jxdinfo.hussar.iam.sdk.server.dao.sync.SyncStruMapper;
import com.jxdinfo.hussar.iam.sdk.server.dao.sync.SyncUserMapper;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.iam.sdk.server.service.impl.sync.hussarIamSdkSyncUserServiceImpl")
public class HussarIamSdkSyncUserServiceImpl
implements IHussarIamSdkSyncUserService {
    @Resource
    private HussarIamUserMapper hussarIamUserMapper;
    @Resource
    private HussarIamStaffMapper hussarIamStaffMapper;
    @Resource
    private SyncUserMapper syncUserMapper;
    @Resource
    private SyncStruMapper syncStruMapper;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Resource
    private ISysStaffAuditService sysStaffAuditService;
    @Resource
    private ISysStruUserService sysStruUserService;
    @Resource
    private ISysStruStaffService sysStruStaffService;
    @Resource
    private ISysUserPostService sysUserPostService;
    @Resource
    private ISysUserIpService sysUserIpService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISysUserroleAuditService sysUserroleAuditService;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private ISysStruUserAuditService sysStruUserAuditService;
    @Resource
    private ISysUserPostAuditService sysUserPostAuditService;
    @Resource
    private UserChangeNotify userChangeNotify;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Resource
    private ICreateUserConfigService createUserConfigService;
    @Resource
    private IHussarPwdConfigService pwdConfigService;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private StaffChangeNotify staffChangeNotify;

    public Page<IamSdkUserInfoVo> getAllUserInfo(IamSdkPageInfo pageInfo) {
        Page page = HussarPageUtils.convert((PageInfo)((PageInfo)JSON.parseObject((String)JSON.toJSONString((Object)pageInfo), PageInfo.class)));
        List<IamSdkUserInfoVo> list = this.hussarIamUserMapper.getAllUserInfo((Page<IamSdkUserInfoVo>)page);
        if (HussarUtils.isEmpty(list)) {
            page.setRecords(list);
            return page;
        }
        List userIds = list.stream().map(IamSdkUserInfoVo::getUserId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = LambdaQueryUtil.getMultiQueryWrapper(SysStruUser::getUserId, userIds);
        List struUsers = this.sysStruUserService.list((Wrapper)wrapper);
        LambdaQueryWrapper ipWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysUserIp::getUserId, userIds);
        List userIps = this.sysUserIpService.list((Wrapper)ipWrapper);
        LambdaQueryWrapper postWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysUserPost::getUserId, userIds);
        List userPosts = this.sysUserPostService.list((Wrapper)postWrapper);
        if (HussarUtils.isNotEmpty((Object)struUsers) || HussarUtils.isNotEmpty((Object)userIps) || HussarUtils.isNotEmpty((Object)userPosts)) {
            Map struMap = struUsers.stream().collect(Collectors.groupingBy(SysStruUser::getUserId, Collectors.mapping(SysStruUser::getStruId, Collectors.toList())));
            Map ipMap = userIps.stream().collect(Collectors.groupingBy(SysUserIp::getUserId, Collectors.mapping(SysUserIp::getUserIp, Collectors.toList())));
            Map postMap = userPosts.stream().collect(Collectors.groupingBy(SysUserPost::getUserId, Collectors.toList()));
            for (IamSdkUserInfoVo vo : list) {
                List struIds = struMap.get(vo.getUserId());
                List ipList = ipMap.get(vo.getUserId());
                List postList = postMap.get(vo.getUserId());
                if (HussarUtils.isNotEmpty(struIds)) {
                    vo.setStruIds(struIds);
                }
                if (HussarUtils.isNotEmpty(ipList)) {
                    vo.setUserIps(ipList);
                }
                if (!HussarUtils.isNotEmpty(postList)) continue;
                List posts = BeanUtil.copy(postList, IamSdkBasePostVo.class);
                vo.setPosts(posts);
            }
        }
        page.setRecords(list);
        return page;
    }

    @HussarTransactional
    public Boolean deleteUser(String outUserId) {
        SyncUser syncUser = (SyncUser)this.syncUserMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SyncUser::getUserId, (Object)outUserId));
        if (HussarUtils.isNotEmpty((Object)syncUser)) {
            Long userId = syncUser.getIamUserId();
            SysUsers user = (SysUsers)this.sysUsersMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsers::getId, (Object)userId)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode()));
            if (HussarUtils.isEmpty((Object)user)) {
                this.syncUserMapper.deleteById(syncUser.getId());
                return Boolean.TRUE;
            }
            SysStaff staff = (SysStaff)this.sysStaffMapper.selectById((Serializable)user.getEmployeeId());
            this.sysStruService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysStru::getPrincipalId, (Object)userId)).set(SysStru::getPrincipalId, null));
            this.sysUserroleAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)userId));
            this.sysUserRoleMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)userId));
            this.sysUserIpService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)userId));
            this.sysStruUserService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)userId));
            this.sysStruUserAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruUserAudit::getUserId, (Object)userId));
            this.sysUserPostService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserPost::getUserId, (Object)userId));
            this.sysUserPostAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserPostAudit::getUserId, (Object)userId));
            this.hussarIamUserMapper.deleteById(userId);
            this.sysStaffMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getId, (Object)user.getEmployeeId()));
            this.sysStaffAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStaffAudit::getRealStaffId, (Object)user.getEmployeeId()));
            this.sysStruStaffService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruStaff::getStaffId, (Object)user.getEmployeeId()));
            this.syncUserMapper.deleteById(syncUser.getId());
            if (HussarUtils.isNotEmpty((Object)staff)) {
                this.staffChangeNotify.notify(DataChangeType.DELETE, new Object[]{staff});
            }
            this.userChangeNotify.notify(DataChangeType.DELETE, new Object[]{user});
        }
        return Boolean.TRUE;
    }

    @HussarTransactional
    public IamSdkDataMapping addUser(IamSdkUserDto userDto) {
        String userId = userDto.getUserId();
        String userName = userDto.getUserName();
        String userAccount = userDto.getUserAccount();
        AssertUtil.isNotEmpty((String)userId, (String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtil.isNotEmpty((String)userName, (String)"\u7528\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtil.isNotEmpty((String)userAccount, (String)"\u7528\u6237\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Long count = this.syncUserMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(SyncUser::getUserId, (Object)userId));
        AssertUtil.isFalse((count > 0L ? 1 : 0) != 0, (String)"\u540c\u6b65\u65b0\u589e\u7528\u6237\u5931\u8d25\uff01\u8be5\u7528\u6237\u5df2\u540c\u6b65\uff01");
        boolean existUser = this.existUser(userAccount);
        AssertUtil.isFalse((boolean)existUser, (String)"\u540c\u6b65\u65b0\u589e\u7528\u6237\u5931\u8d25\uff01\u7528\u6237\u8d26\u53f7\u91cd\u590d\uff01");
        SysUsers user = new SysUsers();
        SysStaff staff = new SysStaff();
        this.initialization(userDto, user, staff);
        boolean staffFlag = this.sysStaffMapper.insert((Object)staff) > 0;
        boolean userFlag = this.sysUsersMapper.insert((Object)user) > 0;
        AssertUtil.isFalse((!staffFlag || !userFlag ? 1 : 0) != 0, (String)"\u540c\u6b65\u65b0\u589e\u7528\u6237\u5931\u8d25\uff01");
        this.handleRelation(userDto, user.getId(), staff.getId());
        SyncUser syncUser = new SyncUser();
        syncUser.setUserId(userId);
        syncUser.setIamUserId(user.getId());
        this.syncUserMapper.insert(syncUser);
        this.staffChangeNotify.notify(DataChangeType.INSERT, new Object[]{staff});
        this.userChangeNotify.notify(DataChangeType.INSERT, new Object[]{user});
        return new IamSdkDataMapping(user.getId(), userId);
    }

    public Boolean editUser(IamSdkUserDto userDto) {
        String outUserId = userDto.getUserId();
        SyncUser syncUser = (SyncUser)this.syncUserMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SyncUser::getUserId, (Object)outUserId));
        AssertUtil.isNotNull((Object)syncUser, (String)"\u540c\u6b65\u4fee\u6539\u7528\u6237\u5931\u8d25\uff01\u8be5\u7528\u6237\u672a\u540c\u6b65\uff01");
        Long userId = syncUser.getIamUserId();
        SysUsers user = (SysUsers)this.sysUsersMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsers::getId, (Object)userId)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode()));
        AssertUtil.isNotNull((Object)user, (String)"\u540c\u6b65\u4fee\u6539\u7528\u6237\u5931\u8d25\uff01\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        SysStaff staff = (SysStaff)this.sysStaffMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getId, (Object)user.getEmployeeId()));
        this.initializationEdit(userDto, staff, user);
        this.sysStaffMapper.updateById((Object)staff);
        this.sysUsersMapper.updateById((Object)user);
        this.sysStruStaffService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruStaff::getStaffId, (Object)user.getEmployeeId()));
        this.sysStruUserService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)userId));
        this.handleRelation(userDto, user.getId(), staff.getId());
        this.staffChangeNotify.notify(DataChangeType.UPDATE, new Object[]{staff});
        this.userChangeNotify.notify(DataChangeType.UPDATE, new Object[]{user});
        return Boolean.TRUE;
    }

    private void handleRelation(IamSdkUserDto userDto, Long userId, Long staffId) {
        LambdaQueryWrapper wrapper;
        List syncStrus;
        List organIds;
        List parentIds = userDto.getParentIds();
        if (HussarUtils.isNotEmpty((Object)parentIds) && HussarUtils.isNotEmpty(organIds = (syncStrus = this.syncStruMapper.selectList((Wrapper)(wrapper = LambdaQueryUtil.getMultiQueryWrapper(SyncStru::getStruId, (List)parentIds)))).stream().map(SyncStru::getIamStruId).distinct().collect(Collectors.toList()))) {
            ArrayList<SysStruUser> organUserList = new ArrayList<SysStruUser>();
            for (Long organId : organIds) {
                SysStruUser sysStruUser = new SysStruUser();
                sysStruUser.setUserId(userId);
                sysStruUser.setStruId(organId);
                organUserList.add(sysStruUser);
            }
            ArrayList<SysStruStaff> organStaffList = new ArrayList<SysStruStaff>();
            for (Long organId : organIds) {
                SysStruStaff sysStruStaff = new SysStruStaff();
                sysStruStaff.setStaffId(staffId);
                sysStruStaff.setStruId(organId);
                organStaffList.add(sysStruStaff);
            }
            if (HussarUtils.isNotEmpty(organUserList)) {
                this.sysStruUserService.saveBatch(organUserList, organUserList.size());
            }
            if (HussarUtils.isNotEmpty(organStaffList)) {
                this.sysStruStaffService.saveBatch(organStaffList, organStaffList.size());
            }
        }
    }

    private void initialization(IamSdkUserDto userDto, SysUsers sysUsers, SysStaff sysStaff) {
        LambdaQueryWrapper wrapper;
        List syncStrus;
        List organIds;
        Long sysStaffId = IdWorker.getId((Object)sysStaff);
        Long sysUserId = HussarUtils.isEmpty((Object)userDto.getUserIdLong()) ? Long.valueOf(IdWorker.getId((Object)sysUsers)) : userDto.getUserIdLong();
        List parentIds = userDto.getParentIds();
        Long departmentId = HussarUtils.isNotEmpty((Object)parentIds) ? (HussarUtils.isNotEmpty(organIds = (syncStrus = this.syncStruMapper.selectList((Wrapper)(wrapper = LambdaQueryUtil.getMultiQueryWrapper(SyncStru::getStruId, (List)parentIds)))).stream().map(SyncStru::getIamStruId).distinct().collect(Collectors.toList())) ? (Long)organIds.get(0) : Long.valueOf(11L)) : Long.valueOf(11L);
        String userAccount = StringUtils.trimToEmpty((String)userDto.getUserAccount());
        String userName = StringUtils.trimToEmpty((String)userDto.getUserName());
        String weChat = StringUtils.trimToEmpty((String)userDto.getWeChat());
        String mobile = StringUtils.trimToEmpty((String)userDto.getMobile());
        String mail = StringUtils.trimToEmpty((String)userDto.getMail());
        String telephone = StringUtils.trimToEmpty((String)userDto.getTelephone());
        String staffPosition = StringUtils.trimToEmpty((String)userDto.getStaffPosition());
        String sex = StringUtils.trimToEmpty((String)userDto.getSex());
        String birthday = StringUtils.trimToEmpty((String)userDto.getBirthday());
        String idcard = StringUtils.trimToEmpty((String)userDto.getIdcard());
        String address = StringUtils.trimToEmpty((String)userDto.getAddress());
        String workId = StringUtils.trimToEmpty((String)userDto.getWorkId());
        String workDate = StringUtils.trimToEmpty((String)userDto.getWorkDate());
        String graduateDate = StringUtils.trimToEmpty((String)userDto.getGraduateDate());
        String graduateSchool = StringUtils.trimToEmpty((String)userDto.getGraduateSchool());
        String secure = StringUtils.trimToEmpty((String)userDto.getSecure());
        sysStaff.setId(sysStaffId);
        sysStaff.setName(userName);
        sysStaff.setAddress(address);
        sysStaff.setBirthday(birthday);
        sysStaff.setSex(sex);
        sysStaff.setIdcard(idcard);
        sysStaff.setGraduateDate(graduateDate);
        sysStaff.setGraduateSchool(graduateSchool);
        sysStaff.setWorkDate(workDate);
        sysStaff.setWorkId(workId);
        sysStaff.setStaffPosition(staffPosition);
        String code = this.getCode();
        sysStaff.setStaffCode(code);
        int staffOrder = 1;
        Integer maxStaffOrder = this.sysStaffMapper.getMaxOrder();
        sysStaff.setStaffOrder(Integer.valueOf(HussarUtils.isEmpty((Object)maxStaffOrder) ? staffOrder : maxStaffOrder + 1));
        sysUsers.setId(sysUserId);
        sysUsers.setUserAccount(userAccount);
        sysUsers.setUserName(userName);
        sysUsers.setWeChat(weChat);
        sysUsers.seteMail(mail);
        sysUsers.setMobile(mobile);
        sysUsers.setTelephone(telephone);
        sysUsers.setEmployeeId(sysStaffId);
        sysUsers.setDepartmentId(departmentId);
        sysUsers.setCorporationId(departmentId);
        sysUsers.setAccountStatus(UserStatus.OK.getCode());
        sysUsers.setSecurityLevel(Integer.valueOf(1));
        sysUsers.setMaxSessions(Integer.valueOf(1));
        sysUsers.setLoginIpLimit("0");
        sysUsers.setLoginTimeLimit("0");
        sysUsers.setIsSys("0");
        sysUsers.setIsCpublic("0");
        sysUsers.setTypeProperty("1");
        int userOrder = 1;
        Integer maxUserOrder = this.sysUsersMapper.getUserMaxOrder();
        sysUsers.setUserOrder(Integer.valueOf(HussarUtils.isEmpty((Object)maxUserOrder) ? userOrder : maxUserOrder + 1));
        if (StringUtils.isBlank((CharSequence)secure)) {
            String pass = "";
            pass = this.createUserConfigService.getCreateUserSendEmail() != false && this.createUserConfigService.getCreateUserUseDefaultPass() == false ? "123456" : this.pwdConfigService.getDefaultPassword();
            String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(pass).getBytes());
            sysUsers.setPassword(pwd);
        } else {
            sysUsers.setPassword(secure);
        }
        sysUsers.setTotpKey(this.abstractOTPCredentialsMatcher.getRandomSecretBase32());
    }

    protected void initializationEdit(IamSdkUserDto userDto, SysStaff sysStaff, SysUsers sysUsers) {
        String userName = StringUtils.trimToEmpty((String)userDto.getUserName());
        String weChat = StringUtils.trimToEmpty((String)userDto.getWeChat());
        String mobile = StringUtils.trimToEmpty((String)userDto.getMobile());
        String telephone = StringUtils.trimToEmpty((String)userDto.getTelephone());
        String mail = StringUtils.trimToEmpty((String)userDto.getMail());
        String staffPosition = StringUtils.trimToEmpty((String)userDto.getStaffPosition());
        String sex = StringUtils.trimToEmpty((String)userDto.getSex());
        String birthday = StringUtils.trimToEmpty((String)userDto.getBirthday());
        String idcard = StringUtils.trimToEmpty((String)userDto.getIdcard());
        String address = StringUtils.trimToEmpty((String)userDto.getAddress());
        String workId = StringUtils.trimToEmpty((String)userDto.getWorkId());
        String workDate = StringUtils.trimToEmpty((String)userDto.getWorkDate());
        String graduateDate = StringUtils.trimToEmpty((String)userDto.getGraduateDate());
        String graduateSchool = StringUtils.trimToEmpty((String)userDto.getGraduateSchool());
        String secure = StringUtils.trimToEmpty((String)userDto.getSecure());
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            sysStaff.setName(userName);
            sysUsers.setUserName(userName);
        }
        if (StringUtils.isNotBlank((CharSequence)weChat)) {
            sysUsers.setWeChat(weChat);
        }
        if (StringUtils.isNotBlank((CharSequence)mobile)) {
            sysUsers.setMobile(mobile);
        }
        if (StringUtils.isNotBlank((CharSequence)telephone)) {
            sysUsers.setTelephone(telephone);
        }
        if (StringUtils.isNotBlank((CharSequence)mail)) {
            sysUsers.seteMail(mail);
        }
        if (StringUtils.isNotBlank((CharSequence)secure)) {
            sysUsers.setPassword(secure);
        }
        if (StringUtils.isNotBlank((CharSequence)staffPosition)) {
            sysStaff.setStaffPosition(staffPosition);
        }
        if (StringUtils.isNotBlank((CharSequence)sex)) {
            sysStaff.setSex(sex);
        }
        if (StringUtils.isNotBlank((CharSequence)birthday)) {
            sysStaff.setBirthday(birthday);
        }
        if (StringUtils.isNotBlank((CharSequence)idcard)) {
            sysStaff.setIdcard(idcard);
        }
        if (StringUtils.isNotBlank((CharSequence)address)) {
            sysStaff.setAddress(address);
        }
        if (StringUtils.isNotBlank((CharSequence)workId)) {
            sysStaff.setWorkId(workId);
        }
        if (StringUtils.isNotBlank((CharSequence)workDate)) {
            sysStaff.setWorkDate(workDate);
        }
        if (StringUtils.isNotBlank((CharSequence)graduateDate)) {
            sysStaff.setGraduateDate(graduateDate);
        }
        if (StringUtils.isNotBlank((CharSequence)graduateSchool)) {
            sysStaff.setGraduateSchool(graduateSchool);
        }
    }

    private boolean existUser(String account) {
        Long count = this.sysUsersMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getUserAccount, (Object)account));
        return count != null && count > 0L;
    }

    private String getCode() {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        String currentCode = "";
        long currentCount = 1L;
        long num = 0L;
        String firstCode = "";
        while (currentCount != 0L) {
            lambdaQueryWrapper.clear();
            currentCode = this.sysIdtableService.getCurrentCode("STAFF_CODE", "SYS_STAFF");
            if (++num == 1L) {
                firstCode = currentCode;
            }
            AssertUtil.isFalse((num > 1L && currentCode.equals(firstCode) ? 1 : 0) != 0, (String)"\u540c\u6b65\u7528\u6237\u5931\u8d25\uff01\u65e0\u53ef\u7528\u7f16\u7801\uff01");
            lambdaQueryWrapper.eq(SysStaff::getStaffCode, (Object)currentCode);
            currentCount = this.hussarIamStaffMapper.selectCount((Wrapper)lambdaQueryWrapper);
        }
        return currentCode;
    }
}

