/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.sdk.server.service.impl.permission;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceExpand;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceExpandService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.iam.common.server.util.ApplicationUtils;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkCheckResourceDto;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkCheckUrlDto;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkQueryResourceDto;
import com.jxdinfo.hussar.iam.sdk.api.service.permission.IHussarIamSdkResourceService;
import com.jxdinfo.hussar.iam.sdk.api.service.permission.IHussarIamSdkRoleService;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkResourceExpandVo;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkResourceModuleVo;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkResourceVo;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkRoleVo;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkUserRelateRoleDetailVo;
import com.jxdinfo.hussar.iam.sdk.server.dao.permission.HussarIamResourceMapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import dm.jdbc.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.iam.sdk.server.service.impl.hussarIamSdkResourceServiceImpl")
public class HussarIamSdkResourceServiceImpl
implements IHussarIamSdkResourceService {
    @Autowired
    private IHussarIamSdkRoleService hussarIamSdkRoleService;
    @Resource
    private HussarIamResourceMapper hussarIamResourceMapper;
    @Autowired
    private IHussarBaseResourceExpandService hussarBaseResourceExpandService;
    @Autowired
    private ISysResourceMosulesService sysResourceMosulesService;

    public List<IamSdkResourceVo> getByUserId(Long userId) {
        List<Long> roleIds = this.getRolesByUserId(userId);
        return this.getByRoleIds(roleIds);
    }

    public Boolean checkAuthority(IamSdkCheckResourceDto iamSdkCheckResourceDto) {
        List<IamSdkResourceVo> resourceVos = this.getByUserId(iamSdkCheckResourceDto.getUserId());
        if (HussarUtils.isNotEmpty(resourceVos)) {
            for (IamSdkResourceVo vo : resourceVos) {
                if (!HussarUtils.equals((Object)iamSdkCheckResourceDto.getResourceId(), (Object)vo.getResourceId())) continue;
                return true;
            }
        }
        return false;
    }

    public Boolean checkUrlAuthority(IamSdkCheckUrlDto iamSdkCheckUrlDto) {
        List<IamSdkResourceVo> resourceVos = this.getByUserId(iamSdkCheckUrlDto.getUserId());
        if (HussarUtils.isNotEmpty(resourceVos)) {
            for (IamSdkResourceVo vo : resourceVos) {
                if (!HussarUtils.equals((Object)iamSdkCheckUrlDto.getUrl(), (Object)vo.getUrlNames())) continue;
                return true;
            }
        }
        return false;
    }

    public List<IamSdkResourceVo> getByFunctionId(Long functionId) {
        List<IamSdkResourceVo> resourceVos = this.hussarIamResourceMapper.getByFunctionId(functionId);
        return this.fillExpands(resourceVos);
    }

    public List<IamSdkResourceVo> getByRoleId(Long roleId) {
        if (HussarUtils.isEmpty((Object)roleId)) {
            return Collections.emptyList();
        }
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("appId", ApplicationUtils.getApplicationId());
        queryParams.put("roleId", roleId);
        List<IamSdkResourceVo> resourceVos = this.hussarIamResourceMapper.getByRoleId(queryParams);
        return this.fillExpands(resourceVos);
    }

    public List<IamSdkResourceVo> getByRoleIds(List<Long> roleIds) {
        if (HussarUtils.isEmpty(roleIds)) {
            return Collections.emptyList();
        }
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("appId", ApplicationUtils.getApplicationId());
        queryParams.put("roleIds", roleIds);
        List<IamSdkResourceVo> resourceVos = this.hussarIamResourceMapper.getByRoleIds(queryParams);
        return this.fillExpands(resourceVos);
    }

    public List<IamSdkResourceVo> list(IamSdkQueryResourceDto iamSdkQueryResourceDto) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("resourceName", StringUtil.trimToEmpty((String)iamSdkQueryResourceDto.getResourceName()));
        queryParams.put("resourceCode", StringUtil.trimToEmpty((String)iamSdkQueryResourceDto.getResourceCode()));
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("moduleId", iamSdkQueryResourceDto.getModuleId());
        queryParams.put("appId", ApplicationUtils.getApplicationId());
        List<IamSdkResourceVo> resourceVos = this.hussarIamResourceMapper.getResourceList(queryParams);
        return this.fillExpands(resourceVos);
    }

    public Page<IamSdkResourceVo> page(IamSdkQueryResourceDto iamSdkQueryResourceDto) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("resourceName", StringUtil.trimToEmpty((String)iamSdkQueryResourceDto.getResourceName()));
        queryParams.put("resourceCode", StringUtil.trimToEmpty((String)iamSdkQueryResourceDto.getResourceCode()));
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("moduleId", iamSdkQueryResourceDto.getModuleId());
        queryParams.put("appId", ApplicationUtils.getApplicationId());
        PageInfo pageInfo = new PageInfo(iamSdkQueryResourceDto.getCurrent().longValue(), iamSdkQueryResourceDto.getSize().longValue());
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        List<IamSdkResourceVo> resourceVos = this.hussarIamResourceMapper.getResourcePageList((Page<IamSdkResourceVo>)page, queryParams);
        List<IamSdkResourceVo> result = this.fillExpands(resourceVos);
        page.setRecords(result);
        return page;
    }

    public List<IamSdkResourceModuleVo> getResourceModule(Long moduleId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)moduleId)) {
            lambdaQueryWrapper.eq(SysResourceModules::getParentModuleId, (Object)moduleId);
        }
        lambdaQueryWrapper.eq(SysResourceModules::getApplicationId, (Object)ApplicationUtils.getApplicationId());
        lambdaQueryWrapper.orderByAsc(SysResourceModules::getSeq);
        List resourceModules = this.sysResourceMosulesService.list((Wrapper)lambdaQueryWrapper);
        ArrayList<IamSdkResourceModuleVo> result = new ArrayList<IamSdkResourceModuleVo>();
        if (HussarUtils.isNotEmpty((Object)resourceModules)) {
            resourceModules.forEach(module -> {
                IamSdkResourceModuleVo vo = new IamSdkResourceModuleVo();
                vo.setParentModuleId(module.getParentModuleId());
                vo.setResourceModuleCode(module.getModuleCode());
                vo.setResourceModuleId(module.getId());
                vo.setResourceModuleName(module.getModuleName());
                vo.setSeq(module.getSeq());
                result.add(vo);
            });
        }
        return result;
    }

    private List<Long> getRolesByUserId(Long userId) {
        IamSdkUserRelateRoleDetailVo userRelateRoleDetail = this.hussarIamSdkRoleService.getUserRelateRoleDetail(userId);
        List roles = userRelateRoleDetail.getRoles();
        return roles.stream().map(IamSdkRoleVo::getId).collect(Collectors.toList());
    }

    private List<IamSdkResourceVo> fillExpands(List<IamSdkResourceVo> resourceVos) {
        if (HussarUtils.isEmpty(resourceVos)) {
            return Collections.emptyList();
        }
        String[] typeArr = new String[]{"res_menu", "res_btn", "res_rights"};
        List<String> types = Arrays.asList(typeArr);
        List resourceIds = resourceVos.stream().filter(r -> !types.contains(r.getResourceType())).map(IamSdkResourceVo::getResourceId).collect(Collectors.toList());
        if (HussarUtils.isEmpty(resourceIds)) {
            return resourceVos;
        }
        LambdaQueryWrapper lambdaQueryWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysResourceExpand::getResourceId, resourceIds);
        List resourceExpands = this.hussarBaseResourceExpandService.list((Wrapper)lambdaQueryWrapper);
        if (HussarUtils.isNotEmpty((Object)resourceExpands)) {
            Map<Long, IamSdkResourceVo> resMap = resourceVos.stream().collect(Collectors.toMap(IamSdkResourceVo::getResourceId, r -> r));
            for (SysResourceExpand expand : resourceExpands) {
                IamSdkResourceVo vo = resMap.get(expand.getResourceId());
                IamSdkResourceExpandVo expandVo = new IamSdkResourceExpandVo();
                expandVo.setExpandId(expand.getResourceTypeExpandId());
                expandVo.setExpandCode(expand.getResourceTypeExpandCode());
                expandVo.setExpandName(expand.getResourceTypeExpandName());
                expandVo.setExpandCode(expand.getResourceTypeExpandCode());
                vo.getExpands().add(expandVo);
            }
        }
        return resourceVos;
    }
}

