/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.sdk.server.service.impl.account;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.iam.common.api.exception.IamSdkAccountException;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkLoginDTO;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkQueryUserDto;
import com.jxdinfo.hussar.iam.sdk.api.service.account.IHussarIamSdkUserService;
import com.jxdinfo.hussar.iam.sdk.api.service.identity.IHussarIamSdkStaffService;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkUserVO;
import com.jxdinfo.hussar.iam.sdk.server.dao.account.HussarIamUserMapper;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.iam.sdk.server.service.impl.account.HussarIamSdkUserServiceImpl")
public class HussarIamSdkUserServiceImpl
implements IHussarIamSdkUserService {
    @Autowired
    private HussarIamUserMapper iamSdkUserMapper;
    @Autowired
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private IHussarIamSdkStaffService iHussarIamSdkStaffService;

    public IamSdkUserVO login(IamSdkLoginDTO loginDTO) {
        if (HussarUtils.isEmpty((Object)loginDTO)) {
            throw new IamSdkAccountException();
        }
        String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(loginDTO.getPassword()).getBytes());
        loginDTO.setPassword(pwd);
        return this.iamSdkUserMapper.getUserByIdPassword(loginDTO);
    }

    public List<IamSdkUserVO> getByRoleId(Long roleId) {
        return this.iamSdkUserMapper.getUserListByRoleId(roleId);
    }

    public List<IamSdkUserVO> list(IamSdkQueryUserDto queryUserDTO) {
        return this.iamSdkUserMapper.listUser(queryUserDTO);
    }

    public Page<IamSdkUserVO> page(IamSdkQueryUserDto queryUserDTO) {
        Page page = new Page();
        page.setCurrent(queryUserDTO.getCurrent().longValue());
        page.setSize(queryUserDTO.getSize().longValue());
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("organIds", queryUserDTO.getOrganIds());
        queryParams.put("userName", queryUserDTO.getUserName());
        queryParams.put("userAccount", queryUserDTO.getUserAccount());
        queryParams.put("accountStatus", queryUserDTO.getAccountStatus());
        List<IamSdkUserVO> userList = this.iamSdkUserMapper.listUserPage((Page<IamSdkUserVO>)page, queryParams);
        page.setRecords(userList);
        return page;
    }

    public List<IamSdkUserVO> listByOrgan(IamSdkQueryUserDto queryUserDTO) {
        List organIds = queryUserDTO.getOrganIds();
        List subOrganByIds = this.iHussarIamSdkStaffService.getSubOrganByIds(organIds);
        queryUserDTO.setOrganIds(subOrganByIds);
        return this.iamSdkUserMapper.listUser(queryUserDTO);
    }

    public Page<IamSdkUserVO> pageByOrgan(IamSdkQueryUserDto queryUserDTO) {
        Page page = new Page();
        page.setCurrent(queryUserDTO.getCurrent().longValue());
        page.setSize(queryUserDTO.getSize().longValue());
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("organIds", this.iHussarIamSdkStaffService.getSubOrganByIds(queryUserDTO.getOrganIds()));
        queryParams.put("userName", queryUserDTO.getUserName());
        queryParams.put("userAccount", queryUserDTO.getUserAccount());
        queryParams.put("accountStatus", queryUserDTO.getAccountStatus());
        List<IamSdkUserVO> userList = this.iamSdkUserMapper.listUserPage((Page<IamSdkUserVO>)page, queryParams);
        page.setRecords(userList);
        return page;
    }

    public List<IamSdkUserVO> getByIds(List<Long> userIds) {
        if (HussarUtils.isEmpty(userIds)) {
            throw new IamSdkAccountException();
        }
        return this.iamSdkUserMapper.getByIds(userIds);
    }

    public List<IamSdkUserVO> getByPostId(Long postId) {
        List<IamSdkUserVO> sdkUserVOS = this.iamSdkUserMapper.getByPostId(postId);
        return sdkUserVOS.stream().filter(HussarIamSdkUserServiceImpl.distinctByKey(IamSdkUserVO::getId)).collect(Collectors.toList());
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> key) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> null == seen.putIfAbsent(key.apply(t), true);
    }
}

