/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.sdk.http.service.account;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.iam.common.api.exception.IamSdkAccountException;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkLoginDTO;
import com.jxdinfo.hussar.iam.sdk.api.dto.IamSdkQueryUserDto;
import com.jxdinfo.hussar.iam.sdk.api.enums.SdkUrlEnum;
import com.jxdinfo.hussar.iam.sdk.api.vo.IamSdkUserVO;
import com.jxdinfo.hussar.iam.sdk.http.utils.SdkHttpUtils;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class HussarIamUserService {
    public IamSdkUserVO login(IamSdkLoginDTO loginDTO) {
        if (ObjectUtils.isEmpty((Object)loginDTO)) {
            throw new IamSdkAccountException();
        }
        return SdkHttpUtils.postHttp(SdkUrlEnum.IAM_SDK_USER_LOGIN, (Object)loginDTO, IamSdkUserVO.class);
    }

    public List<IamSdkUserVO> getByRoleId(Long roleId) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.IAM_SDK_USER_GET_BY_ROLE_ID, (Object)roleId, new TypeReference<List<IamSdkUserVO>>(){});
    }

    public List<IamSdkUserVO> list(IamSdkQueryUserDto queryUserDTO) {
        if (ObjectUtils.isEmpty((Object)queryUserDTO)) {
            throw new IamSdkAccountException();
        }
        return SdkHttpUtils.postHttp(SdkUrlEnum.IAM_SDK_USER_LIST, (Object)queryUserDTO, new TypeReference<List<IamSdkUserVO>>(){});
    }

    public Page<IamSdkUserVO> page(IamSdkQueryUserDto queryUserDTO) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.IAM_SDK_USER_PAGE, (Object)queryUserDTO, new TypeReference<Page<IamSdkUserVO>>(){});
    }

    public List<IamSdkUserVO> listByOrgan(IamSdkQueryUserDto queryUserDTO) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.IAM_SDK_USER_LIST_BY_ORGAN, (Object)queryUserDTO, new TypeReference<List<IamSdkUserVO>>(){});
    }

    public Page<IamSdkUserVO> pageByOrgan(IamSdkQueryUserDto queryUserDTO) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.IAM_SDK_USER_PAGE_BY_ORGAN, (Object)queryUserDTO, new TypeReference<Page<IamSdkUserVO>>(){});
    }

    public List<IamSdkUserVO> getByIds(List<Long> userIds) {
        if (ObjectUtils.isEmpty(userIds)) {
            throw new IamSdkAccountException();
        }
        return SdkHttpUtils.postHttp(SdkUrlEnum.IAM_SDK_USER_GET_BY_IDS, userIds, new TypeReference<List<IamSdkUserVO>>(){});
    }

    public List<IamSdkUserVO> getByPostId(Long postId) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.IAM_SDK_USER_GET_BY_POST_ID, (Object)postId, new TypeReference<List<IamSdkUserVO>>(){});
    }
}

